/*
 * Decompiled with CFR 0.152.
 */
package net.rubygrapefruit.platform.internal;

import java.io.OutputStream;
import net.rubygrapefruit.platform.NativeException;
import net.rubygrapefruit.platform.internal.AbstractTerminal;
import net.rubygrapefruit.platform.internal.FunctionResult;
import net.rubygrapefruit.platform.internal.MutableTerminalSize;
import net.rubygrapefruit.platform.internal.jni.WindowsConsoleFunctions;
import net.rubygrapefruit.platform.terminal.TerminalOutput;
import net.rubygrapefruit.platform.terminal.TerminalSize;
import net.rubygrapefruit.platform.terminal.Terminals;

public class WindowsTerminal
extends AbstractTerminal {
    private final Object lock = new Object();
    private final Terminals.Output output;
    private final OutputStream outputStream;

    public WindowsTerminal(Terminals.Output output) {
        this.output = output;
        this.outputStream = WindowsTerminal.streamForOutput(output);
    }

    public String toString() {
        return String.format("Windows console on %s", this.getOutputDisplay());
    }

    private String getOutputDisplay() {
        return this.output.toString().toLowerCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() {
        Object object = this.lock;
        synchronized (object) {
            FunctionResult result2 = new FunctionResult();
            WindowsConsoleFunctions.initConsole(this.output.ordinal(), result2);
            if (result2.isFailed()) {
                throw new NativeException(String.format("Could not open console for %s: %s", this.getOutputDisplay(), result2.getMessage()));
            }
        }
    }

    public boolean supportsColor() {
        return true;
    }

    public boolean supportsTextAttributes() {
        return true;
    }

    public boolean supportsCursorMotion() {
        return true;
    }

    public boolean supportsCursorVisibility() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TerminalSize getTerminalSize() {
        Object object = this.lock;
        synchronized (object) {
            FunctionResult result2 = new FunctionResult();
            MutableTerminalSize size = new MutableTerminalSize();
            WindowsConsoleFunctions.getConsoleSize(this.output.ordinal(), size, result2);
            if (result2.isFailed()) {
                throw new NativeException(String.format("Could not determine console size for %s: %s", this.getOutputDisplay(), result2.getMessage()));
            }
            return size;
        }
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TerminalOutput bold() {
        Object object = this.lock;
        synchronized (object) {
            FunctionResult result2 = new FunctionResult();
            WindowsConsoleFunctions.boldOn(result2);
            if (result2.isFailed()) {
                throw new NativeException(String.format("Could not switch console to bold mode for %s: %s", this.getOutputDisplay(), result2.getMessage()));
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TerminalOutput foreground(TerminalOutput.Color color) {
        Object object = this.lock;
        synchronized (object) {
            FunctionResult result2 = new FunctionResult();
            WindowsConsoleFunctions.foreground(color.ordinal(), result2);
            if (result2.isFailed()) {
                throw new NativeException(String.format("Could not change console foreground color for %s: %s", this.getOutputDisplay(), result2.getMessage()));
            }
        }
        return this;
    }

    public TerminalOutput dim() throws NativeException {
        return this.normal();
    }

    public TerminalOutput bright() throws NativeException {
        return this.bold();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TerminalOutput defaultForeground() throws NativeException {
        Object object = this.lock;
        synchronized (object) {
            FunctionResult result2 = new FunctionResult();
            WindowsConsoleFunctions.defaultForeground(result2);
            if (result2.isFailed()) {
                throw new NativeException(String.format("Could not switch console to default foreground for %s: %s", this.getOutputDisplay(), result2.getMessage()));
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TerminalOutput normal() {
        Object object = this.lock;
        synchronized (object) {
            FunctionResult result2 = new FunctionResult();
            WindowsConsoleFunctions.boldOff(result2);
            if (result2.isFailed()) {
                throw new NativeException(String.format("Could not switch console to normal mode for %s: %s", this.getOutputDisplay(), result2.getMessage()));
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TerminalOutput reset() {
        Object object = this.lock;
        synchronized (object) {
            FunctionResult result2 = new FunctionResult();
            WindowsConsoleFunctions.reset(result2);
            if (result2.isFailed()) {
                throw new NativeException(String.format("Could not reset console for %s: %s", this.getOutputDisplay(), result2.getMessage()));
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TerminalOutput hideCursor() throws NativeException {
        Object object = this.lock;
        synchronized (object) {
            FunctionResult result2 = new FunctionResult();
            WindowsConsoleFunctions.hideCursor(result2);
            if (result2.isFailed()) {
                throw new NativeException(String.format("Could not hide cursor for %s: %s", this.getOutputDisplay(), result2.getMessage()));
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TerminalOutput showCursor() throws NativeException {
        Object object = this.lock;
        synchronized (object) {
            FunctionResult result2 = new FunctionResult();
            WindowsConsoleFunctions.showCursor(result2);
            if (result2.isFailed()) {
                throw new NativeException(String.format("Could not show cursor for %s: %s", this.getOutputDisplay(), result2.getMessage()));
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TerminalOutput cursorDown(int count2) throws NativeException {
        Object object = this.lock;
        synchronized (object) {
            FunctionResult result2 = new FunctionResult();
            WindowsConsoleFunctions.down(count2, result2);
            if (result2.isFailed()) {
                throw new NativeException(String.format("Could not move cursor down for %s: %s", this.getOutputDisplay(), result2.getMessage()));
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TerminalOutput cursorUp(int count2) throws NativeException {
        Object object = this.lock;
        synchronized (object) {
            FunctionResult result2 = new FunctionResult();
            WindowsConsoleFunctions.up(count2, result2);
            if (result2.isFailed()) {
                throw new NativeException(String.format("Could not move cursor up for %s: %s", this.getOutputDisplay(), result2.getMessage()));
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TerminalOutput cursorLeft(int count2) throws NativeException {
        Object object = this.lock;
        synchronized (object) {
            FunctionResult result2 = new FunctionResult();
            WindowsConsoleFunctions.left(count2, result2);
            if (result2.isFailed()) {
                throw new NativeException(String.format("Could not move cursor left for %s: %s", this.getOutputDisplay(), result2.getMessage()));
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TerminalOutput cursorRight(int count2) throws NativeException {
        Object object = this.lock;
        synchronized (object) {
            FunctionResult result2 = new FunctionResult();
            WindowsConsoleFunctions.right(count2, result2);
            if (result2.isFailed()) {
                throw new NativeException(String.format("Could not move cursor right for %s: %s", this.getOutputDisplay(), result2.getMessage()));
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TerminalOutput cursorStartOfLine() throws NativeException {
        Object object = this.lock;
        synchronized (object) {
            FunctionResult result2 = new FunctionResult();
            WindowsConsoleFunctions.startLine(result2);
            if (result2.isFailed()) {
                throw new NativeException(String.format("Could not move cursor to start of line for %s: %s", this.getOutputDisplay(), result2.getMessage()));
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TerminalOutput clearToEndOfLine() throws NativeException {
        Object object = this.lock;
        synchronized (object) {
            FunctionResult result2 = new FunctionResult();
            WindowsConsoleFunctions.clearToEndOfLine(result2);
            if (result2.isFailed()) {
                throw new NativeException(String.format("Could clear to end of line for %s: %s", this.getOutputDisplay(), result2.getMessage()));
            }
        }
        return this;
    }
}

