/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.kotlin.dsl.tooling.builders;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.LongRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.gradle.internal.exceptions.LocationAwareException;
import org.gradle.kotlin.dsl.resolver.EditorMessages;
import org.gradle.kotlin.dsl.tooling.builders.DefaultEditorPosition;
import org.gradle.kotlin.dsl.tooling.builders.DefaultEditorReport;
import org.gradle.kotlin.dsl.tooling.builders.EditorReportsBuilderKt;
import org.gradle.kotlin.dsl.tooling.models.EditorReport;
import org.gradle.kotlin.dsl.tooling.models.EditorReportSeverity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000l\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a2\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0010\u0010\t\u001a\f\u0012\b\u0012\u00060\nj\u0002`\u000b0\u00052\u0006\u0010\f\u001a\u00020\u0001H\u0000\u001a\u0013\u0010\r\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0082\u0010\u001a0\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0010\u0010\t\u001a\f\u0012\b\u0012\u00060\nj\u0002`\u000b0\u00112\u0006\u0010\f\u001a\u00020\u0001H\u0002\u001a\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u001a\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0002H\u0002\u001a,\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\u00112\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u001dH\u0002\u001a4\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\u00112\u0006\u0010\f\u001a\u00020\u00012\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u001dH\u0002\u001a\u0010\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u001a\u0010 \u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00020\u00112\u0006\u0010!\u001a\u00020\u0015H\u0002\u001a\f\u0010\"\u001a\u00020#*\u00020$H\u0002\u001a\f\u0010\"\u001a\u00020#*\u00020\bH\u0002\u001a\u001c\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011*\f\u0012\b\u0012\u00060\nj\u0002`\u000b0\u0011H\u0002\u001a\f\u0010&\u001a\u00020'*\u00020\bH\u0000\u001a\u0017\u0010(\u001a\u0004\u0018\u00010\u0002*\u00020\u000f2\u0006\u0010!\u001a\u00020\u0015H\u0082\u0010\u001a \u0010)\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011*\b\u0012\u0004\u0012\u00020\u00020\u00112\u0006\u0010!\u001a\u00020\u0015H\u0002\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\u00a8\u0006*"}, d2={"isCausedByScriptCompilationException", "", "Lorg/gradle/internal/exceptions/LocationAwareException;", "(Lorg/gradle/internal/exceptions/LocationAwareException;)Z", "buildEditorReportsFor", "", "Lorg/gradle/kotlin/dsl/tooling/models/EditorReport;", "scriptFile", "Ljava/io/File;", "exceptions", "Ljava/lang/Exception;", "Lkotlin/Exception;", "locationAwareHints", "firstLocationAwareCauseOrNull", "ex", "", "inferEditorReportsFrom", "Lkotlin/sequences/Sequence;", "lineWarning", "Lorg/gradle/kotlin/dsl/tooling/builders/DefaultEditorReport;", "message", "", "line", "", "messageForLocationAwareEditorHint", "failure", "reportExceptionsNotLocatedIn", "", "reports", "", "reportRuntimeExceptionsLocatedIn", "wholeFileWarning", "anyNotLocatedIn", "scriptPath", "countLines", "", "Ljava/io/BufferedInputStream;", "findLocationAwareExceptions", "readLinesRange", "Lkotlin/ranges/LongRange;", "runtimeFailureLocatedIn", "runtimeFailuresLocatedIn", "gradle-kotlin-dsl-tooling-builders"})
public final class EditorReportsBuilderKt {
    @NotNull
    public static final List<EditorReport> buildEditorReportsFor(@Nullable File scriptFile, @NotNull List<? extends Exception> exceptions, boolean locationAwareHints) {
        List<EditorReport> list;
        Intrinsics.checkParameterIsNotNull(exceptions, (String)"exceptions");
        if (scriptFile == null || exceptions.isEmpty()) {
            list = CollectionsKt.emptyList();
        } else {
            File file = scriptFile.getCanonicalFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"scriptFile.canonicalFile");
            list = EditorReportsBuilderKt.inferEditorReportsFrom(file, (Sequence<? extends Exception>)CollectionsKt.asSequence((Iterable)exceptions), locationAwareHints);
        }
        return list;
    }

    private static final List<EditorReport> inferEditorReportsFrom(File scriptFile, Sequence<? extends Exception> exceptions, boolean locationAwareHints) {
        Sequence<LocationAwareException> locatedExceptions = EditorReportsBuilderKt.findLocationAwareExceptions(exceptions);
        List reports = new ArrayList();
        EditorReportsBuilderKt.reportExceptionsNotLocatedIn(scriptFile, locatedExceptions, reports);
        EditorReportsBuilderKt.reportRuntimeExceptionsLocatedIn(scriptFile, locatedExceptions, locationAwareHints, reports);
        return reports;
    }

    private static final void reportExceptionsNotLocatedIn(File scriptFile, Sequence<? extends LocationAwareException> exceptions, List<EditorReport> reports) {
        String string = scriptFile.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"scriptFile.path");
        if (EditorReportsBuilderKt.anyNotLocatedIn(exceptions, string)) {
            reports.add(EditorReportsBuilderKt.wholeFileWarning("Build configuration failed, run 'gradle tasks' for more information"));
        }
    }

    private static final void reportRuntimeExceptionsLocatedIn(File scriptFile, Sequence<? extends LocationAwareException> exceptions, boolean locationAwareHints, List<EditorReport> reports) {
        LongRange actualLinesRange = locationAwareHints ? EditorReportsBuilderKt.readLinesRange(scriptFile) : LongRange.Companion.getEMPTY();
        String string = scriptFile.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"scriptFile.path");
        Sequence<LocationAwareException> $receiver$iv = EditorReportsBuilderKt.runtimeFailuresLocatedIn(exceptions, string);
        for (Object element$iv : $receiver$iv) {
            LocationAwareException failure = (LocationAwareException)element$iv;
            boolean bl = false;
            if (locationAwareHints) {
                ClosedRange closedRange = (ClosedRange)actualLinesRange;
                Integer n = failure.getLineNumber();
                Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"failure.lineNumber");
                if (RangesKt.longRangeContains((ClosedRange)closedRange, (int)n)) {
                    String string2 = EditorReportsBuilderKt.messageForLocationAwareEditorHint(failure);
                    Integer n2 = failure.getLineNumber();
                    Intrinsics.checkExpressionValueIsNotNull((Object)n2, (String)"failure.lineNumber");
                    reports.add(EditorReportsBuilderKt.lineWarning(string2, n2));
                    continue;
                }
            }
            reports.add(EditorReportsBuilderKt.wholeFileWarning("This script caused build configuration to fail, run 'gradle tasks' for more information"));
        }
    }

    private static final Sequence<LocationAwareException> findLocationAwareExceptions(@NotNull Sequence<? extends Exception> $receiver) {
        return SequencesKt.mapNotNull($receiver, (Function1)findLocationAwareExceptions.1.INSTANCE);
    }

    private static final LocationAwareException firstLocationAwareCauseOrNull(Throwable ex) {
        while (!(ex instanceof LocationAwareException)) {
            Throwable cause;
            if (ex.getCause() == null) {
                return null;
            }
            ex = cause;
        }
        return (LocationAwareException)ex;
    }

    private static final boolean anyNotLocatedIn(@NotNull Sequence<? extends LocationAwareException> $receiver, String scriptPath) {
        boolean bl;
        block1: {
            Sequence<? extends LocationAwareException> $receiver$iv = $receiver;
            for (Object element$iv : $receiver$iv) {
                LocationAwareException it = (LocationAwareException)element$iv;
                boolean bl2 = false;
                String string = it.getMessage();
                boolean bl3 = string == null || !StringsKt.contains$default((CharSequence)string, (CharSequence)scriptPath, (boolean)false, (int)2, null);
                if (!bl3) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private static final Sequence<LocationAwareException> runtimeFailuresLocatedIn(@NotNull Sequence<? extends LocationAwareException> $receiver, String scriptPath) {
        return SequencesKt.mapNotNull($receiver, (Function1)((Function1)new Function1<LocationAwareException, LocationAwareException>(scriptPath){
            final /* synthetic */ String $scriptPath;

            @Nullable
            public final LocationAwareException invoke(@NotNull LocationAwareException it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return EditorReportsBuilderKt.access$runtimeFailureLocatedIn((Throwable)it, this.$scriptPath);
            }
            {
                this.$scriptPath = string;
                super(1);
            }
        }));
    }

    private static final LocationAwareException runtimeFailureLocatedIn(@NotNull Throwable $receiver, String scriptPath) {
        while (true) {
            Throwable next;
            if ($receiver instanceof LocationAwareException) {
                String string = $receiver.getMessage();
                if (string != null) {
                    if (StringsKt.contains$default((CharSequence)string, (CharSequence)scriptPath, (boolean)false, (int)2, null)) {
                        return EditorReportsBuilderKt.isCausedByScriptCompilationException((LocationAwareException)$receiver) ? null : (LocationAwareException)$receiver;
                    }
                }
            }
            if ($receiver.getCause() == null) {
                return null;
            }
            $receiver = next;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isCausedByScriptCompilationException(@NotNull LocationAwareException $receiver) {
        Throwable throwable;
        Throwable throwable2 = $receiver.getCause();
        if (throwable2 == null) return false;
        Throwable it = throwable = throwable2;
        boolean bl = false;
        if (!Intrinsics.areEqual((Object)it.getClass().getName(), (Object)"org.gradle.kotlin.dsl.support.ScriptCompilationException")) return false;
        return true;
    }

    private static final String messageForLocationAwareEditorHint(LocationAwareException failure) {
        String string;
        block5: {
            Throwable cause;
            block4: {
                String string2;
                Throwable throwable = failure.getCause();
                if (throwable == null) {
                    Intrinsics.throwNpe();
                }
                if ((string = (cause = throwable).getMessage()) == null) break block4;
                String it = string2 = string;
                boolean bl = false;
                CharSequence charSequence = it;
                string = !StringsKt.isBlank((CharSequence)charSequence) ? string2 : null;
                if (string != null) break block5;
            }
            string = EditorMessages.INSTANCE.defaultLocationAwareHintMessageFor(cause);
        }
        return string;
    }

    private static final DefaultEditorReport wholeFileWarning(String message) {
        return new DefaultEditorReport(EditorReportSeverity.WARNING, message, null, 4, null);
    }

    private static final DefaultEditorReport lineWarning(String message, int line) {
        return new DefaultEditorReport(EditorReportSeverity.WARNING, message, new DefaultEditorPosition(line, 0, 2, null));
    }

    @NotNull
    public static final LongRange readLinesRange(@NotNull File $receiver) {
        LongRange longRange;
        long l;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        long count = l = EditorReportsBuilderKt.countLines($receiver);
        boolean bl = false;
        if (count == 0L) {
            long l2 = 0L;
            longRange = new LongRange(l2, 0L);
        } else {
            long l3 = 1L;
            longRange = new LongRange(l3, count);
        }
        return longRange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final long countLines(@NotNull File $receiver) {
        long l;
        Object object = $receiver;
        object = new FileInputStream((File)object);
        int n = 8192;
        object = object instanceof BufferedInputStream ? (BufferedInputStream)object : new BufferedInputStream((InputStream)object, n);
        Throwable throwable = null;
        try {
            BufferedInputStream input = (BufferedInputStream)object;
            boolean bl = false;
            l = EditorReportsBuilderKt.countLines(input);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        return l;
    }

    /*
     * WARNING - void declaration
     */
    private static final long countLines(@NotNull BufferedInputStream $receiver) {
        byte[] buffer = new byte[8192];
        byte newLine = (byte)10;
        long count = 0L;
        boolean noNewLineBeforeEOF = false;
        int readCount = $receiver.read(buffer);
        while (readCount != -1) {
            int n = 0;
            int n2 = readCount;
            while (n < n2) {
                void idx;
                if (buffer[idx] == newLine) {
                    long l = count;
                    count = l + 1L;
                }
                ++idx;
            }
            noNewLineBeforeEOF = buffer[readCount - 1] != newLine;
            readCount = $receiver.read(buffer);
        }
        if (noNewLineBeforeEOF) {
            long l = count;
            count = l + 1L;
        }
        return count;
    }

    public static final /* synthetic */ LocationAwareException access$firstLocationAwareCauseOrNull(Throwable ex) {
        return EditorReportsBuilderKt.firstLocationAwareCauseOrNull(ex);
    }

    public static final /* synthetic */ LocationAwareException access$runtimeFailureLocatedIn(Throwable $receiver, String scriptPath) {
        return EditorReportsBuilderKt.runtimeFailureLocatedIn($receiver, scriptPath);
    }
}

