/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server.scaninfo;

import java.util.concurrent.atomic.AtomicReference;
import org.gradle.BuildResult;
import org.gradle.api.Action;
import org.gradle.internal.InternalBuildAdapter;
import org.gradle.internal.event.ListenerManager;
import org.gradle.launcher.daemon.registry.DaemonRegistry;
import org.gradle.launcher.daemon.server.expiry.DaemonExpirationListener;
import org.gradle.launcher.daemon.server.expiry.DaemonExpirationResult;
import org.gradle.launcher.daemon.server.expiry.DaemonExpirationStatus;
import org.gradle.launcher.daemon.server.scaninfo.DaemonScanInfo;
import org.gradle.launcher.daemon.server.stats.DaemonRunningStats;

public class DefaultDaemonScanInfo
implements DaemonScanInfo {
    private final DaemonRunningStats stats;
    private final long idleTimeout;
    private final boolean singleRun;
    private final DaemonRegistry daemonRegistry;
    private final ListenerManager listenerManager;

    public DefaultDaemonScanInfo(DaemonRunningStats stats, long idleTimeout, boolean singleRun, DaemonRegistry daemonRegistry, ListenerManager listenerManager) {
        this.stats = stats;
        this.idleTimeout = idleTimeout;
        this.singleRun = singleRun;
        this.daemonRegistry = daemonRegistry;
        this.listenerManager = listenerManager;
    }

    @Override
    public int getNumberOfBuilds() {
        return this.stats.getBuildCount();
    }

    @Override
    public long getStartedAt() {
        return this.stats.getStartTime();
    }

    @Override
    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    @Override
    public int getNumberOfRunningDaemons() {
        return this.daemonRegistry.getAll().size();
    }

    @Override
    public boolean isSingleUse() {
        return this.singleRun;
    }

    @Override
    public void notifyOnUnhealthy(final Action<? super String> listener) {
        final AtomicReference<1> daemonExpirationListenerReference = new AtomicReference<1>();
        DaemonExpirationListener daemonExpirationListener = new DaemonExpirationListener(){

            @Override
            public void onExpirationEvent(DaemonExpirationResult result) {
                if (result.getStatus() == DaemonExpirationStatus.GRACEFUL_EXPIRE) {
                    try {
                        listener.execute(result.getReason());
                    }
                    finally {
                        if (daemonExpirationListenerReference.getAndSet(null) != null) {
                            DefaultDaemonScanInfo.this.listenerManager.removeListener((Object)this);
                        }
                    }
                }
            }
        };
        daemonExpirationListenerReference.set(daemonExpirationListener);
        this.listenerManager.addListener((Object)daemonExpirationListener);
        InternalBuildAdapter buildListener = new InternalBuildAdapter(){

            @Override
            public void buildFinished(BuildResult result) {
                DaemonExpirationListener daemonExpirationListener = daemonExpirationListenerReference.getAndSet(null);
                if (daemonExpirationListener != null) {
                    DefaultDaemonScanInfo.this.listenerManager.removeListener((Object)daemonExpirationListener);
                }
                DefaultDaemonScanInfo.this.listenerManager.removeListener((Object)this);
            }
        };
        this.listenerManager.addListener((Object)buildListener);
    }
}

