/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.components.ServiceManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.stubs.IStubElementType;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.kdoc.psi.api.KDoc;
import org.jetbrains.kotlin.psi.KotlinDeclarationNavigationPolicy;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtModifierListOwnerStub;
import org.jetbrains.kotlin.psi.findDocComment.FindDocCommentKt;
import org.jetbrains.kotlin.psi.stubs.KotlinClassOrObjectStub;

public abstract class KtDeclarationStub<T extends StubElement<?>>
extends KtModifierListOwnerStub<T>
implements KtDeclaration {
    private final AtomicLong modificationStamp = new AtomicLong();

    public KtDeclarationStub(@NotNull T stub, @NotNull IStubElementType nodeType) {
        super(stub, nodeType);
    }

    public KtDeclarationStub(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    public void subtreeChanged() {
        super.subtreeChanged();
        this.modificationStamp.getAndIncrement();
    }

    public long getModificationStamp() {
        return this.modificationStamp.get();
    }

    @Override
    @Nullable
    public KDoc getDocComment() {
        return FindDocCommentKt.findDocComment(this);
    }

    @Override
    public PsiElement getParent() {
        Object stub = this.getStub();
        if (!(stub == null || stub instanceof KotlinClassOrObjectStub && ((KotlinClassOrObjectStub)stub).isLocal())) {
            return stub.getParentStub().getPsi();
        }
        return super.getParent();
    }

    @Override
    public PsiElement getOriginalElement() {
        KotlinDeclarationNavigationPolicy navigationPolicy = ServiceManager.getService(KotlinDeclarationNavigationPolicy.class);
        return navigationPolicy != null ? navigationPolicy.getOriginalElement(this) : this;
    }

    @Override
    @NotNull
    public PsiElement getNavigationElement() {
        KotlinDeclarationNavigationPolicy navigationPolicy = ServiceManager.getService(KotlinDeclarationNavigationPolicy.class);
        return navigationPolicy != null ? navigationPolicy.getNavigationElement(this) : this;
    }
}

