/*
 * Decompiled with CFR 0.152.
 */
package net.rubygrapefruit.platform.internal;

import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.rubygrapefruit.platform.NativeException;
import net.rubygrapefruit.platform.internal.CharInputBuffer;
import net.rubygrapefruit.platform.internal.FunctionResult;
import net.rubygrapefruit.platform.internal.PeekInputStream;
import net.rubygrapefruit.platform.internal.jni.WindowsConsoleFunctions;
import net.rubygrapefruit.platform.terminal.TerminalInput;
import net.rubygrapefruit.platform.terminal.TerminalInputListener;

public class WindowsTerminalInput
implements TerminalInput {
    private final PeekInputStream inputStream = new PeekInputStream(new FileInputStream(FileDescriptor.in));
    private final Object lock = new Object();
    private boolean raw;

    public InputStream getInputStream() {
        return this.inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(TerminalInputListener listener) {
        Object object = this.lock;
        synchronized (object) {
            if (this.raw) {
                FunctionResult result2 = new FunctionResult();
                CharInputBuffer buffer = new CharInputBuffer();
                WindowsConsoleFunctions.readInput(buffer, result2);
                if (result2.isFailed()) {
                    throw new NativeException(String.format("Could not read from console: %s", result2.getMessage()));
                }
                buffer.applyTo(listener);
            } else {
                if (this.peek(0) == 13 && this.peek(1) == 10) {
                    this.inputStream.consume();
                    listener.controlKey(TerminalInputListener.Key.Enter);
                    return;
                }
                int ch = this.next();
                if (ch < 0) {
                    listener.endInput();
                } else {
                    listener.character((char)ch);
                }
            }
        }
    }

    private int peek(int i) {
        try {
            return this.inputStream.peek(i);
        }
        catch (IOException e) {
            throw new NativeException("Could not read from console.", e);
        }
    }

    private int next() {
        try {
            return this.inputStream.read();
        }
        catch (IOException e) {
            throw new NativeException("Could not read from console.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TerminalInput rawMode() throws NativeException {
        Object object = this.lock;
        synchronized (object) {
            FunctionResult result2 = new FunctionResult();
            WindowsConsoleFunctions.rawInputMode(result2);
            if (result2.isFailed()) {
                throw new NativeException(String.format("Could not switch console input to raw mode: %s", result2.getMessage()));
            }
            this.raw = true;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TerminalInput reset() {
        Object object = this.lock;
        synchronized (object) {
            FunctionResult result2 = new FunctionResult();
            WindowsConsoleFunctions.resetInputMode(result2);
            if (result2.isFailed()) {
                throw new NativeException(String.format("Could not reset console input mode: %s", result2.getMessage()));
            }
            this.raw = false;
        }
        return this;
    }
}

