/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import javax.annotation.Nullable;
import org.gradle.api.Task;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.tasks.CompositeTaskOutputPropertySpec;
import org.gradle.api.internal.tasks.DeclaredTaskInputFileProperty;
import org.gradle.api.internal.tasks.DeclaredTaskOutputFileProperty;
import org.gradle.api.internal.tasks.DefaultCacheableTaskOutputFilePropertySpec;
import org.gradle.api.internal.tasks.DefaultTaskInputFilePropertySpec;
import org.gradle.api.internal.tasks.DefaultTaskInputPropertySpec;
import org.gradle.api.internal.tasks.PropertySpecFactory;
import org.gradle.api.internal.tasks.TaskValidationContext;
import org.gradle.api.internal.tasks.ValidatingValue;
import org.gradle.api.internal.tasks.ValidationAction;
import org.gradle.api.internal.tasks.ValidationActions;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.file.TreeType;

public class DefaultPropertySpecFactory
implements PropertySpecFactory {
    private final TaskInternal task;
    private final FileResolver resolver;

    public DefaultPropertySpecFactory(TaskInternal task, FileResolver resolver) {
        this.task = task;
        this.resolver = resolver;
    }

    @Override
    public DeclaredTaskInputFileProperty createInputFileSpec(ValidatingValue paths) {
        return this.createInputFilesSpec(paths, ValidationActions.INPUT_FILE_VALIDATOR);
    }

    @Override
    public DeclaredTaskInputFileProperty createInputFilesSpec(ValidatingValue paths) {
        return this.createInputFilesSpec(paths, ValidationActions.NO_OP);
    }

    @Override
    public DeclaredTaskInputFileProperty createInputDirSpec(ValidatingValue dirPath) {
        FileTreeInternal fileTree = this.resolver.resolveFilesAsTree(new Object[]{dirPath});
        return this.createInputFilesSpec(new FileTreeValue(dirPath, fileTree), ValidationActions.INPUT_DIRECTORY_VALIDATOR);
    }

    private DeclaredTaskInputFileProperty createInputFilesSpec(ValidatingValue paths, ValidationAction validationAction) {
        return new DefaultTaskInputFilePropertySpec(this.task.toString(), this.resolver, paths, validationAction);
    }

    @Override
    public DefaultTaskInputPropertySpec createInputPropertySpec(String name, ValidatingValue value) {
        return new DefaultTaskInputPropertySpec(name, value);
    }

    @Override
    public DeclaredTaskOutputFileProperty createOutputFileSpec(ValidatingValue path) {
        return this.createOutputFilePropertySpec(path, TreeType.FILE, ValidationActions.OUTPUT_FILE_VALIDATOR);
    }

    @Override
    public DeclaredTaskOutputFileProperty createOutputDirSpec(ValidatingValue path) {
        return this.createOutputFilePropertySpec(path, TreeType.DIRECTORY, ValidationActions.OUTPUT_DIRECTORY_VALIDATOR);
    }

    @Override
    public DeclaredTaskOutputFileProperty createOutputFilesSpec(ValidatingValue paths) {
        return new CompositeTaskOutputPropertySpec(this.task.toString(), this.resolver, TreeType.FILE, paths, ValidationActions.OUTPUT_FILES_VALIDATOR);
    }

    @Override
    public DeclaredTaskOutputFileProperty createOutputDirsSpec(ValidatingValue paths) {
        return new CompositeTaskOutputPropertySpec(this.task.toString(), this.resolver, TreeType.DIRECTORY, paths, ValidationActions.OUTPUT_DIRECTORIES_VALIDATOR);
    }

    private DefaultCacheableTaskOutputFilePropertySpec createOutputFilePropertySpec(ValidatingValue path, TreeType type, ValidationAction outputFileValidator) {
        return new DefaultCacheableTaskOutputFilePropertySpec(this.task.toString(), (PathToFileResolver)this.resolver, type, path, outputFileValidator);
    }

    private static class FileTreeValue
    implements ValidatingValue {
        private final ValidatingValue delegate;
        private final FileTreeInternal fileTree;

        public FileTreeValue(ValidatingValue delegate, FileTreeInternal fileTree) {
            this.delegate = delegate;
            this.fileTree = fileTree;
        }

        @Override
        @Nullable
        public Object call() {
            return this.fileTree;
        }

        @Override
        public void attachProducer(Task producer) {
            this.delegate.attachProducer(producer);
        }

        @Override
        public void maybeFinalizeValue() {
            this.delegate.maybeFinalizeValue();
        }

        @Override
        public void validate(String propertyName, boolean optional, ValidationAction valueValidator, TaskValidationContext context) {
            this.delegate.validate(propertyName, optional, valueValidator, context);
        }
    }
}

