/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.test.cpp.plugins;

import java.util.Collection;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Named;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.Usage;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.component.UsageContext;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.language.cpp.CppApplication;
import org.gradle.language.cpp.CppBinary;
import org.gradle.language.cpp.CppPlatform;
import org.gradle.language.cpp.ProductionCppComponent;
import org.gradle.language.cpp.internal.DefaultCppBinary;
import org.gradle.language.cpp.internal.DefaultUsageContext;
import org.gradle.language.cpp.internal.NativeVariantIdentity;
import org.gradle.language.cpp.plugins.CppBasePlugin;
import org.gradle.language.internal.NativeComponentFactory;
import org.gradle.language.nativeplatform.internal.ConfigurableComponentWithLinkUsage;
import org.gradle.language.nativeplatform.internal.Dimensions;
import org.gradle.language.nativeplatform.internal.toolchains.ToolChainSelector;
import org.gradle.language.swift.tasks.UnexportMainSymbol;
import org.gradle.nativeplatform.MachineArchitecture;
import org.gradle.nativeplatform.OperatingSystemFamily;
import org.gradle.nativeplatform.TargetMachine;
import org.gradle.nativeplatform.TargetMachineFactory;
import org.gradle.nativeplatform.platform.internal.DefaultNativePlatform;
import org.gradle.nativeplatform.tasks.InstallExecutable;
import org.gradle.nativeplatform.test.cpp.CppTestExecutable;
import org.gradle.nativeplatform.test.cpp.CppTestSuite;
import org.gradle.nativeplatform.test.cpp.internal.DefaultCppTestExecutable;
import org.gradle.nativeplatform.test.cpp.internal.DefaultCppTestSuite;
import org.gradle.nativeplatform.test.plugins.NativeTestingBasePlugin;
import org.gradle.nativeplatform.test.tasks.RunTestExecutable;

@Incubating
public class CppUnitTestPlugin
implements Plugin<ProjectInternal> {
    private final NativeComponentFactory componentFactory;
    private final ToolChainSelector toolChainSelector;
    private final ObjectFactory objectFactory;
    private final ImmutableAttributesFactory attributesFactory;
    private final TargetMachineFactory targetMachineFactory;

    @Inject
    public CppUnitTestPlugin(NativeComponentFactory componentFactory, ToolChainSelector toolChainSelector, ObjectFactory objectFactory, ImmutableAttributesFactory attributesFactory, TargetMachineFactory targetMachineFactory) {
        this.componentFactory = componentFactory;
        this.toolChainSelector = toolChainSelector;
        this.objectFactory = objectFactory;
        this.attributesFactory = attributesFactory;
        this.targetMachineFactory = targetMachineFactory;
    }

    public void apply(ProjectInternal project) {
        project.getPluginManager().apply(CppBasePlugin.class);
        project.getPluginManager().apply(NativeTestingBasePlugin.class);
        final DefaultCppTestSuite testComponent = (DefaultCppTestSuite)this.componentFactory.newInstance(CppTestSuite.class, DefaultCppTestSuite.class, "test");
        project.getExtensions().add(CppTestSuite.class, "unitTest", (Object)testComponent);
        project.getComponents().add((Object)testComponent);
        testComponent.getBaseName().set((Object)(project.getName() + "Test"));
        testComponent.getTargetMachines().convention((Iterable)Dimensions.getDefaultTargetMachines((TargetMachineFactory)this.targetMachineFactory));
        project.getComponents().withType(ProductionCppComponent.class, (Action)new Action<ProductionCppComponent>(){

            public void execute(ProductionCppComponent component) {
                if ("main".equals(component.getName())) {
                    testComponent.getTargetMachines().convention((Provider)component.getTargetMachines());
                    testComponent.getTestedComponent().set((Object)component);
                }
            }
        });
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(final Project project) {
                final ProductionCppComponent mainComponent = (ProductionCppComponent)project.getComponents().withType(ProductionCppComponent.class).findByName("main");
                testComponent.getTargetMachines().finalizeValue();
                Set targetMachines = (Set)testComponent.getTargetMachines().get();
                CppUnitTestPlugin.this.validateTargetMachines(targetMachines, mainComponent != null ? (Set)mainComponent.getTargetMachines().get() : null);
                CppTestExecutable lastExecutable = null;
                for (TargetMachine targetMachine : targetMachines) {
                    Usage runtimeUsage = (Usage)CppUnitTestPlugin.this.objectFactory.named(Usage.class, "native-runtime");
                    Provider group = project.provider((Callable)new Callable<String>(){

                        @Override
                        public String call() throws Exception {
                            return project.getGroup().toString();
                        }
                    });
                    Provider version = project.provider((Callable)new Callable<String>(){

                        @Override
                        public String call() throws Exception {
                            return project.getVersion().toString();
                        }
                    });
                    AttributeContainerInternal attributesDebug = CppUnitTestPlugin.this.attributesFactory.mutable();
                    attributesDebug.attribute(Usage.USAGE_ATTRIBUTE, (Object)runtimeUsage);
                    attributesDebug.attribute(CppBinary.DEBUGGABLE_ATTRIBUTE, (Object)true);
                    attributesDebug.attribute(CppBinary.OPTIMIZED_ATTRIBUTE, (Object)false);
                    attributesDebug.attribute(MachineArchitecture.ARCHITECTURE_ATTRIBUTE, (Object)targetMachine.getArchitecture());
                    attributesDebug.attribute(OperatingSystemFamily.OPERATING_SYSTEM_ATTRIBUTE, (Object)targetMachine.getOperatingSystemFamily());
                    String operatingSystemSuffix = Dimensions.createDimensionSuffix((Named)targetMachine.getOperatingSystemFamily(), (Collection)targetMachines.stream().map(TargetMachine::getOperatingSystemFamily).collect(Collectors.toSet()));
                    String architectureSuffix = Dimensions.createDimensionSuffix((Named)targetMachine.getArchitecture(), (Collection)targetMachines.stream().map(TargetMachine::getArchitecture).collect(Collectors.toSet()));
                    String variantName = operatingSystemSuffix + architectureSuffix;
                    NativeVariantIdentity debugVariant = new NativeVariantIdentity("debug" + variantName, (Provider)testComponent.getBaseName(), group, version, true, false, targetMachine, null, (UsageContext)new DefaultUsageContext("debug" + variantName + "Runtime", runtimeUsage, (AttributeContainer)attributesDebug));
                    if (!DefaultNativePlatform.getCurrentOperatingSystem().toFamilyName().equals(targetMachine.getOperatingSystemFamily().getName())) continue;
                    ToolChainSelector.Result result = CppUnitTestPlugin.this.toolChainSelector.select(CppPlatform.class, targetMachine);
                    CppTestExecutable testExecutable = testComponent.addExecutable(variantName, debugVariant, (CppPlatform)result.getTargetPlatform(), result.getToolChain(), result.getPlatformToolProvider());
                    if (mainComponent == null && DefaultNativePlatform.getCurrentArchitecture().equals(((CppPlatform)result.getTargetPlatform()).getArchitecture()) && !testComponent.getTestBinary().isPresent()) {
                        testComponent.getTestBinary().set((Object)testExecutable);
                    }
                    lastExecutable = testExecutable;
                }
                if (mainComponent == null && !testComponent.getTestBinary().isPresent() && lastExecutable != null) {
                    testComponent.getTestBinary().set(lastExecutable);
                }
                final TaskContainer tasks = project.getTasks();
                testComponent.getBinaries().whenElementKnown(DefaultCppTestExecutable.class, (Action)new Action<DefaultCppTestExecutable>(){

                    public void execute(final DefaultCppTestExecutable testExecutable) {
                        if (mainComponent != null) {
                            mainComponent.getBinaries().whenElementFinalized((Action)new Action<CppBinary>(){

                                public void execute(final CppBinary testedBinary) {
                                    if (!CppUnitTestPlugin.this.isTestedBinary(testExecutable, mainComponent, testedBinary)) {
                                        return;
                                    }
                                    testExecutable.getImplementationDependencies().extendsFrom(new Configuration[]{((DefaultCppBinary)testedBinary).getImplementationDependencies()});
                                    ConfigurableFileCollection testableObjects = project.files(new Object[0]);
                                    if (mainComponent instanceof CppApplication) {
                                        TaskProvider unexportMainSymbol = tasks.register(testExecutable.getNames().getTaskName("relocateMainFor"), UnexportMainSymbol.class, (Action)new Action<UnexportMainSymbol>(){

                                            public void execute(UnexportMainSymbol unexportMainSymbol) {
                                                unexportMainSymbol.getOutputDirectory().set(project.getLayout().getBuildDirectory().dir("obj/main/for-test"));
                                                unexportMainSymbol.getObjects().from(new Object[]{testedBinary.getObjects()});
                                            }
                                        });
                                        testableObjects.builtBy(new Object[]{unexportMainSymbol});
                                        testableObjects.from(new Object[]{unexportMainSymbol.map((Transformer)new Transformer<FileCollection, UnexportMainSymbol>(){

                                            public FileCollection transform(UnexportMainSymbol unexportMainSymbol) {
                                                return unexportMainSymbol.getRelocatedObjects();
                                            }
                                        })});
                                    } else {
                                        testableObjects.from(new Object[]{testedBinary.getObjects()});
                                    }
                                    Dependency linkDependency = project.getDependencies().create((Object)testableObjects);
                                    testExecutable.getLinkConfiguration().getDependencies().add((Object)linkDependency);
                                    if (testedBinary == mainComponent.getDevelopmentBinary().get() && !testComponent.getTestBinary().isPresent()) {
                                        testComponent.getTestBinary().set((Object)testExecutable);
                                    }
                                }
                            });
                        }
                        TaskProvider testTask = tasks.register(testExecutable.getNames().getTaskName("run"), RunTestExecutable.class, (Action)new Action<RunTestExecutable>(){

                            public void execute(RunTestExecutable testTask) {
                                testTask.setGroup("verification");
                                testTask.setDescription("Executes C++ unit tests.");
                                InstallExecutable installTask = (InstallExecutable)testExecutable.getInstallTask().get();
                                testTask.onlyIf((Spec)new Spec<Task>(){

                                    public boolean isSatisfiedBy(Task element) {
                                        return ((Directory)testExecutable.getInstallDirectory().get()).getAsFile().exists();
                                    }
                                });
                                testTask.getInputs().dir((Object)testExecutable.getInstallDirectory());
                                testTask.setExecutable(((RegularFile)installTask.getRunScriptFile().get()).getAsFile());
                                testTask.dependsOn(new Object[]{testExecutable.getInstallDirectory()});
                                testTask.setOutputDir(((Directory)project.getLayout().getBuildDirectory().dir("test-results/" + testExecutable.getNames().getDirName()).get()).getAsFile());
                            }
                        });
                        testExecutable.getRunTask().set((Provider)testTask);
                    }
                });
                testComponent.getBinaries().realizeNow();
            }
        });
    }

    private boolean isTestedBinary(DefaultCppTestExecutable testExecutable, ProductionCppComponent mainComponent, CppBinary testedBinary) {
        return testedBinary.getTargetPlatform().getOperatingSystemFamily().getName() == testExecutable.getTargetPlatform().getOperatingSystemFamily().getName() && testedBinary.getTargetPlatform().getArchitecture().getName() == testExecutable.getTargetPlatform().getArchitecture().getName() && !testedBinary.isOptimized() && this.hasDevelopmentBinaryLinkage(mainComponent, testedBinary);
    }

    private boolean hasDevelopmentBinaryLinkage(ProductionCppComponent mainComponent, CppBinary testedBinary) {
        if (!(testedBinary instanceof ConfigurableComponentWithLinkUsage)) {
            return true;
        }
        ConfigurableComponentWithLinkUsage developmentBinaryWithUsage = (ConfigurableComponentWithLinkUsage)mainComponent.getDevelopmentBinary().get();
        ConfigurableComponentWithLinkUsage testedBinaryWithUsage = (ConfigurableComponentWithLinkUsage)testedBinary;
        return testedBinaryWithUsage.getLinkage() == developmentBinaryWithUsage.getLinkage();
    }

    private void validateTargetMachines(Set<TargetMachine> testTargetMachines, @Nullable Set<TargetMachine> mainTargetMachines) {
        if (testTargetMachines.isEmpty()) {
            throw new IllegalArgumentException("A target machine needs to be specified for the unit test.");
        }
        if (mainTargetMachines != null) {
            for (TargetMachine machine : testTargetMachines) {
                if (mainTargetMachines.contains(machine)) continue;
                throw new IllegalArgumentException("The target machine " + machine.toString() + " was specified for the unit test, but this target machine was not specified on the main component.");
            }
        }
    }
}

