/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.Task;
import org.gradle.api.internal.tasks.TaskDependencyContainer;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;

public class FailureCollectingTaskDependencyResolveContext
implements TaskDependencyResolveContext {
    private final Set<Object> seen = new HashSet<Object>();
    private final TaskDependencyResolveContext context;
    private final Set<Throwable> failures = new LinkedHashSet<Throwable>();

    public FailureCollectingTaskDependencyResolveContext(TaskDependencyResolveContext context) {
        this.context = context;
    }

    public Set<Throwable> getFailures() {
        return this.failures;
    }

    @Override
    public void add(Object dep) {
        if (!this.seen.add(dep)) {
            return;
        }
        if (dep instanceof TaskDependencyContainer) {
            TaskDependencyContainer container = (TaskDependencyContainer)dep;
            container.visitDependencies(this);
        } else {
            this.context.add(dep);
        }
    }

    @Override
    public void maybeAdd(Object dependency) {
        if (!this.seen.add(dependency)) {
            return;
        }
        if (dependency instanceof TaskDependencyContainer) {
            TaskDependencyContainer container = (TaskDependencyContainer)dependency;
            container.visitDependencies(this);
        } else {
            this.context.maybeAdd(dependency);
        }
    }

    @Override
    public void visitFailure(Throwable failure) {
        this.failures.add(failure);
    }

    @Override
    public Task getTask() {
        return this.context.getTask();
    }
}

