/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.test.xctest.plugins;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Named;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.Usage;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.component.UsageContext;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.language.cpp.CppBinary;
import org.gradle.language.cpp.internal.DefaultUsageContext;
import org.gradle.language.cpp.internal.NativeVariantIdentity;
import org.gradle.language.internal.NativeComponentFactory;
import org.gradle.language.nativeplatform.internal.BuildType;
import org.gradle.language.nativeplatform.internal.Dimensions;
import org.gradle.language.nativeplatform.internal.Names;
import org.gradle.language.nativeplatform.internal.toolchains.ToolChainSelector;
import org.gradle.language.swift.ProductionSwiftComponent;
import org.gradle.language.swift.SwiftApplication;
import org.gradle.language.swift.SwiftBinary;
import org.gradle.language.swift.SwiftComponent;
import org.gradle.language.swift.SwiftPlatform;
import org.gradle.language.swift.internal.DefaultSwiftBinary;
import org.gradle.language.swift.plugins.SwiftBasePlugin;
import org.gradle.language.swift.tasks.SwiftCompile;
import org.gradle.language.swift.tasks.UnexportMainSymbol;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.nativeplatform.MachineArchitecture;
import org.gradle.nativeplatform.OperatingSystemFamily;
import org.gradle.nativeplatform.TargetMachine;
import org.gradle.nativeplatform.TargetMachineFactory;
import org.gradle.nativeplatform.platform.internal.DefaultNativePlatform;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.nativeplatform.tasks.InstallExecutable;
import org.gradle.nativeplatform.tasks.LinkMachOBundle;
import org.gradle.nativeplatform.test.plugins.NativeTestingBasePlugin;
import org.gradle.nativeplatform.test.xctest.SwiftXCTestBundle;
import org.gradle.nativeplatform.test.xctest.SwiftXCTestSuite;
import org.gradle.nativeplatform.test.xctest.internal.DefaultSwiftXCTestBinary;
import org.gradle.nativeplatform.test.xctest.internal.DefaultSwiftXCTestBundle;
import org.gradle.nativeplatform.test.xctest.internal.DefaultSwiftXCTestExecutable;
import org.gradle.nativeplatform.test.xctest.internal.DefaultSwiftXCTestSuite;
import org.gradle.nativeplatform.test.xctest.tasks.InstallXCTestBundle;
import org.gradle.nativeplatform.test.xctest.tasks.XCTest;
import org.gradle.nativeplatform.toolchain.NativeToolChain;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainRegistryInternal;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;
import org.gradle.nativeplatform.toolchain.internal.xcode.MacOSSdkPlatformPathLocator;
import org.gradle.platform.base.Platform;
import org.gradle.util.GUtil;

@Incubating
public class XCTestConventionPlugin
implements Plugin<ProjectInternal> {
    private final MacOSSdkPlatformPathLocator sdkPlatformPathLocator;
    private final ToolChainSelector toolChainSelector;
    private final NativeComponentFactory componentFactory;
    private final ObjectFactory objectFactory;
    private final ImmutableAttributesFactory attributesFactory;
    private final TargetMachineFactory targetMachineFactory;

    @Inject
    public XCTestConventionPlugin(MacOSSdkPlatformPathLocator sdkPlatformPathLocator, ToolChainSelector toolChainSelector, NativeComponentFactory componentFactory, ObjectFactory objectFactory, ImmutableAttributesFactory attributesFactory, TargetMachineFactory targetMachineFactory) {
        this.sdkPlatformPathLocator = sdkPlatformPathLocator;
        this.toolChainSelector = toolChainSelector;
        this.componentFactory = componentFactory;
        this.objectFactory = objectFactory;
        this.attributesFactory = attributesFactory;
        this.targetMachineFactory = targetMachineFactory;
    }

    public void apply(ProjectInternal project) {
        project.getPluginManager().apply(SwiftBasePlugin.class);
        project.getPluginManager().apply(NativeTestingBasePlugin.class);
        final DefaultSwiftXCTestSuite testComponent = this.createTestSuite((Project)project);
        testComponent.getTargetMachines().convention((Iterable)Dimensions.getDefaultTargetMachines((TargetMachineFactory)this.targetMachineFactory));
        project.getComponents().withType(ProductionSwiftComponent.class, (Action)new Action<ProductionSwiftComponent>(){

            public void execute(ProductionSwiftComponent component) {
                if ("main".equals(component.getName())) {
                    testComponent.getTargetMachines().convention((Provider)component.getTargetMachines());
                    testComponent.getTestedComponent().set((Object)component);
                }
            }
        });
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(final Project project) {
                ProductionSwiftComponent mainComponent = (ProductionSwiftComponent)project.getComponents().withType(ProductionSwiftComponent.class).findByName("main");
                testComponent.getTargetMachines().finalizeValue();
                Set targetMachines = (Set)testComponent.getTargetMachines().get();
                XCTestConventionPlugin.this.validateTargetMachines(targetMachines, mainComponent != null ? (Set)mainComponent.getTargetMachines().get() : null);
                Usage runtimeUsage = (Usage)XCTestConventionPlugin.this.objectFactory.named(Usage.class, "native-runtime");
                BuildType buildType = BuildType.DEBUG;
                for (TargetMachine targetMachine : targetMachines) {
                    String operatingSystemSuffix = Dimensions.createDimensionSuffix((Named)targetMachine.getOperatingSystemFamily(), (Collection)targetMachines.stream().map(TargetMachine::getOperatingSystemFamily).collect(Collectors.toSet()));
                    String architectureSuffix = Dimensions.createDimensionSuffix((Named)targetMachine.getArchitecture(), (Collection)targetMachines.stream().map(TargetMachine::getArchitecture).collect(Collectors.toSet()));
                    String variantName = buildType.getName() + operatingSystemSuffix + architectureSuffix;
                    Provider group = project.provider((Callable)new Callable<String>(){

                        @Override
                        public String call() throws Exception {
                            return project.getGroup().toString();
                        }
                    });
                    Provider version = project.provider((Callable)new Callable<String>(){

                        @Override
                        public String call() throws Exception {
                            return project.getVersion().toString();
                        }
                    });
                    AttributeContainerInternal runtimeAttributes = XCTestConventionPlugin.this.attributesFactory.mutable();
                    runtimeAttributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)runtimeUsage);
                    runtimeAttributes.attribute(CppBinary.DEBUGGABLE_ATTRIBUTE, (Object)buildType.isDebuggable());
                    runtimeAttributes.attribute(CppBinary.OPTIMIZED_ATTRIBUTE, (Object)buildType.isOptimized());
                    runtimeAttributes.attribute(OperatingSystemFamily.OPERATING_SYSTEM_ATTRIBUTE, (Object)targetMachine.getOperatingSystemFamily());
                    runtimeAttributes.attribute(MachineArchitecture.ARCHITECTURE_ATTRIBUTE, (Object)targetMachine.getArchitecture());
                    NativeVariantIdentity variantIdentity = new NativeVariantIdentity(variantName, (Provider)testComponent.getModule(), group, version, buildType.isDebuggable(), buildType.isOptimized(), targetMachine, null, (UsageContext)new DefaultUsageContext(variantName + "-runtime", runtimeUsage, (AttributeContainer)runtimeAttributes));
                    if (!DefaultNativePlatform.getCurrentOperatingSystem().toFamilyName().equals(targetMachine.getOperatingSystemFamily().getName())) continue;
                    ToolChainSelector.Result result = XCTestConventionPlugin.this.toolChainSelector.select(SwiftPlatform.class, targetMachine);
                    DefaultSwiftXCTestBinary binary = ((SwiftPlatform)result.getTargetPlatform()).getOperatingSystemFamily().isMacOs() ? (DefaultSwiftXCTestBinary)((Object)testComponent.addBundle(variantIdentity, (SwiftPlatform)result.getTargetPlatform(), result.getToolChain(), result.getPlatformToolProvider())) : (DefaultSwiftXCTestBinary)((Object)testComponent.addExecutable(variantIdentity, (SwiftPlatform)result.getTargetPlatform(), result.getToolChain(), result.getPlatformToolProvider()));
                    testComponent.getTestBinary().set((Object)binary);
                }
                testComponent.getBinaries().whenElementKnown(DefaultSwiftXCTestBinary.class, (Action)new Action<DefaultSwiftXCTestBinary>(){

                    public void execute(final DefaultSwiftXCTestBinary binary) {
                        TaskProvider testingTask = XCTestConventionPlugin.this.createTestingTask(project);
                        binary.getRunTask().set((Provider)testingTask);
                        testingTask.configure((Action)new Action<XCTest>(){

                            public void execute(XCTest xcTest) {
                                xcTest.getTestInstallDirectory().set((Provider)binary.getInstallDirectory());
                                xcTest.getRunScriptFile().set((Provider)binary.getRunScriptFile());
                                xcTest.getWorkingDirectory().set((Provider)binary.getInstallDirectory());
                            }
                        });
                        XCTestConventionPlugin.this.configureTestSuiteBuildingTasks((ProjectInternal)project, binary);
                        XCTestConventionPlugin.this.configureTestSuiteWithTestedComponentWhenAvailable(project, testComponent, binary);
                    }
                });
                testComponent.getBinaries().realizeNow();
            }
        });
    }

    private void configureTestSuiteBuildingTasks(final ProjectInternal project, final DefaultSwiftXCTestBinary binary) {
        if (binary instanceof SwiftXCTestBundle) {
            TaskContainerInternal tasks = project.getTasks();
            final Names names = binary.getNames();
            final DefaultNativePlatform currentPlatform = new DefaultNativePlatform("current");
            ModelRegistry modelRegistry = project.getModelRegistry();
            final NativeToolChain toolChain = (NativeToolChain)((NativeToolChainRegistryInternal)modelRegistry.realize("toolChains", NativeToolChainRegistryInternal.class)).getForPlatform((Platform)currentPlatform);
            SwiftCompile compile = (SwiftCompile)binary.getCompileTask().get();
            compile.getCompilerArgs().addAll(project.provider((Callable)new Callable<List<String>>(){

                @Override
                public List<String> call() {
                    File frameworkDir = new File(XCTestConventionPlugin.this.sdkPlatformPathLocator.find(), "Developer/Library/Frameworks");
                    return Arrays.asList("-parse-as-library", "-F" + frameworkDir.getAbsolutePath());
                }
            }));
            final TaskProvider link = tasks.register(names.getTaskName("link"), LinkMachOBundle.class, (Action)new Action<LinkMachOBundle>(){

                public void execute(LinkMachOBundle link) {
                    link.getLinkerArgs().set(project.provider((Callable)new Callable<List<String>>(){

                        @Override
                        public List<String> call() {
                            File frameworkDir = new File(XCTestConventionPlugin.this.sdkPlatformPathLocator.find(), "Developer/Library/Frameworks");
                            return Lists.newArrayList((Object[])new String[]{"-F" + frameworkDir.getAbsolutePath(), "-framework", "XCTest", "-Xlinker", "-rpath", "-Xlinker", "@executable_path/../Frameworks", "-Xlinker", "-rpath", "-Xlinker", "@loader_path/../Frameworks"});
                        }
                    }));
                    link.source((Object)binary.getObjects());
                    link.lib((Object)binary.getLinkLibraries());
                    final PlatformToolProvider toolProvider = ((NativeToolChainInternal)toolChain).select((NativePlatformInternal)currentPlatform);
                    Provider exeLocation = project.getLayout().getBuildDirectory().file(project.getProviders().provider((Callable)new Callable<String>(){

                        @Override
                        public String call() {
                            return toolProvider.getExecutableName("exe/" + names.getDirName() + (String)binary.getBaseName().get());
                        }
                    }));
                    link.getLinkedFile().set(exeLocation);
                    link.getTargetPlatform().set((Object)currentPlatform);
                    link.getToolChain().set((Object)toolChain);
                    link.getDebuggable().set((Object)binary.isDebuggable());
                }
            });
            TaskProvider install = tasks.register(names.getTaskName("install"), InstallXCTestBundle.class, (Action)new Action<InstallXCTestBundle>(){

                public void execute(InstallXCTestBundle install) {
                    install.getBundleBinaryFile().set((Provider)((LinkMachOBundle)link.get()).getLinkedFile());
                    install.getInstallDirectory().set(project.getLayout().getBuildDirectory().dir("install/" + names.getDirName()));
                }
            });
            binary.getInstallDirectory().set(install.flatMap((Transformer)new Transformer<Provider<? extends Directory>, InstallXCTestBundle>(){

                public Provider<? extends Directory> transform(InstallXCTestBundle installXCTestBundle) {
                    return installXCTestBundle.getInstallDirectory();
                }
            }));
            binary.getExecutableFile().set(link.flatMap((Transformer)new Transformer<Provider<? extends RegularFile>, LinkMachOBundle>(){

                public Provider<? extends RegularFile> transform(LinkMachOBundle linkMachOBundle) {
                    return linkMachOBundle.getLinkedFile();
                }
            }));
            DefaultSwiftXCTestBundle bundle = (DefaultSwiftXCTestBundle)binary;
            bundle.getLinkTask().set((Provider)link);
            bundle.getRunScriptFile().set(install.flatMap((Transformer)new Transformer<Provider<? extends RegularFile>, InstallXCTestBundle>(){

                public Provider<? extends RegularFile> transform(InstallXCTestBundle installXCTestBundle) {
                    return installXCTestBundle.getRunScriptFile();
                }
            }));
        } else {
            DefaultSwiftXCTestExecutable executable = (DefaultSwiftXCTestExecutable)binary;
            executable.getRunScriptFile().set(executable.getInstallTask().flatMap((Transformer)new Transformer<Provider<? extends RegularFile>, InstallExecutable>(){

                public Provider<? extends RegularFile> transform(InstallExecutable installExecutable) {
                    return installExecutable.getRunScriptFile();
                }
            }));
        }
    }

    private TaskProvider<XCTest> createTestingTask(Project project) {
        return project.getTasks().register("xcTest", XCTest.class, (Action)new Action<XCTest>(){

            public void execute(XCTest testTask) {
                testTask.setGroup("verification");
                testTask.setDescription("Executes XCTest suites");
            }
        });
    }

    private DefaultSwiftXCTestSuite createTestSuite(Project project) {
        DefaultSwiftXCTestSuite testSuite = (DefaultSwiftXCTestSuite)this.componentFactory.newInstance(SwiftXCTestSuite.class, DefaultSwiftXCTestSuite.class, "test");
        project.getExtensions().add(SwiftXCTestSuite.class, "xctest", (Object)testSuite);
        project.getComponents().add((Object)testSuite);
        testSuite.getModule().set((Object)GUtil.toCamelCase((CharSequence)(project.getName() + "Test")));
        return testSuite;
    }

    private void configureTestSuiteWithTestedComponentWhenAvailable(final Project project, final DefaultSwiftXCTestSuite testSuite, final DefaultSwiftXCTestBinary testExecutable) {
        SwiftComponent target = (SwiftComponent)testSuite.getTestedComponent().getOrNull();
        if (!(target instanceof ProductionSwiftComponent)) {
            return;
        }
        final ProductionSwiftComponent testedComponent = (ProductionSwiftComponent)target;
        final TaskContainer tasks = project.getTasks();
        testedComponent.getBinaries().whenElementFinalized((Action)new Action<SwiftBinary>(){

            public void execute(final SwiftBinary testedBinary) {
                if (testedBinary != testedComponent.getDevelopmentBinary().get()) {
                    return;
                }
                if (testSuite.getSourceCompatibility().getOrNull() == null) {
                    testExecutable.getSourceCompatibility().set(testedBinary.getSourceCompatibility());
                }
                testExecutable.getImplementationDependencies().extendsFrom(new Configuration[]{((DefaultSwiftBinary)testedBinary).getImplementationDependencies()});
                Dependency compileDependency = project.getDependencies().create((Object)project.files(new Object[]{testedBinary.getModuleFile()}));
                testExecutable.getImportPathConfiguration().getDependencies().add((Object)compileDependency);
                ConfigurableFileCollection testableObjects = project.files(new Object[0]);
                if (testedComponent instanceof SwiftApplication) {
                    TaskProvider unexportMainSymbol = tasks.register("relocateMainForTest", UnexportMainSymbol.class, (Action)new Action<UnexportMainSymbol>(){

                        public void execute(UnexportMainSymbol unexportMainSymbol) {
                            unexportMainSymbol.getOutputDirectory().set(project.getLayout().getBuildDirectory().dir("obj/main/for-test"));
                            unexportMainSymbol.getObjects().from(new Object[]{testedBinary.getObjects()});
                        }
                    });
                    testableObjects.builtBy(new Object[]{unexportMainSymbol});
                    testableObjects.from(new Object[]{unexportMainSymbol.map((Transformer)new Transformer<FileCollection, UnexportMainSymbol>(){

                        public FileCollection transform(UnexportMainSymbol unexportMainSymbol) {
                            return unexportMainSymbol.getRelocatedObjects();
                        }
                    })});
                } else {
                    testableObjects.from(new Object[]{testedBinary.getObjects()});
                }
                Dependency linkDependency = project.getDependencies().create((Object)testableObjects);
                testExecutable.getLinkConfiguration().getDependencies().add((Object)linkDependency);
            }
        });
    }

    private void validateTargetMachines(Set<TargetMachine> testTargetMachines, @Nullable Set<TargetMachine> mainTargetMachines) {
        if (testTargetMachines.isEmpty()) {
            throw new IllegalArgumentException("A target machine needs to be specified for the unit test.");
        }
        if (mainTargetMachines != null) {
            for (TargetMachine machine : testTargetMachines) {
                if (mainTargetMachines.contains(machine)) continue;
                throw new IllegalArgumentException("The target machine " + machine.toString() + " was specified for the unit test, but this target machine was not specified on the main component.");
            }
        }
    }
}

