/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.options;

import java.lang.reflect.Method;
import java.util.List;
import org.gradle.api.internal.tasks.options.AbstractOptionElement;
import org.gradle.api.internal.tasks.options.OptionValidationException;
import org.gradle.api.internal.tasks.options.OptionValueNotationParserFactory;
import org.gradle.api.tasks.options.Option;
import org.gradle.internal.typeconversion.NotationParser;

public class MethodOptionElement
extends AbstractOptionElement {
    private final Method method;

    MethodOptionElement(Option option, Method method, Class<?> optionType, NotationParser<CharSequence, ?> notationParser) {
        super(option.option(), option, optionType, method.getDeclaringClass(), notationParser);
        this.method = method;
        MethodOptionElement.assertMethodTypeSupported(this.getOptionName(), method);
        this.assertValidOptionName();
    }

    private void assertValidOptionName() {
        if (this.getOptionName() == null || this.getOptionName().length() == 0) {
            throw new OptionValidationException(String.format("No option name set on '%s' in class '%s'.", this.getElementName(), this.getDeclaredClass().getName()));
        }
    }

    @Override
    public Class<?> getDeclaredClass() {
        return this.method.getDeclaringClass();
    }

    @Override
    public String getElementName() {
        return this.method.getName();
    }

    @Override
    public void apply(Object object, List<String> parameterValues) {
        if (parameterValues.size() == 0) {
            this.invokeMethod(object, this.method, true);
        } else if (parameterValues.size() > 1 || List.class.equals((Object)this.getOptionType())) {
            this.invokeMethod(object, this.method, parameterValues);
        } else {
            this.invokeMethod(object, this.method, this.getNotationParser().parseNotation((Object)parameterValues.get(0)));
        }
    }

    public static MethodOptionElement create(Option option, Method method, OptionValueNotationParserFactory optionValueNotationParserFactory) {
        Class<?> optionType = MethodOptionElement.calculateOptionType(method);
        NotationParser<CharSequence, ?> notationParser = MethodOptionElement.createNotationParserOrFail(optionValueNotationParserFactory, option.option(), optionType, method.getDeclaringClass());
        return new MethodOptionElement(option, method, optionType, notationParser);
    }

    private static Class<?> calculateOptionType(Method optionMethod) {
        if (optionMethod.getParameterTypes().length == 0) {
            return Void.TYPE;
        }
        return MethodOptionElement.calculateOptionType(optionMethod.getParameterTypes()[0]);
    }

    private static void assertMethodTypeSupported(String optionName, Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length > 1) {
            throw new OptionValidationException(String.format("Option '%s' cannot be linked to methods with multiple parameters in class '%s#%s'.", optionName, method.getDeclaringClass().getName(), method.getName()));
        }
    }
}

