/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.kotlin.dsl.tooling.builders;

import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.tasks.SourceSet;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.internal.resource.TextResource;
import org.gradle.kotlin.dsl.support.KotlinScriptType;
import org.gradle.kotlin.dsl.support.KotlinScriptTypeKt;
import org.gradle.kotlin.dsl.tooling.builders.KotlinBuildScriptModelBuilder$WhenMappings;
import org.gradle.kotlin.dsl.tooling.builders.KotlinBuildScriptModelBuilderKt;
import org.gradle.kotlin.dsl.tooling.builders.KotlinBuildScriptModelParameter;
import org.gradle.kotlin.dsl.tooling.builders.KotlinScriptTargetModelBuilder;
import org.gradle.kotlin.dsl.tooling.models.KotlinBuildScriptModel;
import org.gradle.tooling.provider.model.ToolingModelBuilder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0010H\u0002\u00a8\u0006\u0015"}, d2={"Lorg/gradle/kotlin/dsl/tooling/builders/KotlinBuildScriptModelBuilder;", "Lorg/gradle/tooling/provider/model/ToolingModelBuilder;", "()V", "buildAll", "Lorg/gradle/kotlin/dsl/tooling/models/KotlinBuildScriptModel;", "modelName", "", "modelRequestProject", "Lorg/gradle/api/Project;", "canBuild", "", "isSettingsFileOf", "project", "scriptFile", "Ljava/io/File;", "requestParameterOf", "Lorg/gradle/kotlin/dsl/tooling/builders/KotlinBuildScriptModelParameter;", "scriptModelBuilderFor", "Lorg/gradle/kotlin/dsl/tooling/builders/KotlinScriptTargetModelBuilder;", "Lorg/gradle/api/internal/project/ProjectInternal;", "parameter", "gradle-kotlin-dsl-tooling-builders"})
public final class KotlinBuildScriptModelBuilder
implements ToolingModelBuilder {
    public static final KotlinBuildScriptModelBuilder INSTANCE;

    public boolean canBuild(@NotNull String modelName) {
        Intrinsics.checkParameterIsNotNull((Object)modelName, (String)"modelName");
        return Intrinsics.areEqual((Object)modelName, (Object)"org.gradle.kotlin.dsl.tooling.models.KotlinBuildScriptModel");
    }

    @NotNull
    public KotlinBuildScriptModel buildAll(@NotNull String modelName, @NotNull Project modelRequestProject) {
        Intrinsics.checkParameterIsNotNull((Object)modelName, (String)"modelName");
        Intrinsics.checkParameterIsNotNull((Object)modelRequestProject, (String)"modelRequestProject");
        return this.scriptModelBuilderFor((ProjectInternal)modelRequestProject, this.requestParameterOf(modelRequestProject)).buildModel();
    }

    /*
     * Enabled aggressive block sorting
     */
    private final KotlinScriptTargetModelBuilder scriptModelBuilderFor(ProjectInternal modelRequestProject, KotlinBuildScriptModelParameter parameter) {
        KotlinScriptTargetModelBuilder kotlinScriptTargetModelBuilder;
        File file = KotlinBuildScriptModelBuilderKt.access$getScriptFile$p(parameter);
        if (file == null) return KotlinBuildScriptModelBuilderKt.access$projectScriptModelBuilder(null, (Project)modelRequestProject);
        File scriptFile = file;
        Project project = KotlinBuildScriptModelBuilderKt.access$findProjectWithBuildFile((Project)modelRequestProject, scriptFile);
        if (project != null) {
            Project project2;
            Project buildFileProject = project2 = project;
            return KotlinBuildScriptModelBuilderKt.access$projectScriptModelBuilder(scriptFile, buildFileProject);
        }
        SourceSet sourceSet = KotlinBuildScriptModelBuilderKt.access$enclosingSourceSetOf((Project)modelRequestProject, scriptFile);
        if (sourceSet != null) {
            SourceSet sourceSet2;
            SourceSet enclosingSourceSet = sourceSet2 = sourceSet;
            return KotlinBuildScriptModelBuilderKt.access$precompiledScriptPluginModelBuilder(scriptFile, enclosingSourceSet, (Project)modelRequestProject);
        }
        if (this.isSettingsFileOf((Project)modelRequestProject, scriptFile)) {
            return KotlinBuildScriptModelBuilderKt.access$settingsScriptModelBuilder(scriptFile, (Project)modelRequestProject);
        }
        KotlinScriptType kotlinScriptType = KotlinScriptTypeKt.kotlinScriptTypeFor((File)scriptFile);
        if (kotlinScriptType != null) {
            switch (KotlinBuildScriptModelBuilder$WhenMappings.$EnumSwitchMapping$0[kotlinScriptType.ordinal()]) {
                case 1: {
                    kotlinScriptTargetModelBuilder = KotlinBuildScriptModelBuilderKt.access$initScriptModelBuilder(scriptFile, modelRequestProject);
                    return kotlinScriptTargetModelBuilder;
                }
                case 2: {
                    kotlinScriptTargetModelBuilder = KotlinBuildScriptModelBuilderKt.access$settingsScriptPluginModelBuilder(scriptFile, modelRequestProject);
                    return kotlinScriptTargetModelBuilder;
                }
            }
        }
        kotlinScriptTargetModelBuilder = KotlinBuildScriptModelBuilderKt.access$projectScriptPluginModelBuilder(scriptFile, modelRequestProject);
        return kotlinScriptTargetModelBuilder;
    }

    private final boolean isSettingsFileOf(Project project, File scriptFile) {
        ScriptSource scriptSource = KotlinBuildScriptModelBuilderKt.access$getSettings$p(project).getSettingsScript();
        Intrinsics.checkExpressionValueIsNotNull((Object)scriptSource, (String)"project.settings.settingsScript");
        TextResource textResource = scriptSource.getResource();
        Intrinsics.checkExpressionValueIsNotNull((Object)textResource, (String)"project.settings.settingsScript.resource");
        File file = textResource.getFile();
        return Intrinsics.areEqual((Object)(file != null ? file.getCanonicalFile() : null), (Object)scriptFile);
    }

    private final KotlinBuildScriptModelParameter requestParameterOf(Project modelRequestProject) {
        Object object = modelRequestProject.findProperty("org.gradle.kotlin.dsl.provider.script");
        if (!(object instanceof String)) {
            object = null;
        }
        return new KotlinBuildScriptModelParameter((String)object);
    }

    private KotlinBuildScriptModelBuilder() {
    }

    static {
        KotlinBuildScriptModelBuilder kotlinBuildScriptModelBuilder;
        INSTANCE = kotlinBuildScriptModelBuilder = new KotlinBuildScriptModelBuilder();
    }
}

