/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm;

import java.io.Closeable;
import java.io.File;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CLICompiler;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.CLITool;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.FilteringMessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageUtil;
import org.jetbrains.kotlin.cli.common.messages.OutputMessageUtil;
import org.jetbrains.kotlin.cli.common.modules.ModuleChunk;
import org.jetbrains.kotlin.cli.jvm.K2JVMCompiler;
import org.jetbrains.kotlin.cli.jvm.K2JVMCompilerKt$sam$java_util_function_Predicate$0;
import org.jetbrains.kotlin.cli.jvm.compiler.CompileEnvironmentUtil;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinToJVMBytecodeCompiler;
import org.jetbrains.kotlin.cli.jvm.config.JvmClasspathRoot;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRootsKt;
import org.jetbrains.kotlin.cli.jvm.config.JvmModulePathRoot;
import org.jetbrains.kotlin.cli.jvm.modules.CoreJrtFileSystem;
import org.jetbrains.kotlin.cli.jvm.plugins.PluginCliParser;
import org.jetbrains.kotlin.cli.jvm.repl.ReplFromTerminal;
import org.jetbrains.kotlin.codegen.CompilationException;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.ContentRootsKt;
import org.jetbrains.kotlin.config.IncrementalCompilation;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.config.JVMConstructorCallNormalizationMode;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.incremental.components.ExpectActualTracker;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.javac.JavacWrapper;
import org.jetbrains.kotlin.load.java.JavaClassesTracker;
import org.jetbrains.kotlin.load.kotlin.incremental.components.IncrementalCompilationComponents;
import org.jetbrains.kotlin.modules.Module;
import org.jetbrains.kotlin.script.KotlinScriptDefinitionFromAnnotatedTemplate;
import org.jetbrains.kotlin.script.ScriptDefinitionProvider;
import org.jetbrains.kotlin.script.StandardScriptDefinition;
import org.jetbrains.kotlin.util.PerformanceCounter;
import org.jetbrains.kotlin.utils.KotlinPaths;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001c2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0002J\b\u0010\t\u001a\u00020\u0002H\u0016J*\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J*\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0002J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u001bH\u0014\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/K2JVMCompiler;", "Lorg/jetbrains/kotlin/cli/common/CLICompiler;", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JVMCompilerArguments;", "()V", "compileJavaFilesIfNeeded", "", "environment", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "arguments", "createArguments", "createCoreEnvironment", "rootDisposable", "Lorg/jetbrains/kotlin/com/intellij/openapi/Disposable;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "doExecute", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "paths", "Lorg/jetbrains/kotlin/utils/KotlinPaths;", "executableScriptFileName", "", "registerJavacIfNeeded", "setupPlatformSpecificArgumentsAndServices", "", "services", "Lorg/jetbrains/kotlin/config/Services;", "Companion", "cli"})
public final class K2JVMCompiler
extends CLICompiler<K2JVMCompilerArguments> {
    private static long initStartNanos;
    private static final HashMap<String, Long> elapsedGCTime;
    private static long elapsedJITTime;
    public static final Companion Companion;

    @Override
    @NotNull
    protected ExitCode doExecute(@NotNull K2JVMCompilerArguments arguments2, @NotNull CompilerConfiguration configuration, @NotNull Disposable rootDisposable, @Nullable KotlinPaths paths) {
        List friendPaths;
        String string;
        ExitCode exitCode2;
        MessageCollector messageCollector2;
        Intrinsics.checkParameterIsNotNull((Object)arguments2, (String)"arguments");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)rootDisposable, (String)"rootDisposable");
        PerformanceCounter.Companion.setTimeCounterEnabled(arguments2.getReportPerf());
        MessageCollector messageCollector3 = messageCollector2 = configuration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        Intrinsics.checkExpressionValueIsNotNull((Object)messageCollector3, (String)"messageCollector");
        ExitCode it = exitCode2 = K2JVMCompiler.Companion.configureJdkHome(arguments2, configuration, messageCollector3);
        if (it != ExitCode.OK) {
            return it;
        }
        ExitCode pluginLoadResult = PluginCliParser.loadPluginsSafe(arguments2, configuration);
        if (pluginLoadResult != ExitCode.OK) {
            return pluginLoadResult;
        }
        if (!arguments2.getScript() && arguments2.getBuildFile() == null) {
            for (String arg : arguments2.getFreeArgs()) {
                File file2 = new File(arg);
                if (Intrinsics.areEqual((Object)FilesKt.getExtension((File)file2), (Object)"java")) {
                    JvmContentRootsKt.addJavaSourceRoot$default(configuration, file2, null, 2, null);
                    continue;
                }
                ContentRootsKt.addKotlinSourceRoot(configuration, arg);
                if (!file2.isDirectory()) continue;
                JvmContentRootsKt.addJavaSourceRoot$default(configuration, file2, null, 2, null);
            }
        }
        if ((string = arguments2.getModuleName()) == null) {
            string = "main";
        }
        configuration.put(CommonConfigurationKeys.MODULE_NAME, string);
        if (arguments2.getBuildFile() == null) {
            K2JVMCompiler.Companion.configureContentRoots(paths, arguments2, configuration);
            if (arguments2.getFreeArgs().isEmpty() && !arguments2.getVersion()) {
                if (arguments2.getScript()) {
                    MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.ERROR, "Specify script source path to evaluate", null, 4, null);
                    return ExitCode.COMPILATION_ERROR;
                }
                ReplFromTerminal.Companion.run(rootDisposable, configuration);
                return ExitCode.OK;
            }
        }
        if (arguments2.getIncludeRuntime()) {
            configuration.put(JVMConfigurationKeys.INCLUDE_RUNTIME, true);
        }
        Object[] objectArray = arguments2.getFriendPaths();
        List list2 = friendPaths = objectArray != null ? ArraysKt.toList((Object[])objectArray) : null;
        if (friendPaths != null) {
            configuration.put(JVMConfigurationKeys.FRIEND_PATHS, friendPaths);
        }
        if (arguments2.getJvmTarget() != null) {
            JvmTarget jvmTarget;
            String string2 = arguments2.getJvmTarget();
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            if ((jvmTarget = JvmTarget.Companion.fromString(string2)) != null) {
                configuration.put(JVMConfigurationKeys.JVM_TARGET, jvmTarget);
            } else {
                MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.ERROR, "Unknown JVM target version: " + arguments2.getJvmTarget() + '\n' + "Supported versions: " + ArraysKt.joinToString$default((Object[])JvmTarget.values(), null, null, null, (int)0, null, (Function1)doExecute.2.INSTANCE, (int)31, null), null, 4, null);
            }
        }
        configuration.put(JVMConfigurationKeys.PARAMETERS_METADATA, arguments2.getJavaParameters());
        K2JVMCompiler.Companion.putAdvancedOptions(configuration, arguments2);
        MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.LOGGING, "Configuring the compilation environment", null, 4, null);
        try {
            block34: {
                boolean bl;
                String destination;
                block35: {
                    KotlinCoreEnvironment environment2;
                    block37: {
                        block36: {
                            block33: {
                                boolean bl2;
                                destination = arguments2.getDestination();
                                if (arguments2.getBuildFile() == null) break block33;
                                if (destination != null) {
                                    MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.STRONG_WARNING, "The '-d' option with a directory destination is ignored because '-Xbuild-file' is specified", null, 4, null);
                                }
                                Function1 function1 = (Function1)new Function1<CompilerMessageSeverity, Boolean>(CompilerMessageSeverity.VERBOSE){

                                    public final boolean invoke(CompilerMessageSeverity p1) {
                                        return ((EnumSet)this.receiver).contains((Object)((Object)p1));
                                    }

                                    public final KDeclarationContainer getOwner() {
                                        return Reflection.getOrCreateKotlinClass(EnumSet.class);
                                    }

                                    public final String getName() {
                                        return "contains";
                                    }

                                    public final String getSignature() {
                                        return "contains(Ljava/lang/Object;)Z";
                                    }
                                };
                                FilteringMessageCollector sanitizedCollector2 = new FilteringMessageCollector(messageCollector2, new K2JVMCompilerKt$sam$java_util_function_Predicate$0(function1));
                                File buildFile = new File(arguments2.getBuildFile());
                                ModuleChunk moduleChunk = CompileEnvironmentUtil.loadModuleChunk(buildFile, sanitizedCollector2);
                                configuration.put(JVMConfigurationKeys.MODULE_XML_FILE, buildFile);
                                ModuleChunk moduleChunk2 = moduleChunk;
                                Intrinsics.checkExpressionValueIsNotNull((Object)moduleChunk2, (String)"moduleChunk");
                                List<Module> list3 = moduleChunk2.getModules();
                                Intrinsics.checkExpressionValueIsNotNull(list3, (String)"moduleChunk.modules");
                                KotlinToJVMBytecodeCompiler.INSTANCE.configureSourceRoots$cli(configuration, list3, buildFile);
                                KotlinCoreEnvironment kotlinCoreEnvironment = this.createCoreEnvironment(rootDisposable, configuration, arguments2, messageCollector2);
                                if (kotlinCoreEnvironment == null) {
                                    return ExitCode.COMPILATION_ERROR;
                                }
                                KotlinCoreEnvironment environment3 = kotlinCoreEnvironment;
                                boolean it2 = bl2 = this.registerJavacIfNeeded(environment3, arguments2);
                                if (!it2) {
                                    return ExitCode.COMPILATION_ERROR;
                                }
                                List<Module> list4 = moduleChunk.getModules();
                                Intrinsics.checkExpressionValueIsNotNull(list4, (String)"moduleChunk.modules");
                                KotlinToJVMBytecodeCompiler.INSTANCE.compileModules$cli(environment3, buildFile, list4);
                                break block34;
                            }
                            if (!arguments2.getScript()) break block35;
                            String sourcePath = (String)CollectionsKt.first(arguments2.getFreeArgs());
                            ContentRootsKt.addKotlinSourceRoot(configuration, sourcePath);
                            configuration.put(JVMConfigurationKeys.RETAIN_OUTPUT_IN_MEMORY, true);
                            KotlinCoreEnvironment kotlinCoreEnvironment = this.createCoreEnvironment(rootDisposable, configuration, arguments2, messageCollector2);
                            if (kotlinCoreEnvironment == null) {
                                return ExitCode.COMPILATION_ERROR;
                            }
                            environment2 = kotlinCoreEnvironment;
                            ScriptDefinitionProvider scriptDefinitionProvider = ScriptDefinitionProvider.Companion.getInstance(environment2.getProject());
                            File scriptFile = new File(sourcePath);
                            if (scriptFile.isDirectory()) break block36;
                            String string3 = scriptFile.getName();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"scriptFile.name");
                            if (scriptDefinitionProvider.isScript(string3)) break block37;
                        }
                        String extensionHint = Intrinsics.areEqual(configuration.get(JVMConfigurationKeys.SCRIPT_DEFINITIONS), (Object)CollectionsKt.listOf((Object)StandardScriptDefinition.INSTANCE)) ? " (.kts)" : "";
                        MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.ERROR, "Specify path to the script file" + extensionHint + " as the first argument", null, 4, null);
                        return ExitCode.COMPILATION_ERROR;
                    }
                    List<String> scriptArgs = arguments2.getFreeArgs().subList(1, arguments2.getFreeArgs().size());
                    return KotlinToJVMBytecodeCompiler.INSTANCE.compileAndExecuteScript$cli(environment2, scriptArgs);
                }
                if (destination != null) {
                    if (StringsKt.endsWith$default((String)destination, (String)".jar", (boolean)false, (int)2, null)) {
                        configuration.put(JVMConfigurationKeys.OUTPUT_JAR, new File(destination));
                    } else {
                        configuration.put(JVMConfigurationKeys.OUTPUT_DIRECTORY, new File(destination));
                    }
                }
                KotlinCoreEnvironment kotlinCoreEnvironment = this.createCoreEnvironment(rootDisposable, configuration, arguments2, messageCollector2);
                if (kotlinCoreEnvironment == null) {
                    return ExitCode.COMPILATION_ERROR;
                }
                KotlinCoreEnvironment environment4 = kotlinCoreEnvironment;
                boolean it3 = bl = this.registerJavacIfNeeded(environment4, arguments2);
                if (!it3) {
                    return ExitCode.COMPILATION_ERROR;
                }
                if (environment4.getSourceFiles().isEmpty()) {
                    if (arguments2.getVersion()) {
                        return ExitCode.OK;
                    }
                    MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.ERROR, "No source files", null, 4, null);
                    return ExitCode.COMPILATION_ERROR;
                }
                KotlinToJVMBytecodeCompiler.INSTANCE.compileBunchOfSources(environment4);
                it3 = bl = this.compileJavaFilesIfNeeded(environment4, arguments2);
                if (!it3) {
                    return ExitCode.COMPILATION_ERROR;
                }
            }
            if (arguments2.getReportPerf()) {
                Companion.reportGCTime(configuration);
                Companion.reportCompilationTime(configuration);
                PerformanceCounter.Companion.report((Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(configuration){
                    final /* synthetic */ CompilerConfiguration $configuration;

                    public final void invoke(@NotNull String s) {
                        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
                        K2JVMCompiler.Companion.reportPerf(this.$configuration, s);
                    }
                    {
                        this.$configuration = compilerConfiguration;
                        super(1);
                    }
                }));
            }
            return ExitCode.OK;
        }
        catch (CompilationException e) {
            String string4 = OutputMessageUtil.renderException(e);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"OutputMessageUtil.renderException(e)");
            messageCollector2.report(CompilerMessageSeverity.EXCEPTION, string4, MessageUtil.psiElementToMessageLocation(e.getElement()));
            return ExitCode.INTERNAL_ERROR;
        }
    }

    private final boolean registerJavacIfNeeded(KotlinCoreEnvironment environment2, K2JVMCompilerArguments arguments2) {
        if (arguments2.getUseJavac()) {
            environment2.getConfiguration().put(JVMConfigurationKeys.USE_JAVAC, true);
            if (arguments2.getCompileJava()) {
                environment2.getConfiguration().put(JVMConfigurationKeys.COMPILE_JAVA, true);
            }
            return KotlinCoreEnvironment.registerJavac$default(environment2, null, null, arguments2.getJavacArguments(), null, null, 27, null);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean compileJavaFilesIfNeeded(KotlinCoreEnvironment environment2, K2JVMCompilerArguments arguments2) {
        if (arguments2.getCompileJava()) {
            boolean bl;
            Closeable closeable = JavacWrapper.Companion.getInstance(environment2.getProject());
            Throwable throwable = null;
            try {
                JavacWrapper it = (JavacWrapper)closeable;
                bl = JavacWrapper.compile$default(it, null, 1, null);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return bl;
        }
        return true;
    }

    private final KotlinCoreEnvironment createCoreEnvironment(Disposable rootDisposable, CompilerConfiguration configuration, K2JVMCompilerArguments arguments2, MessageCollector messageCollector2) {
        HashMap<String, Object> hashMap = Companion.createScriptResolverEnvironment(arguments2, messageCollector2);
        if (hashMap == null) {
            return null;
        }
        HashMap<String, Object> scriptResolverEnv = hashMap;
        Companion.configureScriptDefinitions(arguments2.getScriptTemplates(), configuration, messageCollector2, scriptResolverEnv);
        if (messageCollector2.hasErrors()) {
            return null;
        }
        KotlinCoreEnvironment environment2 = KotlinCoreEnvironment.Companion.createForProduction(rootDisposable, configuration, EnvironmentConfigFiles.JVM_CONFIG_FILES);
        if (initStartNanos != 0L) {
            long initNanos = System.nanoTime() - initStartNanos;
            Companion.reportPerf(configuration, "INIT: Compiler initialized in " + TimeUnit.NANOSECONDS.toMillis(initNanos) + " ms");
            initStartNanos = 0L;
        }
        if (!messageCollector2.hasErrors()) {
            Object object;
            Object object2 = environment2.getProject();
            String string = "projectRoot";
            HashMap<String, Object> hashMap2 = scriptResolverEnv;
            Object $receiver = object2;
            String string2 = $receiver.getBasePath();
            if (string2 == null) {
                VirtualFile virtualFile2 = $receiver.getBaseDir();
                string2 = virtualFile2 != null ? virtualFile2.getCanonicalPath() : null;
            }
            Object object3 = string2;
            HashMap<String, Object> hashMap3 = hashMap2;
            String string3 = string;
            String string4 = object3;
            if (string4 != null) {
                object2 = string4;
                string = string3;
                hashMap2 = hashMap3;
                Object p1 = object2;
                object3 = new File((String)p1);
                hashMap3 = hashMap2;
                string3 = string;
                object = object3;
            } else {
                object = null;
            }
            hashMap3.put(string3, object);
            return environment2;
        }
        return null;
    }

    @Override
    protected void setupPlatformSpecificArgumentsAndServices(@NotNull CompilerConfiguration configuration, @NotNull K2JVMCompilerArguments arguments2, @NotNull Services services) {
        block5: {
            Object object;
            Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
            Intrinsics.checkParameterIsNotNull((Object)arguments2, (String)"arguments");
            Intrinsics.checkParameterIsNotNull((Object)services, (String)"services");
            if (IncrementalCompilation.isEnabled()) {
                Object it;
                LookupTracker lookupTracker = services.get(LookupTracker.class);
                if (lookupTracker != null) {
                    it = object = lookupTracker;
                    configuration.put(CommonConfigurationKeys.LOOKUP_TRACKER, it);
                }
                ExpectActualTracker expectActualTracker = services.get(ExpectActualTracker.class);
                if (expectActualTracker != null) {
                    it = object = expectActualTracker;
                    configuration.put(CommonConfigurationKeys.EXPECT_ACTUAL_TRACKER, it);
                }
                IncrementalCompilationComponents incrementalCompilationComponents = services.get(IncrementalCompilationComponents.class);
                if (incrementalCompilationComponents != null) {
                    it = object = incrementalCompilationComponents;
                    configuration.put(JVMConfigurationKeys.INCREMENTAL_COMPILATION_COMPONENTS, it);
                }
                JavaClassesTracker javaClassesTracker = services.get(JavaClassesTracker.class);
                if (javaClassesTracker != null) {
                    it = object = javaClassesTracker;
                    configuration.put(JVMConfigurationKeys.JAVA_CLASSES_TRACKER, it);
                }
            }
            Object[] objectArray = arguments2.getAdditionalJavaModules();
            if (objectArray == null) break block5;
            Object[] additionalJavaModules = object = objectArray;
            configuration.addAll(JVMConfigurationKeys.ADDITIONAL_JAVA_MODULES, ArraysKt.toList((Object[])additionalJavaModules));
        }
    }

    @Override
    @NotNull
    public K2JVMCompilerArguments createArguments() {
        K2JVMCompilerArguments k2JVMCompilerArguments;
        K2JVMCompilerArguments $receiver = k2JVMCompilerArguments = new K2JVMCompilerArguments();
        if (System.getenv("KOTLIN_REPORT_PERF") != null) {
            $receiver.setReportPerf(true);
        }
        return k2JVMCompilerArguments;
    }

    @Override
    @NotNull
    public String executableScriptFileName() {
        return "kotlinc-jvm";
    }

    static {
        Companion = new Companion(null);
        initStartNanos = System.nanoTime();
        elapsedGCTime = new HashMap();
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Companion.main(args);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\r\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0002JA\u0010\u0016\u001a\u00020\u000b2\u000e\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00182\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0014\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0004\u00a2\u0006\u0002\u0010\u001aJ&\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015J\u001b\u0010\u001c\u001a\u00020\u000b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00050\u0018H\u0007\u00a2\u0006\u0002\u0010\u001eJ\u0018\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u000e\u0010 \u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010!\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\"\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010#\u001a\u00020\u0005J\u0006\u0010$\u001a\u00020\u000bR*\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/K2JVMCompiler$Companion;", "", "()V", "elapsedGCTime", "Ljava/util/HashMap;", "", "", "Lkotlin/collections/HashMap;", "elapsedJITTime", "initStartNanos", "configureContentRoots", "", "paths", "Lorg/jetbrains/kotlin/utils/KotlinPaths;", "arguments", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JVMCompilerArguments;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "configureJdkHome", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "configureScriptDefinitions", "scriptTemplates", "", "scriptResolverEnv", "([Ljava/lang/String;Lorg/jetbrains/kotlin/config/CompilerConfiguration;Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;Ljava/util/HashMap;)V", "createScriptResolverEnvironment", "main", "args", "([Ljava/lang/String;)V", "putAdvancedOptions", "reportCompilationTime", "reportGCTime", "reportPerf", "message", "resetInitStartTime", "cli"})
    public static final class Companion {
        public final void resetInitStartTime() {
            if (initStartNanos == 0L) {
                initStartNanos = System.nanoTime();
            }
        }

        @JvmStatic
        public final void main(@NotNull String[] args) {
            Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
            CLITool.Companion.doMain(new K2JVMCompiler(), args);
        }

        public final void reportPerf(@NotNull CompilerConfiguration configuration, @NotNull String message) {
            Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            if (!configuration.getBoolean(CLIConfigurationKeys.REPORT_PERF)) {
                return;
            }
            MessageCollector.DefaultImpls.report$default(configuration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY), CompilerMessageSeverity.INFO, "PERF: " + message, null, 4, null);
        }

        public final void reportGCTime(@NotNull CompilerConfiguration configuration) {
            Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
            List<GarbageCollectorMXBean> list2 = ManagementFactory.getGarbageCollectorMXBeans();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"ManagementFactory.getGarbageCollectorMXBeans()");
            Iterable $receiver$iv = list2;
            for (Object element$iv : $receiver$iv) {
                String string;
                String string2;
                GarbageCollectorMXBean it;
                GarbageCollectorMXBean garbageCollectorMXBean = it = (GarbageCollectorMXBean)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)garbageCollectorMXBean, (String)"it");
                long currentTime = garbageCollectorMXBean.getCollectionTime();
                Map map2 = elapsedGCTime;
                Intrinsics.checkExpressionValueIsNotNull((Object)it.getName(), (String)"it.name");
                Object object = map2.get(string2);
                if (object == null) {
                    object = 0L;
                }
                long elapsedTime = ((Number)object).longValue();
                long time = currentTime - elapsedTime;
                Companion.reportPerf(configuration, "GC time for " + it.getName() + " is " + time + " ms");
                Map map3 = elapsedGCTime;
                Intrinsics.checkExpressionValueIsNotNull((Object)it.getName(), (String)"it.name");
                Long l = currentTime;
                map3.put(string, l);
            }
        }

        public final void reportCompilationTime(@NotNull CompilerConfiguration configuration) {
            Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
            CompilationMXBean compilationMXBean = ManagementFactory.getCompilationMXBean();
            if (compilationMXBean == null) {
                return;
            }
            CompilationMXBean bean = compilationMXBean;
            long currentTime = bean.getTotalCompilationTime();
            this.reportPerf(configuration, "JIT time is " + (currentTime - elapsedJITTime) + " ms");
            elapsedJITTime = currentTime;
        }

        /*
         * WARNING - void declaration
         */
        private final void putAdvancedOptions(CompilerConfiguration configuration, K2JVMCompilerArguments arguments2) {
            block4: {
                JVMConstructorCallNormalizationMode jVMConstructorCallNormalizationMode;
                Object object;
                configuration.put(JVMConfigurationKeys.DISABLE_CALL_ASSERTIONS, arguments2.getNoCallAssertions());
                configuration.put(JVMConfigurationKeys.DISABLE_RECEIVER_ASSERTIONS, arguments2.getNoReceiverAssertions());
                configuration.put(JVMConfigurationKeys.DISABLE_PARAM_ASSERTIONS, arguments2.getNoParamAssertions());
                configuration.put(JVMConfigurationKeys.NO_EXCEPTION_ON_EXPLICIT_EQUALS_FOR_BOXED_NULL, arguments2.getNoExceptionOnExplicitEqualsForBoxedNull());
                configuration.put(JVMConfigurationKeys.DISABLE_OPTIMIZATION, arguments2.getNoOptimize());
                JVMConstructorCallNormalizationMode constructorCallNormalizationMode = JVMConstructorCallNormalizationMode.Companion.fromStringOrNull(arguments2.getConstructorCallNormalizationMode());
                if (constructorCallNormalizationMode == null) {
                    Collection<String> collection;
                    void $receiver$iv$iv;
                    void $receiver$iv;
                    object = JVMConstructorCallNormalizationMode.values();
                    StringBuilder stringBuilder = new StringBuilder().append("Unknown constructor call normalization mode: ").append(arguments2.getConstructorCallNormalizationMode()).append(", ").append("supported modes: ");
                    CompilerMessageSeverity compilerMessageSeverity = CompilerMessageSeverity.ERROR;
                    MessageCollector messageCollector2 = configuration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
                    void var5_8 = $receiver$iv;
                    Collection destination$iv$iv = new ArrayList(((void)$receiver$iv).length);
                    int n = ((void)$receiver$iv$iv).length;
                    for (int i = 0; i < n; ++i) {
                        void it;
                        void item$iv$iv;
                        void var10_13 = item$iv$iv = $receiver$iv$iv[i];
                        collection = destination$iv$iv;
                        String string = it.getDescription();
                        collection.add(string);
                    }
                    collection = (List)destination$iv$iv;
                    MessageCollector.DefaultImpls.report$default(messageCollector2, compilerMessageSeverity, stringBuilder.append(collection).toString(), null, 4, null);
                }
                if ((jVMConstructorCallNormalizationMode = constructorCallNormalizationMode) == null) {
                    jVMConstructorCallNormalizationMode = JVMConstructorCallNormalizationMode.DEFAULT;
                }
                configuration.put(JVMConfigurationKeys.CONSTRUCTOR_CALL_NORMALIZATION_MODE, jVMConstructorCallNormalizationMode);
                configuration.put(JVMConfigurationKeys.INHERIT_MULTIFILE_PARTS, arguments2.getInheritMultifileParts());
                configuration.put(JVMConfigurationKeys.USE_TYPE_TABLE, arguments2.getUseTypeTable());
                configuration.put(JVMConfigurationKeys.SKIP_RUNTIME_VERSION_CHECK, arguments2.getSkipRuntimeVersionCheck());
                configuration.put(JVMConfigurationKeys.USE_FAST_CLASS_FILES_READING, !arguments2.getUseOldClassFilesReading());
                if (arguments2.getUseOldClassFilesReading()) {
                    MessageCollector.DefaultImpls.report$default(configuration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY), CompilerMessageSeverity.INFO, "Using the old java class files reading implementation", null, 4, null);
                }
                configuration.put(CLIConfigurationKeys.ALLOW_KOTLIN_PACKAGE, arguments2.getAllowKotlinPackage());
                configuration.put(CLIConfigurationKeys.REPORT_PERF, arguments2.getReportPerf());
                configuration.put(JVMConfigurationKeys.USE_SINGLE_MODULE, arguments2.getSingleModule());
                configuration.put(JVMConfigurationKeys.ADD_BUILT_INS_FROM_COMPILER_TO_DEPENDENCIES, arguments2.getAddCompilerBuiltIns());
                configuration.put(JVMConfigurationKeys.CREATE_BUILT_INS_FROM_MODULE_DEPENDENCIES, arguments2.getLoadBuiltInsFromDependencies());
                String string = arguments2.getDeclarationsOutputPath();
                if (string == null) break block4;
                Object it = object = string;
                configuration.put(JVMConfigurationKeys.DECLARATIONS_JSON_PATH, it);
            }
        }

        private final void configureContentRoots(KotlinPaths paths, K2JVMCompilerArguments arguments2, CompilerConfiguration configuration) {
            MessageCollector messageCollector2 = configuration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
            String string = arguments2.getClasspath();
            List list2 = string != null ? StringsKt.split$default((CharSequence)string, (char[])new char[]{File.pathSeparatorChar}, (boolean)false, (int)0, (int)6, null) : null;
            List list3 = list2;
            if (list3 == null) {
                list3 = CollectionsKt.emptyList();
            }
            for (String path2 : list3) {
                configuration.add(JVMConfigurationKeys.CONTENT_ROOTS, new JvmClasspathRoot(new File(path2)));
            }
            String string2 = arguments2.getJavaModulePath();
            list2 = string2 != null ? StringsKt.split$default((CharSequence)string2, (char[])new char[]{File.pathSeparatorChar}, (boolean)false, (int)0, (int)6, null) : null;
            List list4 = list2;
            if (list4 == null) {
                list4 = CollectionsKt.emptyList();
            }
            for (String modularRoot : list4) {
                configuration.add(JVMConfigurationKeys.CONTENT_ROOTS, new JvmModulePathRoot(new File(modularRoot)));
            }
            File file2 = configuration.get(JVMConfigurationKeys.JDK_HOME);
            File it = file2;
            boolean isModularJava = it != null && CoreJrtFileSystem.Companion.isModularJdk(it);
            Function4<String, String, Function1<? super KotlinPaths, ? extends File>, String, Unit> addRoot$ = new Function4<String, String, Function1<? super KotlinPaths, ? extends File>, String, Unit>(paths, messageCollector2, isModularJava, configuration){
                final /* synthetic */ KotlinPaths $paths;
                final /* synthetic */ MessageCollector $messageCollector;
                final /* synthetic */ boolean $isModularJava;
                final /* synthetic */ CompilerConfiguration $configuration;

                public final void invoke(@NotNull String moduleName, @NotNull String libraryName, @NotNull Function1<? super KotlinPaths, ? extends File> getLibrary, @NotNull String noLibraryArgument) {
                    Intrinsics.checkParameterIsNotNull((Object)moduleName, (String)"moduleName");
                    Intrinsics.checkParameterIsNotNull((Object)libraryName, (String)"libraryName");
                    Intrinsics.checkParameterIsNotNull(getLibrary, (String)"getLibrary");
                    Intrinsics.checkParameterIsNotNull((Object)noLibraryArgument, (String)"noLibraryArgument");
                    File file2 = CLICompiler.getLibraryFromHome(this.$paths, getLibrary, libraryName, this.$messageCollector, noLibraryArgument);
                    if (file2 == null) {
                        return;
                    }
                    File file3 = file2;
                    if (this.$isModularJava) {
                        File file4 = file3;
                        Intrinsics.checkExpressionValueIsNotNull((Object)file4, (String)"file");
                        this.$configuration.add(JVMConfigurationKeys.CONTENT_ROOTS, new JvmModulePathRoot(file4));
                        this.$configuration.add(JVMConfigurationKeys.ADDITIONAL_JAVA_MODULES, moduleName);
                    } else {
                        File file5 = file3;
                        Intrinsics.checkExpressionValueIsNotNull((Object)file5, (String)"file");
                        this.$configuration.add(JVMConfigurationKeys.CONTENT_ROOTS, new JvmClasspathRoot(file5));
                    }
                }
                {
                    this.$paths = kotlinPaths;
                    this.$messageCollector = messageCollector2;
                    this.$isModularJava = bl;
                    this.$configuration = compilerConfiguration;
                    super(4);
                }
            };
            if (!arguments2.getNoStdlib()) {
                addRoot$.invoke("kotlin.stdlib", "kotlin-stdlib.jar", (Function1<? super KotlinPaths, ? extends File>)((Function1)configureContentRoots.2.INSTANCE), "'-no-stdlib'");
                addRoot$.invoke("kotlin.script.runtime", "kotlin-script-runtime.jar", (Function1<? super KotlinPaths, ? extends File>)((Function1)configureContentRoots.3.INSTANCE), "'-no-stdlib'");
            }
            if (!arguments2.getNoReflect() && !arguments2.getNoStdlib()) {
                addRoot$.invoke("kotlin.reflect", "kotlin-reflect.jar", (Function1<? super KotlinPaths, ? extends File>)((Function1)configureContentRoots.4.INSTANCE), "'-no-reflect' or '-no-stdlib'");
            }
        }

        private final ExitCode configureJdkHome(K2JVMCompilerArguments arguments2, CompilerConfiguration configuration, MessageCollector messageCollector2) {
            if (arguments2.getNoJdk()) {
                configuration.put(JVMConfigurationKeys.NO_JDK, true);
                if (arguments2.getJdkHome() != null) {
                    MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.STRONG_WARNING, "The '-jdk-home' option is ignored because '-no-jdk' is specified", null, 4, null);
                }
                return ExitCode.OK;
            }
            if (arguments2.getJdkHome() != null) {
                File jdkHome = new File(arguments2.getJdkHome());
                if (!jdkHome.exists()) {
                    MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.ERROR, "JDK home directory does not exist: " + jdkHome, null, 4, null);
                    return ExitCode.COMPILATION_ERROR;
                }
                MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.LOGGING, "Using JDK home directory " + jdkHome, null, 4, null);
                configuration.put(JVMConfigurationKeys.JDK_HOME, jdkHome);
            }
            return ExitCode.OK;
        }

        /*
         * WARNING - void declaration
         */
        public final void configureScriptDefinitions(@Nullable String[] scriptTemplates, @NotNull CompilerConfiguration configuration, @NotNull MessageCollector messageCollector2, @NotNull HashMap<String, Object> scriptResolverEnv) {
            String[] stringArray;
            String[] stringArray2;
            Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
            Intrinsics.checkParameterIsNotNull((Object)messageCollector2, (String)"messageCollector");
            Intrinsics.checkParameterIsNotNull(scriptResolverEnv, (String)"scriptResolverEnv");
            List<File> classpath = JvmContentRootsKt.getJvmClasspathRoots(configuration);
            if (scriptTemplates != null && !((stringArray2 = (stringArray = scriptTemplates)).length == 0)) {
                Collection<URL> collection;
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                Iterable iterable = $receiver$iv = (Iterable)classpath;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void it;
                    File file2 = (File)item$iv$iv;
                    collection = destination$iv$iv;
                    URL uRL = it.toURI().toURL();
                    collection.add(uRL);
                }
                collection = (List)destination$iv$iv;
                $receiver$iv = collection;
                Iterable thisCollection$iv = $receiver$iv;
                URL[] uRLArray = thisCollection$iv.toArray(new URL[0]);
                if (uRLArray == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                collection = uRLArray;
                URL[] uRLArray2 = (URL[])collection;
                Thread thread = Thread.currentThread();
                Intrinsics.checkExpressionValueIsNotNull((Object)thread, (String)"Thread.currentThread()");
                ClassLoader classLoader = thread.getContextClassLoader();
                URL[] uRLArray3 = uRLArray2;
                URLClassLoader classloader = new URLClassLoader(uRLArray3, classLoader);
                boolean hasErrors = false;
                for (String template : scriptTemplates) {
                    try {
                        Class<?> cls;
                        Class<?> clazz = cls = classloader.loadClass(template);
                        Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"cls");
                        KotlinScriptDefinitionFromAnnotatedTemplate def = new KotlinScriptDefinitionFromAnnotatedTemplate(JvmClassMappingKt.getKotlinClass(clazz), scriptResolverEnv, null, 4, null);
                        configuration.add(JVMConfigurationKeys.SCRIPT_DEFINITIONS, def);
                        MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.INFO, "Added script definition " + template + " to configuration: files pattern = \"" + def.getScriptFilePattern() + "\", " + "resolver = " + def.getDependencyResolver().getClass().getName(), null, 4, null);
                    }
                    catch (ClassNotFoundException ex) {
                        MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.ERROR, "Cannot find script definition template class " + template, null, 4, null);
                        hasErrors = true;
                    }
                    catch (Exception ex) {
                        MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.ERROR, "Error processing script definition template " + template + ": " + ex.getMessage(), null, 4, null);
                        hasErrors = true;
                        break;
                    }
                }
                if (hasErrors) {
                    MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.LOGGING, "(Classpath used for templates loading: " + classpath + ')', null, 4, null);
                    return;
                }
            }
            configuration.add(JVMConfigurationKeys.SCRIPT_DEFINITIONS, StandardScriptDefinition.INSTANCE);
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final HashMap<String, Object> createScriptResolverEnvironment(@NotNull K2JVMCompilerArguments arguments2, @NotNull MessageCollector messageCollector2) {
            Intrinsics.checkParameterIsNotNull((Object)arguments2, (String)"arguments");
            Intrinsics.checkParameterIsNotNull((Object)messageCollector2, (String)"messageCollector");
            HashMap<String, Object> scriptResolverEnv = new HashMap<String, Object>();
            String string = "(\\w+)=(?:\"([^\"\\\\]*(\\\\.[^\"\\\\]*)*)\"|([^\\s]*))";
            Regex envParseRe = new Regex(string);
            String string2 = "\\\\([\"\\\\])";
            Regex unescapeRe = new Regex(string2);
            if (arguments2.getScriptResolverEnvironment() != null) {
                String[] stringArray = arguments2.getScriptResolverEnvironment();
                if (stringArray == null) {
                    Intrinsics.throwNpe();
                }
                for (String envParam : stringArray) {
                    String string3;
                    String string4;
                    HashMap<String, Object> hashMap;
                    Object e;
                    Object object;
                    block7: {
                        void $receiver$iv;
                        MatchResult match2 = envParseRe.matchEntire((CharSequence)envParam);
                        if (match2 == null || match2.getGroupValues().size() < 4 || StringsKt.isBlank((CharSequence)((CharSequence)match2.getGroupValues().get(1)))) {
                            MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.ERROR, "Unable to parse script-resolver-environment argument " + envParam, null, 4, null);
                            return null;
                        }
                        object = CollectionsKt.drop((Iterable)match2.getGroupValues(), (int)2);
                        e = match2.getGroupValues().get(1);
                        hashMap = scriptResolverEnv;
                        for (Object element$iv : $receiver$iv) {
                            String it = (String)element$iv;
                            CharSequence charSequence = it;
                            if (!(charSequence.length() > 0)) continue;
                            string4 = (String)element$iv;
                            break block7;
                        }
                        string4 = null;
                    }
                    String string5 = string4;
                    HashMap<String, Object> hashMap2 = hashMap;
                    Object e2 = e;
                    String string6 = string5;
                    if (string6 != null) {
                        object = string6;
                        e = e2;
                        hashMap = hashMap2;
                        Object it = object;
                        string5 = unescapeRe.replace((CharSequence)it, "$1");
                        hashMap2 = hashMap;
                        e2 = e;
                        string3 = string5;
                    } else {
                        string3 = null;
                    }
                    hashMap2.put((String)e2, string3);
                }
            }
            return scriptResolverEnv;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

