/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.kotlin.dsl.accessors;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.reflect.TypeOf;
import org.gradle.kotlin.dsl.accessors.KotlinTypeStringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\b\u001a\u00020\u00022\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n\"!\u0010\u0000\u001a\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"primitiveKotlinTypeNames", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "getPrimitiveKotlinTypeNames", "()Ljava/util/HashSet;", "primitiveTypeStrings", "", "kotlinTypeStringFor", "type", "Lorg/gradle/api/reflect/TypeOf;", "gradle-kotlin-dsl"})
public final class KotlinTypeStringsKt {
    private static final Map<String, String> primitiveTypeStrings = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"java.lang.Object", (Object)"Any"), TuplesKt.to((Object)"java.lang.String", (Object)"String"), TuplesKt.to((Object)"java.lang.Character", (Object)"Char"), TuplesKt.to((Object)"char", (Object)"Char"), TuplesKt.to((Object)"java.lang.Boolean", (Object)"Boolean"), TuplesKt.to((Object)"boolean", (Object)"Boolean"), TuplesKt.to((Object)"java.lang.Byte", (Object)"Byte"), TuplesKt.to((Object)"byte", (Object)"Byte"), TuplesKt.to((Object)"java.lang.Short", (Object)"Short"), TuplesKt.to((Object)"short", (Object)"Short"), TuplesKt.to((Object)"java.lang.Integer", (Object)"Int"), TuplesKt.to((Object)"int", (Object)"Int"), TuplesKt.to((Object)"java.lang.Long", (Object)"Long"), TuplesKt.to((Object)"long", (Object)"Long"), TuplesKt.to((Object)"java.lang.Float", (Object)"Float"), TuplesKt.to((Object)"float", (Object)"Float"), TuplesKt.to((Object)"java.lang.Double", (Object)"Double"), TuplesKt.to((Object)"double", (Object)"Double")});
    @NotNull
    private static final HashSet<String> primitiveKotlinTypeNames = CollectionsKt.toHashSet((Iterable)primitiveTypeStrings.values());

    @NotNull
    public static final String kotlinTypeStringFor(@NotNull TypeOf<?> type) {
        Object object;
        TypeOf<?> typeOf2;
        Intrinsics.checkParameterIsNotNull(type, (String)"type");
        TypeOf<?> $receiver = typeOf2 = type;
        if ($receiver.isArray()) {
            StringBuilder stringBuilder = new StringBuilder().append("Array<");
            TypeOf typeOf3 = $receiver.getComponentType();
            if (typeOf3 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)typeOf3, (String)"componentType!!");
            object = stringBuilder.append(KotlinTypeStringsKt.kotlinTypeStringFor(typeOf3)).append('>').toString();
        } else if ($receiver.isParameterized()) {
            StringBuilder stringBuilder = new StringBuilder().append("").append($receiver.getParameterizedTypeDefinition()).append('<');
            List list2 = $receiver.getActualTypeArguments();
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"actualTypeArguments");
            object = stringBuilder.append(CollectionsKt.joinToString$default((Iterable)list2, null, null, null, (int)0, null, (Function1)kotlinTypeStringFor.1.1.INSTANCE, (int)31, null)).append('>').toString();
        } else if ($receiver.isWildcard()) {
            TypeOf typeOf4;
            TypeOf p1;
            object = $receiver.getUpperBound();
            if (object == null || (object = KotlinTypeStringsKt.kotlinTypeStringFor(p1 = (typeOf4 = object))) == null) {
                object = "Any";
            }
        } else {
            String string = $receiver.toString();
            String it = string;
            object = primitiveTypeStrings.get(it);
            if (object == null) {
                String string2 = it;
                object = string2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"it");
            }
        }
        return object;
    }

    @NotNull
    public static final HashSet<String> getPrimitiveKotlinTypeNames() {
        return primitiveKotlinTypeNames;
    }
}

