/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization.buildsrc;

import java.io.File;
import org.gradle.StartParameter;
import org.gradle.api.Transformer;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.cache.FileLock;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.LockOptions;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.initialization.buildsrc.BuildBuildSrcBuildOperationType;
import org.gradle.initialization.buildsrc.BuildSrcBuildListenerFactory;
import org.gradle.initialization.buildsrc.BuildSrcUpdateFactory;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.BuildStateRegistry;
import org.gradle.internal.build.StandAloneNestedBuild;
import org.gradle.internal.classpath.CachedClasspathTransformer;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.invocation.BuildController;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.CallableBuildOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildSourceBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(BuildSourceBuilder.class);
    private static final BuildBuildSrcBuildOperationType.Result BUILD_BUILDSRC_RESULT = new BuildBuildSrcBuildOperationType.Result(){};
    public static final String BUILD_SRC = "buildSrc";
    private final BuildState currentBuild;
    private final ClassLoaderScope classLoaderScope;
    private final FileLockManager fileLockManager;
    private final BuildOperationExecutor buildOperationExecutor;
    private final CachedClasspathTransformer cachedClasspathTransformer;
    private final BuildSrcBuildListenerFactory buildSrcBuildListenerFactory;
    private final BuildStateRegistry buildRegistry;
    private static final LockOptions LOCK_OPTIONS = LockOptionsBuilder.mode((FileLockManager.LockMode)FileLockManager.LockMode.Exclusive).useCrossVersionImplementation();

    public BuildSourceBuilder(BuildState currentBuild, ClassLoaderScope classLoaderScope, FileLockManager fileLockManager, BuildOperationExecutor buildOperationExecutor, CachedClasspathTransformer cachedClasspathTransformer, BuildSrcBuildListenerFactory buildSrcBuildListenerFactory, BuildStateRegistry buildRegistry) {
        this.currentBuild = currentBuild;
        this.classLoaderScope = classLoaderScope;
        this.fileLockManager = fileLockManager;
        this.buildOperationExecutor = buildOperationExecutor;
        this.cachedClasspathTransformer = cachedClasspathTransformer;
        this.buildSrcBuildListenerFactory = buildSrcBuildListenerFactory;
        this.buildRegistry = buildRegistry;
    }

    public ClassLoaderScope buildAndCreateClassLoader(GradleInternal gradle, File rootDir, StartParameter containingBuildParameters) {
        File buildSrcDir = new File(rootDir, BUILD_SRC);
        ClassPath classpath = this.createBuildSourceClasspath(gradle, buildSrcDir, containingBuildParameters);
        return this.classLoaderScope.createChild(buildSrcDir.getAbsolutePath()).export(classpath).lock();
    }

    private ClassPath createBuildSourceClasspath(final GradleInternal gradle, File buildSrcDir, StartParameter containingBuildParameters) {
        if (!buildSrcDir.isDirectory()) {
            LOGGER.debug("Gradle source dir does not exist. We leave.");
            return ClassPath.EMPTY;
        }
        StartParameter buildSrcStartParameter = containingBuildParameters.newBuild();
        buildSrcStartParameter.setCurrentDir(buildSrcDir);
        buildSrcStartParameter.setProjectProperties(containingBuildParameters.getProjectProperties());
        buildSrcStartParameter.setSearchUpwards(false);
        buildSrcStartParameter.setProfile(containingBuildParameters.isProfile());
        final BuildDefinition buildDefinition = BuildDefinition.fromStartParameterForBuild(buildSrcStartParameter, BUILD_SRC, buildSrcDir);
        assert (buildSrcStartParameter.getBuildFile() == null);
        return (ClassPath)this.buildOperationExecutor.call((CallableBuildOperation)new CallableBuildOperation<ClassPath>(){

            public ClassPath call(BuildOperationContext context) {
                ClassPath classPath = BuildSourceBuilder.this.buildBuildSrc(buildDefinition);
                context.setResult((Object)BUILD_BUILDSRC_RESULT);
                return classPath;
            }

            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName((String)"Build buildSrc").progressDisplayName("Building buildSrc").details((Object)new BuildBuildSrcBuildOperationType.Details(){

                    public String getBuildPath() {
                        return gradle.getIdentityPath().toString();
                    }
                });
            }
        });
    }

    private ClassPath buildBuildSrc(final BuildDefinition buildDefinition) {
        StandAloneNestedBuild nestedBuild = this.buildRegistry.addNestedBuild(buildDefinition, this.currentBuild);
        return nestedBuild.run(new Transformer<ClassPath, BuildController>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public ClassPath transform(BuildController buildController) {
                File lockTarget = new File(buildDefinition.getBuildRootDir(), ".gradle/noVersion/buildSrc");
                FileLock lock = BuildSourceBuilder.this.fileLockManager.lock(lockTarget, LOCK_OPTIONS, "buildSrc build lock");
                try {
                    ClassPath classPath = new BuildSrcUpdateFactory(buildController, BuildSourceBuilder.this.buildSrcBuildListenerFactory, BuildSourceBuilder.this.cachedClasspathTransformer).create();
                    return classPath;
                }
                finally {
                    lock.close();
                }
            }
        });
    }
}

