/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.config.AnalysisFlag;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorUtilKt;
import org.jetbrains.kotlin.descriptors.EffectiveVisibility;
import org.jetbrains.kotlin.descriptors.EffectiveVisibilityKt;
import org.jetbrains.kotlin.descriptors.FindClassInModuleKt;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClassInitializer;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDeclarationWithInitializer;
import org.jetbrains.kotlin.psi.KtDelegatedSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPropertyDelegate;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.Deprecation;
import org.jetbrains.kotlin.resolve.DeprecationResolver;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ModuleAnnotationsResolver;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.checkers.CheckerContext;
import org.jetbrains.kotlin.resolve.checkers.ClassifierUsageChecker;
import org.jetbrains.kotlin.resolve.checkers.ClassifierUsageCheckerContext;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.checkers.ExperimentalUsageChecker$Companion$WhenMappings;
import org.jetbrains.kotlin.resolve.checkers.ExperimentalUsageChecker$Overrides$WhenMappings;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.EnumValue;
import org.jetbrains.kotlin.resolve.constants.KClassValue;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.utils.SmartSet;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00102\u00020\u0001:\u0004\u000f\u0010\u0011\u0012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "project", "Lorg/jetbrains/kotlin/com/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "moduleAnnotationsResolver", "Lorg/jetbrains/kotlin/resolve/ModuleAnnotationsResolver;", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "ClassifierUsage", "Companion", "Experimentality", "Overrides", "frontend"})
public final class ExperimentalUsageChecker
implements CallChecker {
    private final ModuleAnnotationsResolver moduleAnnotationsResolver;
    @NotNull
    private static final FqName EXPERIMENTAL_FQ_NAME;
    @NotNull
    private static final FqName USE_EXPERIMENTAL_FQ_NAME;
    @NotNull
    private static final Name USE_EXPERIMENTAL_ANNOTATION_CLASS;
    private static final Name LEVEL;
    private static final Name WARNING_LEVEL;
    private static final Name ERROR_LEVEL;
    @NotNull
    private static final Name IMPACT;
    private static final Name COMPILATION_IMPACT;
    private static final Name LINKAGE_IMPACT;
    private static final Name RUNTIME_IMPACT;
    public static final Companion Companion;

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkParameterIsNotNull(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkParameterIsNotNull((Object)reportOn, (String)"reportOn");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Object obj = resolvedCall2.getResultingDescriptor();
        Intrinsics.checkExpressionValueIsNotNull(obj, (String)"resolvedCall.resultingDescriptor");
        ExperimentalUsageChecker.Companion.checkExperimental((DeclarationDescriptor)obj, reportOn, context, this.moduleAnnotationsResolver);
    }

    public ExperimentalUsageChecker(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.moduleAnnotationsResolver = ModuleAnnotationsResolver.Companion.getInstance(project);
    }

    static {
        Companion = new Companion(null);
        EXPERIMENTAL_FQ_NAME = new FqName("kotlin.Experimental");
        USE_EXPERIMENTAL_FQ_NAME = new FqName("kotlin.UseExperimental");
        USE_EXPERIMENTAL_ANNOTATION_CLASS = Name.identifier("markerClass");
        LEVEL = Name.identifier("level");
        WARNING_LEVEL = Name.identifier("WARNING");
        ERROR_LEVEL = Name.identifier("ERROR");
        IMPACT = Name.identifier("changesMayBreak");
        COMPILATION_IMPACT = Name.identifier("COMPILATION");
        LINKAGE_IMPACT = Name.identifier("LINKAGE");
        RUNTIME_IMPACT = Name.identifier("RUNTIME");
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0080\b\u0018\u0000 \"2\u00020\u0001:\u0003\"#$B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0007H\u00c6\u0003J\u000f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0003J7\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u00112\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\t\u0010 \u001a\u00020!H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$Experimentality;", "", "markerDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "annotationFqName", "Lorg/jetbrains/kotlin/name/FqName;", "severity", "Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$Experimentality$Severity;", "impact", "", "Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$Experimentality$Impact;", "(Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$Experimentality$Severity;Ljava/util/List;)V", "getAnnotationFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "getImpact", "()Ljava/util/List;", "isCompilationOnly", "", "()Z", "getMarkerDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "getSeverity", "()Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$Experimentality$Severity;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "", "Companion", "Impact", "Severity", "frontend"})
    public static final class Experimentality {
        @NotNull
        private final ClassDescriptor markerDescriptor;
        @NotNull
        private final FqName annotationFqName;
        @NotNull
        private final Severity severity;
        @NotNull
        private final List<Impact> impact;
        @NotNull
        private static final Severity DEFAULT_SEVERITY;
        @NotNull
        private static final List<Impact> DEFAULT_IMPACT;
        public static final Companion Companion;

        /*
         * WARNING - void declaration
         */
        public final boolean isCompilationOnly() {
            boolean bl;
            block3: {
                void $receiver$iv;
                Iterable iterable = this.impact;
                Impact impact = Impact.COMPILATION;
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $receiver$iv) {
                        Object p1 = element$iv;
                        if (impact.equals(p1)) continue;
                        bl = false;
                        break block3;
                    }
                    bl = true;
                }
            }
            return bl;
        }

        @NotNull
        public final ClassDescriptor getMarkerDescriptor() {
            return this.markerDescriptor;
        }

        @NotNull
        public final FqName getAnnotationFqName() {
            return this.annotationFqName;
        }

        @NotNull
        public final Severity getSeverity() {
            return this.severity;
        }

        @NotNull
        public final List<Impact> getImpact() {
            return this.impact;
        }

        public Experimentality(@NotNull ClassDescriptor markerDescriptor, @NotNull FqName annotationFqName, @NotNull Severity severity, @NotNull List<? extends Impact> impact) {
            Intrinsics.checkParameterIsNotNull((Object)markerDescriptor, (String)"markerDescriptor");
            Intrinsics.checkParameterIsNotNull((Object)annotationFqName, (String)"annotationFqName");
            Intrinsics.checkParameterIsNotNull((Object)((Object)severity), (String)"severity");
            Intrinsics.checkParameterIsNotNull(impact, (String)"impact");
            this.markerDescriptor = markerDescriptor;
            this.annotationFqName = annotationFqName;
            this.severity = severity;
            this.impact = impact;
        }

        static {
            Companion = new Companion(null);
            DEFAULT_SEVERITY = Severity.ERROR;
            DEFAULT_IMPACT = CollectionsKt.listOf((Object[])new Impact[]{Impact.COMPILATION, Impact.LINKAGE_OR_RUNTIME});
        }

        @NotNull
        public final ClassDescriptor component1() {
            return this.markerDescriptor;
        }

        @NotNull
        public final FqName component2() {
            return this.annotationFqName;
        }

        @NotNull
        public final Severity component3() {
            return this.severity;
        }

        @NotNull
        public final List<Impact> component4() {
            return this.impact;
        }

        @NotNull
        public final Experimentality copy(@NotNull ClassDescriptor markerDescriptor, @NotNull FqName annotationFqName, @NotNull Severity severity, @NotNull List<? extends Impact> impact) {
            Intrinsics.checkParameterIsNotNull((Object)markerDescriptor, (String)"markerDescriptor");
            Intrinsics.checkParameterIsNotNull((Object)annotationFqName, (String)"annotationFqName");
            Intrinsics.checkParameterIsNotNull((Object)((Object)severity), (String)"severity");
            Intrinsics.checkParameterIsNotNull(impact, (String)"impact");
            return new Experimentality(markerDescriptor, annotationFqName, severity, impact);
        }

        @NotNull
        public static /* synthetic */ Experimentality copy$default(Experimentality experimentality, ClassDescriptor classDescriptor, FqName fqName2, Severity severity, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                classDescriptor = experimentality.markerDescriptor;
            }
            if ((n & 2) != 0) {
                fqName2 = experimentality.annotationFqName;
            }
            if ((n & 4) != 0) {
                severity = experimentality.severity;
            }
            if ((n & 8) != 0) {
                list2 = experimentality.impact;
            }
            return experimentality.copy(classDescriptor, fqName2, severity, list2);
        }

        public String toString() {
            return "Experimentality(markerDescriptor=" + this.markerDescriptor + ", annotationFqName=" + this.annotationFqName + ", severity=" + (Object)((Object)this.severity) + ", impact=" + this.impact + ")";
        }

        public int hashCode() {
            ClassDescriptor classDescriptor = this.markerDescriptor;
            FqName fqName2 = this.annotationFqName;
            Severity severity = this.severity;
            List<Impact> list2 = this.impact;
            return (((classDescriptor != null ? classDescriptor.hashCode() : 0) * 31 + (fqName2 != null ? ((Object)fqName2).hashCode() : 0)) * 31 + (severity != null ? ((Object)((Object)severity)).hashCode() : 0)) * 31 + (list2 != null ? ((Object)list2).hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Experimentality)) break block3;
                    Experimentality experimentality = (Experimentality)object;
                    if (!Intrinsics.areEqual((Object)this.markerDescriptor, (Object)experimentality.markerDescriptor) || !Intrinsics.areEqual((Object)this.annotationFqName, (Object)experimentality.annotationFqName) || !Intrinsics.areEqual((Object)((Object)this.severity), (Object)((Object)experimentality.severity)) || !Intrinsics.areEqual(this.impact, experimentality.impact)) break block3;
                }
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$Experimentality$Severity;", "", "(Ljava/lang/String;I)V", "WARNING", "ERROR", "frontend"})
        public static final class Severity
        extends Enum<Severity> {
            public static final /* enum */ Severity WARNING;
            public static final /* enum */ Severity ERROR;
            private static final /* synthetic */ Severity[] $VALUES;

            static {
                Severity[] severityArray = new Severity[2];
                Severity[] severityArray2 = severityArray;
                severityArray[0] = WARNING = new Severity();
                severityArray[1] = ERROR = new Severity();
                $VALUES = severityArray;
            }

            public static Severity[] values() {
                return (Severity[])$VALUES.clone();
            }

            public static Severity valueOf(String string) {
                return Enum.valueOf(Severity.class, string);
            }
        }

        @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$Experimentality$Impact;", "", "(Ljava/lang/String;I)V", "COMPILATION", "LINKAGE_OR_RUNTIME", "frontend"})
        public static final class Impact
        extends Enum<Impact> {
            public static final /* enum */ Impact COMPILATION;
            public static final /* enum */ Impact LINKAGE_OR_RUNTIME;
            private static final /* synthetic */ Impact[] $VALUES;

            static {
                Impact[] impactArray = new Impact[2];
                Impact[] impactArray2 = impactArray;
                impactArray[0] = COMPILATION = new Impact();
                impactArray[1] = LINKAGE_OR_RUNTIME = new Impact();
                $VALUES = impactArray;
            }

            public static Impact[] values() {
                return (Impact[])$VALUES.clone();
            }

            public static Impact valueOf(String string) {
                return Enum.valueOf(Impact.class, string);
            }
        }

        @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$Experimentality$Companion;", "", "()V", "DEFAULT_IMPACT", "", "Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$Experimentality$Impact;", "getDEFAULT_IMPACT", "()Ljava/util/List;", "DEFAULT_SEVERITY", "Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$Experimentality$Severity;", "getDEFAULT_SEVERITY", "()Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$Experimentality$Severity;", "frontend"})
        public static final class Companion {
            @NotNull
            public final Severity getDEFAULT_SEVERITY() {
                return DEFAULT_SEVERITY;
            }

            @NotNull
            public final List<Impact> getDEFAULT_IMPACT() {
                return DEFAULT_IMPACT;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$ClassifierUsage;", "Lorg/jetbrains/kotlin/resolve/checkers/ClassifierUsageChecker;", "project", "Lorg/jetbrains/kotlin/com/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "moduleAnnotationsResolver", "Lorg/jetbrains/kotlin/resolve/ModuleAnnotationsResolver;", "check", "", "targetDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "element", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/ClassifierUsageCheckerContext;", "frontend"})
    public static final class ClassifierUsage
    implements ClassifierUsageChecker {
        private final ModuleAnnotationsResolver moduleAnnotationsResolver;

        @Override
        public void check(@NotNull ClassifierDescriptor targetDescriptor, @NotNull PsiElement element, @NotNull ClassifierUsageCheckerContext context) {
            Intrinsics.checkParameterIsNotNull((Object)targetDescriptor, (String)"targetDescriptor");
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Companion.checkExperimental(targetDescriptor, element, context, this.moduleAnnotationsResolver);
        }

        public ClassifierUsage(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            this.moduleAnnotationsResolver = ModuleAnnotationsResolver.Companion.getInstance(project);
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$Overrides;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "project", "Lorg/jetbrains/kotlin/com/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "moduleAnnotationsResolver", "Lorg/jetbrains/kotlin/resolve/ModuleAnnotationsResolver;", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend"})
    public static final class Overrides
    implements DeclarationChecker {
        private final ModuleAnnotationsResolver moduleAnnotationsResolver;

        /*
         * WARNING - void declaration
         */
        @Override
        public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
            void $receiver$iv$iv;
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            if (!(descriptor2 instanceof CallableMemberDescriptor)) {
                return;
            }
            Collection<? extends CallableMemberDescriptor> collection = ((CallableMemberDescriptor)descriptor2).getOverriddenDescriptors();
            Intrinsics.checkExpressionValueIsNotNull(collection, (String)"descriptor.overriddenDescriptors");
            Iterable $receiver$iv = collection;
            Object object = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                void $receiver$iv$iv2;
                Iterable $receiver$iv2;
                CallableMemberDescriptor member;
                CallableMemberDescriptor callableMemberDescriptor = member = (CallableMemberDescriptor)element$iv$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)callableMemberDescriptor, (String)"member");
                Iterable iterable = $receiver$iv2 = (Iterable)Companion.loadExperimentalities(callableMemberDescriptor, this.moduleAnnotationsResolver);
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv2) {
                    void experimentality;
                    Experimentality experimentality2 = (Experimentality)item$iv$iv;
                    Collection collection2 = destination$iv$iv2;
                    Pair pair = TuplesKt.to((Object)experimentality, (Object)member);
                    collection2.add(pair);
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Map experimentalOverridden = MapsKt.toMap((Iterable)((List)destination$iv$iv));
            ModuleDescriptor module2 = DescriptorUtilsKt.getModule(descriptor2);
            Map map2 = experimentalOverridden;
            Iterator iterator2 = map2.entrySet().iterator();
            while (iterator2.hasNext()) {
                Object object2 = object = iterator2.next();
                Experimentality experimentality = (Experimentality)object2.getKey();
                object2 = object;
                CallableMemberDescriptor member = (CallableMemberDescriptor)object2.getValue();
                Collection collection3 = CollectionsKt.listOf((Object)experimentality);
                PsiElement psiElement = declaration;
                BindingContext bindingContext = context.getTrace().getBindingContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext, (String)"context.trace.bindingContext");
                Companion.checkExperimental(collection3, psiElement, bindingContext, context.getLanguageVersionSettings(), module2, (Function2<? super Experimentality, ? super Boolean, Unit>)((Function2)new Function2<Experimentality, Boolean, Unit>(experimentality, declaration, context, member){
                    final /* synthetic */ Experimentality $experimentality;
                    final /* synthetic */ KtDeclaration $declaration;
                    final /* synthetic */ DeclarationCheckerContext $context;
                    final /* synthetic */ CallableMemberDescriptor $member;

                    public final void invoke(@NotNull Experimentality $noName_0, boolean $noName_1) {
                        PsiElement psiElement;
                        DiagnosticFactory2<PsiElement, FqName, DeclarationDescriptor> diagnosticFactory2;
                        Intrinsics.checkParameterIsNotNull((Object)$noName_0, (String)"<anonymous parameter 0>");
                        switch (ExperimentalUsageChecker$Overrides$WhenMappings.$EnumSwitchMapping$0[this.$experimentality.getSeverity().ordinal()]) {
                            case 1: {
                                diagnosticFactory2 = Errors.EXPERIMENTAL_OVERRIDE;
                                break;
                            }
                            case 2: {
                                diagnosticFactory2 = Errors.EXPERIMENTAL_OVERRIDE_ERROR;
                                break;
                            }
                            default: {
                                throw new NoWhenBranchMatchedException();
                            }
                        }
                        DiagnosticFactory2<PsiElement, FqName, DeclarationDescriptor> diagnostic = diagnosticFactory2;
                        KtDeclaration ktDeclaration = this.$declaration;
                        if (!(ktDeclaration instanceof KtNamedDeclaration)) {
                            ktDeclaration = null;
                        }
                        if ((psiElement = (KtNamedDeclaration)ktDeclaration) == null || (psiElement = psiElement.getNameIdentifier()) == null) {
                            psiElement = this.$declaration;
                        }
                        PsiElement reportOn = psiElement;
                        BindingTrace bindingTrace = this.$context.getTrace();
                        FqName fqName2 = this.$experimentality.getAnnotationFqName();
                        CallableMemberDescriptor callableMemberDescriptor = this.$member;
                        Intrinsics.checkExpressionValueIsNotNull((Object)callableMemberDescriptor, (String)"member");
                        bindingTrace.report(diagnostic.on(reportOn, fqName2, callableMemberDescriptor.getContainingDeclaration()));
                    }
                    {
                        this.$experimentality = experimentality;
                        this.$declaration = ktDeclaration;
                        this.$context = declarationCheckerContext;
                        this.$member = callableMemberDescriptor;
                        super(2);
                    }
                }));
            }
        }

        public Overrides(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            this.moduleAnnotationsResolver = ModuleAnnotationsResolver.Companion.getInstance(project);
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00160\u001c2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00160\u001cJn\u0010\u001f\u001a\u00020\u00162\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u001826\u0010'\u001a2\u0012\u0013\u0012\u00110\"\u00a2\u0006\f\b)\u0012\b\b*\u0012\u0004\b\b(+\u0012\u0013\u0012\u00110,\u00a2\u0006\f\b)\u0012\b\b*\u0012\u0004\b\b(-\u0012\u0004\u0012\u00020\u00160(H\u0002J(\u0010\u001f\u001a\u00020\u00162\u0006\u0010.\u001a\u00020/2\u0006\u0010#\u001a\u00020$2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0002JG\u00104\u001a\u00020,*\u00020$28\u00105\u001a4\u0012\u0013\u0012\u00110$\u00a2\u0006\f\b)\u0012\b\b*\u0012\u0004\b\b(#\u0012\u0015\u0012\u0013\u0018\u00010$\u00a2\u0006\f\b)\u0012\b\b*\u0012\u0004\b\b(6\u0012\u0004\u0012\u00020,0(H\u0082\bJ$\u00107\u001a\u00020,*\u00020$2\u0006\u00108\u001a\u00020\u00072\u0006\u0010%\u001a\u00020&2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001c\u00109\u001a\u00020,*\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010:\u001a\u00020,H\u0002J\u0014\u0010;\u001a\u00020,*\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J\u0014\u0010<\u001a\u00020,*\u00020=2\u0006\u00108\u001a\u00020\u0007H\u0002J\u001a\u0010>\u001a\b\u0012\u0004\u0012\u00020\"0?*\u00020/2\u0006\u00102\u001a\u000203H\u0002J\u0013\u0010@\u001a\u0004\u0018\u00010\"*\u00020AH\u0000\u00a2\u0006\u0002\bBJ$\u0010C\u001a\u00020,*\u00020$2\u0006\u00108\u001a\u00020\u00072\u0006\u0010%\u001a\u00020&2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\fR\u0014\u0010\u0012\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\tR\u000e\u0010\u0014\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$Companion;", "", "()V", "COMPILATION_IMPACT", "Lorg/jetbrains/kotlin/name/Name;", "ERROR_LEVEL", "EXPERIMENTAL_FQ_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "getEXPERIMENTAL_FQ_NAME$frontend", "()Lorg/jetbrains/kotlin/name/FqName;", "IMPACT", "getIMPACT$frontend", "()Lorg/jetbrains/kotlin/name/Name;", "LEVEL", "LINKAGE_IMPACT", "RUNTIME_IMPACT", "USE_EXPERIMENTAL_ANNOTATION_CLASS", "getUSE_EXPERIMENTAL_ANNOTATION_CLASS$frontend", "USE_EXPERIMENTAL_FQ_NAME", "getUSE_EXPERIMENTAL_FQ_NAME$frontend", "WARNING_LEVEL", "checkCompilerArguments", "", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "reportError", "Lkotlin/Function1;", "", "reportWarning", "checkExperimental", "experimentalities", "", "Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$Experimentality;", "element", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "report", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "experimentality", "", "isBodyUsageOfCompilationExperimentality", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/CheckerContext;", "moduleAnnotationsResolver", "Lorg/jetbrains/kotlin/resolve/ModuleAnnotationsResolver;", "anyParentMatches", "predicate", "parent", "hasContainerAnnotatedWithUseExperimental", "annotationFqName", "isBodyUsage", "allowPublicInline", "isPublicInline", "isUseExperimental", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "loadExperimentalities", "", "loadExperimentalityForMarkerAnnotation", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "loadExperimentalityForMarkerAnnotation$frontend", "propagates", "frontend"})
    public static final class Companion {
        @NotNull
        public final FqName getEXPERIMENTAL_FQ_NAME$frontend() {
            return EXPERIMENTAL_FQ_NAME;
        }

        @NotNull
        public final FqName getUSE_EXPERIMENTAL_FQ_NAME$frontend() {
            return USE_EXPERIMENTAL_FQ_NAME;
        }

        @NotNull
        public final Name getUSE_EXPERIMENTAL_ANNOTATION_CLASS$frontend() {
            return USE_EXPERIMENTAL_ANNOTATION_CLASS;
        }

        @NotNull
        public final Name getIMPACT$frontend() {
            return IMPACT;
        }

        private final void checkExperimental(DeclarationDescriptor descriptor2, PsiElement element, CheckerContext context, ModuleAnnotationsResolver moduleAnnotationsResolver) {
            Set<Experimentality> experimentalities = this.loadExperimentalities(descriptor2, moduleAnnotationsResolver);
            Collection collection = experimentalities;
            if (!collection.isEmpty()) {
                Collection collection2 = experimentalities;
                BindingContext bindingContext = context.getTrace().getBindingContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext, (String)"context.trace.bindingContext");
                this.checkExperimental(collection2, element, bindingContext, context.getLanguageVersionSettings(), context.getModuleDescriptor(), (Function2<? super Experimentality, ? super Boolean, Unit>)((Function2)new Function2<Experimentality, Boolean, Unit>(context, element){
                    final /* synthetic */ CheckerContext $context;
                    final /* synthetic */ PsiElement $element;

                    public final void invoke(@NotNull Experimentality experimentality, boolean isBodyUsageOfSourceOnlyExperimentality) {
                        DiagnosticFactory2<PsiElement, FqName, Boolean> diagnosticFactory2;
                        Intrinsics.checkParameterIsNotNull((Object)experimentality, (String)"experimentality");
                        switch (ExperimentalUsageChecker$Companion$WhenMappings.$EnumSwitchMapping$0[experimentality.getSeverity().ordinal()]) {
                            case 1: {
                                diagnosticFactory2 = Errors.EXPERIMENTAL_API_USAGE;
                                break;
                            }
                            case 2: {
                                diagnosticFactory2 = Errors.EXPERIMENTAL_API_USAGE_ERROR;
                                break;
                            }
                            default: {
                                throw new NoWhenBranchMatchedException();
                            }
                        }
                        DiagnosticFactory2<PsiElement, FqName, Boolean> diagnostic = diagnosticFactory2;
                        this.$context.getTrace().report(diagnostic.on(this.$element, experimentality.getAnnotationFqName(), isBodyUsageOfSourceOnlyExperimentality));
                    }
                    {
                        this.$context = checkerContext;
                        this.$element = psiElement;
                        super(2);
                    }
                }));
            }
        }

        private final void checkExperimental(Collection<Experimentality> experimentalities, PsiElement element, BindingContext bindingContext, LanguageVersionSettings languageVersionSettings, ModuleDescriptor module2, Function2<? super Experimentality, ? super Boolean, Unit> report2) {
            boolean isBodyUsageExceptPublicInline = this.isBodyUsage(element, bindingContext, false);
            boolean isBodyUsage = isBodyUsageExceptPublicInline || this.isBodyUsage(element, bindingContext, true);
            for (Experimentality experimentality : experimentalities) {
                boolean isBodyUsageOfCompilationExperimentality = experimentality.isCompilationOnly() && isBodyUsage;
                boolean isBodyUsageInSameModule = Intrinsics.areEqual((Object)DescriptorUtilsKt.getModule(experimentality.getMarkerDescriptor()), (Object)module2) && isBodyUsageExceptPublicInline;
                FqName annotationFqName = experimentality.getAnnotationFqName();
                boolean isExperimentalityAccepted = isBodyUsageInSameModule || isBodyUsageOfCompilationExperimentality && this.hasContainerAnnotatedWithUseExperimental(element, annotationFqName, bindingContext, languageVersionSettings) || this.propagates(element, annotationFqName, bindingContext, languageVersionSettings);
                if (isExperimentalityAccepted) continue;
                report2.invoke((Object)experimentality, (Object)isBodyUsageOfCompilationExperimentality);
            }
        }

        private final Set<Experimentality> loadExperimentalities(@NotNull DeclarationDescriptor $receiver, ModuleAnnotationsResolver moduleAnnotationsResolver) {
            SmartSet result2 = SmartSet.Companion.create();
            for (AnnotationDescriptor annotation2 : $receiver.getAnnotations()) {
                ClassDescriptor classDescriptor = DescriptorUtilsKt.getAnnotationClass(annotation2);
                org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull(result2, classDescriptor != null ? this.loadExperimentalityForMarkerAnnotation$frontend(classDescriptor) : null);
            }
            DeclarationDescriptor container2 = $receiver.getContainingDeclaration();
            if (container2 instanceof ClassDescriptor && !($receiver instanceof ConstructorDescriptor)) {
                result2.addAll(this.loadExperimentalities(container2, moduleAnnotationsResolver));
            }
            for (ClassId moduleAnnotationClassId : moduleAnnotationsResolver.getAnnotationsOnContainingModule($receiver)) {
                ClassDescriptor annotationClass = FindClassInModuleKt.findClassAcrossModuleDependencies(DescriptorUtilsKt.getModule($receiver), moduleAnnotationClassId);
                ClassDescriptor classDescriptor = annotationClass;
                org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull(result2, classDescriptor != null ? this.loadExperimentalityForMarkerAnnotation$frontend(classDescriptor) : null);
            }
            return result2;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final Experimentality loadExperimentalityForMarkerAnnotation$frontend(@NotNull ClassDescriptor $receiver) {
            List list2;
            Object object;
            Experimentality.Severity severity;
            Name name;
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            AnnotationDescriptor annotationDescriptor = $receiver.getAnnotations().findAnnotation(this.getEXPERIMENTAL_FQ_NAME$frontend());
            if (annotationDescriptor == null) {
                return null;
            }
            AnnotationDescriptor experimental = annotationDescriptor;
            ConstantValue<?> constantValue = experimental.getAllValueArguments().get(LEVEL);
            if (!(constantValue instanceof EnumValue)) {
                constantValue = null;
            }
            EnumValue enumValue = (EnumValue)constantValue;
            Name name2 = name = enumValue != null ? enumValue.getEnumEntryName() : null;
            Experimentality.Severity severity2 = severity = Intrinsics.areEqual((Object)name, (Object)WARNING_LEVEL) ? Experimentality.Severity.WARNING : (Intrinsics.areEqual((Object)name, (Object)ERROR_LEVEL) ? Experimentality.Severity.ERROR : Experimentality.Companion.getDEFAULT_SEVERITY());
            ConstantValue<?> constantValue2 = experimental.getAllValueArguments().get(this.getIMPACT$frontend());
            if (!(constantValue2 instanceof ArrayValue)) {
                constantValue2 = null;
            }
            if ((object = (ArrayValue)constantValue2) != null && (object = (List)((ConstantValue)object).getValue()) != null) {
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                Iterable iterable = $receiver$iv = (Iterable)object;
                Collection destination$iv$iv = new ArrayList();
                void $receiver$iv$iv$iv = $receiver$iv$iv;
                for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                    Experimentality.Impact impact;
                    Name name3;
                    Object element$iv$iv = element$iv$iv$iv;
                    ConstantValue impact2 = (ConstantValue)element$iv$iv;
                    ConstantValue constantValue3 = impact2;
                    if (!(constantValue3 instanceof EnumValue)) {
                        constantValue3 = null;
                    }
                    EnumValue enumValue2 = (EnumValue)constantValue3;
                    Name name4 = name3 = enumValue2 != null ? enumValue2.getEnumEntryName() : null;
                    Experimentality.Impact impact3 = Intrinsics.areEqual((Object)name3, (Object)COMPILATION_IMPACT) ? Experimentality.Impact.COMPILATION : (Intrinsics.areEqual((Object)name3, (Object)LINKAGE_IMPACT) || Intrinsics.areEqual((Object)name3, (Object)RUNTIME_IMPACT) ? Experimentality.Impact.LINKAGE_OR_RUNTIME : null);
                    if (impact3 == null) continue;
                    Experimentality.Impact it$iv$iv = impact = impact3;
                    destination$iv$iv.add(it$iv$iv);
                }
                list2 = (List)destination$iv$iv;
            } else {
                list2 = Experimentality.Companion.getDEFAULT_IMPACT();
            }
            List impact = list2;
            return new Experimentality($receiver, DescriptorUtilsKt.getFqNameSafe($receiver), severity, impact);
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isBodyUsage(@NotNull PsiElement $receiver, BindingContext bindingContext, boolean allowPublicInline) {
            void $receiver$iv;
            PsiElement psiElement = $receiver;
            Companion this_$iv = this;
            PsiElement element$iv = $receiver$iv;
            while (true) {
                KtExpression ktExpression;
                KtExpression ktExpression2;
                void parent2;
                void element;
                PsiElement parent$iv;
                PsiElement psiElement2 = parent$iv = element$iv.getParent();
                void v0 = element = element$iv;
                Object v1 = parent2;
                if (!(v1 instanceof KtDeclarationWithBody)) {
                    v1 = null;
                }
                if ((ktExpression2 = (KtDeclarationWithBody)v1) != null && (ktExpression2 = ktExpression2.getBodyExpression()) != null) {
                    KtExpression ktExpression3 = ktExpression2;
                    void var11_11 = v0;
                    KtExpression ktExpression4 = ktExpression3;
                    KtExpression ktExpression5 = allowPublicInline || !Companion.isPublicInline((PsiElement)parent2, bindingContext) ? ktExpression3 : null;
                    v0 = var11_11;
                    ktExpression = ktExpression5;
                } else {
                    ktExpression = null;
                }
                if (Intrinsics.areEqual((Object)v0, ktExpression)) return true;
                Object v4 = parent2;
                if (!(v4 instanceof KtDeclarationWithInitializer)) {
                    v4 = null;
                }
                KtDeclarationWithInitializer ktDeclarationWithInitializer = v4;
                if (Intrinsics.areEqual((Object)element, (Object)(ktDeclarationWithInitializer != null ? ktDeclarationWithInitializer.getInitializer() : null))) return true;
                Object v6 = parent2;
                if (!(v6 instanceof KtClassInitializer)) {
                    v6 = null;
                }
                KtClassInitializer ktClassInitializer = v6;
                if (Intrinsics.areEqual((Object)element, (Object)(ktClassInitializer != null ? ktClassInitializer.getBody() : null))) return true;
                Object v8 = parent2;
                if (!(v8 instanceof KtParameter)) {
                    v8 = null;
                }
                KtParameter ktParameter = v8;
                if (Intrinsics.areEqual((Object)element, (Object)(ktParameter != null ? ktParameter.getDefaultValue() : null))) return true;
                Object v10 = parent2;
                if (!(v10 instanceof KtSuperTypeCallEntry)) {
                    v10 = null;
                }
                KtSuperTypeCallEntry ktSuperTypeCallEntry = v10;
                if (Intrinsics.areEqual((Object)element, (Object)(ktSuperTypeCallEntry != null ? ktSuperTypeCallEntry.getValueArgumentList() : null))) return true;
                Object v12 = parent2;
                if (!(v12 instanceof KtDelegatedSuperTypeEntry)) {
                    v12 = null;
                }
                KtDelegatedSuperTypeEntry ktDelegatedSuperTypeEntry = v12;
                if (Intrinsics.areEqual((Object)element, (Object)(ktDelegatedSuperTypeEntry != null ? ktDelegatedSuperTypeEntry.getDelegateExpression() : null))) return true;
                Object v14 = parent2;
                if (!(v14 instanceof KtPropertyDelegate)) {
                    v14 = null;
                }
                KtPropertyDelegate ktPropertyDelegate = v14;
                if (Intrinsics.areEqual((Object)element, (Object)(ktPropertyDelegate != null ? ktPropertyDelegate.getExpression() : null))) {
                    return true;
                }
                boolean bl = false;
                if (bl) {
                    return true;
                }
                if (parent$iv == null) return false;
            }
        }

        private final boolean isPublicInline(@NotNull PsiElement $receiver, BindingContext bindingContext) {
            Object it;
            FunctionDescriptor descriptor2;
            Object object = $receiver;
            FunctionDescriptor functionDescriptor = object instanceof KtFunction ? (FunctionDescriptor)bindingContext.get(BindingContext.FUNCTION, $receiver) : (descriptor2 = object instanceof KtPropertyAccessor ? (FunctionDescriptor)bindingContext.get(BindingContext.PROPERTY_ACCESSOR, $receiver) : null);
            return descriptor2 != null && descriptor2.isInline() && (Intrinsics.areEqual((Object)(it = (object = EffectiveVisibilityKt.effectiveVisibility$default(descriptor2, null, false, 3, null))), (Object)EffectiveVisibility.Public.INSTANCE) || Intrinsics.areEqual((Object)it, (Object)EffectiveVisibility.ProtectedBound.INSTANCE) || it instanceof EffectiveVisibility.Protected);
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean propagates(@NotNull PsiElement $receiver, FqName annotationFqName, BindingContext bindingContext, LanguageVersionSettings languageVersionSettings) {
            void $receiver$iv;
            if (languageVersionSettings.getFlag(AnalysisFlag.Flags.getExperimental()).contains(annotationFqName.asString())) return true;
            PsiElement psiElement = $receiver;
            Companion companion = this;
            PsiElement element$iv = $receiver$iv;
            while (true) {
                boolean bl;
                PsiElement parent$iv;
                PsiElement psiElement2 = parent$iv = element$iv.getParent();
                PsiElement element = element$iv;
                if (element instanceof KtDeclaration) {
                    DeclarationDescriptor descriptor2 = bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, element);
                    if (descriptor2 != null && !DescriptorUtils.isLocal(descriptor2) && descriptor2.getAnnotations().hasAnnotation(annotationFqName)) {
                        return true;
                    }
                    bl = false;
                } else {
                    bl = false;
                }
                if (bl) {
                    return true;
                }
                if (parent$iv == null) return false;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean hasContainerAnnotatedWithUseExperimental(@NotNull PsiElement $receiver, FqName annotationFqName, BindingContext bindingContext, LanguageVersionSettings languageVersionSettings) {
            void $receiver$iv;
            if (languageVersionSettings.getFlag(AnalysisFlag.Flags.getUseExperimental()).contains(annotationFqName.asString())) return true;
            PsiElement psiElement = $receiver;
            Companion companion = this;
            PsiElement element$iv = $receiver$iv;
            while (true) {
                PsiElement parent$iv;
                PsiElement psiElement2 = parent$iv = element$iv.getParent();
                PsiElement element = element$iv;
                if (element instanceof KtAnnotated) {
                    boolean bl;
                    List<KtAnnotationEntry> list2 = ((KtAnnotated)element).getAnnotationEntries();
                    Intrinsics.checkExpressionValueIsNotNull(list2, (String)"element.annotationEntries");
                    Iterable $receiver$iv2 = list2;
                    if ($receiver$iv2 instanceof Collection && ((Collection)$receiver$iv2).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv2 : $receiver$iv2) {
                            KtAnnotationEntry entry = (KtAnnotationEntry)element$iv2;
                            AnnotationDescriptor annotationDescriptor = (AnnotationDescriptor)bindingContext.get(BindingContext.ANNOTATION, entry);
                            if (annotationDescriptor != null && Companion.isUseExperimental(annotationDescriptor, annotationFqName)) {
                                return true;
                            }
                            boolean bl2 = false;
                            if (!bl2) continue;
                            return true;
                        }
                        bl = false;
                    }
                    if (bl) {
                        return true;
                    }
                }
                boolean bl = false;
                if (bl) {
                    return true;
                }
                if (parent$iv == null) return false;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isUseExperimental(@NotNull AnnotationDescriptor $receiver, FqName annotationFqName) {
            ConstantValue constantValue;
            Object object;
            if (Intrinsics.areEqual((Object)$receiver.getFqName(), (Object)this.getUSE_EXPERIMENTAL_FQ_NAME$frontend()) ^ true) {
                return false;
            }
            ConstantValue<?> annotationClasses = $receiver.getAllValueArguments().get(this.getUSE_EXPERIMENTAL_ANNOTATION_CLASS$frontend());
            if (!(annotationClasses instanceof ArrayValue)) return false;
            Iterable $receiver$iv = (Iterable)((ArrayValue)annotationClasses).getValue();
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                return false;
            }
            Iterator iterator2 = $receiver$iv.iterator();
            do {
                if (!iterator2.hasNext()) return false;
                Object element$iv = iterator2.next();
                ConstantValue annotationClass = (ConstantValue)element$iv;
                constantValue = annotationClass;
                if (constantValue instanceof KClassValue) continue;
                constantValue = null;
            } while (!Intrinsics.areEqual((object = (KClassValue)constantValue) != null && (object = ((KClassValue)object).getValue()) != null && (object = ((KotlinType)object).getConstructor()) != null && (object = object.getDeclarationDescriptor()) != null ? DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)object) : null, (Object)annotationFqName));
            return true;
        }

        /*
         * WARNING - void declaration
         */
        public final void checkCompilerArguments(@NotNull ModuleDescriptor module2, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull Function1<? super String, Unit> reportError2, @NotNull Function1<? super String, Unit> reportWarning) {
            void $receiver$iv$iv;
            void $receiver$iv;
            Iterable $receiver$iv$iv2;
            void $receiver$iv2;
            Intrinsics.checkParameterIsNotNull((Object)module2, (String)"module");
            Intrinsics.checkParameterIsNotNull((Object)languageVersionSettings, (String)"languageVersionSettings");
            Intrinsics.checkParameterIsNotNull(reportError2, (String)"reportError");
            Intrinsics.checkParameterIsNotNull(reportWarning, (String)"reportWarning");
            DeprecationResolver deprecationResolver = new DeprecationResolver(new LockBasedStorageManager(), languageVersionSettings);
            Function2<String, Boolean, Boolean> checkAnnotation$ = new Function2<String, Boolean, Boolean>(module2, deprecationResolver, reportWarning, reportError2){
                final /* synthetic */ ModuleDescriptor $module;
                final /* synthetic */ DeprecationResolver $deprecationResolver;
                final /* synthetic */ Function1 $reportWarning;
                final /* synthetic */ Function1 $reportError;

                /*
                 * WARNING - void declaration
                 * Enabled aggressive block sorting
                 */
                public final boolean invoke(@NotNull String fqName2, boolean allowNonCompilationImpact) {
                    Object object;
                    ClassDescriptor descriptor2;
                    block18: {
                        String string;
                        block16: {
                            Experimentality experimentality;
                            block17: {
                                block15: {
                                    Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
                                    ClassDescriptor classDescriptor = descriptor2 = DescriptorUtilKt.resolveClassByFqName(this.$module, new FqName(fqName2), NoLookupLocation.FOR_NON_TRACKED_SCOPE);
                                    Experimentality experimentality2 = experimentality = classDescriptor != null ? ExperimentalUsageChecker.Companion.loadExperimentalityForMarkerAnnotation$frontend(classDescriptor) : null;
                                    if (descriptor2 != null) break block15;
                                    string = "Experimental API marker " + fqName2 + " is unresolved. " + "Please make sure it's present in the module dependencies";
                                    break block16;
                                }
                                if (experimentality != null) break block17;
                                string = "Class " + fqName2 + " is not an experimental API marker annotation";
                                break block16;
                            }
                            if (!allowNonCompilationImpact) {
                                boolean bl;
                                block14: {
                                    void $receiver$iv;
                                    Iterable iterable = experimentality.getImpact();
                                    object = Experimentality.Impact.COMPILATION;
                                    if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                                        bl = true;
                                    } else {
                                        for (T element$iv : $receiver$iv) {
                                            T p1 = element$iv;
                                            if (((Enum)object).equals(p1)) continue;
                                            bl = false;
                                            break block14;
                                        }
                                        bl = true;
                                    }
                                }
                                if (!bl) {
                                    string = "Experimental API marker " + fqName2 + " has impact other than COMPILATION, " + "therefore it can't be used with -Xuse-experimental";
                                }
                            }
                            break block18;
                        }
                        String message = string;
                        this.$reportError.invoke((Object)message);
                        return false;
                    }
                    object = this.$deprecationResolver.getDeprecations(descriptor2).iterator();
                    while (object.hasNext()) {
                        String string;
                        String string2;
                        Function1 function1;
                        StringBuilder stringBuilder;
                        String string3;
                        Function1 report2;
                        Function1 function12;
                        Deprecation deprecation = (Deprecation)object.next();
                        switch (ExperimentalUsageChecker$Companion$WhenMappings.$EnumSwitchMapping$1[deprecation.getDeprecationLevel().ordinal()]) {
                            case 1: {
                                function12 = this.$reportWarning;
                                break;
                            }
                            case 2: 
                            case 3: {
                                function12 = this.$reportError;
                                break;
                            }
                            default: {
                                throw new NoWhenBranchMatchedException();
                            }
                        }
                        Function1 function13 = report2 = function12;
                        StringBuilder stringBuilder2 = new StringBuilder().append("Experimental API marker ").append(fqName2).append(" is deprecated");
                        String string4 = deprecation.getMessage();
                        if (string4 != null) {
                            string3 = string4;
                            stringBuilder = stringBuilder2;
                            function1 = function13;
                            String it = string3;
                            string2 = ". " + it;
                            function13 = function1;
                            stringBuilder2 = stringBuilder;
                            string = string2;
                        } else {
                            string = null;
                        }
                        string3 = string;
                        stringBuilder = stringBuilder2;
                        function1 = function13;
                        String string5 = string3;
                        if (string5 == null) {
                            string5 = "";
                        }
                        string2 = string5;
                        function1.invoke((Object)stringBuilder.append(string2).toString());
                    }
                    return true;
                }
                {
                    this.$module = moduleDescriptor;
                    this.$deprecationResolver = deprecationResolver;
                    this.$reportWarning = function1;
                    this.$reportError = function12;
                    super(2);
                }
            };
            Iterable iterable = languageVersionSettings.getFlag(AnalysisFlag.Flags.getExperimental());
            void var9_8 = $receiver$iv2;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv2) {
                String it = (String)element$iv$iv;
                if (!checkAnnotation$.invoke(it, true)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List validExperimental = (List)destination$iv$iv;
            $receiver$iv$iv2 = languageVersionSettings.getFlag(AnalysisFlag.Flags.getUseExperimental());
            destination$iv$iv = $receiver$iv;
            Collection destination$iv$iv2 = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                String it = (String)element$iv$iv;
                if (!checkAnnotation$.invoke(it, false)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List validUseExperimental = (List)destination$iv$iv2;
            for (String fqName2 : CollectionsKt.intersect((Iterable)validExperimental, (Iterable)validUseExperimental)) {
                reportError2.invoke((Object)("'-Xuse-experimental=" + fqName2 + "' has no effect because '-Xexperimental=" + fqName2 + "' is used"));
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

