/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.locking;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gradle.internal.locking.LockEntryFilter;

class LockEntryFilterFactory {
    private static final LockEntryFilter FILTERS_NONE = new LockEntryFilter(){

        @Override
        public boolean filters(String moduleIdentifier) {
            return false;
        }
    };
    private static final LockEntryFilter FILTERS_ALL = new LockEntryFilter(){

        @Override
        public boolean filters(String moduleIdentifier) {
            return true;
        }
    };
    private static final String WILDCARD_SUFFIX = "*";
    public static final String MODULE_SEPARATOR = ":";

    LockEntryFilterFactory() {
    }

    static LockEntryFilter forParameter(List<String> lockedDependenciesToUpdate) {
        if (lockedDependenciesToUpdate.isEmpty()) {
            return FILTERS_NONE;
        }
        HashSet<LockEntryFilter> lockEntryFilters = new HashSet<LockEntryFilter>();
        for (String lockExcludes : lockedDependenciesToUpdate) {
            for (String lockExclude : lockExcludes.split(",")) {
                if (!lockExclude.contains(MODULE_SEPARATOR)) {
                    LockEntryFilterFactory.throwInvalid(lockExclude);
                }
                if (lockExclude.contains(WILDCARD_SUFFIX)) {
                    lockEntryFilters.add(LockEntryFilterFactory.extractAdvancedLockEntryFilter(lockExclude));
                    continue;
                }
                lockEntryFilters.add(new BasicLockEntryFilter(lockExclude));
            }
            if (!lockEntryFilters.isEmpty()) continue;
            LockEntryFilterFactory.throwInvalid(lockExcludes);
        }
        if (lockEntryFilters.size() == 1) {
            return (LockEntryFilter)lockEntryFilters.iterator().next();
        }
        return new AggregateLockEntryFilter(lockEntryFilters);
    }

    private static LockEntryFilter throwInvalid(String lockExclude) {
        throw new IllegalArgumentException("Update lock format must be <group>:<artifact> but '" + lockExclude + "' is invalid.");
    }

    private static LockEntryFilter extractAdvancedLockEntryFilter(String lockExclude) {
        String[] split = lockExclude.split(MODULE_SEPARATOR);
        LockEntryFilterFactory.validateNotation(lockExclude, split);
        String group = split[0];
        String module = split[1];
        if (group.equals(WILDCARD_SUFFIX) && module.equals(WILDCARD_SUFFIX)) {
            return FILTERS_ALL;
        }
        if (module.equals(WILDCARD_SUFFIX)) {
            if (group.contains(WILDCARD_SUFFIX)) {
                return new GroupOnlyWildcardLockEntryFilter(group);
            }
            return new GroupStrictLockEntryFilter(group);
        }
        if (module.contains(WILDCARD_SUFFIX)) {
            if (group.equals(WILDCARD_SUFFIX)) {
                return new ModuleOnlyWildcardLockEntryFilter(module);
            }
            if (group.contains(WILDCARD_SUFFIX)) {
                return new GroupModuleWildcardLockEntryFilter(group, module);
            }
            return new GroupStrictModuleWildcardLockEntryFilter(group, module);
        }
        if (group.equals(WILDCARD_SUFFIX)) {
            return new ModuleStrictLockEntryFilter(module);
        }
        return new GroupWildcardModuleStrictLockEntryFilter(group, module);
    }

    private static void validateNotation(String lockExclude, String[] split) {
        if (split.length != 2) {
            LockEntryFilterFactory.throwInvalid(lockExclude);
        }
        String group = split[0];
        String module = split[1];
        if (group.contains(WILDCARD_SUFFIX) && !group.endsWith(WILDCARD_SUFFIX) || module.contains(WILDCARD_SUFFIX) && !module.endsWith(WILDCARD_SUFFIX)) {
            LockEntryFilterFactory.throwInvalid(lockExclude);
        }
    }

    private static class GroupStrictModuleWildcardLockEntryFilter
    implements LockEntryFilter {
        private final String group;
        private final String module;

        public GroupStrictModuleWildcardLockEntryFilter(String group, String module) {
            this.group = group;
            this.module = module.substring(0, module.length() - 1);
        }

        @Override
        public boolean filters(String moduleIdentifier) {
            String[] split = moduleIdentifier.split(LockEntryFilterFactory.MODULE_SEPARATOR);
            return split[0].equals(this.group) && split[1].startsWith(this.module);
        }
    }

    private static class ModuleStrictLockEntryFilter
    implements LockEntryFilter {
        private final String module;

        public ModuleStrictLockEntryFilter(String module) {
            this.module = module;
        }

        @Override
        public boolean filters(String moduleIdentifier) {
            String[] split = moduleIdentifier.split(LockEntryFilterFactory.MODULE_SEPARATOR);
            return split[1].equals(this.module);
        }
    }

    private static class GroupWildcardModuleStrictLockEntryFilter
    implements LockEntryFilter {
        private final String group;
        private final String module;

        public GroupWildcardModuleStrictLockEntryFilter(String group, String module) {
            this.group = group.substring(0, group.length() - 1);
            this.module = module;
        }

        @Override
        public boolean filters(String moduleIdentifier) {
            String[] split = moduleIdentifier.split(LockEntryFilterFactory.MODULE_SEPARATOR);
            return split[0].startsWith(this.group) && split[1].equals(this.module);
        }
    }

    private static class GroupModuleWildcardLockEntryFilter
    implements LockEntryFilter {
        private final String group;
        private final String module;

        public GroupModuleWildcardLockEntryFilter(String group, String module) {
            this.group = group.substring(0, group.length() - 1);
            this.module = module.substring(0, module.length() - 1);
        }

        @Override
        public boolean filters(String moduleIdentifier) {
            String[] split = moduleIdentifier.split(LockEntryFilterFactory.MODULE_SEPARATOR);
            return split[0].startsWith(this.group) && split[1].startsWith(this.module);
        }
    }

    private static class ModuleOnlyWildcardLockEntryFilter
    implements LockEntryFilter {
        private final String module;

        public ModuleOnlyWildcardLockEntryFilter(String module) {
            this.module = module.substring(0, module.length() - 1);
        }

        @Override
        public boolean filters(String moduleIdentifier) {
            String[] split = moduleIdentifier.split(LockEntryFilterFactory.MODULE_SEPARATOR);
            return split[1].startsWith(this.module);
        }
    }

    private static class GroupStrictLockEntryFilter
    implements LockEntryFilter {
        private final String group;

        public GroupStrictLockEntryFilter(String group) {
            this.group = group;
        }

        @Override
        public boolean filters(String moduleIdentifier) {
            return moduleIdentifier.substring(0, moduleIdentifier.indexOf(LockEntryFilterFactory.MODULE_SEPARATOR)).equals(this.group);
        }
    }

    private static class GroupOnlyWildcardLockEntryFilter
    implements LockEntryFilter {
        private final String group;

        public GroupOnlyWildcardLockEntryFilter(String group) {
            this.group = group.substring(0, group.length() - 1);
        }

        @Override
        public boolean filters(String moduleIdentifier) {
            return moduleIdentifier.startsWith(this.group);
        }
    }

    private static class BasicLockEntryFilter
    implements LockEntryFilter {
        private final String lockExclude;

        public BasicLockEntryFilter(String lockExclude) {
            this.lockExclude = lockExclude;
        }

        @Override
        public boolean filters(String moduleIdentifier) {
            return moduleIdentifier.startsWith(this.lockExclude);
        }
    }

    private static class AggregateLockEntryFilter
    implements LockEntryFilter {
        private final Set<LockEntryFilter> filters;

        private AggregateLockEntryFilter(Set<LockEntryFilter> filters) {
            this.filters = filters;
        }

        @Override
        public boolean filters(String moduleIdentifier) {
            for (LockEntryFilter filter : this.filters) {
                if (!filter.filters(moduleIdentifier)) continue;
                return true;
            }
            return false;
        }
    }
}

