/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.internal;

import java.io.File;
import java.util.concurrent.Callable;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.internal.tasks.DefaultSourceSetOutput;
import org.gradle.api.internal.tasks.compile.processing.DefaultProcessorPath;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.internal.Cast;

public class SourceSetUtil {
    private SourceSetUtil() {
    }

    public static void configureForSourceSet(final SourceSet sourceSet, final SourceDirectorySet sourceDirectorySet, AbstractCompile compile, final Project target) {
        compile.setDescription("Compiles the " + sourceDirectorySet.getDisplayName() + ".");
        compile.setSource((FileTree)sourceSet.getJava());
        compile.getConventionMapping().map("classpath", (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return sourceSet.getCompileClasspath().plus((FileCollection)target.files(new Object[]{sourceSet.getJava().getOutputDir()}));
            }
        });
        compile.setDestinationDir(target.provider((Callable)new Callable<File>(){

            @Override
            public File call() throws Exception {
                return sourceDirectorySet.getOutputDir();
            }
        }));
        SourceSetUtil.configureOutputDirectoryForSourceSet(sourceSet, sourceDirectorySet, target);
    }

    public static void configureForSourceSet(SourceSet sourceSet, SourceDirectorySet sourceDirectorySet, AbstractCompile compile, CompileOptions options, Project target) {
        SourceSetUtil.configureForSourceSet(sourceSet, sourceDirectorySet, compile, target);
        SourceSetUtil.configureAnnotationProcessorPath(sourceSet, options, target);
    }

    public static void configureAnnotationProcessorPath(final SourceSet sourceSet, CompileOptions options, final Project target) {
        new DslObject((Object)options).getConventionMapping().map("annotationProcessorPath", (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                FileCollection processorPath = sourceSet.getAnnotationProcessorPath();
                if (processorPath == target.getConfigurations().getByName(sourceSet.getAnnotationProcessorConfigurationName())) {
                    return new DefaultProcessorPath((Configuration)processorPath);
                }
                return processorPath;
            }
        });
    }

    public static void configureOutputDirectoryForSourceSet(final SourceSet sourceSet, final SourceDirectorySet sourceDirectorySet, final Project target) {
        final String sourceSetChildPath = "classes/" + sourceDirectorySet.getName() + "/" + sourceSet.getName();
        sourceDirectorySet.setOutputDir(target.provider((Callable)new Callable<File>(){

            @Override
            public File call() throws Exception {
                if (sourceSet.getOutput().isLegacyLayout()) {
                    return sourceSet.getOutput().getClassesDir();
                }
                return new File(target.getBuildDir(), sourceSetChildPath);
            }
        }));
        DefaultSourceSetOutput sourceSetOutput = (DefaultSourceSetOutput)Cast.cast(DefaultSourceSetOutput.class, (Object)sourceSet.getOutput());
        sourceSetOutput.addClassesDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return sourceDirectorySet.getOutputDir();
            }
        });
    }
}

