/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal;

import org.apache.commons.lang.StringUtils;
import org.gradle.api.Describable;
import org.gradle.internal.DisplayName;

public class Describables {
    private Describables() {
    }

    public static DisplayName of(Object displayName) {
        if (displayName instanceof DisplayName) {
            return (DisplayName)displayName;
        }
        return new FixedDescribable(displayName);
    }

    public static DisplayName of(Object part1, Object part2) {
        return new TwoPartDescribable(part1, part2);
    }

    public static DisplayName of(Object part1, Object part2, Object part3) {
        return new ThreePartDescribable(part1, part2, part3);
    }

    public static DisplayName withTypeAndName(final String type, final String name) {
        return new AbstractDescribable(){

            public String getCapitalizedDisplayName() {
                StringBuilder result = this.asMutable();
                result.setCharAt(0, Character.toUpperCase(result.charAt(0)));
                return result.toString();
            }

            public String getDisplayName() {
                return this.asMutable().toString();
            }

            private StringBuilder asMutable() {
                StringBuilder result = new StringBuilder(type.length() + name.length() + 3);
                result.append(type);
                result.append(" '");
                result.append(name);
                result.append('\'');
                return result;
            }
        };
    }

    public static DisplayName memoize(Describable describable) {
        return new MemoizingDescribable(describable);
    }

    private static void appendDisplayName(Object src, StringBuilder stringBuilder) {
        if (src instanceof Describable) {
            Describable describable = (Describable)src;
            stringBuilder.append(describable.getDisplayName());
        } else {
            stringBuilder.append(src.toString());
        }
    }

    private static void appendCapDisplayName(Object src, StringBuilder stringBuilder) {
        if (src instanceof DisplayName) {
            DisplayName displayName = (DisplayName)src;
            stringBuilder.append(displayName.getCapitalizedDisplayName());
        } else {
            int pos = stringBuilder.length();
            if (src instanceof Describable) {
                Describable describable = (Describable)src;
                stringBuilder.append(describable.getDisplayName());
            } else {
                stringBuilder.append(src.toString());
            }
            stringBuilder.setCharAt(pos, Character.toUpperCase(stringBuilder.charAt(pos)));
        }
    }

    private static class MemoizingDescribable
    extends AbstractDescribable {
        private Describable describable;
        private String displayName;
        private String capDisplayName;

        MemoizingDescribable(Describable describable) {
            this.describable = describable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getCapitalizedDisplayName() {
            MemoizingDescribable memoizingDescribable = this;
            synchronized (memoizingDescribable) {
                if (this.capDisplayName == null) {
                    String string = this.capDisplayName = this.describable instanceof DisplayName ? ((DisplayName)this.describable).getCapitalizedDisplayName() : StringUtils.capitalize((String)this.getDisplayName());
                    if (this.displayName != null) {
                        this.describable = null;
                    }
                }
                return this.capDisplayName;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getDisplayName() {
            MemoizingDescribable memoizingDescribable = this;
            synchronized (memoizingDescribable) {
                if (this.displayName == null) {
                    this.displayName = this.describable.getDisplayName();
                    if (this.capDisplayName != null || !(this.describable instanceof DisplayName)) {
                        this.describable = null;
                    }
                }
                return this.displayName;
            }
        }
    }

    private static class ThreePartDescribable
    extends AbstractDescribable {
        private final Object part1;
        private final Object part2;
        private final Object part3;

        ThreePartDescribable(Object part1, Object part2, Object part3) {
            this.part1 = part1;
            this.part2 = part2;
            this.part3 = part3;
        }

        public String getDisplayName() {
            StringBuilder builder = new StringBuilder();
            Describables.appendDisplayName(this.part1, builder);
            builder.append(' ');
            Describables.appendDisplayName(this.part2, builder);
            builder.append(' ');
            Describables.appendDisplayName(this.part3, builder);
            return builder.toString();
        }

        public String getCapitalizedDisplayName() {
            StringBuilder builder = new StringBuilder();
            Describables.appendCapDisplayName(this.part1, builder);
            builder.append(' ');
            Describables.appendDisplayName(this.part2, builder);
            builder.append(' ');
            Describables.appendDisplayName(this.part3, builder);
            return builder.toString();
        }
    }

    private static class TwoPartDescribable
    extends AbstractDescribable {
        private final Object part1;
        private final Object part2;

        TwoPartDescribable(Object part1, Object part2) {
            this.part1 = part1;
            this.part2 = part2;
        }

        public String getDisplayName() {
            StringBuilder builder = new StringBuilder();
            Describables.appendDisplayName(this.part1, builder);
            builder.append(' ');
            Describables.appendDisplayName(this.part2, builder);
            return builder.toString();
        }

        public String getCapitalizedDisplayName() {
            StringBuilder builder = new StringBuilder();
            Describables.appendCapDisplayName(this.part1, builder);
            builder.append(' ');
            Describables.appendDisplayName(this.part2, builder);
            return builder.toString();
        }
    }

    private static class FixedDescribable
    extends AbstractDescribable {
        private final Object displayName;

        FixedDescribable(Object displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            StringBuilder builder = new StringBuilder();
            Describables.appendDisplayName(this.displayName, builder);
            return builder.toString();
        }

        public String getCapitalizedDisplayName() {
            StringBuilder builder = new StringBuilder();
            Describables.appendCapDisplayName(this.displayName, builder);
            return builder.toString();
        }
    }

    private static abstract class AbstractDescribable
    implements DisplayName {
        private AbstractDescribable() {
        }

        public String toString() {
            return this.getDisplayName();
        }
    }
}

