/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import org.gradle.api.Transformer;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.internal.artifacts.DefaultBuildIdentifier;
import org.gradle.initialization.BuildRequestContext;
import org.gradle.initialization.GradleLauncher;
import org.gradle.initialization.GradleLauncherFactory;
import org.gradle.initialization.RootBuildLifecycleListener;
import org.gradle.internal.build.AbstractBuildState;
import org.gradle.internal.build.RootBuildState;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.invocation.BuildController;
import org.gradle.internal.invocation.GradleBuildController;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.util.Path;

class DefaultRootBuildState
extends AbstractBuildState
implements RootBuildState {
    private final BuildDefinition buildDefinition;
    private final BuildRequestContext requestContext;
    private final GradleLauncherFactory gradleLauncherFactory;
    private final ListenerManager listenerManager;
    private final ServiceRegistry parentServices;
    private SettingsInternal settings;

    DefaultRootBuildState(BuildDefinition buildDefinition, BuildRequestContext requestContext, GradleLauncherFactory gradleLauncherFactory, ListenerManager listenerManager, ServiceRegistry parentServices) {
        this.buildDefinition = buildDefinition;
        this.requestContext = requestContext;
        this.gradleLauncherFactory = gradleLauncherFactory;
        this.listenerManager = listenerManager;
        this.parentServices = parentServices;
    }

    public String toString() {
        return "root build";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T run(Transformer<T, ? super BuildController> buildAction) {
        GradleLauncher gradleLauncher = this.gradleLauncherFactory.newInstance(this.buildDefinition, (RootBuildState)this, this.requestContext, this.parentServices);
        GradleBuildController buildController = new GradleBuildController(gradleLauncher);
        try {
            Object object;
            RootBuildLifecycleListener buildLifecycleListener = (RootBuildLifecycleListener)this.listenerManager.getBroadcaster(RootBuildLifecycleListener.class);
            buildLifecycleListener.afterStart();
            try {
                object = buildAction.transform((Object)buildController);
            }
            catch (Throwable throwable) {
                buildLifecycleListener.beforeComplete();
                throw throwable;
            }
            buildLifecycleListener.beforeComplete();
            return (T)object;
        }
        finally {
            buildController.stop();
        }
    }

    public void setSettings(SettingsInternal settings) {
        this.settings = settings;
    }

    public SettingsInternal getLoadedSettings() {
        if (this.settings == null) {
            throw new IllegalStateException("Settings have not been attached to this build yet.");
        }
        return this.settings;
    }

    public Path getIdentityPathForProject(Path path) {
        return path;
    }

    public BuildIdentifier getBuildIdentifier() {
        return DefaultBuildIdentifier.ROOT;
    }

    public boolean isImplicitBuild() {
        return false;
    }
}

