/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.attributes;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.attributes.AttributeValue;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.changedetection.state.isolation.Isolatable;
import org.gradle.internal.Cast;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DefaultImmutableAttributes
implements ImmutableAttributes,
AttributeValue<Object> {
    private static final Comparator<Attribute<?>> ATTRIBUTE_NAME_COMPARATOR = new Comparator<Attribute<?>>(){

        @Override
        public int compare(Attribute<?> o1, Attribute<?> o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    private final DefaultImmutableAttributes parent;
    final Attribute<?> attribute;
    final Isolatable<?> value;
    private final int hashCode;
    private final int size;
    private Set<Attribute<?>> keySet;

    DefaultImmutableAttributes() {
        this.parent = null;
        this.attribute = null;
        this.value = null;
        this.hashCode = 0;
        this.size = 0;
    }

    DefaultImmutableAttributes(DefaultImmutableAttributes parent, Attribute<?> key, Isolatable<?> value) {
        this.parent = parent;
        this.attribute = key;
        this.value = value;
        int hashCode = parent.hashCode();
        hashCode = 31 * hashCode + this.attribute.hashCode();
        this.hashCode = hashCode = 31 * hashCode + value.hashCode();
        this.size = parent.size + 1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultImmutableAttributes that = (DefaultImmutableAttributes)o;
        if (this.size != that.size) {
            return false;
        }
        DefaultImmutableAttributes cur = this;
        while (cur.value != null) {
            if (!cur.value.isolate().equals(that.getAttribute(cur.attribute))) {
                return false;
            }
            cur = cur.parent;
        }
        return true;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public Set<Attribute<?>> keySet() {
        if (this.parent == null) {
            return Collections.emptySet();
        }
        if (this.keySet == null) {
            this.keySet = Sets.union(Collections.singleton(this.attribute), this.parent.keySet());
        }
        return this.keySet;
    }

    public <T> AttributeContainer attribute(Attribute<T> key, T value) {
        throw new UnsupportedOperationException("Mutation of attributes is not allowed");
    }

    public <T> T getAttribute(Attribute<T> key) {
        if (key.equals(this.attribute)) {
            return (T)Cast.uncheckedCast(this.value.isolate());
        }
        if (this.parent != null) {
            return this.parent.getAttribute(key);
        }
        return null;
    }

    @Override
    public <T> AttributeValue<T> findEntry(Attribute<T> key) {
        if (key.equals(this.attribute)) {
            return (AttributeValue)Cast.uncheckedCast((Object)this);
        }
        if (this.parent != null) {
            return this.parent.findEntry(key);
        }
        return (AttributeValue)Cast.uncheckedCast(AttributeValue.MISSING);
    }

    @Override
    public AttributeValue<?> findEntry(String key) {
        if (this.attribute != null && key.equals(this.attribute.getName())) {
            return this;
        }
        if (this.parent != null) {
            return this.parent.findEntry(key);
        }
        return AttributeValue.MISSING;
    }

    @Override
    public Object get() {
        return this.value.isolate();
    }

    @Override
    @Nullable
    public <S> S coerce(Class<S> type) {
        Isolatable<S> converted;
        if (this.value != null && (converted = this.value.coerce(type)) != null) {
            return converted.isolate();
        }
        return null;
    }

    @Override
    public boolean isPresent() {
        return this.attribute != null;
    }

    public boolean isEmpty() {
        return this.attribute == null;
    }

    public boolean contains(Attribute<?> key) {
        return key.equals(this.attribute) || this.parent != null && this.parent.contains(key);
    }

    @Override
    public ImmutableAttributes asImmutable() {
        return this;
    }

    public AttributeContainer getAttributes() {
        return this;
    }

    public String toString() {
        TreeMap sorted = new TreeMap(ATTRIBUTE_NAME_COMPARATOR);
        DefaultImmutableAttributes node = this;
        while (node != null) {
            if (node.attribute != null) {
                sorted.put(node.attribute, node.value.isolate());
            }
            node = node.parent;
        }
        return ((Object)sorted).toString();
    }
}

