/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.clean;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.AbstractNode;
import org.jetbrains.kotlin.js.backend.ast.JsArrayAccess;
import org.jetbrains.kotlin.js.backend.ast.JsArrayLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsCase;
import org.jetbrains.kotlin.js.backend.ast.JsCatch;
import org.jetbrains.kotlin.js.backend.ast.JsConditional;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsContinue;
import org.jetbrains.kotlin.js.backend.ast.JsDefault;
import org.jetbrains.kotlin.js.backend.ast.JsDoWhile;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFor;
import org.jetbrains.kotlin.js.backend.ast.JsForIn;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsLabel;
import org.jetbrains.kotlin.js.backend.ast.JsLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNew;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsObjectLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsPostfixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsPrefixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsPropertyInitializer;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsSwitch;
import org.jetbrains.kotlin.js.backend.ast.JsSwitchMember;
import org.jetbrains.kotlin.js.backend.ast.JsThrow;
import org.jetbrains.kotlin.js.backend.ast.JsTry;
import org.jetbrains.kotlin.js.backend.ast.JsUnaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContextImpl;
import org.jetbrains.kotlin.js.backend.ast.JsWhile;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;
import org.jetbrains.kotlin.js.backend.ast.SourceInfoAwareJsNode;
import org.jetbrains.kotlin.js.backend.ast.metadata.HasMetadata;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.backend.ast.metadata.SideEffectKind;
import org.jetbrains.kotlin.js.inline.clean.TemporaryVariableElimination;
import org.jetbrains.kotlin.js.inline.clean.TemporaryVariableElimination$SubstitutionCandidateFinder$WhenMappings;
import org.jetbrains.kotlin.js.inline.util.CollectUtilsKt;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.UtilsKt;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\r\b\u0000\u0018\u00002\u00020\u0001:\u0001%B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\u0006\u0010\u001a\u001a\u00020\fJ\u0018\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\bH\u0002J\b\u0010\u001e\u001a\u00020\u0019H\u0002J\u0010\u0010\u001f\u001a\u00020\f2\u0006\u0010 \u001a\u00020\bH\u0002J\b\u0010!\u001a\u00020\u0019H\u0002J\u0010\u0010\"\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u0007H\u0002J\u0010\u0010#\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u0007H\u0002J\u0010\u0010$\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u0007H\u0002R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/TemporaryVariableElimination;", "", "function", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "(Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;)V", "definedValues", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "definitions", "", "hasChanges", "", "localVariables", "", "namesToSubstitute", "", "namesWithSideEffects", "root", "Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;", "statementsToRemove", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "temporary", "usages", "analyze", "", "apply", "assignVariable", "name", "value", "cleanUp", "isTrivial", "expr", "perform", "shouldConsiderTemporary", "shouldConsiderUnused", "useVariable", "SubstitutionCandidateFinder", "kotlin-compiler"})
public final class TemporaryVariableElimination {
    private final JsBlock root;
    private final Map<JsName, Integer> definitions;
    private final Map<JsName, Integer> usages;
    private final Map<JsName, JsExpression> definedValues;
    private final Set<JsName> temporary;
    private boolean hasChanges;
    private final Set<JsName> localVariables;
    private final Set<JsName> namesToSubstitute;
    private final Set<JsNode> statementsToRemove;
    private final Set<JsName> namesWithSideEffects;
    private final JsFunction function;

    public final boolean apply() {
        this.analyze();
        this.perform();
        this.cleanUp();
        return this.hasChanges;
    }

    private final void analyze() {
        new RecursiveJsVisitor(this){
            @NotNull
            private final Set<JsName> currentScope;
            @NotNull
            private Set<JsName> localVars;
            final /* synthetic */ TemporaryVariableElimination this$0;

            @NotNull
            public final Set<JsName> getCurrentScope() {
                return this.currentScope;
            }

            @NotNull
            public final Set<JsName> getLocalVars() {
                return this.localVars;
            }

            public final void setLocalVars(@NotNull Set<JsName> set) {
                Intrinsics.checkParameterIsNotNull(set, "<set-?>");
                this.localVars = set;
            }

            public void visitExpressionStatement(@NotNull JsExpressionStatement x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                JsExpression jsExpression = x.getExpression();
                if (!(jsExpression instanceof JsBinaryOperation)) {
                    jsExpression = null;
                }
                JsBinaryOperation jsBinaryOperation = (JsBinaryOperation)jsExpression;
                if (jsBinaryOperation != null) {
                    JsBinaryOperation jsBinaryOperation2;
                    JsBinaryOperation expression2 = jsBinaryOperation2 = jsBinaryOperation;
                    this.processBinaryExpression(expression2, MetadataProperties.getSynthetic(x), new Function0<Unit>(this, x){
                        final /* synthetic */ analyze.1 this$0;
                        final /* synthetic */ JsExpressionStatement $x$inlined;
                        {
                            this.this$0 = var1_1;
                            this.$x$inlined = jsExpressionStatement;
                            super(0);
                        }

                        public final void invoke() {
                            analyze.1.access$visitExpressionStatement$s-1623866647(this.this$0, this.$x$inlined);
                        }
                    });
                    return;
                }
                super.visitExpressionStatement(x);
            }

            public void visitBinaryExpression(@NotNull JsBinaryOperation x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                this.processBinaryExpression(x, false, new Function0<Unit>(this, x){
                    final /* synthetic */ analyze.1 this$0;
                    final /* synthetic */ JsBinaryOperation $x;

                    public final void invoke() {
                        analyze.1.access$visitBinaryExpression$s-1623866647(this.this$0, this.$x);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$x = jsBinaryOperation;
                        super(0);
                    }
                });
            }

            /*
             * WARNING - void declaration
             */
            private final void processBinaryExpression(JsBinaryOperation expression2, boolean synthetic, Function0<Unit> orElse) {
                Pair<JsName, JsExpression> assignment = JsAstUtils.decomposeAssignmentToVariable(expression2);
                if (assignment != null) {
                    void name;
                    Object object = assignment;
                    JsName jsName = ((Pair)object).component1();
                    JsExpression value = ((Pair)object).component2();
                    if (TemporaryVariableElimination.access$getLocalVariables$p(this.this$0).contains(name)) {
                        void v0 = name;
                        Intrinsics.checkExpressionValueIsNotNull(v0, "name");
                        JsExpression jsExpression = value;
                        Intrinsics.checkExpressionValueIsNotNull(jsExpression, "value");
                        TemporaryVariableElimination.access$assignVariable(this.this$0, (JsName)v0, jsExpression);
                        this.addVar((JsName)name);
                        this.accept((JsNode)value);
                        if (synthetic) {
                            object = TemporaryVariableElimination.access$getTemporary$p(this.this$0);
                            object.add(name);
                        }
                        return;
                    }
                }
                orElse.invoke();
            }

            public void visitVars(@NotNull JsVars x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                for (JsVars.JsVar v : x.getVars()) {
                    JsName name = v.getName();
                    JsExpression value = v.getInitExpression();
                    if (!TemporaryVariableElimination.access$getLocalVariables$p(this.this$0).contains(name)) continue;
                    if (MetadataProperties.getSynthetic(x)) {
                        Collection collection = TemporaryVariableElimination.access$getTemporary$p(this.this$0);
                        collection.add(name);
                    }
                    if (value == null) continue;
                    JsName jsName = name;
                    Intrinsics.checkExpressionValueIsNotNull(jsName, "name");
                    TemporaryVariableElimination.access$assignVariable(this.this$0, jsName, value);
                    this.addVar(name);
                    this.accept((JsNode)value);
                }
            }

            public void visitNameRef(@NotNull JsNameRef nameRef) {
                Intrinsics.checkParameterIsNotNull(nameRef, "nameRef");
                JsName name = nameRef.getName();
                if (name != null && TemporaryVariableElimination.access$getLocalVariables$p(this.this$0).contains(name)) {
                    TemporaryVariableElimination.access$useVariable(this.this$0, name);
                    if (!this.currentScope.contains(name)) {
                        JsExpression jsExpression = Namer.getUndefinedExpression();
                        Intrinsics.checkExpressionValueIsNotNull(jsExpression, "Namer.getUndefinedExpression()");
                        TemporaryVariableElimination.access$assignVariable(this.this$0, name, jsExpression);
                    }
                    return;
                }
                super.visitNameRef(nameRef);
            }

            public void visitBreak(@NotNull JsBreak x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
            }

            public void visitContinue(@NotNull JsContinue x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
            }

            public void visitObjectLiteral(@NotNull JsObjectLiteral x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                for (JsPropertyInitializer initializer2 : x.getPropertyInitializers()) {
                    this.accept((JsNode)initializer2.getValueExpr());
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void visitFor(@NotNull JsFor x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                analyze.1 this_$iv = this;
                Set<JsName> localVarsBackup$iv = this_$iv.getLocalVars();
                try {
                    analyze.1 var4_4 = this_$iv;
                    Set set = new LinkedHashSet<E>();
                    var4_4.setLocalVars(set);
                    super.visitFor(x);
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    Collection collection = this_$iv.getCurrentScope();
                    Iterable iterable = this_$iv.getLocalVars();
                    CollectionsKt.removeAll(collection, iterable);
                    this_$iv.setLocalVars(localVarsBackup$iv);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void visitForIn(@NotNull JsForIn x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                analyze.1 this_$iv = this;
                Set<JsName> localVarsBackup$iv = this_$iv.getLocalVars();
                try {
                    analyze.1 var4_4 = this_$iv;
                    Set set = new LinkedHashSet<E>();
                    var4_4.setLocalVars(set);
                    super.visitForIn(x);
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    Collection collection = this_$iv.getCurrentScope();
                    Iterable iterable = this_$iv.getLocalVars();
                    CollectionsKt.removeAll(collection, iterable);
                    this_$iv.setLocalVars(localVarsBackup$iv);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void visitWhile(@NotNull JsWhile x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                analyze.1 this_$iv = this;
                Set<JsName> localVarsBackup$iv = this_$iv.getLocalVars();
                try {
                    analyze.1 var4_4 = this_$iv;
                    Set set = new LinkedHashSet<E>();
                    var4_4.setLocalVars(set);
                    super.visitWhile(x);
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    Collection collection = this_$iv.getCurrentScope();
                    Iterable iterable = this_$iv.getLocalVars();
                    CollectionsKt.removeAll(collection, iterable);
                    this_$iv.setLocalVars(localVarsBackup$iv);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void visitDoWhile(@NotNull JsDoWhile x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                analyze.1 this_$iv = this;
                Set<JsName> localVarsBackup$iv = this_$iv.getLocalVars();
                try {
                    analyze.1 var4_4 = this_$iv;
                    Set set = new LinkedHashSet<E>();
                    var4_4.setLocalVars(set);
                    super.visitDoWhile(x);
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    Collection collection = this_$iv.getCurrentScope();
                    Iterable iterable = this_$iv.getLocalVars();
                    CollectionsKt.removeAll(collection, iterable);
                    this_$iv.setLocalVars(localVarsBackup$iv);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void visitIf(@NotNull JsIf x) {
                Iterable iterable;
                Object object;
                Object object2;
                Intrinsics.checkParameterIsNotNull(x, "x");
                this.accept((JsNode)x.getIfExpression());
                analyze.1 this_$iv = this;
                Set<JsName> localVarsBackup$iv = this_$iv.getLocalVars();
                try {
                    analyze.1 var4_4 = this_$iv;
                    Set set = new LinkedHashSet<E>();
                    var4_4.setLocalVars(set);
                    this.accept((JsNode)x.getThenStatement());
                    object2 = Unit.INSTANCE;
                }
                finally {
                    object = this_$iv.getCurrentScope();
                    iterable = this_$iv.getLocalVars();
                    CollectionsKt.removeAll(object, iterable);
                    this_$iv.setLocalVars(localVarsBackup$iv);
                }
                JsStatement jsStatement = x.getElseStatement();
                if (jsStatement != null) {
                    JsStatement jsStatement2;
                    JsStatement it = jsStatement2 = jsStatement;
                    analyze.1 this_$iv2 = this;
                    Set<JsName> localVarsBackup$iv2 = this_$iv2.getLocalVars();
                    try {
                        analyze.1 var9_13 = this_$iv2;
                        object2 = new LinkedHashSet<E>();
                        var9_13.setLocalVars((Set<JsName>)object2);
                        this.accept((JsNode)it);
                        object = Unit.INSTANCE;
                    }
                    finally {
                        iterable = this_$iv2.getCurrentScope();
                        Iterable iterable2 = this_$iv2.getLocalVars();
                        CollectionsKt.removeAll(iterable, iterable2);
                        this_$iv2.setLocalVars(localVarsBackup$iv2);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void visitCase(@NotNull JsCase x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                analyze.1 this_$iv = this;
                Set<JsName> localVarsBackup$iv = this_$iv.getLocalVars();
                try {
                    analyze.1 var4_4 = this_$iv;
                    Set set = new LinkedHashSet<E>();
                    var4_4.setLocalVars(set);
                    super.visitCase(x);
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    Collection collection = this_$iv.getCurrentScope();
                    Iterable iterable = this_$iv.getLocalVars();
                    CollectionsKt.removeAll(collection, iterable);
                    this_$iv.setLocalVars(localVarsBackup$iv);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void visitDefault(@NotNull JsDefault x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                analyze.1 this_$iv = this;
                Set<JsName> localVarsBackup$iv = this_$iv.getLocalVars();
                try {
                    analyze.1 var4_4 = this_$iv;
                    Set set = new LinkedHashSet<E>();
                    var4_4.setLocalVars(set);
                    super.visitDefault(x);
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    Collection collection = this_$iv.getCurrentScope();
                    Iterable iterable = this_$iv.getLocalVars();
                    CollectionsKt.removeAll(collection, iterable);
                    this_$iv.setLocalVars(localVarsBackup$iv);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void visitCatch(@NotNull JsCatch x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                analyze.1 this_$iv = this;
                Set<JsName> localVarsBackup$iv = this_$iv.getLocalVars();
                try {
                    analyze.1 var4_4 = this_$iv;
                    Set set = new LinkedHashSet<E>();
                    var4_4.setLocalVars(set);
                    super.visitCatch(x);
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    Collection collection = this_$iv.getCurrentScope();
                    Iterable iterable = this_$iv.getLocalVars();
                    CollectionsKt.removeAll(collection, iterable);
                    this_$iv.setLocalVars(localVarsBackup$iv);
                }
            }

            public void visitFunction(@NotNull JsFunction x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                Iterator<JsName> iterator2 = CollectUtilsKt.collectFreeVariables(x).iterator();
                while (iterator2.hasNext()) {
                    JsName freeVar;
                    JsName jsName = freeVar = iterator2.next();
                    Intrinsics.checkExpressionValueIsNotNull(jsName, "freeVar");
                    TemporaryVariableElimination.access$useVariable(this.this$0, jsName);
                    TemporaryVariableElimination.access$useVariable(this.this$0, freeVar);
                }
            }

            private final void addVar(JsName name) {
                Collection collection = this.currentScope;
                collection.add(name);
                this.localVars.add(name);
            }
            {
                Set set;
                this.this$0 = $outer;
                this.currentScope = SequencesKt.toMutableSet(SequencesKt.map(CollectionsKt.asSequence((Iterable)TemporaryVariableElimination.access$getFunction$p($outer).getParameters()), analyze.currentScope.1.INSTANCE));
                analyze.1 var2_2 = this;
                var2_2.localVars = set = (Set)new LinkedHashSet<E>();
            }

            public static final /* synthetic */ void access$visitExpressionStatement$s-1623866647(analyze.1 $this, @NotNull JsExpressionStatement x) {
                super.visitExpressionStatement(x);
            }

            public static final /* synthetic */ void access$visitBinaryExpression$s-1623866647(analyze.1 $this, @NotNull JsBinaryOperation x) {
                super.visitBinaryExpression(x);
            }
        }.accept((JsNode)this.root);
    }

    private final void perform() {
        new RecursiveJsVisitor(this){
            @NotNull
            private final List<Pair<JsName, JsNode>> lastAssignedVars;
            final /* synthetic */ TemporaryVariableElimination this$0;

            @NotNull
            public final List<Pair<JsName, JsNode>> getLastAssignedVars() {
                return this.lastAssignedVars;
            }

            /*
             * WARNING - void declaration
             */
            public void visitExpressionStatement(@NotNull JsExpressionStatement x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                JsExpression expression2 = x.getExpression();
                Pair<JsName, JsExpression> assignment = JsAstUtils.decomposeAssignmentToVariable(expression2);
                if (assignment != null) {
                    void name;
                    Pair<JsName, JsExpression> pair = assignment;
                    JsName jsName = pair.component1();
                    JsExpression value = pair.component2();
                    void v0 = name;
                    Intrinsics.checkExpressionValueIsNotNull(v0, "name");
                    JsExpression jsExpression = value;
                    Intrinsics.checkExpressionValueIsNotNull(jsExpression, "value");
                    this.handleDefinition((JsName)v0, jsExpression, x);
                } else {
                    JsExpression jsExpression = expression2;
                    Intrinsics.checkExpressionValueIsNotNull(jsExpression, "expression");
                    if (this.handleExpression(jsExpression)) {
                        this.invalidateTemporaries();
                    }
                }
            }

            public void visitVars(@NotNull JsVars x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                for (JsVars.JsVar v : x.getVars()) {
                    JsExpression initializer2 = v.getInitExpression();
                    if (initializer2 == null) continue;
                    JsName jsName = v.getName();
                    Intrinsics.checkExpressionValueIsNotNull(jsName, "v.name");
                    JsVars.JsVar jsVar = v;
                    Intrinsics.checkExpressionValueIsNotNull(jsVar, "v");
                    this.handleDefinition(jsName, initializer2, jsVar);
                }
            }

            private final void handleDefinition(JsName name, JsExpression value, JsNode node) {
                boolean sideEffects;
                boolean bl = sideEffects = this.handleExpression(value) || !TemporaryVariableElimination.access$getLocalVariables$p(this.this$0).contains(name);
                if (TemporaryVariableElimination.access$shouldConsiderTemporary(this.this$0, name)) {
                    if (TemporaryVariableElimination.access$isTrivial(this.this$0, value)) {
                        Collection collection = TemporaryVariableElimination.access$getStatementsToRemove$p(this.this$0);
                        collection.add(node);
                        collection = TemporaryVariableElimination.access$getNamesToSubstitute$p(this.this$0);
                        collection.add(name);
                    } else {
                        Collection collection = this.lastAssignedVars;
                        Pair<JsName, JsNode> pair = new Pair<JsName, JsNode>(name, node);
                        collection.add(pair);
                        if (sideEffects) {
                            collection = TemporaryVariableElimination.access$getNamesWithSideEffects$p(this.this$0);
                            collection.add(name);
                        }
                    }
                } else if (sideEffects) {
                    this.invalidateTemporaries();
                }
            }

            public void visitIf(@NotNull JsIf x) {
                block0: {
                    JsStatement jsStatement;
                    Intrinsics.checkParameterIsNotNull(x, "x");
                    JsExpression jsExpression = x.getIfExpression();
                    Intrinsics.checkExpressionValueIsNotNull(jsExpression, "x.ifExpression");
                    this.handleExpression(jsExpression);
                    this.invalidateTemporaries();
                    this.accept((JsNode)x.getThenStatement());
                    this.invalidateTemporaries();
                    JsStatement jsStatement2 = x.getElseStatement();
                    if (jsStatement2 == null) break block0;
                    JsStatement it = jsStatement = jsStatement2;
                    this.accept((JsNode)it);
                    this.invalidateTemporaries();
                }
            }

            public void visitReturn(@NotNull JsReturn x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                JsExpression jsExpression = x.getExpression();
                if (jsExpression != null) {
                    JsExpression jsExpression2;
                    JsExpression it = jsExpression2 = jsExpression;
                    this.handleExpression(it);
                }
                this.invalidateTemporaries();
            }

            public void visitThrow(@NotNull JsThrow x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                JsExpression jsExpression = x.getExpression();
                Intrinsics.checkExpressionValueIsNotNull(jsExpression, "x.expression");
                this.handleExpression(jsExpression);
                this.invalidateTemporaries();
            }

            public void visit(@NotNull JsSwitch x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                JsExpression jsExpression = x.getExpression();
                Intrinsics.checkExpressionValueIsNotNull(jsExpression, "x.expression");
                this.handleExpression(jsExpression);
                this.invalidateTemporaries();
                Iterable $receiver$iv = x.getCases();
                for (T element$iv : $receiver$iv) {
                    JsSwitchMember it = (JsSwitchMember)element$iv;
                    this.accept((JsNode)it);
                    this.invalidateTemporaries();
                }
            }

            public void visitObjectLiteral(@NotNull JsObjectLiteral x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                for (JsPropertyInitializer initializer2 : x.getPropertyInitializers()) {
                    this.accept((JsNode)initializer2.getValueExpr());
                }
            }

            public void visitWhile(@NotNull JsWhile x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                this.invalidateTemporaries();
                super.visitWhile(x);
                this.invalidateTemporaries();
            }

            public void visitDoWhile(@NotNull JsDoWhile x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                this.invalidateTemporaries();
                super.visitDoWhile(x);
                this.invalidateTemporaries();
            }

            public void visitForIn(@NotNull JsForIn x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                JsExpression jsExpression = x.getObjectExpression();
                Intrinsics.checkExpressionValueIsNotNull(jsExpression, "x.objectExpression");
                this.handleExpression(jsExpression);
                this.invalidateTemporaries();
                this.accept((JsNode)x.getBody());
                this.invalidateTemporaries();
            }

            public void visitFor(@NotNull JsFor x) {
                JsVars it;
                SourceInfoAwareJsNode sourceInfoAwareJsNode;
                Intrinsics.checkParameterIsNotNull(x, "x");
                JsVars jsVars = x.getInitVars();
                if (jsVars != null) {
                    it = sourceInfoAwareJsNode = jsVars;
                    this.accept((JsNode)it);
                }
                JsExpression jsExpression = x.getInitExpression();
                if (jsExpression != null) {
                    it = sourceInfoAwareJsNode = jsExpression;
                    this.handleExpression((JsExpression)((Object)it));
                }
                this.invalidateTemporaries();
                JsExpression jsExpression2 = x.getCondition();
                if (jsExpression2 != null) {
                    it = sourceInfoAwareJsNode = jsExpression2;
                    this.accept((JsNode)it);
                }
                JsExpression jsExpression3 = x.getIncrementExpression();
                if (jsExpression3 != null) {
                    it = sourceInfoAwareJsNode = jsExpression3;
                    this.accept((JsNode)it);
                }
                this.invalidateTemporaries();
                this.accept((JsNode)x.getBody());
                this.invalidateTemporaries();
            }

            public void visitTry(@NotNull JsTry x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                this.invalidateTemporaries();
                super.visitTry(x);
                this.invalidateTemporaries();
            }

            public void visitCatch(@NotNull JsCatch x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                this.invalidateTemporaries();
                super.visitCatch(x);
                this.invalidateTemporaries();
            }

            public void visitLabel(@NotNull JsLabel x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                this.invalidateTemporaries();
                super.visitLabel(x);
                this.invalidateTemporaries();
            }

            public void visitBreak(@NotNull JsBreak x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                this.invalidateTemporaries();
            }

            public void visitContinue(@NotNull JsContinue x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                this.invalidateTemporaries();
            }

            private final void invalidateTemporaries() {
                this.lastAssignedVars.clear();
            }

            /*
             * WARNING - void declaration
             */
            private final boolean handleExpression(JsExpression expression2) {
                Object object;
                SubstitutionCandidateFinder candidateFinder = this.this$0.new SubstitutionCandidateFinder();
                candidateFinder.accept((JsNode)expression2);
                List<JsName> candidates2 = candidateFinder.getSubstitutableVariableReferences();
                while (!(object = (Collection)this.lastAssignedVars).isEmpty()) {
                    void assignedVar;
                    Pair<JsName, JsNode> pair = CollectionsKt.last(this.lastAssignedVars);
                    object = pair.component1();
                    JsNode assignedStatement = pair.component2();
                    int candidateIndex = candidates2.lastIndexOf(assignedVar);
                    if (candidateIndex < 0) break;
                    Collection collection = TemporaryVariableElimination.access$getNamesToSubstitute$p(this.this$0);
                    collection.add(assignedVar);
                    collection = TemporaryVariableElimination.access$getStatementsToRemove$p(this.this$0);
                    collection.add(assignedStatement);
                    if (TemporaryVariableElimination.access$getNamesWithSideEffects$p(this.this$0).contains(assignedVar)) {
                        candidateFinder.setSideEffectOccurred(true);
                    }
                    candidates2 = candidates2.subList(0, candidateIndex);
                    this.lastAssignedVars.remove(CollectionsKt.getLastIndex(this.lastAssignedVars));
                }
                return candidateFinder.getSideEffectOccurred();
            }
            {
                List list2;
                this.this$0 = $outer;
                perform.1 var2_2 = this;
                var2_2.lastAssignedVars = list2 = (List)new ArrayList<E>();
            }
        }.accept((JsNode)this.root);
    }

    private final void cleanUp() {
        new JsVisitorWithContextImpl(this){
            final /* synthetic */ TemporaryVariableElimination this$0;

            public boolean visit(@NotNull JsVars x, @NotNull JsContext<JsNode> ctx) {
                List<Pair<List<JsVars.JsVar>, S>> ranges2;
                Intrinsics.checkParameterIsNotNull(x, "x");
                Intrinsics.checkParameterIsNotNull(ctx, "ctx");
                Collection collection = x.getVars();
                Collection object2 = TemporaryVariableElimination.access$getStatementsToRemove$p(this.this$0);
                Collection collection2 = collection;
                if (collection2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableCollection<T>");
                }
                if (TypeIntrinsics.asMutableCollection(collection2).removeAll(object2)) {
                    TemporaryVariableElimination.access$setHasChanges$p(this.this$0, true);
                }
                if ((ranges2 = UtilsKt.splitToRanges(x.getVars(), (Function1)new Function1<JsVars.JsVar, Boolean>(this){
                    final /* synthetic */ cleanUp.1 this$0;

                    public final boolean invoke(JsVars.JsVar it) {
                        TemporaryVariableElimination temporaryVariableElimination = this.this$0.this$0;
                        JsName jsName = it.getName();
                        Intrinsics.checkExpressionValueIsNotNull(jsName, "it.name");
                        return TemporaryVariableElimination.access$shouldConsiderUnused(temporaryVariableElimination, jsName);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                })).size() == 1 && !((Boolean)ranges2.get(0).getSecond()).booleanValue()) {
                    return super.visit(x, ctx);
                }
                TemporaryVariableElimination.access$setHasChanges$p(this.this$0, true);
                for (Pair<List<JsVars.JsVar>, S> pair : ranges2) {
                    JsVars jsVars;
                    JsVars.JsVar[] jsVarArray;
                    Iterable thisCollection$iv;
                    JsVars jsVars2;
                    AbstractNode abstractNode;
                    JsContext<JsNode> jsContext;
                    Object initializer2;
                    Object element$iv;
                    Iterator<Object> $receiver$iv$iv;
                    Iterable $receiver$iv;
                    List<JsVars.JsVar> subList = pair.component1();
                    boolean isRemoved = (Boolean)pair.component2();
                    Iterable iterable = $receiver$iv = (Iterable)subList;
                    Collection destination$iv$iv = new ArrayList<E>();
                    void $receiver$iv$iv$iv = $receiver$iv$iv;
                    for (T element$iv$iv$iv : $receiver$iv$iv$iv) {
                        JsExpression jsExpression;
                        T element$iv$iv = element$iv$iv$iv;
                        JsVars.JsVar it = (JsVars.JsVar)element$iv$iv;
                        if (it.getInitExpression() == null) continue;
                        JsExpression it$iv$iv = jsExpression;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    List initializers = (List)destination$iv$iv;
                    $receiver$iv = initializers;
                    $receiver$iv$iv = $receiver$iv.iterator();
                    while ($receiver$iv$iv.hasNext()) {
                        element$iv = $receiver$iv$iv.next();
                        JsExpression it = (JsExpression)element$iv;
                        this.accept((JsNode)it);
                    }
                    if (isRemoved) {
                        $receiver$iv$iv = initializers.iterator();
                        while ($receiver$iv$iv.hasNext()) {
                            initializer2 = (JsExpression)$receiver$iv$iv.next();
                            element$iv = new JsExpressionStatement((JsExpression)this.accept((JsNode)initializer2));
                            jsContext = ctx;
                            Object $receiver = element$iv;
                            MetadataProperties.setSynthetic((HasMetadata)$receiver, true);
                            abstractNode = element$iv;
                            jsContext.addPrevious((JsNode)abstractNode);
                        }
                        continue;
                    }
                    initializer2 = subList;
                    JsVars jsVars3 = jsVars2;
                    abstractNode = jsVars2;
                    jsContext = ctx;
                    if ($receiver$iv == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                    }
                    if (thisCollection$iv.toArray(new JsVars.JsVar[thisCollection$iv.size()]) == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    JsVars.JsVar[] jsVarArray2 = jsVarArray;
                    jsVars3(Arrays.copyOf(jsVarArray2, jsVarArray2.length));
                    JsVars $receiver = jsVars = abstractNode;
                    MetadataProperties.setSynthetic($receiver, true);
                    abstractNode = jsVars;
                    jsContext.addPrevious((JsNode)abstractNode);
                }
                ctx.removeMe();
                return false;
            }

            /*
             * WARNING - void declaration
             */
            public boolean visit(@NotNull JsExpressionStatement x, @NotNull JsContext<JsNode> ctx) {
                Pair<JsName, JsExpression> assignment;
                Intrinsics.checkParameterIsNotNull(x, "x");
                Intrinsics.checkParameterIsNotNull(ctx, "ctx");
                if (TemporaryVariableElimination.access$getStatementsToRemove$p(this.this$0).contains(x)) {
                    ctx.removeMe();
                    TemporaryVariableElimination.access$setHasChanges$p(this.this$0, true);
                    return false;
                }
                JsExpression expression2 = x.getExpression();
                if (expression2 instanceof JsNameRef && ((JsNameRef)expression2).getQualifier() == null && CollectionsKt.contains(TemporaryVariableElimination.access$getLocalVariables$p(this.this$0), ((JsNameRef)expression2).getName())) {
                    MetadataProperties.setSynthetic(x, true);
                }
                if ((assignment = JsAstUtils.decomposeAssignmentToVariable(expression2)) != null) {
                    void name;
                    Object object = assignment;
                    JsName jsName = ((Pair)object).component1();
                    JsExpression value = ((Pair)object).component2();
                    void v0 = name;
                    Intrinsics.checkExpressionValueIsNotNull(v0, "name");
                    if (TemporaryVariableElimination.access$shouldConsiderUnused(this.this$0, (JsName)v0)) {
                        TemporaryVariableElimination.access$setHasChanges$p(this.this$0, true);
                        object = this.accept((JsNode)new JsExpressionStatement(value));
                        JsContext<JsNode> jsContext = ctx;
                        JsExpressionStatement $receiver = (JsExpressionStatement)object;
                        MetadataProperties.setSynthetic($receiver, true);
                        Object object2 = object;
                        jsContext.replaceMe(object2);
                        return false;
                    }
                }
                return super.visit(x, ctx);
            }

            public boolean visit(@NotNull JsObjectLiteral x, @NotNull JsContext<?> ctx) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                Intrinsics.checkParameterIsNotNull(ctx, "ctx");
                for (JsPropertyInitializer initializer2 : x.getPropertyInitializers()) {
                    this.accept((JsNode)initializer2.getValueExpr());
                }
                return super.visit(x, ctx);
            }

            public boolean visit(@NotNull JsNameRef x, @NotNull JsContext<JsNode> ctx) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                Intrinsics.checkParameterIsNotNull(ctx, "ctx");
                JsName name = x.getName();
                if (name != null && x.getQualifier() == null && TemporaryVariableElimination.access$getNamesToSubstitute$p(this.this$0).contains(name)) {
                    V v = TemporaryVariableElimination.access$getDefinedValues$p(this.this$0).get(name);
                    if (v == null) {
                        Intrinsics.throwNpe();
                    }
                    JsExpression replacement = (JsExpression)this.accept((JsNode)v);
                    JsExpression jsExpression = replacement.deepCopy();
                    JsContext<JsNode> jsContext = ctx;
                    JsExpression $receiver = jsExpression;
                    MetadataProperties.setSynthetic($receiver, true);
                    JsExpression jsExpression2 = jsExpression;
                    jsContext.replaceMe((JsNode)jsExpression2);
                    return false;
                }
                return super.visit(x, ctx);
            }

            public boolean visit(@NotNull JsFunction x, @NotNull JsContext<?> ctx) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                Intrinsics.checkParameterIsNotNull(ctx, "ctx");
                return false;
            }

            public boolean visit(@NotNull JsBreak x, @NotNull JsContext<?> ctx) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                Intrinsics.checkParameterIsNotNull(ctx, "ctx");
                return false;
            }

            public boolean visit(@NotNull JsContinue x, @NotNull JsContext<?> ctx) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                Intrinsics.checkParameterIsNotNull(ctx, "ctx");
                return false;
            }

            public void endVisit(@NotNull JsBinaryOperation x, @NotNull JsContext<JsNode> ctx) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                Intrinsics.checkParameterIsNotNull(ctx, "ctx");
                Pair<JsName, JsExpression> assignment = JsAstUtils.decomposeAssignmentToVariable(x);
                if (assignment != null) {
                    JsName name;
                    JsName jsName = name = assignment.getFirst();
                    Intrinsics.checkExpressionValueIsNotNull(jsName, "name");
                    if (TemporaryVariableElimination.access$shouldConsiderUnused(this.this$0, jsName)) {
                        JsNode jsNode = this.accept((JsNode)x.getArg2());
                        JsContext<JsNode> jsContext = ctx;
                        JsExpression $receiver = (JsExpression)jsNode;
                        MetadataProperties.setSynthetic($receiver, true);
                        JsNode jsNode2 = jsNode;
                        jsContext.replaceMe(jsNode2);
                    }
                }
                super.endVisit(x, ctx);
            }
            {
                this.this$0 = $outer;
            }
        }.accept((JsNode)this.root);
    }

    private final void assignVariable(JsName name, JsExpression value) {
        Map<JsName, Object> map2 = this.definitions;
        Integer n = this.definitions.get(name);
        Object object = (n != null ? n : 0) + 1;
        map2.put(name, (Integer)object);
        map2 = this.definedValues;
        object = value;
        map2.put(name, (Integer)object);
    }

    private final void useVariable(JsName name) {
        Map<JsName, Integer> map2 = this.usages;
        Integer n = this.usages.get(name);
        Integer n2 = (n != null ? n : 0) + 1;
        map2.put(name, n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldConsiderUnused(JsName name) {
        Integer n = this.definitions.get(name);
        if (n == null) return false;
        int n2 = n;
        if (n2 <= 0) return false;
        Integer n3 = this.usages.get(name);
        if ((n3 != null ? n3 : 0) != 0) return false;
        if (!this.temporary.contains(name)) return false;
        if (MetadataProperties.getImported(name)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldConsiderTemporary(JsName name) {
        Integer n = this.definitions.get(name);
        if (n == null) return false;
        if (n != 1) return false;
        if (!this.temporary.contains(name)) {
            return false;
        }
        JsExpression expr = this.definedValues.get(name);
        if (expr != null) {
            if (this.isTrivial(expr)) return true;
        }
        Integer n2 = this.usages.get(name);
        if (n2 == null) return false;
        if (n2 != 1) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isTrivial(JsExpression expr) {
        JsExpression jsExpression = expr;
        if (jsExpression instanceof JsNameRef) {
            JsExpression qualifier = ((JsNameRef)expr).getQualifier();
            if (Intrinsics.areEqual((Object)MetadataProperties.getSideEffects(expr), (Object)SideEffectKind.PURE) && (qualifier == null || this.isTrivial(qualifier))) {
                if (CollectionsKt.contains((Iterable)this.temporary, ((JsNameRef)expr).getName())) return false;
                return true;
            }
            JsName name = ((JsNameRef)expr).getName();
            if (!CollectionsKt.contains((Iterable)this.localVariables, name)) return false;
            Object object = this.definitions;
            Map<JsName, Integer> map2 = object;
            if (map2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, V>");
            }
            Integer n = map2.get(name);
            if (n == null || n == 0) {
                return true;
            }
            if (n != 1) return false;
            if (!CollectionsKt.contains((Iterable)this.namesToSubstitute, name)) return true;
            object = this.definedValues;
            Map<JsName, Object> map3 = object;
            if (map3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, V>");
            }
            JsExpression jsExpression2 = (JsExpression)map3.get(name);
            if (jsExpression2 == null) return false;
            Object it = object = jsExpression2;
            boolean bl = this.isTrivial((JsExpression)it);
            if (!bl) return false;
            return true;
        }
        if (jsExpression instanceof JsLiteral.JsValueLiteral) {
            if (expr.toString().length() >= 10) return false;
            return true;
        }
        if (jsExpression instanceof JsInvocation) {
            JsExpression jsExpression3;
            if (!Intrinsics.areEqual((Object)MetadataProperties.getSideEffects(expr), (Object)SideEffectKind.PURE)) return false;
            JsExpression jsExpression4 = ((JsInvocation)expr).getQualifier();
            Intrinsics.checkExpressionValueIsNotNull(jsExpression4, "expr.qualifier");
            if (!this.isTrivial(jsExpression4)) return false;
            Iterable $receiver$iv = ((JsInvocation)expr).getArguments();
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                return true;
            }
            Iterator iterator2 = $receiver$iv.iterator();
            do {
                JsExpression it;
                if (!iterator2.hasNext()) return true;
                Object element$iv = iterator2.next();
                jsExpression3 = it = (JsExpression)element$iv;
                Intrinsics.checkExpressionValueIsNotNull(jsExpression3, "it");
            } while (this.isTrivial(jsExpression3));
            return false;
        }
        if (!(jsExpression instanceof JsArrayAccess)) return false;
        JsExpression jsExpression5 = ((JsArrayAccess)expr).getArrayExpression();
        Intrinsics.checkExpressionValueIsNotNull(jsExpression5, "expr.arrayExpression");
        if (!this.isTrivial(jsExpression5)) return false;
        JsExpression jsExpression6 = ((JsArrayAccess)expr).getIndexExpression();
        Intrinsics.checkExpressionValueIsNotNull(jsExpression6, "expr.indexExpression");
        if (!this.isTrivial(jsExpression6)) return false;
        if (!Intrinsics.areEqual((Object)MetadataProperties.getSideEffects(expr), (Object)SideEffectKind.PURE)) return false;
        return true;
    }

    public TemporaryVariableElimination(@NotNull JsFunction function2) {
        Intrinsics.checkParameterIsNotNull(function2, "function");
        this.function = function2;
        this.root = this.function.getBody();
        TemporaryVariableElimination temporaryVariableElimination = this;
        Object object = new LinkedHashMap();
        temporaryVariableElimination.definitions = object;
        temporaryVariableElimination = this;
        object = new LinkedHashMap();
        temporaryVariableElimination.usages = object;
        temporaryVariableElimination = this;
        object = new LinkedHashMap();
        temporaryVariableElimination.definedValues = object;
        temporaryVariableElimination = this;
        temporaryVariableElimination.temporary = object = (Set)new LinkedHashSet();
        this.localVariables = CollectUtilsKt.collectLocalVariables(this.function);
        temporaryVariableElimination = this;
        temporaryVariableElimination.namesToSubstitute = object = (Set)new LinkedHashSet();
        temporaryVariableElimination = this;
        temporaryVariableElimination.statementsToRemove = object = (Set)new LinkedHashSet();
        temporaryVariableElimination = this;
        temporaryVariableElimination.namesWithSideEffects = object = (Set)new LinkedHashSet();
    }

    public static final /* synthetic */ void access$assignVariable(TemporaryVariableElimination $this, @NotNull JsName name, @NotNull JsExpression value) {
        $this.assignVariable(name, value);
    }

    @NotNull
    public static final /* synthetic */ Set access$getTemporary$p(TemporaryVariableElimination $this) {
        return $this.temporary;
    }

    public static final /* synthetic */ void access$useVariable(TemporaryVariableElimination $this, @NotNull JsName name) {
        $this.useVariable(name);
    }

    @NotNull
    public static final /* synthetic */ JsFunction access$getFunction$p(TemporaryVariableElimination $this) {
        return $this.function;
    }

    public static final /* synthetic */ boolean access$isTrivial(TemporaryVariableElimination $this, @NotNull JsExpression expr) {
        return $this.isTrivial(expr);
    }

    @NotNull
    public static final /* synthetic */ Set access$getStatementsToRemove$p(TemporaryVariableElimination $this) {
        return $this.statementsToRemove;
    }

    @NotNull
    public static final /* synthetic */ Set access$getNamesWithSideEffects$p(TemporaryVariableElimination $this) {
        return $this.namesWithSideEffects;
    }

    public static final /* synthetic */ boolean access$getHasChanges$p(TemporaryVariableElimination $this) {
        return $this.hasChanges;
    }

    public static final /* synthetic */ void access$setHasChanges$p(TemporaryVariableElimination $this, boolean bl) {
        $this.hasChanges = bl;
    }

    public static final /* synthetic */ boolean access$shouldConsiderUnused(TemporaryVariableElimination $this, @NotNull JsName name) {
        return $this.shouldConsiderUnused(name);
    }

    @NotNull
    public static final /* synthetic */ Map access$getDefinedValues$p(TemporaryVariableElimination $this) {
        return $this.definedValues;
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020'H\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/TemporaryVariableElimination$SubstitutionCandidateFinder;", "Lorg/jetbrains/kotlin/js/backend/ast/RecursiveJsVisitor;", "(Lorg/jetbrains/kotlin/js/inline/clean/TemporaryVariableElimination;)V", "sideEffectOccurred", "", "getSideEffectOccurred", "()Z", "setSideEffectOccurred", "(Z)V", "substitutableVariableReferences", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "getSubstitutableVariableReferences", "()Ljava/util/List;", "visitArray", "", "x", "Lorg/jetbrains/kotlin/js/backend/ast/JsArrayLiteral;", "visitArrayAccess", "Lorg/jetbrains/kotlin/js/backend/ast/JsArrayAccess;", "visitBinaryExpression", "Lorg/jetbrains/kotlin/js/backend/ast/JsBinaryOperation;", "visitConditional", "Lorg/jetbrains/kotlin/js/backend/ast/JsConditional;", "visitFunction", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "visitInvocation", "invocation", "Lorg/jetbrains/kotlin/js/backend/ast/JsInvocation;", "visitNameRef", "nameRef", "Lorg/jetbrains/kotlin/js/backend/ast/JsNameRef;", "visitNew", "Lorg/jetbrains/kotlin/js/backend/ast/JsNew;", "visitObjectLiteral", "Lorg/jetbrains/kotlin/js/backend/ast/JsObjectLiteral;", "visitPostfixOperation", "Lorg/jetbrains/kotlin/js/backend/ast/JsPostfixOperation;", "visitPrefixOperation", "Lorg/jetbrains/kotlin/js/backend/ast/JsPrefixOperation;", "kotlin-compiler"})
    private final class SubstitutionCandidateFinder
    extends RecursiveJsVisitor {
        @NotNull
        private final List<JsName> substitutableVariableReferences;
        private boolean sideEffectOccurred;

        @NotNull
        public final List<JsName> getSubstitutableVariableReferences() {
            return this.substitutableVariableReferences;
        }

        public final boolean getSideEffectOccurred() {
            return this.sideEffectOccurred;
        }

        public final void setSideEffectOccurred(boolean bl) {
            this.sideEffectOccurred = bl;
        }

        @Override
        public void visitFunction(@NotNull JsFunction x) {
            Intrinsics.checkParameterIsNotNull(x, "x");
            this.sideEffectOccurred = true;
        }

        @Override
        public void visitObjectLiteral(@NotNull JsObjectLiteral x) {
            Intrinsics.checkParameterIsNotNull(x, "x");
            for (JsPropertyInitializer initializer2 : x.getPropertyInitializers()) {
                this.accept((JsNode)initializer2.getValueExpr());
            }
            this.sideEffectOccurred = true;
        }

        @Override
        public void visitNew(@NotNull JsNew x) {
            Intrinsics.checkParameterIsNotNull(x, "x");
            super.visitNew(x);
            if (Intrinsics.areEqual((Object)MetadataProperties.getSideEffects(x), (Object)SideEffectKind.AFFECTS_STATE)) {
                this.sideEffectOccurred = true;
            }
        }

        @Override
        public void visitInvocation(@NotNull JsInvocation invocation) {
            Intrinsics.checkParameterIsNotNull(invocation, "invocation");
            super.visitInvocation(invocation);
            if (Intrinsics.areEqual((Object)MetadataProperties.getSideEffects(invocation), (Object)SideEffectKind.AFFECTS_STATE)) {
                this.sideEffectOccurred = true;
            }
        }

        @Override
        public void visitConditional(@NotNull JsConditional x) {
            Intrinsics.checkParameterIsNotNull(x, "x");
            this.accept((JsNode)x.getTestExpression());
        }

        @Override
        public void visitArrayAccess(@NotNull JsArrayAccess x) {
            Intrinsics.checkParameterIsNotNull(x, "x");
            super.visitArrayAccess(x);
            if (Intrinsics.areEqual((Object)MetadataProperties.getSideEffects(x), (Object)SideEffectKind.AFFECTS_STATE)) {
                this.sideEffectOccurred = true;
            }
        }

        @Override
        public void visitArray(@NotNull JsArrayLiteral x) {
            Intrinsics.checkParameterIsNotNull(x, "x");
            super.visitArray(x);
            this.sideEffectOccurred = true;
        }

        @Override
        public void visitPrefixOperation(@NotNull JsPrefixOperation x) {
            Intrinsics.checkParameterIsNotNull(x, "x");
            super.visitPrefixOperation(x);
            JsUnaryOperator jsUnaryOperator = x.getOperator();
            if (jsUnaryOperator != null) {
                switch (TemporaryVariableElimination$SubstitutionCandidateFinder$WhenMappings.$EnumSwitchMapping$0[jsUnaryOperator.ordinal()]) {
                    case 1: 
                    case 2: {
                        this.sideEffectOccurred = true;
                    }
                }
            }
        }

        @Override
        public void visitPostfixOperation(@NotNull JsPostfixOperation x) {
            Intrinsics.checkParameterIsNotNull(x, "x");
            super.visitPostfixOperation(x);
            JsUnaryOperator jsUnaryOperator = x.getOperator();
            if (jsUnaryOperator != null) {
                switch (TemporaryVariableElimination$SubstitutionCandidateFinder$WhenMappings.$EnumSwitchMapping$1[jsUnaryOperator.ordinal()]) {
                    case 1: 
                    case 2: {
                        this.sideEffectOccurred = true;
                    }
                }
            }
        }

        @Override
        public void visitNameRef(@NotNull JsNameRef nameRef) {
            Intrinsics.checkParameterIsNotNull(nameRef, "nameRef");
            JsName name = nameRef.getName();
            if (name != null && TemporaryVariableElimination.this.localVariables.contains(name)) {
                if (!TemporaryVariableElimination.this.namesToSubstitute.contains(name) && TemporaryVariableElimination.this.shouldConsiderTemporary(name) && !this.sideEffectOccurred) {
                    Collection collection = this.substitutableVariableReferences;
                    collection.add(name);
                }
            } else {
                super.visitNameRef(nameRef);
                if (Intrinsics.areEqual((Object)MetadataProperties.getSideEffects(nameRef), (Object)SideEffectKind.AFFECTS_STATE)) {
                    this.sideEffectOccurred = true;
                }
            }
        }

        @Override
        public void visitBinaryExpression(@NotNull JsBinaryOperation x) {
            Intrinsics.checkParameterIsNotNull(x, "x");
            if (Intrinsics.areEqual(x.getOperator(), JsBinaryOperator.ASG)) {
                JsExpression left = x.getArg1();
                JsExpression right = x.getArg2();
                if (left instanceof JsNameRef) {
                    JsExpression qualifier = ((JsNameRef)left).getQualifier();
                    if (qualifier != null) {
                        this.accept((JsNode)qualifier);
                    }
                } else if (left instanceof JsArrayAccess) {
                    this.accept((JsNode)((JsArrayAccess)left).getArrayExpression());
                    this.accept((JsNode)((JsArrayAccess)left).getIndexExpression());
                }
                this.accept((JsNode)right);
                this.sideEffectOccurred = true;
            } else {
                super.visitBinaryExpression(x);
            }
        }

        public SubstitutionCandidateFinder() {
            List list2;
            SubstitutionCandidateFinder substitutionCandidateFinder = this;
            substitutionCandidateFinder.substitutableVariableReferences = list2 = (List)new ArrayList();
        }
    }
}

