/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.http;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.caching.configuration.AbstractBuildCache;
import org.gradle.caching.http.HttpBuildCacheCredentials;

@Incubating
public class HttpBuildCache
extends AbstractBuildCache {
    private final HttpBuildCacheCredentials credentials = new HttpBuildCacheCredentials();
    private URI url;
    private boolean allowUntrustedServer;

    @Nullable
    public URI getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.setUrl(URI.create(url));
    }

    public void setUrl(URL url) throws URISyntaxException {
        this.setUrl(url.toURI());
    }

    public void setUrl(URI url) {
        this.url = url;
    }

    public HttpBuildCacheCredentials getCredentials() {
        return this.credentials;
    }

    public void credentials(Action<? super HttpBuildCacheCredentials> configuration) {
        configuration.execute((Object)this.credentials);
    }

    public boolean isAllowUntrustedServer() {
        return this.allowUntrustedServer;
    }

    public void setAllowUntrustedServer(boolean allowUntrustedServer) {
        this.allowUntrustedServer = allowUntrustedServer;
    }
}

