/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.TreeSet;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.DependencySubstitution;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.artifacts.DependencySubstitutionInternal;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.VersionSelectionReasons;
import org.gradle.internal.Pair;
import org.gradle.internal.component.local.model.DefaultProjectComponentSelector;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeBuildDependencySubstitutions
implements Action<DependencySubstitution> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompositeBuildDependencySubstitutions.class);
    private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;
    private final Multimap<ModuleIdentifier, ProjectComponentIdentifier> replacementMap = ArrayListMultimap.create();

    public CompositeBuildDependencySubstitutions(Collection<Pair<ModuleVersionIdentifier, ProjectComponentIdentifier>> replacements, ImmutableModuleIdentifierFactory moduleIdentifierFactory) {
        this.moduleIdentifierFactory = moduleIdentifierFactory;
        for (Pair<ModuleVersionIdentifier, ProjectComponentIdentifier> replacement : replacements) {
            this.replacementMap.put((Object)((ModuleVersionIdentifier)replacement.getLeft()).getModule(), replacement.getRight());
        }
    }

    public void execute(DependencySubstitution sub) {
        ModuleComponentSelector selector;
        ProjectComponentIdentifier replacement;
        DependencySubstitutionInternal dependencySubstitution = (DependencySubstitutionInternal)sub;
        ComponentSelector requested = dependencySubstitution.getTarget();
        if (requested instanceof ModuleComponentSelector && (replacement = this.getReplacementFor(selector = (ModuleComponentSelector)requested)) != null) {
            dependencySubstitution.useTarget((Object)DefaultProjectComponentSelector.newSelector((ProjectComponentIdentifier)replacement), VersionSelectionReasons.COMPOSITE_BUILD);
        }
    }

    private ProjectComponentIdentifier getReplacementFor(ModuleComponentSelector selector) {
        ModuleIdentifier candidateId = this.moduleIdentifierFactory.module(selector.getGroup(), selector.getModule());
        Collection providingProjects = this.replacementMap.get((Object)candidateId);
        if (providingProjects.isEmpty()) {
            LOGGER.info("Found no composite build substitute for module '" + candidateId + "'.");
            return null;
        }
        if (providingProjects.size() == 1) {
            ProjectComponentIdentifier match = (ProjectComponentIdentifier)providingProjects.iterator().next();
            LOGGER.info("Found project '" + match + "' as substitute for module '" + candidateId + "'.");
            return match;
        }
        TreeSet sortedProjects = Sets.newTreeSet((Iterable)CollectionUtils.collect((Iterable)providingProjects, (Transformer)new Transformer<String, ProjectComponentIdentifier>(){

            public String transform(ProjectComponentIdentifier projectComponentIdentifier) {
                return projectComponentIdentifier.getDisplayName();
            }
        }));
        String failureMessage = String.format("Module version '%s' is not unique in composite: can be provided by %s.", selector.getDisplayName(), sortedProjects);
        throw new ModuleVersionResolveException((ComponentSelector)selector, failureMessage);
    }
}

