/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ModuleExclusion;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ModuleExclusions;
import org.gradle.internal.component.external.model.DefaultConfigurationMetadata;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetadata;
import org.gradle.internal.component.model.Exclude;

class IvyConfigurationMetadata
extends DefaultConfigurationMetadata {
    private final ImmutableList<Exclude> excludes;
    private ModuleExclusion exclusions;

    IvyConfigurationMetadata(ModuleComponentIdentifier componentId, String name, boolean transitive, boolean visible, ImmutableList<IvyConfigurationMetadata> parents, List<Exclude> excludes, ImmutableList<ModuleComponentArtifactMetadata> artifacts) {
        super(componentId, name, transitive, visible, parents, artifacts);
        Collection<String> hierarchy = this.getHierarchy();
        ImmutableList.Builder filtered = ImmutableList.builder();
        block0: for (Exclude exclude : excludes) {
            for (String config : exclude.getConfigurations()) {
                if (!hierarchy.contains(config)) continue;
                filtered.add((Object)exclude);
                continue block0;
            }
        }
        this.excludes = filtered.build();
    }

    public List<Exclude> getExcludes() {
        return this.excludes;
    }

    @Override
    public ModuleExclusion getExclusions(ModuleExclusions moduleExclusions) {
        if (this.exclusions == null) {
            this.exclusions = moduleExclusions.excludeAny(this.excludes);
        }
        return this.exclusions;
    }
}

