/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dependencies;

import java.util.List;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.internal.artifacts.ResolvedVersionConstraint;
import org.gradle.api.internal.artifacts.dependencies.DefaultImmutableVersionConstraint;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelectorScheme;

public class DefaultResolvedVersionConstraint
extends DefaultImmutableVersionConstraint
implements ResolvedVersionConstraint {
    private final VersionSelector preferredVersionSelector;
    private final VersionSelector rejectedVersionsSelector;

    public DefaultResolvedVersionConstraint(VersionConstraint parent, VersionSelectorScheme scheme) {
        super(parent.getPreferredVersion(), parent.getRejectedVersions());
        String preferredVersion = parent.getPreferredVersion();
        List rejectedVersions = parent.getRejectedVersions();
        this.preferredVersionSelector = scheme.parseSelector(preferredVersion);
        this.rejectedVersionsSelector = DefaultResolvedVersionConstraint.toRejectSelector(scheme, rejectedVersions);
    }

    private static VersionSelector toRejectSelector(VersionSelectorScheme scheme, List<String> rejectedVersions) {
        if (rejectedVersions.size() > 1) {
            throw new UnsupportedOperationException("Multiple rejects are not yet supported");
        }
        return rejectedVersions.isEmpty() ? null : scheme.parseSelector(rejectedVersions.get(0));
    }

    @Override
    public VersionSelector getPreferredSelector() {
        return this.preferredVersionSelector;
    }

    @Override
    public VersionSelector getRejectedSelector() {
        return this.rejectedVersionsSelector;
    }
}

