/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resolve.result;

import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.result.ComponentSelectionReason;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.VersionSelectionReasons;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.internal.resolve.result.BuildableComponentIdResolveResult;
import org.gradle.internal.resolve.result.DefaultResourceAwareResolveResult;

public class DefaultBuildableComponentIdResolveResult
extends DefaultResourceAwareResolveResult
implements BuildableComponentIdResolveResult {
    private ModuleVersionResolveException failure;
    private ComponentResolveMetadata metaData;
    private ComponentIdentifier id;
    private ModuleVersionIdentifier moduleVersionId;
    private ComponentSelectionReason selectionReason;
    private VersionSelector versionSelector;

    @Override
    public boolean hasResult() {
        return this.id != null || this.failure != null;
    }

    @Override
    public ModuleVersionResolveException getFailure() {
        return this.failure;
    }

    @Override
    public ComponentIdentifier getId() {
        this.assertResolved();
        return this.id;
    }

    @Override
    public ModuleVersionIdentifier getModuleVersionId() {
        this.assertResolved();
        return this.moduleVersionId;
    }

    @Override
    public ComponentSelectionReason getSelectionReason() {
        return this.selectionReason;
    }

    @Override
    public void setSelectionReason(ComponentSelectionReason reason) {
        this.selectionReason = reason;
    }

    @Override
    public ComponentResolveMetadata getMetaData() {
        this.assertResolved();
        return this.metaData;
    }

    @Override
    public void resolved(ComponentIdentifier id, ModuleVersionIdentifier moduleVersionIdentifier) {
        this.reset();
        this.id = id;
        this.moduleVersionId = moduleVersionIdentifier;
    }

    @Override
    public void resolved(ComponentResolveMetadata metaData) {
        this.resolved(metaData.getComponentId(), metaData.getId());
        this.metaData = metaData;
    }

    @Override
    public void failed(ModuleVersionResolveException failure) {
        this.reset();
        this.failure = failure;
    }

    private void assertResolved() {
        if (this.failure != null) {
            throw this.failure;
        }
        if (this.id == null) {
            throw new IllegalStateException("Not resolved.");
        }
    }

    private void reset() {
        this.failure = null;
        this.metaData = null;
        this.id = null;
        this.moduleVersionId = null;
        this.selectionReason = VersionSelectionReasons.REQUESTED;
        this.versionSelector = null;
    }

    @Override
    public VersionSelector getVersionSelector() {
        return this.versionSelector;
    }

    @Override
    public void setVersionSelector(VersionSelector versionSelector) {
        this.versionSelector = versionSelector;
    }
}

