/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component;

import com.google.common.collect.Ordering;
import java.util.List;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariant;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.internal.component.AmbiguousConfigurationSelectionException;
import org.gradle.internal.component.model.AttributeMatcher;
import org.gradle.internal.text.TreeFormatter;

public class AmbiguousVariantSelectionException
extends RuntimeException {
    public AmbiguousVariantSelectionException(String producerDisplayName, AttributeContainerInternal requested, List<? extends ResolvedVariant> matches, AttributeMatcher matcher) {
        super(AmbiguousVariantSelectionException.format(producerDisplayName, requested, matches, matcher));
    }

    private static String format(String producerDisplayName, AttributeContainerInternal consumer, List<? extends ResolvedVariant> variants, AttributeMatcher matcher) {
        TreeFormatter formatter = new TreeFormatter();
        formatter.node("More than one variant of " + producerDisplayName + " matches the consumer attributes");
        formatter.startChildren();
        for (ResolvedVariant resolvedVariant : variants) {
            formatter.node(resolvedVariant.asDescribable().getCapitalizedDisplayName());
            AmbiguousConfigurationSelectionException.formatAttributeMatches(formatter, consumer, matcher, resolvedVariant.getAttributes());
        }
        formatter.endChildren();
        return formatter.toString();
    }

    public static void formatAttributes(TreeFormatter formatter, AttributeContainer attributes) {
        formatter.startChildren();
        for (Attribute attribute : Ordering.usingToString().sortedCopy((Iterable)attributes.keySet())) {
            formatter.node(attribute.getName() + " '" + attributes.getAttribute(attribute) + "'");
        }
        formatter.endChildren();
    }
}

