/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.lang.constant.Constable;
import java.util.Iterator;
import java.util.List;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.codegen.And;
import org.jetbrains.kotlin.codegen.ArgumentGenerator;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.BranchedValue;
import org.jetbrains.kotlin.codegen.CallBasedArgumentGenerator;
import org.jetbrains.kotlin.codegen.CallGenerator;
import org.jetbrains.kotlin.codegen.Callable;
import org.jetbrains.kotlin.codegen.CallableMethod;
import org.jetbrains.kotlin.codegen.CodegenUtilKt;
import org.jetbrains.kotlin.codegen.CoercionValue;
import org.jetbrains.kotlin.codegen.DefaultCallArgs;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.FieldInfo;
import org.jetbrains.kotlin.codegen.FrameMap;
import org.jetbrains.kotlin.codegen.FunctionCallStackValue;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.OperationStackValue;
import org.jetbrains.kotlin.codegen.Or;
import org.jetbrains.kotlin.codegen.intrinsics.JavaClassProperty;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.descriptors.impl.SyntheticFieldDescriptor;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ImportedFromObjectCallableDescriptor;
import org.jetbrains.kotlin.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterKind;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterSignature;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

public abstract class StackValue {
    public static final Local LOCAL_0 = StackValue.local(0, AsmTypes.OBJECT_TYPE);
    private static final StackValue UNIT = StackValue.operation(AsmTypes.UNIT_TYPE, v -> {
        v.visitFieldInsn(178, AsmTypes.UNIT_TYPE.getInternalName(), "INSTANCE", AsmTypes.UNIT_TYPE.getDescriptor());
        return null;
    });
    @NotNull
    public final Type type;
    private final boolean canHaveSideEffects;

    protected StackValue(@NotNull Type type2) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(0);
        }
        this(type2, true);
    }

    protected StackValue(@NotNull Type type2, boolean canHaveSideEffects) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(1);
        }
        this.type = type2;
        this.canHaveSideEffects = canHaveSideEffects;
    }

    public void moveToTopOfStack(@NotNull Type type2, @NotNull InstructionAdapter v, int depth) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(2);
        }
        if (v == null) {
            StackValue.$$$reportNull$$$0(3);
        }
        this.put(type2, v);
    }

    public void put(@NotNull Type type2, @NotNull InstructionAdapter v) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(4);
        }
        if (v == null) {
            StackValue.$$$reportNull$$$0(5);
        }
        this.put(type2, v, false);
    }

    public void put(@NotNull Type type2, @NotNull InstructionAdapter v, boolean skipReceiver) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(6);
        }
        if (v == null) {
            StackValue.$$$reportNull$$$0(7);
        }
        if (!skipReceiver) {
            this.putReceiver(v, true);
        }
        this.putSelector(type2, v);
    }

    public abstract void putSelector(@NotNull Type var1, @NotNull InstructionAdapter var2);

    public boolean isNonStaticAccess(boolean isRead) {
        return false;
    }

    public void putReceiver(@NotNull InstructionAdapter v, boolean isRead) {
        if (v == null) {
            StackValue.$$$reportNull$$$0(8);
        }
    }

    public void dup(@NotNull InstructionAdapter v, boolean withReceiver) {
        if (v == null) {
            StackValue.$$$reportNull$$$0(9);
        }
        if (!Type.VOID_TYPE.equals(this.type)) {
            AsmUtil.dup(v, this.type);
        }
    }

    public void store(@NotNull StackValue value, @NotNull InstructionAdapter v) {
        if (value == null) {
            StackValue.$$$reportNull$$$0(10);
        }
        if (v == null) {
            StackValue.$$$reportNull$$$0(11);
        }
        this.store(value, v, false);
    }

    public boolean canHaveSideEffects() {
        return this.canHaveSideEffects;
    }

    public void store(@NotNull StackValue value, @NotNull InstructionAdapter v, boolean skipReceiver) {
        if (value == null) {
            StackValue.$$$reportNull$$$0(12);
        }
        if (v == null) {
            StackValue.$$$reportNull$$$0(13);
        }
        if (!skipReceiver) {
            this.putReceiver(v, false);
        }
        value.put(value.type, v);
        this.storeSelector(value.type, v);
    }

    protected void storeSelector(@NotNull Type topOfStackType, @NotNull InstructionAdapter v) {
        if (topOfStackType == null) {
            StackValue.$$$reportNull$$$0(14);
        }
        if (v == null) {
            StackValue.$$$reportNull$$$0(15);
        }
        throw new UnsupportedOperationException("Cannot store to value " + this);
    }

    @NotNull
    public static Local local(int index2, @NotNull Type type2) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(16);
        }
        Local local = new Local(index2, type2);
        if (local == null) {
            StackValue.$$$reportNull$$$0(17);
        }
        return local;
    }

    @NotNull
    public static Delegate delegate(@NotNull Type type2, @NotNull StackValue delegateValue, @NotNull StackValue metadataValue, @NotNull VariableDescriptorWithAccessors variableDescriptor, @NotNull ExpressionCodegen codegen) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(18);
        }
        if (delegateValue == null) {
            StackValue.$$$reportNull$$$0(19);
        }
        if (metadataValue == null) {
            StackValue.$$$reportNull$$$0(20);
        }
        if (variableDescriptor == null) {
            StackValue.$$$reportNull$$$0(21);
        }
        if (codegen == null) {
            StackValue.$$$reportNull$$$0(22);
        }
        Delegate delegate2 = new Delegate(type2, delegateValue, metadataValue, variableDescriptor, codegen);
        if (delegate2 == null) {
            StackValue.$$$reportNull$$$0(23);
        }
        return delegate2;
    }

    @NotNull
    public static StackValue shared(int index2, @NotNull Type type2) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(24);
        }
        Shared shared = new Shared(index2, type2);
        if (shared == null) {
            StackValue.$$$reportNull$$$0(25);
        }
        return shared;
    }

    @NotNull
    public static StackValue onStack(@NotNull Type type2) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(26);
        }
        StackValue stackValue = type2 == Type.VOID_TYPE ? StackValue.none() : new OnStack(type2);
        if (stackValue == null) {
            StackValue.$$$reportNull$$$0(27);
        }
        return stackValue;
    }

    @NotNull
    public static StackValue constant(@Nullable Object value, @NotNull Type type2) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(28);
        }
        if (type2 == Type.BOOLEAN_TYPE) {
            assert (value instanceof Boolean) : "Value for boolean constant should have boolean type: " + value;
            BranchedValue branchedValue = BranchedValue.Companion.booleanConstant((Boolean)value);
            if (branchedValue == null) {
                StackValue.$$$reportNull$$$0(29);
            }
            return branchedValue;
        }
        Constant constant = new Constant(value, type2);
        if (constant == null) {
            StackValue.$$$reportNull$$$0(30);
        }
        return constant;
    }

    public static StackValue createDefaulValue(@NotNull Type type2) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(31);
        }
        if (type2.getSort() == 10 || type2.getSort() == 9) {
            return StackValue.constant(null, type2);
        }
        return StackValue.createDefaultPrimitiveValue(type2);
    }

    private static StackValue createDefaultPrimitiveValue(@NotNull Type type2) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(32);
        }
        assert (1 <= type2.getSort() && type2.getSort() <= 8) : "'createDefaultPrimitiveValue' method should be called only for primitive types, but " + type2;
        Constable value = 0;
        if (type2.getSort() == 1) {
            value = Boolean.FALSE;
        } else if (type2.getSort() == 6) {
            value = new Float(0.0);
        } else if (type2.getSort() == 8) {
            value = new Double(0.0);
        } else if (type2.getSort() == 7) {
            value = new Long(0L);
        }
        return StackValue.constant(value, type2);
    }

    @NotNull
    public static StackValue cmp(@NotNull IElementType opToken, @NotNull Type type2, StackValue left, StackValue right) {
        if (opToken == null) {
            StackValue.$$$reportNull$$$0(33);
        }
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(34);
        }
        StackValue stackValue = BranchedValue.Companion.cmp(opToken, type2, left, right);
        if (stackValue == null) {
            StackValue.$$$reportNull$$$0(35);
        }
        return stackValue;
    }

    @NotNull
    public static StackValue not(@NotNull StackValue stackValue) {
        if (stackValue == null) {
            StackValue.$$$reportNull$$$0(36);
        }
        StackValue stackValue2 = BranchedValue.Companion.createInvertValue(stackValue);
        if (stackValue2 == null) {
            StackValue.$$$reportNull$$$0(37);
        }
        return stackValue2;
    }

    public static StackValue or(@NotNull StackValue left, @NotNull StackValue right) {
        if (left == null) {
            StackValue.$$$reportNull$$$0(38);
        }
        if (right == null) {
            StackValue.$$$reportNull$$$0(39);
        }
        return new Or(left, right);
    }

    public static StackValue and(@NotNull StackValue left, @NotNull StackValue right) {
        if (left == null) {
            StackValue.$$$reportNull$$$0(40);
        }
        if (right == null) {
            StackValue.$$$reportNull$$$0(41);
        }
        return new And(left, right);
    }

    public static StackValue compareIntWithZero(@NotNull StackValue argument, int operation) {
        if (argument == null) {
            StackValue.$$$reportNull$$$0(42);
        }
        return new BranchedValue(argument, null, Type.INT_TYPE, operation);
    }

    public static StackValue compareWithNull(@NotNull StackValue argument, int operation) {
        if (argument == null) {
            StackValue.$$$reportNull$$$0(43);
        }
        return new BranchedValue(argument, null, AsmTypes.OBJECT_TYPE, operation);
    }

    @NotNull
    public static StackValue arrayElement(@NotNull Type type2, StackValue array, StackValue index2) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(44);
        }
        ArrayElement arrayElement = new ArrayElement(type2, array, index2);
        if (arrayElement == null) {
            StackValue.$$$reportNull$$$0(45);
        }
        return arrayElement;
    }

    @NotNull
    public static StackValue collectionElement(CollectionElementReceiver collectionElementReceiver, Type type2, ResolvedCall<FunctionDescriptor> getter2, ResolvedCall<FunctionDescriptor> setter2, ExpressionCodegen codegen) {
        CollectionElement collectionElement = new CollectionElement(collectionElementReceiver, type2, getter2, setter2, codegen);
        if (collectionElement == null) {
            StackValue.$$$reportNull$$$0(46);
        }
        return collectionElement;
    }

    @NotNull
    public static Field field(@NotNull Type type2, @NotNull Type owner, @NotNull String name, boolean isStatic, @NotNull StackValue receiver) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(47);
        }
        if (owner == null) {
            StackValue.$$$reportNull$$$0(48);
        }
        if (name == null) {
            StackValue.$$$reportNull$$$0(49);
        }
        if (receiver == null) {
            StackValue.$$$reportNull$$$0(50);
        }
        Field field = StackValue.field(type2, owner, name, isStatic, receiver, null);
        if (field == null) {
            StackValue.$$$reportNull$$$0(51);
        }
        return field;
    }

    @NotNull
    public static Field field(@NotNull Type type2, @NotNull Type owner, @NotNull String name, boolean isStatic, @NotNull StackValue receiver, @Nullable DeclarationDescriptor descriptor2) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(52);
        }
        if (owner == null) {
            StackValue.$$$reportNull$$$0(53);
        }
        if (name == null) {
            StackValue.$$$reportNull$$$0(54);
        }
        if (receiver == null) {
            StackValue.$$$reportNull$$$0(55);
        }
        Field field = new Field(type2, owner, name, isStatic, receiver, descriptor2);
        if (field == null) {
            StackValue.$$$reportNull$$$0(56);
        }
        return field;
    }

    @NotNull
    public static Field field(@NotNull Field field, @NotNull StackValue newReceiver) {
        if (field == null) {
            StackValue.$$$reportNull$$$0(57);
        }
        if (newReceiver == null) {
            StackValue.$$$reportNull$$$0(58);
        }
        Field field2 = StackValue.field(field.type, field.owner, field.name, field.isStaticPut, newReceiver, field.descriptor);
        if (field2 == null) {
            StackValue.$$$reportNull$$$0(59);
        }
        return field2;
    }

    @NotNull
    public static Field field(@NotNull FieldInfo info, @NotNull StackValue receiver) {
        if (info == null) {
            StackValue.$$$reportNull$$$0(60);
        }
        if (receiver == null) {
            StackValue.$$$reportNull$$$0(61);
        }
        Field field = StackValue.field(info.getFieldType(), Type.getObjectType(info.getOwnerInternalName()), info.getFieldName(), info.isStatic(), receiver);
        if (field == null) {
            StackValue.$$$reportNull$$$0(62);
        }
        return field;
    }

    @NotNull
    public static StackValue changeReceiverForFieldAndSharedVar(@NotNull StackValueWithSimpleReceiver stackValue, @Nullable StackValue newReceiver) {
        if (stackValue == null) {
            StackValue.$$$reportNull$$$0(63);
        }
        if (newReceiver == null || stackValue.isStaticPut) {
            StackValueWithSimpleReceiver stackValueWithSimpleReceiver = stackValue;
            if (stackValueWithSimpleReceiver == null) {
                StackValue.$$$reportNull$$$0(64);
            }
            return stackValueWithSimpleReceiver;
        }
        StackValueWithSimpleReceiver stackValueWithSimpleReceiver = stackValue.changeReceiver(newReceiver);
        if (stackValueWithSimpleReceiver == null) {
            StackValue.$$$reportNull$$$0(65);
        }
        return stackValueWithSimpleReceiver;
    }

    @NotNull
    public static Property property(@NotNull PropertyDescriptor descriptor2, @Nullable Type backingFieldOwner, @NotNull Type type2, boolean isStaticBackingField, @Nullable String fieldName, @Nullable CallableMethod getter2, @Nullable CallableMethod setter2, @NotNull StackValue receiver, @NotNull ExpressionCodegen codegen, @Nullable ResolvedCall resolvedCall2) {
        if (descriptor2 == null) {
            StackValue.$$$reportNull$$$0(66);
        }
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(67);
        }
        if (receiver == null) {
            StackValue.$$$reportNull$$$0(68);
        }
        if (codegen == null) {
            StackValue.$$$reportNull$$$0(69);
        }
        Property property = new Property(descriptor2, backingFieldOwner, getter2, setter2, isStaticBackingField, fieldName, type2, receiver, codegen, resolvedCall2);
        if (property == null) {
            StackValue.$$$reportNull$$$0(70);
        }
        return property;
    }

    @NotNull
    public static StackValue expression(Type type2, KtExpression expression2, ExpressionCodegen generator) {
        Expression expression3 = new Expression(type2, expression2, generator);
        if (expression3 == null) {
            StackValue.$$$reportNull$$$0(71);
        }
        return expression3;
    }

    private static void box(Type type2, Type toType, InstructionAdapter v) {
        Type boxedType;
        if (type2 == Type.INT_TYPE) {
            if (toType.getInternalName().equals("java/lang/Byte")) {
                type2 = Type.BYTE_TYPE;
            } else if (toType.getInternalName().equals("java/lang/Short")) {
                type2 = Type.SHORT_TYPE;
            } else if (toType.getInternalName().equals("java/lang/Long")) {
                type2 = Type.LONG_TYPE;
            }
            v.cast(Type.INT_TYPE, type2);
        }
        if ((boxedType = AsmUtil.boxType(type2)) == type2) {
            return;
        }
        v.invokestatic(boxedType.getInternalName(), "valueOf", Type.getMethodDescriptor(boxedType, type2), false);
        StackValue.coerce(boxedType, toType, v);
    }

    private static void unbox(Type methodOwner2, Type type2, InstructionAdapter v) {
        assert (AsmUtil.isPrimitive(type2)) : "Unboxing should be performed to primitive type, but " + type2.getClassName();
        v.invokevirtual(methodOwner2.getInternalName(), type2.getClassName() + "Value", "()" + type2.getDescriptor(), false);
    }

    protected void coerceTo(@NotNull Type toType, @NotNull InstructionAdapter v) {
        if (toType == null) {
            StackValue.$$$reportNull$$$0(72);
        }
        if (v == null) {
            StackValue.$$$reportNull$$$0(73);
        }
        StackValue.coerce(this.type, toType, v);
    }

    protected void coerceFrom(@NotNull Type topOfStackType, @NotNull InstructionAdapter v) {
        if (topOfStackType == null) {
            StackValue.$$$reportNull$$$0(74);
        }
        if (v == null) {
            StackValue.$$$reportNull$$$0(75);
        }
        StackValue.coerce(topOfStackType, this.type, v);
    }

    public static void coerce(@NotNull Type fromType, @NotNull Type toType, @NotNull InstructionAdapter v) {
        if (fromType == null) {
            StackValue.$$$reportNull$$$0(76);
        }
        if (toType == null) {
            StackValue.$$$reportNull$$$0(77);
        }
        if (v == null) {
            StackValue.$$$reportNull$$$0(78);
        }
        if (toType.equals(fromType)) {
            return;
        }
        if (toType.getSort() == 0) {
            AsmUtil.pop(v, fromType);
        } else if (fromType.getSort() == 0) {
            if (toType.equals(AsmTypes.UNIT_TYPE) || toType.equals(AsmTypes.OBJECT_TYPE)) {
                StackValue.putUnitInstance(v);
            } else if (toType.getSort() == 10 || toType.getSort() == 9) {
                v.aconst(null);
            } else {
                AsmUtil.pushDefaultPrimitiveValueOnStack(toType, v);
            }
        } else if (toType.equals(AsmTypes.UNIT_TYPE)) {
            if (fromType.equals(AsmTypes.getType(Object.class))) {
                v.checkcast(AsmTypes.UNIT_TYPE);
            } else if (!fromType.equals(AsmTypes.getType(Void.class))) {
                AsmUtil.pop(v, fromType);
                StackValue.putUnitInstance(v);
            }
        } else if (toType.getSort() == 9) {
            v.checkcast(toType);
        } else if (toType.getSort() == 10) {
            if (fromType.getSort() == 10 || fromType.getSort() == 9) {
                if (!toType.equals(AsmTypes.OBJECT_TYPE)) {
                    v.checkcast(toType);
                }
            } else {
                StackValue.box(fromType, toType, v);
            }
        } else if (fromType.getSort() == 10) {
            Type unboxedType = AsmUtil.unboxPrimitiveTypeOrNull(fromType);
            if (unboxedType != null) {
                StackValue.unbox(fromType, unboxedType, v);
                StackValue.coerce(unboxedType, toType, v);
            } else if (toType.getSort() == 1) {
                StackValue.coerce(fromType, AsmTypes.BOOLEAN_WRAPPER_TYPE, v);
                StackValue.unbox(AsmTypes.BOOLEAN_WRAPPER_TYPE, Type.BOOLEAN_TYPE, v);
            } else if (toType.getSort() == 2) {
                if (fromType.equals(AsmTypes.NUMBER_TYPE)) {
                    StackValue.unbox(AsmTypes.NUMBER_TYPE, Type.INT_TYPE, v);
                    v.visitInsn(146);
                } else {
                    StackValue.coerce(fromType, AsmTypes.CHARACTER_WRAPPER_TYPE, v);
                    StackValue.unbox(AsmTypes.CHARACTER_WRAPPER_TYPE, Type.CHAR_TYPE, v);
                }
            } else {
                StackValue.coerce(fromType, AsmTypes.NUMBER_TYPE, v);
                StackValue.unbox(AsmTypes.NUMBER_TYPE, toType, v);
            }
        } else {
            v.cast(fromType, toType);
        }
    }

    public static void putUnitInstance(@NotNull InstructionAdapter v) {
        if (v == null) {
            StackValue.$$$reportNull$$$0(79);
        }
        StackValue.unit().put(AsmTypes.UNIT_TYPE, v);
    }

    public static StackValue unit() {
        return UNIT;
    }

    public static StackValue none() {
        return None.INSTANCE;
    }

    public static Field receiverWithRefWrapper(@NotNull Type localType, @NotNull Type classType, @NotNull String fieldName, @NotNull StackValue receiver, @Nullable DeclarationDescriptor descriptor2) {
        if (localType == null) {
            StackValue.$$$reportNull$$$0(80);
        }
        if (classType == null) {
            StackValue.$$$reportNull$$$0(81);
        }
        if (fieldName == null) {
            StackValue.$$$reportNull$$$0(82);
        }
        if (receiver == null) {
            StackValue.$$$reportNull$$$0(83);
        }
        return StackValue.field(StackValue.sharedTypeForType(localType), classType, fieldName, false, receiver, descriptor2);
    }

    public static FieldForSharedVar fieldForSharedVar(@NotNull Type localType, @NotNull Type classType, @NotNull String fieldName, @NotNull Field refWrapper) {
        if (localType == null) {
            StackValue.$$$reportNull$$$0(84);
        }
        if (classType == null) {
            StackValue.$$$reportNull$$$0(85);
        }
        if (fieldName == null) {
            StackValue.$$$reportNull$$$0(86);
        }
        if (refWrapper == null) {
            StackValue.$$$reportNull$$$0(87);
        }
        return new FieldForSharedVar(localType, classType, fieldName, refWrapper);
    }

    @NotNull
    public static FieldForSharedVar fieldForSharedVar(@NotNull FieldForSharedVar field, @NotNull StackValue newReceiver) {
        if (field == null) {
            StackValue.$$$reportNull$$$0(88);
        }
        if (newReceiver == null) {
            StackValue.$$$reportNull$$$0(89);
        }
        Field oldReceiver = (Field)field.receiver;
        Field newSharedVarReceiver = StackValue.field(oldReceiver, newReceiver);
        FieldForSharedVar fieldForSharedVar = new FieldForSharedVar(field.type, field.owner, field.name, newSharedVarReceiver);
        if (fieldForSharedVar == null) {
            StackValue.$$$reportNull$$$0(90);
        }
        return fieldForSharedVar;
    }

    public static StackValue coercion(@NotNull StackValue value, @NotNull Type castType) {
        if (value == null) {
            StackValue.$$$reportNull$$$0(91);
        }
        if (castType == null) {
            StackValue.$$$reportNull$$$0(92);
        }
        if (value.type.equals(castType)) {
            return value;
        }
        return new CoercionValue(value, castType);
    }

    @NotNull
    public static StackValue thisOrOuter(@NotNull ExpressionCodegen codegen, @NotNull ClassDescriptor descriptor2, boolean isSuper, boolean castReceiver) {
        if (codegen == null) {
            StackValue.$$$reportNull$$$0(93);
        }
        if (descriptor2 == null) {
            StackValue.$$$reportNull$$$0(94);
        }
        boolean coerceType = descriptor2.getKind() == ClassKind.INTERFACE || castReceiver && !isSuper;
        ThisOuter thisOuter = new ThisOuter(codegen, descriptor2, isSuper, coerceType);
        if (thisOuter == null) {
            StackValue.$$$reportNull$$$0(95);
        }
        return thisOuter;
    }

    public static StackValue postIncrement(int index2, int increment) {
        return new PostIncrement(index2, increment);
    }

    public static StackValue preIncrementForLocalVar(int index2, int increment) {
        return new PreIncrementForLocalVar(index2, increment);
    }

    public static StackValue preIncrement(@NotNull Type type2, @NotNull StackValue stackValue, int delta, ResolvedCall resolvedCall2, @NotNull ExpressionCodegen codegen) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(96);
        }
        if (stackValue == null) {
            StackValue.$$$reportNull$$$0(97);
        }
        if (codegen == null) {
            StackValue.$$$reportNull$$$0(98);
        }
        if (stackValue instanceof Local && Type.INT_TYPE == stackValue.type) {
            return StackValue.preIncrementForLocalVar(((Local)stackValue).index, delta);
        }
        return new PrefixIncrement(type2, stackValue, resolvedCall2, codegen);
    }

    public static StackValue receiver(ResolvedCall<?> resolvedCall2, StackValue receiver, ExpressionCodegen codegen, @Nullable Callable callableMethod) {
        ReceiverValue callDispatchReceiver = resolvedCall2.getDispatchReceiver();
        Object descriptor2 = resolvedCall2.getResultingDescriptor();
        if (descriptor2 instanceof SyntheticFieldDescriptor) {
            callDispatchReceiver = ((SyntheticFieldDescriptor)descriptor2).getDispatchReceiverForBackend();
        }
        ReceiverValue callExtensionReceiver = resolvedCall2.getExtensionReceiver();
        if (callDispatchReceiver != null || callExtensionReceiver != null || StackValue.isLocalFunCall(callableMethod) || StackValue.isCallToMemberObjectImportedByName(resolvedCall2)) {
            ReceiverParameterDescriptor dispatchReceiverParameter = descriptor2.getDispatchReceiverParameter();
            ReceiverParameterDescriptor extensionReceiverParameter = descriptor2.getExtensionReceiverParameter();
            if (descriptor2 instanceof SyntheticFieldDescriptor) {
                dispatchReceiverParameter = ((SyntheticFieldDescriptor)descriptor2).getDispatchReceiverParameterForBackend();
            }
            boolean hasExtensionReceiver = callExtensionReceiver != null;
            StackValue dispatchReceiver = StackValue.platformStaticCallIfPresent(StackValue.genReceiver(hasExtensionReceiver ? StackValue.none() : receiver, codegen, resolvedCall2, callableMethod, callDispatchReceiver, false), descriptor2);
            StackValue extensionReceiver = StackValue.genReceiver(receiver, codegen, resolvedCall2, callableMethod, callExtensionReceiver, true);
            Type type2 = CallReceiver.calcType(resolvedCall2, dispatchReceiverParameter, extensionReceiverParameter, codegen.typeMapper, callableMethod, codegen.getState());
            assert (type2 != null) : "Could not map receiver type for " + resolvedCall2;
            return new CallReceiver(dispatchReceiver, extensionReceiver, type2);
        }
        return receiver;
    }

    private static StackValue genReceiver(@NotNull StackValue receiver, @NotNull ExpressionCodegen codegen, @NotNull ResolvedCall resolvedCall2, @Nullable Callable callableMethod, @Nullable ReceiverValue receiverValue, boolean isExtension) {
        if (receiver == null) {
            StackValue.$$$reportNull$$$0(99);
        }
        if (codegen == null) {
            StackValue.$$$reportNull$$$0(100);
        }
        if (resolvedCall2 == null) {
            StackValue.$$$reportNull$$$0(101);
        }
        if (receiver == StackValue.none()) {
            if (receiverValue != null) {
                return codegen.generateReceiverValue(receiverValue, false);
            }
            if (StackValue.isLocalFunCall(callableMethod) && !isExtension) {
                StackValue value = codegen.findLocalOrCapturedValue(resolvedCall2.getResultingDescriptor().getOriginal());
                assert (value != null) : "Local fun should be found in locals or in captured params: " + resolvedCall2;
                return value;
            }
            if (StackValue.isCallToMemberObjectImportedByName(resolvedCall2)) {
                return StackValue.singleton(((ImportedFromObjectCallableDescriptor)resolvedCall2.getResultingDescriptor()).getContainingObject(), codegen.typeMapper);
            }
        } else if (receiverValue != null) {
            return receiver;
        }
        return StackValue.none();
    }

    private static boolean isCallToMemberObjectImportedByName(@NotNull ResolvedCall resolvedCall2) {
        if (resolvedCall2 == null) {
            StackValue.$$$reportNull$$$0(102);
        }
        return resolvedCall2.getResultingDescriptor() instanceof ImportedFromObjectCallableDescriptor;
    }

    private static StackValue platformStaticCallIfPresent(@NotNull StackValue resultReceiver, @NotNull CallableDescriptor descriptor2) {
        if (resultReceiver == null) {
            StackValue.$$$reportNull$$$0(103);
        }
        if (descriptor2 == null) {
            StackValue.$$$reportNull$$$0(104);
        }
        if (CodegenUtilKt.isJvmStaticInObjectOrClass(descriptor2)) {
            if (resultReceiver.canHaveSideEffects()) {
                return StackValue.coercion(resultReceiver, Type.VOID_TYPE);
            }
            return StackValue.none();
        }
        return resultReceiver;
    }

    @Contract(value="null -> false")
    private static boolean isLocalFunCall(@Nullable Callable callableMethod) {
        return callableMethod != null && callableMethod.getGenerateCalleeType() != null;
    }

    public static StackValue receiverWithoutReceiverArgument(StackValue receiverWithParameter) {
        if (receiverWithParameter instanceof CallReceiver) {
            CallReceiver callReceiver = (CallReceiver)receiverWithParameter;
            return new CallReceiver(callReceiver.dispatchReceiver, StackValue.none(), callReceiver.type);
        }
        return receiverWithParameter;
    }

    @NotNull
    public static Field enumEntry(@NotNull ClassDescriptor descriptor2, @NotNull KotlinTypeMapper typeMapper) {
        if (descriptor2 == null) {
            StackValue.$$$reportNull$$$0(105);
        }
        if (typeMapper == null) {
            StackValue.$$$reportNull$$$0(106);
        }
        DeclarationDescriptor enumClass = descriptor2.getContainingDeclaration();
        assert (DescriptorUtils.isEnumClass(enumClass)) : "Enum entry should be declared in enum class: " + descriptor2;
        Type type2 = typeMapper.mapType((ClassDescriptor)enumClass);
        Field field = StackValue.field(type2, type2, descriptor2.getName().asString(), true, StackValue.none(), descriptor2);
        if (field == null) {
            StackValue.$$$reportNull$$$0(107);
        }
        return field;
    }

    @NotNull
    public static Field singleton(@NotNull ClassDescriptor classDescriptor, @NotNull KotlinTypeMapper typeMapper) {
        if (classDescriptor == null) {
            StackValue.$$$reportNull$$$0(108);
        }
        if (typeMapper == null) {
            StackValue.$$$reportNull$$$0(109);
        }
        Field field = StackValue.field(FieldInfo.createForSingleton(classDescriptor, typeMapper), StackValue.none());
        if (field == null) {
            StackValue.$$$reportNull$$$0(110);
        }
        return field;
    }

    public static Field singletonViaInstance(ClassDescriptor classDescriptor, KotlinTypeMapper typeMapper) {
        return StackValue.field(FieldInfo.createSingletonViaInstance(classDescriptor, typeMapper), StackValue.none());
    }

    public static StackValue operation(Type type2, Function1<InstructionAdapter, Unit> lambda2) {
        return new OperationStackValue(type2, lambda2);
    }

    public static StackValue functionCall(Type type2, Function1<InstructionAdapter, Unit> lambda2) {
        return new FunctionCallStackValue(type2, lambda2);
    }

    public static boolean couldSkipReceiverOnStaticCall(StackValue value) {
        return value instanceof Local || value instanceof Constant;
    }

    @NotNull
    public static Type sharedTypeForType(@NotNull Type type2) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(111);
        }
        switch (type2.getSort()) {
            case 9: 
            case 10: {
                Type type3 = AsmTypes.OBJECT_REF_TYPE;
                if (type3 == null) {
                    StackValue.$$$reportNull$$$0(112);
                }
                return type3;
            }
        }
        PrimitiveType primitiveType = AsmUtil.asmPrimitiveTypeToLangPrimitiveType(type2);
        if (primitiveType == null) {
            throw new UnsupportedOperationException();
        }
        Type type4 = AsmTypes.sharedTypeForPrimitive(primitiveType);
        if (type4 == null) {
            StackValue.$$$reportNull$$$0(113);
        }
        return type4;
    }

    public static Type refType(Type type2) {
        if (type2.getSort() == 10 || type2.getSort() == 9) {
            return AsmTypes.OBJECT_TYPE;
        }
        return type2;
    }

    public static StackValue complexWriteReadReceiver(StackValue stackValue) {
        return StackValue.complexReceiver(stackValue, false, true);
    }

    private static StackValue complexReceiver(StackValue stackValue, boolean ... isReadOperations) {
        if (stackValue instanceof Delegate) {
            StackValue.throwUnsupportedComplexOperation(((Delegate)stackValue).variableDescriptor);
        }
        if (stackValue instanceof StackValueWithSimpleReceiver) {
            return new DelegatedForComplexReceiver(stackValue.type, (StackValueWithSimpleReceiver)stackValue, new ComplexReceiver((StackValueWithSimpleReceiver)stackValue, isReadOperations));
        }
        return stackValue;
    }

    private static void throwUnsupportedComplexOperation(@NotNull CallableDescriptor descriptor2) {
        if (descriptor2 == null) {
            StackValue.$$$reportNull$$$0(114);
        }
        throw new RuntimeException("Augment assignment and increment are not supported for local delegated properties ans inline properties: " + descriptor2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 17: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 30: 
            case 35: 
            case 37: 
            case 45: 
            case 46: 
            case 51: 
            case 56: 
            case 59: 
            case 62: 
            case 64: 
            case 65: 
            case 70: 
            case 71: 
            case 90: 
            case 95: 
            case 107: 
            case 110: 
            case 112: 
            case 113: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 17: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 30: 
            case 35: 
            case 37: 
            case 45: 
            case 46: 
            case 51: 
            case 56: 
            case 59: 
            case 62: 
            case 64: 
            case 65: 
            case 70: 
            case 71: 
            case 90: 
            case 95: 
            case 107: 
            case 110: 
            case 112: 
            case 113: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 73: 
            case 75: 
            case 78: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "v";
                break;
            }
            case 10: 
            case 12: 
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 14: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topOfStackType";
                break;
            }
            case 17: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 30: 
            case 35: 
            case 37: 
            case 45: 
            case 46: 
            case 51: 
            case 56: 
            case 59: 
            case 62: 
            case 64: 
            case 65: 
            case 70: 
            case 71: 
            case 90: 
            case 95: 
            case 107: 
            case 110: 
            case 112: 
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/codegen/StackValue";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegateValue";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metadataValue";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableDescriptor";
                break;
            }
            case 22: 
            case 69: 
            case 93: 
            case 98: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codegen";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "opToken";
                break;
            }
            case 36: 
            case 63: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stackValue";
                break;
            }
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 39: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 48: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 49: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 50: 
            case 55: 
            case 61: 
            case 68: 
            case 83: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiver";
                break;
            }
            case 57: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 58: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newReceiver";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 66: 
            case 94: 
            case 104: 
            case 105: 
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 72: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toType";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromType";
                break;
            }
            case 80: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localType";
                break;
            }
            case 81: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classType";
                break;
            }
            case 82: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refWrapper";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "castType";
                break;
            }
            case 101: 
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedCall";
                break;
            }
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultReceiver";
                break;
            }
            case 106: 
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeMapper";
                break;
            }
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/codegen/StackValue";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "local";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "delegate";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "shared";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "onStack";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "constant";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "cmp";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "not";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "arrayElement";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "collectionElement";
                break;
            }
            case 51: 
            case 56: 
            case 59: 
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "field";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "changeReceiverForFieldAndSharedVar";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "property";
                break;
            }
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "expression";
                break;
            }
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "fieldForSharedVar";
                break;
            }
            case 95: {
                objectArray = objectArray2;
                objectArray2[1] = "thisOrOuter";
                break;
            }
            case 107: {
                objectArray = objectArray2;
                objectArray2[1] = "enumEntry";
                break;
            }
            case 110: {
                objectArray = objectArray2;
                objectArray2[1] = "singleton";
                break;
            }
            case 112: 
            case 113: {
                objectArray = objectArray2;
                objectArray2[1] = "sharedTypeForType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "moveToTopOfStack";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "putReceiver";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "dup";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "store";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "storeSelector";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "local";
                break;
            }
            case 17: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 30: 
            case 35: 
            case 37: 
            case 45: 
            case 46: 
            case 51: 
            case 56: 
            case 59: 
            case 62: 
            case 64: 
            case 65: 
            case 70: 
            case 71: 
            case 90: 
            case 95: 
            case 107: 
            case 110: 
            case 112: 
            case 113: {
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "delegate";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "shared";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "onStack";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "constant";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createDefaulValue";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultPrimitiveValue";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "cmp";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "not";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "or";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "and";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "compareIntWithZero";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "compareWithNull";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "arrayElement";
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 57: 
            case 58: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "field";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "changeReceiverForFieldAndSharedVar";
                break;
            }
            case 66: 
            case 67: 
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "property";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "coerceTo";
                break;
            }
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "coerceFrom";
                break;
            }
            case 76: 
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "coerce";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "putUnitInstance";
                break;
            }
            case 80: 
            case 81: 
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "receiverWithRefWrapper";
                break;
            }
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "fieldForSharedVar";
                break;
            }
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "coercion";
                break;
            }
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "thisOrOuter";
                break;
            }
            case 96: 
            case 97: 
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "preIncrement";
                break;
            }
            case 99: 
            case 100: 
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "genReceiver";
                break;
            }
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "isCallToMemberObjectImportedByName";
                break;
            }
            case 103: 
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "platformStaticCallIfPresent";
                break;
            }
            case 105: 
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "enumEntry";
                break;
            }
            case 108: 
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "singleton";
                break;
            }
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "sharedTypeForType";
                break;
            }
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "throwUnsupportedComplexOperation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 17: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 30: 
            case 35: 
            case 37: 
            case 45: 
            case 46: 
            case 51: 
            case 56: 
            case 59: 
            case 62: 
            case 64: 
            case 65: 
            case 70: 
            case 71: 
            case 90: 
            case 95: 
            case 107: 
            case 110: 
            case 112: 
            case 113: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class SafeFallback
    extends StackValueWithSimpleReceiver {
        @Nullable
        private final Label ifNull;

        public SafeFallback(@NotNull Type type2, @Nullable Label ifNull, StackValue receiver) {
            if (type2 == null) {
                SafeFallback.$$$reportNull$$$0(0);
            }
            super(type2, false, false, receiver, true);
            this.ifNull = ifNull;
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                SafeFallback.$$$reportNull$$$0(1);
            }
            if (v == null) {
                SafeFallback.$$$reportNull$$$0(2);
            }
            Label end = new Label();
            v.goTo(end);
            v.mark(this.ifNull);
            v.pop();
            if (!this.type.equals(Type.VOID_TYPE)) {
                v.aconst(null);
            }
            v.mark(end);
            this.coerceTo(type2, v);
        }

        @Override
        public void store(@NotNull StackValue rightSide, @NotNull InstructionAdapter v, boolean skipReceiver) {
            if (rightSide == null) {
                SafeFallback.$$$reportNull$$$0(3);
            }
            if (v == null) {
                SafeFallback.$$$reportNull$$$0(4);
            }
            this.receiver.store(rightSide, v, skipReceiver);
            Label end = new Label();
            v.goTo(end);
            v.mark(this.ifNull);
            v.pop();
            v.mark(end);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "v";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rightSide";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/codegen/StackValue$SafeFallback";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "putSelector";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "store";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class SafeCall
    extends StackValue {
        @NotNull
        private final Type type;
        private final StackValue receiver;
        @Nullable
        private final Label ifNull;

        public SafeCall(@NotNull Type type2, @NotNull StackValue value, @Nullable Label ifNull) {
            if (type2 == null) {
                SafeCall.$$$reportNull$$$0(0);
            }
            if (value == null) {
                SafeCall.$$$reportNull$$$0(1);
            }
            super(type2);
            this.type = type2;
            this.receiver = value;
            this.ifNull = ifNull;
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                SafeCall.$$$reportNull$$$0(2);
            }
            if (v == null) {
                SafeCall.$$$reportNull$$$0(3);
            }
            this.receiver.put(this.type, v);
            if (this.ifNull != null) {
                v.dup();
                v.ifnull(this.ifNull);
            }
            this.coerceTo(type2, v);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "v";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/codegen/StackValue$SafeCall";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "putSelector";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class DelegatedForComplexReceiver
    extends StackValueWithSimpleReceiver {
        public final StackValueWithSimpleReceiver originalValue;

        public DelegatedForComplexReceiver(@NotNull Type type2, @NotNull StackValueWithSimpleReceiver originalValue, @NotNull ComplexReceiver receiver) {
            if (type2 == null) {
                DelegatedForComplexReceiver.$$$reportNull$$$0(0);
            }
            if (originalValue == null) {
                DelegatedForComplexReceiver.$$$reportNull$$$0(1);
            }
            if (receiver == null) {
                DelegatedForComplexReceiver.$$$reportNull$$$0(2);
            }
            super(type2, DelegatedForComplexReceiver.bothReceiverStatic(originalValue), DelegatedForComplexReceiver.bothReceiverStatic(originalValue), receiver, originalValue.canHaveSideEffects());
            this.originalValue = originalValue;
        }

        private static boolean bothReceiverStatic(StackValueWithSimpleReceiver originalValue) {
            return !originalValue.isNonStaticAccess(true) && !originalValue.isNonStaticAccess(false);
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                DelegatedForComplexReceiver.$$$reportNull$$$0(3);
            }
            if (v == null) {
                DelegatedForComplexReceiver.$$$reportNull$$$0(4);
            }
            this.originalValue.putSelector(type2, v);
        }

        @Override
        public void store(@NotNull StackValue rightSide, @NotNull InstructionAdapter v, boolean skipReceiver) {
            if (rightSide == null) {
                DelegatedForComplexReceiver.$$$reportNull$$$0(5);
            }
            if (v == null) {
                DelegatedForComplexReceiver.$$$reportNull$$$0(6);
            }
            if (!skipReceiver) {
                this.putReceiver(v, false);
            }
            this.originalValue.store(rightSide, v, true);
        }

        @Override
        public void storeSelector(@NotNull Type topOfStackType, @NotNull InstructionAdapter v) {
            if (topOfStackType == null) {
                DelegatedForComplexReceiver.$$$reportNull$$$0(7);
            }
            if (v == null) {
                DelegatedForComplexReceiver.$$$reportNull$$$0(8);
            }
            this.originalValue.storeSelector(topOfStackType, v);
        }

        @Override
        public void dup(@NotNull InstructionAdapter v, boolean withWriteReceiver) {
            if (v == null) {
                DelegatedForComplexReceiver.$$$reportNull$$$0(9);
            }
            this.originalValue.dup(v, withWriteReceiver);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "originalValue";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "receiver";
                    break;
                }
                case 4: 
                case 6: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "v";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rightSide";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "topOfStackType";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/codegen/StackValue$DelegatedForComplexReceiver";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "putSelector";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "store";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "storeSelector";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "dup";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Receiver
    extends StackValue {
        private final StackValue[] instructions;

        protected Receiver(@NotNull Type type2, StackValue ... receiverInstructions) {
            if (type2 == null) {
                Receiver.$$$reportNull$$$0(0);
            }
            super(type2);
            this.instructions = receiverInstructions;
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                Receiver.$$$reportNull$$$0(1);
            }
            if (v == null) {
                Receiver.$$$reportNull$$$0(2);
            }
            for (StackValue instruction : this.instructions) {
                instruction.put(instruction.type, v);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "v";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/codegen/StackValue$Receiver";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "putSelector";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ComplexReceiver
    extends StackValue {
        private final StackValueWithSimpleReceiver originalValueWithReceiver;
        private final boolean[] isReadOperations;

        public ComplexReceiver(StackValueWithSimpleReceiver value, boolean[] isReadOperations) {
            super(value.type, value.receiver.canHaveSideEffects());
            this.originalValueWithReceiver = value;
            this.isReadOperations = isReadOperations;
            if (value instanceof CollectionElement && value.receiver instanceof CollectionElementReceiver) {
                ((CollectionElementReceiver)value.receiver).isComplexOperationWithDup = true;
            }
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                ComplexReceiver.$$$reportNull$$$0(0);
            }
            if (v == null) {
                ComplexReceiver.$$$reportNull$$$0(1);
            }
            boolean wasPut = false;
            StackValue receiver = this.originalValueWithReceiver.receiver;
            for (boolean operation : this.isReadOperations) {
                if (!this.originalValueWithReceiver.isNonStaticAccess(operation)) continue;
                if (!wasPut) {
                    receiver.put(receiver.type, v);
                    wasPut = true;
                    continue;
                }
                receiver.dup(v, false);
            }
            if (!wasPut && receiver.canHaveSideEffects()) {
                receiver.put(Type.VOID_TYPE, v);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "v";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/kotlin/codegen/StackValue$ComplexReceiver";
            objectArray[2] = "putSelector";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class StackValueWithSimpleReceiver
    extends StackValue {
        public final boolean isStaticPut;
        public final boolean isStaticStore;
        @NotNull
        public final StackValue receiver;

        public StackValueWithSimpleReceiver(@NotNull Type type2, boolean isStaticPut, boolean isStaticStore, @NotNull StackValue receiver, boolean canHaveSideEffects) {
            if (type2 == null) {
                StackValueWithSimpleReceiver.$$$reportNull$$$0(0);
            }
            if (receiver == null) {
                StackValueWithSimpleReceiver.$$$reportNull$$$0(1);
            }
            super(type2, canHaveSideEffects);
            this.receiver = receiver;
            this.isStaticPut = isStaticPut;
            this.isStaticStore = isStaticStore;
        }

        @Override
        public void putReceiver(@NotNull InstructionAdapter v, boolean isRead) {
            boolean hasReceiver;
            if (v == null) {
                StackValueWithSimpleReceiver.$$$reportNull$$$0(2);
            }
            if ((hasReceiver = this.isNonStaticAccess(isRead)) || this.receiver.canHaveSideEffects()) {
                this.receiver.put(hasReceiver ? this.receiver.type : Type.VOID_TYPE, v);
            }
        }

        @Override
        public boolean isNonStaticAccess(boolean isRead) {
            return isRead ? !this.isStaticPut : !this.isStaticStore;
        }

        public int receiverSize() {
            return this.receiver.type.getSize();
        }

        @Override
        public void dup(@NotNull InstructionAdapter v, boolean withWriteReceiver) {
            if (v == null) {
                StackValueWithSimpleReceiver.$$$reportNull$$$0(3);
            }
            if (!withWriteReceiver) {
                super.dup(v, false);
            } else {
                int receiverSize = this.isNonStaticAccess(false) ? this.receiverSize() : 0;
                switch (receiverSize) {
                    case 0: {
                        AsmUtil.dup(v, this.type);
                        break;
                    }
                    case 1: {
                        if (this.type.getSize() == 2) {
                            v.dup2X1();
                            break;
                        }
                        v.dupX1();
                        break;
                    }
                    case 2: {
                        if (this.type.getSize() == 2) {
                            v.dup2X2();
                            break;
                        }
                        v.dupX2();
                        break;
                    }
                    case -1: {
                        throw new UnsupportedOperationException();
                    }
                }
            }
        }

        @Override
        public void store(@NotNull StackValue rightSide, @NotNull InstructionAdapter v, boolean skipReceiver) {
            if (rightSide == null) {
                StackValueWithSimpleReceiver.$$$reportNull$$$0(4);
            }
            if (v == null) {
                StackValueWithSimpleReceiver.$$$reportNull$$$0(5);
            }
            if (!skipReceiver) {
                this.putReceiver(v, false);
            }
            rightSide.put(rightSide.type, v);
            this.storeSelector(rightSide.type, v);
        }

        protected StackValueWithSimpleReceiver changeReceiver(@NotNull StackValue newReceiver) {
            if (newReceiver == null) {
                StackValueWithSimpleReceiver.$$$reportNull$$$0(6);
            }
            return this;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "receiver";
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "v";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rightSide";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newReceiver";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/codegen/StackValue$StackValueWithSimpleReceiver";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "putReceiver";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "dup";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "store";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "changeReceiver";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class CallReceiver
    extends StackValue {
        private final StackValue dispatchReceiver;
        private final StackValue extensionReceiver;

        public CallReceiver(@NotNull StackValue dispatchReceiver, @NotNull StackValue extensionReceiver, @NotNull Type type2) {
            if (dispatchReceiver == null) {
                CallReceiver.$$$reportNull$$$0(0);
            }
            if (extensionReceiver == null) {
                CallReceiver.$$$reportNull$$$0(1);
            }
            if (type2 == null) {
                CallReceiver.$$$reportNull$$$0(2);
            }
            super(type2, dispatchReceiver.canHaveSideEffects() || extensionReceiver.canHaveSideEffects());
            this.dispatchReceiver = dispatchReceiver;
            this.extensionReceiver = extensionReceiver;
        }

        @Nullable
        public static Type calcType(@NotNull ResolvedCall<?> resolvedCall2, @Nullable ReceiverParameterDescriptor dispatchReceiver, @Nullable ReceiverParameterDescriptor extensionReceiver, @NotNull KotlinTypeMapper typeMapper, @Nullable Callable callableMethod, @NotNull GenerationState state2) {
            if (resolvedCall2 == null) {
                CallReceiver.$$$reportNull$$$0(3);
            }
            if (typeMapper == null) {
                CallReceiver.$$$reportNull$$$0(4);
            }
            if (state2 == null) {
                CallReceiver.$$$reportNull$$$0(5);
            }
            if (extensionReceiver != null) {
                Object descriptor2 = resolvedCall2.getCandidateDescriptor();
                if (descriptor2 instanceof PropertyDescriptor && state2.getIntrinsics().getIntrinsic((PropertyDescriptor)descriptor2) != JavaClassProperty.INSTANCE) {
                    ReceiverParameterDescriptor receiverCandidate = descriptor2.getExtensionReceiverParameter();
                    assert (receiverCandidate != null);
                    return typeMapper.mapType(receiverCandidate.getType());
                }
                return callableMethod != null ? callableMethod.getExtensionReceiverType() : typeMapper.mapType(extensionReceiver.getType());
            }
            if (dispatchReceiver != null) {
                Object descriptor3 = resolvedCall2.getResultingDescriptor();
                if (CodegenUtilKt.isJvmStaticInObjectOrClass(descriptor3)) {
                    return Type.VOID_TYPE;
                }
                if (callableMethod != null) {
                    return callableMethod.getDispatchReceiverType();
                }
                DeclarationDescriptor container2 = descriptor3.getContainingDeclaration();
                if (container2 instanceof ClassDescriptor) {
                    return typeMapper.mapClass((ClassDescriptor)container2);
                }
                return typeMapper.mapType(dispatchReceiver);
            }
            if (StackValue.isLocalFunCall(callableMethod)) {
                return callableMethod.getGenerateCalleeType();
            }
            return Type.VOID_TYPE;
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            boolean hasExtensionReceiver;
            if (type2 == null) {
                CallReceiver.$$$reportNull$$$0(6);
            }
            if (v == null) {
                CallReceiver.$$$reportNull$$$0(7);
            }
            StackValue currentExtensionReceiver = this.extensionReceiver;
            boolean bl = hasExtensionReceiver = this.extensionReceiver != CallReceiver.none();
            if (this.extensionReceiver instanceof SafeCall) {
                currentExtensionReceiver.put(currentExtensionReceiver.type, v);
                currentExtensionReceiver = StackValue.onStack(currentExtensionReceiver.type);
            }
            this.dispatchReceiver.put(hasExtensionReceiver ? this.dispatchReceiver.type : type2, v);
            currentExtensionReceiver.moveToTopOfStack(hasExtensionReceiver ? type2 : currentExtensionReceiver.type, v, this.dispatchReceiver.type.getSize());
        }

        @Override
        public void dup(@NotNull InstructionAdapter v, boolean withReceiver) {
            if (v == null) {
                CallReceiver.$$$reportNull$$$0(8);
            }
            AsmUtil.dup(v, this.extensionReceiver.type, this.dispatchReceiver.type);
        }

        @NotNull
        public StackValue getDispatchReceiver() {
            StackValue stackValue = this.dispatchReceiver;
            if (stackValue == null) {
                CallReceiver.$$$reportNull$$$0(9);
            }
            return stackValue;
        }

        @NotNull
        public StackValue getExtensionReceiver() {
            StackValue stackValue = this.extensionReceiver;
            if (stackValue == null) {
                CallReceiver.$$$reportNull$$$0(10);
            }
            return stackValue;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 9: 
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 9: 
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dispatchReceiver";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extensionReceiver";
                    break;
                }
                case 2: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resolvedCall";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeMapper";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "v";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/codegen/StackValue$CallReceiver";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/codegen/StackValue$CallReceiver";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDispatchReceiver";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExtensionReceiver";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "calcType";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "putSelector";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "dup";
                    break;
                }
                case 9: 
                case 10: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 9: 
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PrefixIncrement
    extends StackValue {
        private final ResolvedCall resolvedCall;
        private final ExpressionCodegen codegen;
        private StackValue value;

        public PrefixIncrement(@NotNull Type type2, @NotNull StackValue value, ResolvedCall resolvedCall2, @NotNull ExpressionCodegen codegen) {
            if (type2 == null) {
                PrefixIncrement.$$$reportNull$$$0(0);
            }
            if (value == null) {
                PrefixIncrement.$$$reportNull$$$0(1);
            }
            if (codegen == null) {
                PrefixIncrement.$$$reportNull$$$0(2);
            }
            super(type2);
            this.value = value;
            this.resolvedCall = resolvedCall2;
            this.codegen = codegen;
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                PrefixIncrement.$$$reportNull$$$0(3);
            }
            if (v == null) {
                PrefixIncrement.$$$reportNull$$$0(4);
            }
            this.value = StackValue.complexReceiver(this.value, new boolean[]{true, false, true});
            this.value.put(this.type, v);
            this.value.store(this.codegen.invokeFunction(this.resolvedCall, StackValue.onStack(this.type)), v, true);
            this.value.put(this.type, v, true);
            this.coerceTo(type2, v);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "codegen";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "v";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/codegen/StackValue$PrefixIncrement";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "putSelector";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PreIncrementForLocalVar
    extends StackValue {
        private final int index;
        private final int increment;

        public PreIncrementForLocalVar(int index2, int increment) {
            super(Type.INT_TYPE);
            this.index = index2;
            this.increment = increment;
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                PreIncrementForLocalVar.$$$reportNull$$$0(0);
            }
            if (v == null) {
                PreIncrementForLocalVar.$$$reportNull$$$0(1);
            }
            v.iinc(this.index, this.increment);
            if (!type2.equals(Type.VOID_TYPE)) {
                v.load(this.index, Type.INT_TYPE);
                this.coerceTo(type2, v);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "v";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/kotlin/codegen/StackValue$PreIncrementForLocalVar";
            objectArray[2] = "putSelector";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PostIncrement
    extends StackValue {
        private final int index;
        private final int increment;

        public PostIncrement(int index2, int increment) {
            super(Type.INT_TYPE);
            this.index = index2;
            this.increment = increment;
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                PostIncrement.$$$reportNull$$$0(0);
            }
            if (v == null) {
                PostIncrement.$$$reportNull$$$0(1);
            }
            if (!type2.equals(Type.VOID_TYPE)) {
                v.load(this.index, Type.INT_TYPE);
                this.coerceTo(type2, v);
            }
            v.iinc(this.index, this.increment);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "v";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/kotlin/codegen/StackValue$PostIncrement";
            objectArray[2] = "putSelector";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ThisOuter
    extends StackValue {
        private final ExpressionCodegen codegen;
        private final ClassDescriptor descriptor;
        private final boolean isSuper;
        private final boolean coerceType;

        public ThisOuter(ExpressionCodegen codegen, ClassDescriptor descriptor2, boolean isSuper, boolean coerceType) {
            super(AsmTypes.OBJECT_TYPE, false);
            this.codegen = codegen;
            this.descriptor = descriptor2;
            this.isSuper = isSuper;
            this.coerceType = coerceType;
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                ThisOuter.$$$reportNull$$$0(0);
            }
            if (v == null) {
                ThisOuter.$$$reportNull$$$0(1);
            }
            StackValue stackValue = this.codegen.generateThisOrOuter(this.descriptor, this.isSuper);
            stackValue.put(this.coerceType ? type2 : stackValue.type, v);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "v";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/kotlin/codegen/StackValue$ThisOuter";
            objectArray[2] = "putSelector";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class FieldForSharedVar
    extends StackValueWithSimpleReceiver {
        final Type owner;
        final String name;

        public FieldForSharedVar(Type type2, Type owner, String name, Field receiver) {
            super(type2, false, false, receiver, receiver.canHaveSideEffects());
            this.owner = owner;
            this.name = name;
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                FieldForSharedVar.$$$reportNull$$$0(0);
            }
            if (v == null) {
                FieldForSharedVar.$$$reportNull$$$0(1);
            }
            Type sharedType = FieldForSharedVar.sharedTypeForType(this.type);
            Type refType = FieldForSharedVar.refType(this.type);
            v.visitFieldInsn(180, sharedType.getInternalName(), "element", refType.getDescriptor());
            this.coerceFrom(refType, v);
            this.coerceTo(type2, v);
        }

        @Override
        public void storeSelector(@NotNull Type topOfStackType, @NotNull InstructionAdapter v) {
            if (topOfStackType == null) {
                FieldForSharedVar.$$$reportNull$$$0(2);
            }
            if (v == null) {
                FieldForSharedVar.$$$reportNull$$$0(3);
            }
            this.coerceFrom(topOfStackType, v);
            v.visitFieldInsn(181, FieldForSharedVar.sharedTypeForType(this.type).getInternalName(), "element", FieldForSharedVar.refType(this.type).getDescriptor());
        }

        @Override
        protected StackValueWithSimpleReceiver changeReceiver(@NotNull StackValue newReceiver) {
            if (newReceiver == null) {
                FieldForSharedVar.$$$reportNull$$$0(4);
            }
            return FieldForSharedVar.fieldForSharedVar(this, newReceiver);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "v";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "topOfStackType";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newReceiver";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/codegen/StackValue$FieldForSharedVar";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "putSelector";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "storeSelector";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "changeReceiver";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Shared
    extends StackValueWithSimpleReceiver {
        private final int index;

        public Shared(int index2, Type type2) {
            super(type2, false, false, Shared.local(index2, AsmTypes.OBJECT_TYPE), false);
            this.index = index2;
        }

        public int getIndex() {
            return this.index;
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                Shared.$$$reportNull$$$0(0);
            }
            if (v == null) {
                Shared.$$$reportNull$$$0(1);
            }
            Type refType = Shared.refType(this.type);
            Type sharedType = Shared.sharedTypeForType(this.type);
            v.visitFieldInsn(180, sharedType.getInternalName(), "element", refType.getDescriptor());
            this.coerceFrom(refType, v);
            this.coerceTo(type2, v);
        }

        @Override
        public void storeSelector(@NotNull Type topOfStackType, @NotNull InstructionAdapter v) {
            if (topOfStackType == null) {
                Shared.$$$reportNull$$$0(2);
            }
            if (v == null) {
                Shared.$$$reportNull$$$0(3);
            }
            this.coerceFrom(topOfStackType, v);
            Type refType = Shared.refType(this.type);
            Type sharedType = Shared.sharedTypeForType(this.type);
            v.visitFieldInsn(181, sharedType.getInternalName(), "element", refType.getDescriptor());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "v";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "topOfStackType";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/codegen/StackValue$Shared";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "putSelector";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "storeSelector";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class Expression
    extends StackValue {
        private final KtExpression expression;
        private final ExpressionCodegen generator;

        public Expression(Type type2, KtExpression expression2, ExpressionCodegen generator) {
            super(type2);
            this.expression = expression2;
            this.generator = generator;
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                Expression.$$$reportNull$$$0(0);
            }
            if (v == null) {
                Expression.$$$reportNull$$$0(1);
            }
            this.generator.gen(this.expression, type2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "v";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/kotlin/codegen/StackValue$Expression";
            objectArray[2] = "putSelector";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Property
    extends StackValueWithSimpleReceiver {
        private final CallableMethod getter;
        private final CallableMethod setter;
        private final Type backingFieldOwner;
        private final PropertyDescriptor descriptor;
        private final String fieldName;
        @NotNull
        private final ExpressionCodegen codegen;
        @Nullable
        private final ResolvedCall resolvedCall;

        public Property(@NotNull PropertyDescriptor descriptor2, @Nullable Type backingFieldOwner, @Nullable CallableMethod getter2, @Nullable CallableMethod setter2, boolean isStaticBackingField, @Nullable String fieldName, @NotNull Type type2, @NotNull StackValue receiver, @NotNull ExpressionCodegen codegen, @Nullable ResolvedCall resolvedCall2) {
            if (descriptor2 == null) {
                Property.$$$reportNull$$$0(0);
            }
            if (type2 == null) {
                Property.$$$reportNull$$$0(1);
            }
            if (receiver == null) {
                Property.$$$reportNull$$$0(2);
            }
            if (codegen == null) {
                Property.$$$reportNull$$$0(3);
            }
            super(type2, Property.isStatic(isStaticBackingField, getter2), Property.isStatic(isStaticBackingField, setter2), receiver, true);
            this.backingFieldOwner = backingFieldOwner;
            this.getter = getter2;
            this.setter = setter2;
            this.descriptor = descriptor2;
            this.fieldName = fieldName;
            this.codegen = codegen;
            this.resolvedCall = resolvedCall2;
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                Property.$$$reportNull$$$0(4);
            }
            if (v == null) {
                Property.$$$reportNull$$$0(5);
            }
            if (this.getter == null) {
                assert (this.fieldName != null) : "Property should have either a getter or a field name: " + this.descriptor;
                assert (this.backingFieldOwner != null) : "Property should have either a getter or a backingFieldOwner: " + this.descriptor;
                if (this.inlineConstantIfNeeded(type2, v)) {
                    return;
                }
                v.visitFieldInsn(this.isStaticPut ? 178 : 180, this.backingFieldOwner.getInternalName(), this.fieldName, this.type.getDescriptor());
                this.genNotNullAssertionForLateInitIfNeeded(v);
                this.coerceTo(type2, v);
            } else {
                PropertyGetterDescriptor getterDescriptor = this.descriptor.getGetter();
                assert (getterDescriptor != null) : "Getter descriptor should be not null for " + this.descriptor;
                if (this.resolvedCall != null && getterDescriptor.isInline()) {
                    CallGenerator callGenerator = this.codegen.getOrCreateCallGenerator(this.resolvedCall, getterDescriptor);
                    callGenerator.processAndPutHiddenParameters(false);
                    callGenerator.genCall(this.getter, this.resolvedCall, false, this.codegen);
                } else {
                    this.getter.genInvokeInstruction(v);
                }
                Type typeOfValueOnStack = this.getter.getReturnType();
                if (DescriptorUtils.isAnnotationClass(this.descriptor.getContainingDeclaration())) {
                    if (this.type.equals(AsmTypes.K_CLASS_TYPE)) {
                        AsmUtil.wrapJavaClassIntoKClass(v);
                        typeOfValueOnStack = AsmTypes.K_CLASS_TYPE;
                    } else if (this.type.equals(AsmTypes.K_CLASS_ARRAY_TYPE)) {
                        AsmUtil.wrapJavaClassesIntoKClasses(v);
                        typeOfValueOnStack = AsmTypes.K_CLASS_ARRAY_TYPE;
                    }
                }
                Property.coerce(typeOfValueOnStack, type2, v);
                KotlinType returnType = this.descriptor.getReturnType();
                if (returnType != null && KotlinBuiltIns.isNothing(returnType)) {
                    v.aconst(null);
                    v.athrow();
                }
            }
        }

        private boolean inlineConstantIfNeeded(@NotNull Type type2, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                Property.$$$reportNull$$$0(6);
            }
            if (v == null) {
                Property.$$$reportNull$$$0(7);
            }
            if (JvmCodegenUtil.isInlinedJavaConstProperty(this.descriptor)) {
                return this.inlineConstant(type2, v);
            }
            if (this.descriptor.isConst() && this.codegen.getState().getShouldInlineConstVals()) {
                return this.inlineConstant(type2, v);
            }
            return false;
        }

        private boolean inlineConstant(@NotNull Type type2, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                Property.$$$reportNull$$$0(8);
            }
            if (v == null) {
                Property.$$$reportNull$$$0(9);
            }
            assert (AsmUtil.isPrimitive(this.type) || AsmTypes.JAVA_STRING_TYPE.equals(this.type)) : "Const property should have primitive or string type: " + this.descriptor;
            assert (this.isStaticPut) : "Const property should be static" + this.descriptor;
            ConstantValue<?> constantValue = this.descriptor.getCompileTimeInitializer();
            if (constantValue == null) {
                return false;
            }
            Object value = constantValue.getValue();
            if (this.type == Type.FLOAT_TYPE && value instanceof Double) {
                value = Float.valueOf(((Double)value).floatValue());
            }
            StackValue.constant(value, this.type).putSelector(type2, v);
            return true;
        }

        private void genNotNullAssertionForLateInitIfNeeded(@NotNull InstructionAdapter v) {
            if (v == null) {
                Property.$$$reportNull$$$0(10);
            }
            if (!this.descriptor.isLateInit()) {
                return;
            }
            v.dup();
            Label ok = new Label();
            v.ifnonnull(ok);
            v.visitLdcInsn(this.descriptor.getName().asString());
            v.invokestatic("kotlin/jvm/internal/Intrinsics", "throwUninitializedPropertyAccessException", "(Ljava/lang/String;)V", false);
            v.mark(ok);
        }

        @Override
        public void store(@NotNull StackValue rightSide, @NotNull InstructionAdapter v, boolean skipReceiver) {
            if (rightSide == null) {
                Property.$$$reportNull$$$0(11);
            }
            if (v == null) {
                Property.$$$reportNull$$$0(12);
            }
            PropertySetterDescriptor setterDescriptor = this.descriptor.getSetter();
            if (this.resolvedCall != null && setterDescriptor != null && setterDescriptor.isInline()) {
                assert (this.setter != null) : "Setter should be not null for " + this.descriptor;
                CallGenerator callGenerator = this.codegen.getOrCreateCallGenerator(this.resolvedCall, setterDescriptor);
                if (!skipReceiver) {
                    this.putReceiver(v, false);
                }
                callGenerator.processAndPutHiddenParameters(true);
                callGenerator.putValueIfNeeded(rightSide.type, rightSide);
                callGenerator.putHiddenParamsIntoLocals();
                callGenerator.genCall(this.setter, this.resolvedCall, false, this.codegen);
            } else {
                super.store(rightSide, v, skipReceiver);
            }
        }

        @Override
        public void storeSelector(@NotNull Type topOfStackType, @NotNull InstructionAdapter v) {
            if (topOfStackType == null) {
                Property.$$$reportNull$$$0(13);
            }
            if (v == null) {
                Property.$$$reportNull$$$0(14);
            }
            if (this.setter == null) {
                this.coerceFrom(topOfStackType, v);
                assert (this.fieldName != null) : "Property should have either a setter or a field name: " + this.descriptor;
                assert (this.backingFieldOwner != null) : "Property should have either a setter or a backingFieldOwner: " + this.descriptor;
                v.visitFieldInsn(this.isStaticStore ? 179 : 181, this.backingFieldOwner.getInternalName(), this.fieldName, this.type.getDescriptor());
            } else {
                Property.coerce(topOfStackType, ArraysKt.last(this.setter.getParameterTypes()), v);
                this.setter.genInvokeInstruction(v);
                Type returnType = this.setter.getReturnType();
                if (returnType != Type.VOID_TYPE) {
                    AsmUtil.pop(v, returnType);
                }
            }
        }

        private static boolean isStatic(boolean isStaticBackingField, @Nullable CallableMethod callable) {
            if (isStaticBackingField && callable == null) {
                return true;
            }
            if (callable != null && callable.isStaticCall()) {
                JvmMethodParameterSignature parameter;
                JvmMethodParameterKind kind;
                List<JvmMethodParameterSignature> parameters2 = callable.getValueParameters();
                Iterator<JvmMethodParameterSignature> iterator2 = parameters2.iterator();
                while (iterator2.hasNext() && (kind = (parameter = iterator2.next()).getKind()) != JvmMethodParameterKind.VALUE) {
                    if (kind != JvmMethodParameterKind.RECEIVER && kind != JvmMethodParameterKind.THIS) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 1: 
                case 4: 
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "receiver";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "codegen";
                    break;
                }
                case 5: 
                case 7: 
                case 9: 
                case 10: 
                case 12: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "v";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rightSide";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "topOfStackType";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/codegen/StackValue$Property";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "putSelector";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "inlineConstantIfNeeded";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "inlineConstant";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "genNotNullAssertionForLateInitIfNeeded";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[2] = "store";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[2] = "storeSelector";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Field
    extends StackValueWithSimpleReceiver {
        public final Type owner;
        public final String name;
        public final DeclarationDescriptor descriptor;

        public Field(@NotNull Type type2, @NotNull Type owner, @NotNull String name, boolean isStatic, @NotNull StackValue receiver, @Nullable DeclarationDescriptor descriptor2) {
            if (type2 == null) {
                Field.$$$reportNull$$$0(0);
            }
            if (owner == null) {
                Field.$$$reportNull$$$0(1);
            }
            if (name == null) {
                Field.$$$reportNull$$$0(2);
            }
            if (receiver == null) {
                Field.$$$reportNull$$$0(3);
            }
            super(type2, isStatic, isStatic, receiver, receiver.canHaveSideEffects());
            this.owner = owner;
            this.name = name;
            this.descriptor = descriptor2;
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                Field.$$$reportNull$$$0(4);
            }
            if (v == null) {
                Field.$$$reportNull$$$0(5);
            }
            v.visitFieldInsn(this.isStaticPut ? 178 : 180, this.owner.getInternalName(), this.name, this.type.getDescriptor());
            this.coerceTo(type2, v);
        }

        @Override
        public void storeSelector(@NotNull Type topOfStackType, @NotNull InstructionAdapter v) {
            if (topOfStackType == null) {
                Field.$$$reportNull$$$0(6);
            }
            if (v == null) {
                Field.$$$reportNull$$$0(7);
            }
            this.coerceFrom(topOfStackType, v);
            v.visitFieldInsn(this.isStaticStore ? 179 : 181, this.owner.getInternalName(), this.name, this.type.getDescriptor());
        }

        @Override
        protected StackValueWithSimpleReceiver changeReceiver(@NotNull StackValue newReceiver) {
            if (newReceiver == null) {
                Field.$$$reportNull$$$0(8);
            }
            return Field.field(this, newReceiver);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "receiver";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "v";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "topOfStackType";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newReceiver";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/codegen/StackValue$Field";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "putSelector";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "storeSelector";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "changeReceiver";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class CollectionElement
    extends StackValueWithSimpleReceiver {
        private final Callable getter;
        private final Callable setter;
        private final ExpressionCodegen codegen;
        private final ResolvedCall<FunctionDescriptor> resolvedGetCall;
        private final ResolvedCall<FunctionDescriptor> resolvedSetCall;

        public CollectionElement(@NotNull CollectionElementReceiver collectionElementReceiver, @NotNull Type type2, @Nullable ResolvedCall<FunctionDescriptor> resolvedGetCall, @Nullable ResolvedCall<FunctionDescriptor> resolvedSetCall, @NotNull ExpressionCodegen codegen) {
            if (collectionElementReceiver == null) {
                CollectionElement.$$$reportNull$$$0(0);
            }
            if (type2 == null) {
                CollectionElement.$$$reportNull$$$0(1);
            }
            if (codegen == null) {
                CollectionElement.$$$reportNull$$$0(2);
            }
            super(type2, false, false, collectionElementReceiver, true);
            this.resolvedGetCall = resolvedGetCall;
            this.resolvedSetCall = resolvedSetCall;
            this.setter = resolvedSetCall == null ? null : codegen.resolveToCallable(codegen.accessibleFunctionDescriptor(resolvedSetCall), false, resolvedSetCall);
            this.getter = resolvedGetCall == null ? null : codegen.resolveToCallable(codegen.accessibleFunctionDescriptor(resolvedGetCall), false, resolvedGetCall);
            this.codegen = codegen;
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                CollectionElement.$$$reportNull$$$0(3);
            }
            if (v == null) {
                CollectionElement.$$$reportNull$$$0(4);
            }
            if (this.getter == null) {
                throw new UnsupportedOperationException("no getter specified");
            }
            CallGenerator callGenerator = this.getCallGenerator();
            callGenerator.genCall(this.getter, this.resolvedGetCall, this.genDefaultMaskIfPresent(callGenerator), this.codegen);
            this.coerceTo(type2, v);
        }

        private boolean genDefaultMaskIfPresent(CallGenerator callGenerator) {
            DefaultCallArgs defaultArgs = ((CollectionElementReceiver)this.receiver).defaultArgs;
            return defaultArgs.generateOnStackIfNeeded(callGenerator, true);
        }

        private CallGenerator getCallGenerator() {
            CallGenerator generator = ((CollectionElementReceiver)this.receiver).callGenerator;
            assert (generator != null) : "CollectionElementReceiver should be putted on stack before CollectionElement: getCall = " + this.resolvedGetCall + ",  setCall = " + this.resolvedSetCall;
            return generator;
        }

        @Override
        public int receiverSize() {
            if (CollectionElement.isStandardStack(this.codegen.typeMapper, this.resolvedGetCall, 1) && CollectionElement.isStandardStack(this.codegen.typeMapper, this.resolvedSetCall, 2)) {
                return 2;
            }
            return -1;
        }

        public static boolean isStandardStack(@NotNull KotlinTypeMapper typeMapper, @Nullable ResolvedCall<?> call2, int valueParamsSize) {
            if (typeMapper == null) {
                CollectionElement.$$$reportNull$$$0(5);
            }
            if (call2 == null) {
                return true;
            }
            List<ValueParameterDescriptor> valueParameters = call2.getResultingDescriptor().getValueParameters();
            if (valueParameters.size() != valueParamsSize) {
                return false;
            }
            for (ValueParameterDescriptor valueParameter : valueParameters) {
                if (typeMapper.mapType(valueParameter.getType()).getSize() == 1) continue;
                return false;
            }
            return !(call2.getDispatchReceiver() != null ? call2.getExtensionReceiver() != null : typeMapper.mapType(call2.getResultingDescriptor().getExtensionReceiverParameter().getType()).getSize() != 1);
        }

        @Override
        public void storeSelector(@NotNull Type topOfStackType, @NotNull InstructionAdapter v) {
            if (topOfStackType == null) {
                CollectionElement.$$$reportNull$$$0(6);
            }
            if (v == null) {
                CollectionElement.$$$reportNull$$$0(7);
            }
            if (this.setter == null) {
                throw new UnsupportedOperationException("no setter specified");
            }
            Type lastParameterType = ArraysKt.last(this.setter.getParameterTypes());
            CollectionElement.coerce(topOfStackType, lastParameterType, v);
            this.getCallGenerator().putValueIfNeeded(lastParameterType, StackValue.onStack(lastParameterType));
            CollectionElementReceiver collectionElementReceiver = (CollectionElementReceiver)this.receiver;
            if (collectionElementReceiver.isGetter) {
                List arguments2 = collectionElementReceiver.valueArguments;
                List<Type> types = this.getter.getValueParameterTypes();
                for (int i = arguments2.size() - 1; i >= 0; --i) {
                    ResolvedValueArgument argument = (ResolvedValueArgument)arguments2.get(i);
                    if (!(argument instanceof DefaultValueArgument)) continue;
                    Type defaultType2 = types.get(i);
                    AsmUtil.swap(v, lastParameterType, defaultType2);
                    AsmUtil.pop(v, defaultType2);
                }
            }
            this.getCallGenerator().genCall(this.setter, this.resolvedSetCall, false, this.codegen);
            Type returnType = this.setter.getReturnType();
            if (returnType != Type.VOID_TYPE) {
                AsmUtil.pop(v, returnType);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "collectionElementReceiver";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "codegen";
                    break;
                }
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "v";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeMapper";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "topOfStackType";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/codegen/StackValue$CollectionElement";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "putSelector";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isStandardStack";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "storeSelector";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class CollectionElementReceiver
    extends StackValue {
        private final Callable callable;
        private final boolean isGetter;
        private final ExpressionCodegen codegen;
        private final List<ResolvedValueArgument> valueArguments;
        private final FrameMap frame;
        private final StackValue receiver;
        private final ResolvedCall<FunctionDescriptor> resolvedGetCall;
        private final ResolvedCall<FunctionDescriptor> resolvedSetCall;
        private DefaultCallArgs defaultArgs;
        private CallGenerator callGenerator;
        boolean isComplexOperationWithDup;

        public CollectionElementReceiver(@NotNull Callable callable, @NotNull StackValue receiver, ResolvedCall<FunctionDescriptor> resolvedGetCall, ResolvedCall<FunctionDescriptor> resolvedSetCall, boolean isGetter, @NotNull ExpressionCodegen codegen, List<ResolvedValueArgument> valueArguments2) {
            if (callable == null) {
                CollectionElementReceiver.$$$reportNull$$$0(0);
            }
            if (receiver == null) {
                CollectionElementReceiver.$$$reportNull$$$0(1);
            }
            if (codegen == null) {
                CollectionElementReceiver.$$$reportNull$$$0(2);
            }
            super(AsmTypes.OBJECT_TYPE);
            this.callable = callable;
            this.isGetter = isGetter;
            this.receiver = receiver;
            this.resolvedGetCall = resolvedGetCall;
            this.resolvedSetCall = resolvedSetCall;
            this.valueArguments = valueArguments2;
            this.codegen = codegen;
            this.frame = codegen.myFrameMap;
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                CollectionElementReceiver.$$$reportNull$$$0(3);
            }
            if (v == null) {
                CollectionElementReceiver.$$$reportNull$$$0(4);
            }
            ResolvedCall<FunctionDescriptor> call2 = this.isGetter ? this.resolvedGetCall : this.resolvedSetCall;
            StackValue newReceiver = StackValue.receiver(call2, this.receiver, this.codegen, this.callable);
            ArgumentGenerator generator = this.createArgumentGenerator();
            newReceiver.put(newReceiver.type, v);
            this.callGenerator.processAndPutHiddenParameters(false);
            this.defaultArgs = generator.generate(this.valueArguments, this.valueArguments, call2.getResultingDescriptor());
        }

        private ArgumentGenerator createArgumentGenerator() {
            ResolvedCall<FunctionDescriptor> resolvedCall2;
            assert (this.callGenerator == null) : "'putSelector' and 'createArgumentGenerator' methods should be called once for CollectionElementReceiver: " + this.callable;
            ResolvedCall<FunctionDescriptor> resolvedCall3 = resolvedCall2 = this.isGetter ? this.resolvedGetCall : this.resolvedSetCall;
            assert (resolvedCall2 != null) : "Resolved call should be non-null: " + this.callable;
            this.callGenerator = !this.isComplexOperationWithDup ? this.codegen.getOrCreateCallGenerator(resolvedCall2) : this.codegen.defaultCallGenerator;
            return new CallBasedArgumentGenerator(this.codegen, this.callGenerator, resolvedCall2.getResultingDescriptor().getValueParameters(), this.callable.getValueParameterTypes());
        }

        @Override
        public void dup(@NotNull InstructionAdapter v, boolean withReceiver) {
            if (v == null) {
                CollectionElementReceiver.$$$reportNull$$$0(5);
            }
            this.dupReceiver(v);
        }

        public void dupReceiver(@NotNull InstructionAdapter v) {
            Type type2;
            int realReceiverIndex;
            Type realReceiverType;
            if (v == null) {
                CollectionElementReceiver.$$$reportNull$$$0(6);
            }
            if (CollectionElement.isStandardStack(this.codegen.typeMapper, this.resolvedGetCall, 1) && CollectionElement.isStandardStack(this.codegen.typeMapper, this.resolvedSetCall, 2)) {
                v.dup2();
                return;
            }
            FrameMap.Mark mark = this.frame.mark();
            List<ValueParameterDescriptor> valueParameters = this.resolvedGetCall.getResultingDescriptor().getValueParameters();
            int firstParamIndex = -1;
            for (int i = valueParameters.size() - 1; i >= 0; --i) {
                Type type3 = this.codegen.typeMapper.mapType(valueParameters.get(i).getType());
                firstParamIndex = this.frame.enterTemp(type3);
                v.store(firstParamIndex, type3);
            }
            ReceiverValue receiverParameter = this.resolvedGetCall.getExtensionReceiver();
            int receiverIndex = -1;
            if (receiverParameter != null) {
                Type type4 = this.codegen.typeMapper.mapType(receiverParameter.getType());
                receiverIndex = this.frame.enterTemp(type4);
                v.store(receiverIndex, type4);
            }
            ReceiverValue dispatchReceiver = this.resolvedGetCall.getDispatchReceiver();
            int thisIndex = -1;
            if (dispatchReceiver != null) {
                thisIndex = this.frame.enterTemp(AsmTypes.OBJECT_TYPE);
                v.store(thisIndex, AsmTypes.OBJECT_TYPE);
            }
            if (receiverIndex != -1) {
                realReceiverType = this.codegen.typeMapper.mapType(receiverParameter.getType());
                realReceiverIndex = receiverIndex;
            } else if (thisIndex != -1) {
                realReceiverType = AsmTypes.OBJECT_TYPE;
                realReceiverIndex = thisIndex;
            } else {
                throw new UnsupportedOperationException();
            }
            if (this.resolvedSetCall.getDispatchReceiver() != null) {
                if (this.resolvedSetCall.getExtensionReceiver() != null) {
                    this.codegen.generateReceiverValue(this.resolvedSetCall.getDispatchReceiver(), false).put(AsmTypes.OBJECT_TYPE, v);
                }
                v.load(realReceiverIndex, realReceiverType);
            } else if (this.resolvedSetCall.getExtensionReceiver() != null) {
                v.load(realReceiverIndex, realReceiverType);
            } else {
                throw new UnsupportedOperationException();
            }
            int index2 = firstParamIndex;
            for (ValueParameterDescriptor valueParameter : valueParameters) {
                type2 = this.codegen.typeMapper.mapType(valueParameter.getType());
                v.load(index2, type2);
                index2 -= type2.getSize();
            }
            if (thisIndex != -1) {
                v.load(thisIndex, AsmTypes.OBJECT_TYPE);
            }
            if (receiverIndex != -1) {
                v.load(receiverIndex, realReceiverType);
            }
            index2 = firstParamIndex;
            for (ValueParameterDescriptor valueParameter : valueParameters) {
                type2 = this.codegen.typeMapper.mapType(valueParameter.getType());
                v.load(index2, type2);
                index2 -= type2.getSize();
            }
            mark.dropTo();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "receiver";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "codegen";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "v";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/codegen/StackValue$CollectionElementReceiver";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "putSelector";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "dup";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "dupReceiver";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ArrayElement
    extends StackValueWithSimpleReceiver {
        private final Type type;

        public ArrayElement(Type type2, StackValue array, StackValue index2) {
            super(type2, false, false, new Receiver(Type.LONG_TYPE, array, index2), true);
            this.type = type2;
        }

        @Override
        public void storeSelector(@NotNull Type topOfStackType, @NotNull InstructionAdapter v) {
            if (topOfStackType == null) {
                ArrayElement.$$$reportNull$$$0(0);
            }
            if (v == null) {
                ArrayElement.$$$reportNull$$$0(1);
            }
            this.coerceFrom(topOfStackType, v);
            v.astore(this.type);
        }

        @Override
        public int receiverSize() {
            return 2;
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                ArrayElement.$$$reportNull$$$0(2);
            }
            if (v == null) {
                ArrayElement.$$$reportNull$$$0(3);
            }
            v.aload(this.type);
            this.coerceTo(type2, v);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "topOfStackType";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "v";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/codegen/StackValue$ArrayElement";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "storeSelector";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "putSelector";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Constant
    extends StackValue {
        @Nullable
        public final Object value;

        public Constant(@Nullable Object value, Type type2) {
            super(type2, false);
            assert (!Type.BOOLEAN_TYPE.equals(type2)) : "Boolean constants should be created via 'StackValue.constant'";
            this.value = value;
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                Constant.$$$reportNull$$$0(0);
            }
            if (v == null) {
                Constant.$$$reportNull$$$0(1);
            }
            if (this.value instanceof Integer || this.value instanceof Byte || this.value instanceof Short) {
                v.iconst(((Number)this.value).intValue());
            } else if (this.value instanceof Character) {
                v.iconst(((Character)this.value).charValue());
            } else if (this.value instanceof Long) {
                v.lconst((Long)this.value);
            } else if (this.value instanceof Float) {
                v.fconst(((Float)this.value).floatValue());
            } else if (this.value instanceof Double) {
                v.dconst((Double)this.value);
            } else {
                v.aconst(this.value);
            }
            if (this.value != null || AsmUtil.isPrimitive(type2)) {
                this.coerceTo(type2, v);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "v";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/kotlin/codegen/StackValue$Constant";
            objectArray[2] = "putSelector";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class OnStack
    extends StackValue {
        public OnStack(Type type2) {
            super(type2);
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                OnStack.$$$reportNull$$$0(0);
            }
            if (v == null) {
                OnStack.$$$reportNull$$$0(1);
            }
            this.coerceTo(type2, v);
        }

        @Override
        public void moveToTopOfStack(@NotNull Type type2, @NotNull InstructionAdapter v, int depth) {
            if (type2 == null) {
                OnStack.$$$reportNull$$$0(2);
            }
            if (v == null) {
                OnStack.$$$reportNull$$$0(3);
            }
            if (depth == 0) {
                this.put(type2, v);
            } else if (depth == 1) {
                int size = this.type.getSize();
                if (size == 1) {
                    v.swap();
                } else if (size == 2) {
                    v.dupX2();
                    v.pop();
                } else {
                    throw new UnsupportedOperationException("don't know how to move type " + type2 + " to top of stack");
                }
                this.coerceTo(type2, v);
            } else if (depth == 2) {
                int size = this.type.getSize();
                if (size == 1) {
                    v.dup2X1();
                    v.pop2();
                } else if (size == 2) {
                    v.dup2X2();
                    v.pop2();
                } else {
                    throw new UnsupportedOperationException("don't know how to move type " + type2 + " to top of stack");
                }
                this.coerceTo(type2, v);
            } else {
                throw new UnsupportedOperationException("unsupported move-to-top depth " + depth);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "v";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/codegen/StackValue$OnStack";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "putSelector";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "moveToTopOfStack";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Delegate
    extends StackValue {
        @NotNull
        private final StackValue delegateValue;
        @NotNull
        private final StackValue metadataValue;
        @NotNull
        private final VariableDescriptorWithAccessors variableDescriptor;
        @NotNull
        private final ExpressionCodegen codegen;

        private Delegate(@NotNull Type type2, @NotNull StackValue delegateValue, @NotNull StackValue metadataValue, @NotNull VariableDescriptorWithAccessors variableDescriptor, @NotNull ExpressionCodegen codegen) {
            if (type2 == null) {
                Delegate.$$$reportNull$$$0(0);
            }
            if (delegateValue == null) {
                Delegate.$$$reportNull$$$0(1);
            }
            if (metadataValue == null) {
                Delegate.$$$reportNull$$$0(2);
            }
            if (variableDescriptor == null) {
                Delegate.$$$reportNull$$$0(3);
            }
            if (codegen == null) {
                Delegate.$$$reportNull$$$0(4);
            }
            super(type2);
            this.delegateValue = delegateValue;
            this.metadataValue = metadataValue;
            this.variableDescriptor = variableDescriptor;
            this.codegen = codegen;
        }

        private ResolvedCall<FunctionDescriptor> getResolvedCall(boolean isGetter) {
            VariableAccessorDescriptor accessor;
            BindingContext bindingContext = this.codegen.getState().getBindingContext();
            VariableAccessorDescriptor variableAccessorDescriptor = accessor = isGetter ? this.variableDescriptor.getGetter() : this.variableDescriptor.getSetter();
            assert (accessor != null) : "Accessor descriptor for delegated local property should be present " + this.variableDescriptor;
            ResolvedCall<FunctionDescriptor> resolvedCall2 = bindingContext.get(BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL, accessor);
            assert (resolvedCall2 != null) : "Resolve call should be recorded for delegate call " + this.variableDescriptor;
            return resolvedCall2;
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                Delegate.$$$reportNull$$$0(5);
            }
            if (v == null) {
                Delegate.$$$reportNull$$$0(6);
            }
            ResolvedCall<FunctionDescriptor> resolvedCall2 = this.getResolvedCall(true);
            List<? extends ValueArgument> arguments2 = resolvedCall2.getCall().getValueArguments();
            assert (arguments2.size() == 2) : "Resolved call for 'getValue' should have 2 arguments, but was " + arguments2.size() + ": " + resolvedCall2;
            this.codegen.tempVariables.put(arguments2.get(0).asElement(), StackValue.constant(null, AsmTypes.OBJECT_TYPE));
            this.codegen.tempVariables.put(arguments2.get(1).asElement(), this.metadataValue);
            StackValue lastValue = this.codegen.invokeFunction(resolvedCall2, this.delegateValue);
            lastValue.put(type2, v);
            this.codegen.tempVariables.remove(arguments2.get(0).asElement());
            this.codegen.tempVariables.remove(arguments2.get(1).asElement());
        }

        @Override
        public void store(@NotNull StackValue rightSide, @NotNull InstructionAdapter v, boolean skipReceiver) {
            if (rightSide == null) {
                Delegate.$$$reportNull$$$0(7);
            }
            if (v == null) {
                Delegate.$$$reportNull$$$0(8);
            }
            ResolvedCall<FunctionDescriptor> resolvedCall2 = this.getResolvedCall(false);
            List<? extends ValueArgument> arguments2 = resolvedCall2.getCall().getValueArguments();
            assert (arguments2.size() == 3) : "Resolved call for 'setValue' should have 3 arguments, but was " + arguments2.size() + ": " + resolvedCall2;
            this.codegen.tempVariables.put(arguments2.get(0).asElement(), StackValue.constant(null, AsmTypes.OBJECT_TYPE));
            this.codegen.tempVariables.put(arguments2.get(1).asElement(), this.metadataValue);
            this.codegen.tempVariables.put(arguments2.get(2).asElement(), rightSide);
            StackValue lastValue = this.codegen.invokeFunction(resolvedCall2, this.delegateValue);
            lastValue.put(Type.VOID_TYPE, v);
            this.codegen.tempVariables.remove(arguments2.get(0).asElement());
            this.codegen.tempVariables.remove(arguments2.get(1).asElement());
            this.codegen.tempVariables.remove(arguments2.get(2).asElement());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegateValue";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "metadataValue";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variableDescriptor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "codegen";
                    break;
                }
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "v";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rightSide";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/codegen/StackValue$Delegate";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "putSelector";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "store";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Local
    extends StackValue {
        public final int index;

        private Local(int index2, Type type2) {
            super(type2, false);
            this.index = index2;
            if (index2 < 0) {
                throw new IllegalStateException("local variable index must be non-negative");
            }
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                Local.$$$reportNull$$$0(0);
            }
            if (v == null) {
                Local.$$$reportNull$$$0(1);
            }
            v.load(this.index, this.type);
            this.coerceTo(type2, v);
        }

        @Override
        public void storeSelector(@NotNull Type topOfStackType, @NotNull InstructionAdapter v) {
            if (topOfStackType == null) {
                Local.$$$reportNull$$$0(2);
            }
            if (v == null) {
                Local.$$$reportNull$$$0(3);
            }
            this.coerceFrom(topOfStackType, v);
            v.store(this.index, this.type);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "v";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "topOfStackType";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/codegen/StackValue$Local";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "putSelector";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "storeSelector";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class None
    extends StackValue {
        public static final None INSTANCE = new None();

        private None() {
            super(Type.VOID_TYPE, false);
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                None.$$$reportNull$$$0(0);
            }
            if (v == null) {
                None.$$$reportNull$$$0(1);
            }
            this.coerceTo(type2, v);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "v";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/kotlin/codegen/StackValue$None";
            objectArray[2] = "putSelector";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

