/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.cpp.plugins;

import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.file.DirectoryVar;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.specs.Spec;
import org.gradle.language.cpp.CppApplication;
import org.gradle.language.cpp.internal.DefaultCppApplication;
import org.gradle.language.cpp.plugins.CppBasePlugin;
import org.gradle.nativeplatform.tasks.InstallExecutable;
import org.gradle.nativeplatform.tasks.LinkExecutable;
import org.gradle.platform.base.ToolChain;

@Incubating
public class CppExecutablePlugin
implements Plugin<ProjectInternal> {
    private final FileOperations fileOperations;

    @Inject
    public CppExecutablePlugin(FileOperations fileOperations) {
        this.fileOperations = fileOperations;
    }

    public void apply(ProjectInternal project) {
        project.getPluginManager().apply(CppBasePlugin.class);
        DirectoryVar buildDirectory = project.getLayout().getBuildDirectory();
        ConfigurationContainer configurations = project.getConfigurations();
        ProviderFactory providers = project.getProviders();
        TaskContainerInternal tasks = project.getTasks();
        final CppApplication application = (CppApplication)project.getExtensions().create(CppApplication.class, "executable", DefaultCppApplication.class, new Object[]{"main", project.getObjects(), this.fileOperations, providers, configurations});
        project.getComponents().add((Object)application);
        project.getComponents().add((Object)application.getDebugExecutable());
        project.getComponents().add((Object)application.getReleaseExecutable());
        application.getBaseName().set((Object)project.getName());
        LinkExecutable link = (LinkExecutable)tasks.getByName("linkDebug");
        final InstallExecutable install = (InstallExecutable)tasks.create("installMain", InstallExecutable.class);
        install.setPlatform(link.getTargetPlatform());
        install.setToolChain((ToolChain)link.getToolChain());
        install.setDestinationDir(buildDirectory.dir(providers.provider((Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return "install/" + (String)application.getBaseName().get();
            }
        })));
        install.setExecutable((Provider)link.getBinaryFile());
        install.onlyIf((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task element) {
                return install.getExecutable().exists();
            }
        });
        install.lib((Object)application.getDebugExecutable().getRuntimeLibraries());
        tasks.getByName("assemble").dependsOn(new Object[]{install});
    }
}

