/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.schema.extract;

import java.lang.reflect.Constructor;
import org.gradle.model.internal.asm.AsmClassGenerator;
import org.gradle.model.internal.manage.schema.extract.AbstractProxyClassGenerator;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedCollectionProxyClassGenerator
extends AbstractProxyClassGenerator {
    public Class<?> generate(Class<?> implClass, Class<?> publicContractType) {
        AsmClassGenerator classGenerator = new AsmClassGenerator(publicContractType, "_Impl");
        ClassWriter visitor = classGenerator.getVisitor();
        Type generatedType = classGenerator.getGeneratedType();
        Type superclassType = Type.getType(implClass);
        Type publicType = Type.getType(publicContractType);
        this.generateClass(visitor, generatedType, superclassType, publicType);
        this.generateConstructors(visitor, implClass, superclassType);
        visitor.visitEnd();
        return classGenerator.define();
    }

    private <T> void generateConstructors(ClassWriter visitor, Class<? extends T> implClass, Type superclassType) {
        for (Constructor<?> constructor : implClass.getConstructors()) {
            Type[] paramTypes = new Type[constructor.getParameterTypes().length];
            for (int i = 0; i < paramTypes.length; ++i) {
                paramTypes[i] = Type.getType(constructor.getParameterTypes()[i]);
            }
            String methodDescriptor = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])paramTypes);
            MethodVisitor constructorVisitor = visitor.visitMethod(1, "<init>", methodDescriptor, CONCRETE_SIGNATURE, NO_EXCEPTIONS);
            constructorVisitor.visitCode();
            this.putThisOnStack(constructorVisitor);
            for (int i = 0; i < paramTypes.length; ++i) {
                constructorVisitor.visitVarInsn(paramTypes[i].getOpcode(21), i + 1);
            }
            constructorVisitor.visitMethodInsn(183, superclassType.getInternalName(), "<init>", methodDescriptor, false);
            this.finishVisitingMethod(constructorVisitor);
        }
    }

    private void generateClass(ClassWriter visitor, Type generatedType, Type superclassType, Type publicType) {
        visitor.visit(50, 1, generatedType.getInternalName(), null, superclassType.getInternalName(), new String[]{publicType.getInternalName()});
    }
}

