/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.http.ntlm;

import java.io.IOException;
import jcifs.ntlmssp.Type1Message;
import jcifs.ntlmssp.Type2Message;
import jcifs.ntlmssp.Type3Message;
import jcifs.util.Base64;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthSchemeProvider;
import org.apache.http.impl.auth.NTLMEngine;
import org.apache.http.impl.auth.NTLMEngineException;
import org.apache.http.impl.auth.NTLMScheme;
import org.apache.http.protocol.HttpContext;

public class NTLMSchemeFactory
implements AuthSchemeProvider {
    public AuthScheme create(HttpContext context) {
        return new NTLMScheme((NTLMEngine)new JCIFSEngine());
    }

    private static class JCIFSEngine
    implements NTLMEngine {
        private JCIFSEngine() {
        }

        public String generateType1Msg(String domain, String workstation) throws NTLMEngineException {
            Type1Message type1Message = new Type1Message(Type1Message.getDefaultFlags(), domain, workstation);
            return Base64.encode((byte[])type1Message.toByteArray());
        }

        public String generateType3Msg(String username, String password, String domain, String workstation, String challenge) throws NTLMEngineException {
            Type2Message type2Message = this.decodeType2Message(challenge);
            Type3Message type3Message = new Type3Message(type2Message, password, domain, username, workstation, Type3Message.getDefaultFlags());
            return Base64.encode((byte[])type3Message.toByteArray());
        }

        private Type2Message decodeType2Message(String challenge) throws NTLMEngineException {
            try {
                return new Type2Message(Base64.decode((String)challenge));
            }
            catch (IOException exception) {
                throw new NTLMEngineException("Invalid Type2 message", (Throwable)exception);
            }
        }
    }
}

