/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.progress;

import org.gradle.internal.logging.progress.ProgressLogger;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.gradle.internal.progress.LoggerProvider;
import org.gradle.internal.progress.ProgressLoggerProvider;

public class BuildProgressLogger
implements LoggerProvider {
    public static final String INITIALIZATION_PHASE_DESCRIPTION = "Initializing build";
    public static final String INITIALIZATION_PHASE_SHORT_DESCRIPTION = "INITIALIZING";
    public static final String CONFIGURATION_PHASE_DESCRIPTION = "Configuring projects";
    public static final String CONFIGURATION_PHASE_SHORT_DESCRIPTION = "CONFIGURING";
    public static final String EXECUTION_PHASE_DESCRIPTION = "Executing tasks";
    public static final String EXECUTION_PHASE_SHORT_DESCRIPTION = "EXECUTING";
    public static final String WAITING_PHASE_DESCRIPTION = "WAITING";
    private final ProgressLoggerProvider loggerProvider;
    private boolean rootBuildInitComplete;
    private boolean rootTaskGraphPopulated;
    private ProgressLogger buildProgress;

    public BuildProgressLogger(ProgressLoggerFactory progressLoggerFactory) {
        this(new ProgressLoggerProvider(progressLoggerFactory, BuildProgressLogger.class));
    }

    BuildProgressLogger(ProgressLoggerProvider loggerProvider) {
        this.loggerProvider = loggerProvider;
    }

    public void buildStarted() {
        this.buildProgress = this.loggerProvider.start(INITIALIZATION_PHASE_DESCRIPTION, INITIALIZATION_PHASE_SHORT_DESCRIPTION, 0);
    }

    public void settingsEvaluated() {
        this.buildProgress.completed();
        this.rootBuildInitComplete = true;
    }

    public void projectsLoaded(int totalProjects) {
        this.buildProgress = this.loggerProvider.start(CONFIGURATION_PHASE_DESCRIPTION, CONFIGURATION_PHASE_SHORT_DESCRIPTION, totalProjects);
    }

    public void beforeEvaluate(String projectPath) {
    }

    public void afterEvaluate(String projectPath) {
        if (!this.rootTaskGraphPopulated) {
            this.buildProgress.progress("", false);
        }
    }

    public void graphPopulated(int totalTasks) {
        this.rootTaskGraphPopulated = true;
        this.buildProgress.completed();
        this.buildProgress = this.loggerProvider.start(EXECUTION_PHASE_DESCRIPTION, EXECUTION_PHASE_SHORT_DESCRIPTION, totalTasks);
    }

    public void nestedTaskGraphPopulated(int totalTasks) {
        if (!this.rootBuildInitComplete) {
            this.buildProgress.completed();
            this.buildProgress = this.loggerProvider.start(INITIALIZATION_PHASE_DESCRIPTION, INITIALIZATION_PHASE_SHORT_DESCRIPTION, totalTasks);
        }
    }

    public void beforeExecute() {
    }

    public void afterExecute(boolean taskFailed) {
        this.buildProgress.progress("", taskFailed);
    }

    public void afterNestedExecute(boolean taskFailed) {
        if (!this.rootBuildInitComplete) {
            this.afterExecute(taskFailed);
        }
    }

    public void beforeComplete() {
        this.buildProgress.completed(WAITING_PHASE_DESCRIPTION, false);
        this.buildProgress = null;
    }

    public ProgressLogger getLogger() {
        if (this.buildProgress == null) {
            throw new IllegalStateException("Build logger is unavailable (it hasn't started or is already completed).");
        }
        return this.buildProgress;
    }
}

