/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.filewatch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.api.Action;
import org.gradle.api.internal.file.FileSystemSubset;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.filewatch.FileSystemChangeWaiter;
import org.gradle.internal.filewatch.FileWatcher;
import org.gradle.internal.filewatch.FileWatcherEvent;
import org.gradle.internal.filewatch.FileWatcherEventListener;
import org.gradle.internal.filewatch.FileWatcherFactory;
import org.gradle.internal.filewatch.FileWatcherListener;
import org.gradle.internal.filewatch.PendingChangesListener;

class DefaultFileSystemChangeWaiter
implements FileSystemChangeWaiter {
    private final long quietPeriodMillis;
    private final BuildCancellationToken cancellationToken;
    private final AtomicReference<Throwable> error = new AtomicReference();
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private final AtomicLong lastChangeAt = new AtomicLong(0L);
    private final FileWatcher watcher;
    private final Action<Throwable> onError;
    private boolean watching;
    private FileWatcherEventListener eventListener;
    private final Collection<FileWatcherEvent> eventsBeforeListening = new ArrayList<FileWatcherEvent>();
    private final Lock eventDeliveryLock = new ReentrantLock();

    private static long monotonicClockMillis() {
        return System.nanoTime() / 1000000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void signal(Lock lock, Condition condition, Runnable runnable) {
        boolean interrupted = Thread.interrupted();
        lock.lock();
        try {
            runnable.run();
            condition.signal();
        }
        finally {
            lock.unlock();
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private static void signal(Lock lock, Condition condition) {
        DefaultFileSystemChangeWaiter.signal(lock, condition, new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    DefaultFileSystemChangeWaiter(FileWatcherFactory fileWatcherFactory, final PendingChangesListener pendingChangesListener, long quietPeriodMillis, BuildCancellationToken cancellationToken) {
        this.quietPeriodMillis = quietPeriodMillis;
        this.cancellationToken = cancellationToken;
        this.onError = new Action<Throwable>(){

            public void execute(Throwable throwable) {
                DefaultFileSystemChangeWaiter.this.error.set(throwable);
                DefaultFileSystemChangeWaiter.signal(DefaultFileSystemChangeWaiter.this.lock, DefaultFileSystemChangeWaiter.this.condition);
            }
        };
        this.watcher = fileWatcherFactory.watch(this.onError, new FileWatcherListener(){

            @Override
            public void onChange(FileWatcher watcher, FileWatcherEvent event) {
                if (event.getType() != FileWatcherEvent.Type.MODIFY || !event.getFile().isDirectory()) {
                    DefaultFileSystemChangeWaiter.this.deliverEvent(event);
                    DefaultFileSystemChangeWaiter.signal(DefaultFileSystemChangeWaiter.this.lock, DefaultFileSystemChangeWaiter.this.condition, new Runnable(){

                        @Override
                        public void run() {
                            DefaultFileSystemChangeWaiter.this.lastChangeAt.set(DefaultFileSystemChangeWaiter.monotonicClockMillis());
                            pendingChangesListener.onPendingChanges();
                        }
                    });
                }
            }
        });
    }

    @Override
    public void watch(FileSystemSubset fileSystemSubset) {
        try {
            if (!fileSystemSubset.isEmpty()) {
                this.watching = true;
                this.watcher.watch(fileSystemSubset);
            }
        }
        catch (IOException e) {
            this.onError.execute((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void wait(Runnable notifier, FileWatcherEventListener eventListener) {
        Runnable cancellationHandler = new Runnable(){

            @Override
            public void run() {
                DefaultFileSystemChangeWaiter.signal(DefaultFileSystemChangeWaiter.this.lock, DefaultFileSystemChangeWaiter.this.condition);
            }
        };
        try {
            this.attachEventListener(eventListener);
            if (this.cancellationToken.isCancellationRequested()) {
                return;
            }
            this.cancellationToken.addCallback(cancellationHandler);
            notifier.run();
            this.lock.lock();
            try {
                long lastChangeAtValue = this.lastChangeAt.get();
                while (!this.cancellationToken.isCancellationRequested() && this.waitingForChanges(lastChangeAtValue)) {
                    this.condition.await(this.quietPeriodMillis, TimeUnit.MILLISECONDS);
                    lastChangeAtValue = this.lastChangeAt.get();
                }
            }
            finally {
                this.lock.unlock();
            }
            Throwable throwable = this.error.get();
            if (throwable != null) {
                throw throwable;
            }
        }
        catch (Throwable e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        finally {
            this.detachEventListener();
            this.cancellationToken.removeCallback(cancellationHandler);
            this.watcher.stop();
        }
    }

    private boolean waitingForChanges(long lastChangeAtValue) {
        return this.error.get() == null && this.shouldKeepWaitingForQuietPeriod(lastChangeAtValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliverEvent(FileWatcherEvent event) {
        this.eventDeliveryLock.lock();
        try {
            if (this.eventListener != null) {
                this.eventListener.onChange(event);
            } else {
                this.eventsBeforeListening.add(event);
            }
        }
        finally {
            this.eventDeliveryLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attachEventListener(FileWatcherEventListener eventListener) {
        this.eventDeliveryLock.lock();
        try {
            this.eventListener = eventListener;
            for (FileWatcherEvent event : this.eventsBeforeListening) {
                eventListener.onChange(event);
            }
            this.eventsBeforeListening.clear();
        }
        finally {
            this.eventDeliveryLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void detachEventListener() {
        this.eventDeliveryLock.lock();
        try {
            this.eventListener = null;
        }
        finally {
            this.eventDeliveryLock.unlock();
        }
    }

    private boolean shouldKeepWaitingForQuietPeriod(long lastChangeAtValue) {
        long now = DefaultFileSystemChangeWaiter.monotonicClockMillis();
        return lastChangeAtValue == 0L || now < lastChangeAtValue || now - lastChangeAtValue < this.quietPeriodMillis;
    }

    @Override
    public boolean isWatching() {
        return this.watching;
    }

    public void stop() {
        this.watcher.stop();
    }
}

