/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.IntArray;
import com.badlogic.gdx.utils.Null;
import com.badlogic.gdx.utils.ObjectSet;
import com.badlogic.gdx.utils.Pool;
import com.badlogic.gdx.utils.SnapshotArray;
import com.esotericsoftware.spine.Animation;
import com.esotericsoftware.spine.AnimationStateData;
import com.esotericsoftware.spine.Bone;
import com.esotericsoftware.spine.Event;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.Slot;

public class AnimationState {
    private static final Animation emptyAnimation = new Animation("<empty>", new Array<Animation.Timeline>(0), 0.0f);
    private static final int SUBSEQUENT = 0;
    private static final int FIRST = 1;
    private static final int HOLD_SUBSEQUENT = 2;
    private static final int HOLD_FIRST = 3;
    private static final int HOLD_MIX = 4;
    private static final int SETUP = 1;
    private static final int CURRENT = 2;
    private AnimationStateData data;
    final Array<TrackEntry> tracks = new Array();
    private final Array<Event> events = new Array();
    final SnapshotArray<AnimationStateListener> listeners = new SnapshotArray();
    private final EventQueue queue = new EventQueue();
    private final ObjectSet<String> propertyIds = new ObjectSet();
    boolean animationsChanged;
    private float timeScale = 1.0f;
    private int unkeyedState;
    final Pool<TrackEntry> trackEntryPool = new Pool(){

        protected Object newObject() {
            return new TrackEntry();
        }
    };

    public AnimationState() {
    }

    public AnimationState(AnimationStateData data) {
        if (data == null) {
            throw new IllegalArgumentException("data cannot be null.");
        }
        this.data = data;
    }

    /*
     * Unable to fully structure code
     */
    public void update(float delta) {
        delta *= this.timeScale;
        tracks = this.tracks.items;
        i = 0;
        n = this.tracks.size;
        while (i < n) {
            block7: {
                block9: {
                    block8: {
                        current = (TrackEntry)tracks[i];
                        if (current == null) break block7;
                        current.animationLast = current.nextAnimationLast;
                        current.trackLast = current.nextTrackLast;
                        currentDelta = delta * current.timeScale;
                        if (!(current.delay > 0.0f)) break block8;
                        current.delay -= currentDelta;
                        if (current.delay > 0.0f) break block7;
                        currentDelta = -current.delay;
                        current.delay = 0.0f;
                    }
                    if ((next = current.next) == null) break block9;
                    nextTime = current.trackLast - next.delay;
                    if (!(nextTime >= 0.0f)) ** GOTO lbl-1000
                    next.delay = 0.0f;
                    next.trackTime = next.trackTime + (current.timeScale == 0.0f ? 0.0f : (nextTime / current.timeScale + delta) * next.timeScale);
                    current.trackTime += currentDelta;
                    this.setCurrent(i, next, true);
                    while (next.mixingFrom != null) {
                        next.mixTime += delta;
                        next = next.mixingFrom;
                    }
                    break block7;
                }
                if (current.trackLast >= current.trackEnd && current.mixingFrom == null) {
                    tracks[i] = null;
                    this.queue.end(current);
                    this.disposeNext(current);
                } else lbl-1000:
                // 2 sources

                {
                    if (current.mixingFrom != null && this.updateMixingFrom(current, delta)) {
                        from = current.mixingFrom;
                        current.mixingFrom = null;
                        if (from != null) {
                            from.mixingTo = null;
                        }
                        while (from != null) {
                            this.queue.end(from);
                            from = from.mixingFrom;
                        }
                    }
                    current.trackTime += currentDelta;
                }
            }
            ++i;
        }
        this.queue.drain();
    }

    private boolean updateMixingFrom(TrackEntry to, float delta) {
        TrackEntry from = to.mixingFrom;
        if (from == null) {
            return true;
        }
        boolean finished = this.updateMixingFrom(from, delta);
        from.animationLast = from.nextAnimationLast;
        from.trackLast = from.nextTrackLast;
        if (to.mixTime > 0.0f && to.mixTime >= to.mixDuration) {
            if (from.totalAlpha == 0.0f || to.mixDuration == 0.0f) {
                to.mixingFrom = from.mixingFrom;
                if (from.mixingFrom != null) {
                    from.mixingFrom.mixingTo = to;
                }
                to.interruptAlpha = from.interruptAlpha;
                this.queue.end(from);
            }
            return finished;
        }
        from.trackTime += delta * from.timeScale;
        to.mixTime += delta;
        return false;
    }

    public boolean apply(Skeleton skeleton) {
        if (skeleton == null) {
            throw new IllegalArgumentException("skeleton cannot be null.");
        }
        if (this.animationsChanged) {
            this.animationsChanged();
        }
        Array<Event> events = this.events;
        boolean applied = false;
        T[] tracks = this.tracks.items;
        int i = 0;
        int n = this.tracks.size;
        while (i < n) {
            TrackEntry current = (TrackEntry)tracks[i];
            if (current != null && !(current.delay > 0.0f)) {
                float animationTime;
                applied = true;
                Animation.MixBlend blend = i == 0 ? Animation.MixBlend.first : current.mixBlend;
                float mix = current.alpha;
                if (current.mixingFrom != null) {
                    mix *= this.applyMixingFrom(current, skeleton, blend);
                } else if (current.trackTime >= current.trackEnd && current.next == null) {
                    mix = 0.0f;
                }
                float animationLast = current.animationLast;
                float applyTime = animationTime = current.getAnimationTime();
                Array<Event> applyEvents = events;
                if (current.reverse) {
                    applyTime = current.animation.duration - applyTime;
                    applyEvents = null;
                }
                int timelineCount = current.animation.timelines.size;
                T[] timelines = current.animation.timelines.items;
                if (i == 0 && mix == 1.0f || blend == Animation.MixBlend.add) {
                    int ii = 0;
                    while (ii < timelineCount) {
                        Object timeline = timelines[ii];
                        if (timeline instanceof Animation.AttachmentTimeline) {
                            this.applyAttachmentTimeline((Animation.AttachmentTimeline)timeline, skeleton, applyTime, blend, true);
                        } else {
                            ((Animation.Timeline)timeline).apply(skeleton, animationLast, applyTime, applyEvents, mix, blend, Animation.MixDirection.in);
                        }
                        ++ii;
                    }
                } else {
                    boolean firstFrame;
                    int[] timelineMode = current.timelineMode.items;
                    boolean bl = firstFrame = current.timelinesRotation.size != timelineCount << 1;
                    if (firstFrame) {
                        current.timelinesRotation.setSize(timelineCount << 1);
                    }
                    float[] timelinesRotation = current.timelinesRotation.items;
                    int ii = 0;
                    while (ii < timelineCount) {
                        Animation.MixBlend timelineBlend;
                        Animation.Timeline timeline = (Animation.Timeline)timelines[ii];
                        Animation.MixBlend mixBlend = timelineBlend = timelineMode[ii] == 0 ? blend : Animation.MixBlend.setup;
                        if (timeline instanceof Animation.RotateTimeline) {
                            this.applyRotateTimeline((Animation.RotateTimeline)timeline, skeleton, applyTime, mix, timelineBlend, timelinesRotation, ii << 1, firstFrame);
                        } else if (timeline instanceof Animation.AttachmentTimeline) {
                            this.applyAttachmentTimeline((Animation.AttachmentTimeline)timeline, skeleton, applyTime, blend, true);
                        } else {
                            timeline.apply(skeleton, animationLast, applyTime, applyEvents, mix, timelineBlend, Animation.MixDirection.in);
                        }
                        ++ii;
                    }
                }
                this.queueEvents(current, animationTime);
                events.clear();
                current.nextAnimationLast = animationTime;
                current.nextTrackLast = current.trackTime;
            }
            ++i;
        }
        int setupState = this.unkeyedState + 1;
        T[] slots = skeleton.slots.items;
        int i2 = 0;
        int n2 = skeleton.slots.size;
        while (i2 < n2) {
            Slot slot = (Slot)slots[i2];
            if (slot.attachmentState == setupState) {
                String attachmentName = slot.data.attachmentName;
                slot.setAttachment(attachmentName == null ? null : skeleton.getAttachment(slot.data.index, attachmentName));
            }
            ++i2;
        }
        this.unkeyedState += 2;
        this.queue.drain();
        return applied;
    }

    private float applyMixingFrom(TrackEntry to, Skeleton skeleton, Animation.MixBlend blend) {
        float animationTime;
        float mix;
        TrackEntry from;
        block26: {
            boolean firstFrame;
            Array<Event> events;
            float applyTime;
            float animationLast;
            float alphaMix;
            float alphaHold;
            T[] timelines;
            int timelineCount;
            boolean drawOrder;
            boolean attachments;
            block25: {
                from = to.mixingFrom;
                if (from.mixingFrom != null) {
                    this.applyMixingFrom(from, skeleton, blend);
                }
                if (to.mixDuration == 0.0f) {
                    mix = 1.0f;
                    if (blend == Animation.MixBlend.first) {
                        blend = Animation.MixBlend.setup;
                    }
                } else {
                    mix = to.mixTime / to.mixDuration;
                    if (mix > 1.0f) {
                        mix = 1.0f;
                    }
                    if (blend != Animation.MixBlend.first) {
                        blend = from.mixBlend;
                    }
                }
                attachments = mix < from.attachmentThreshold;
                drawOrder = mix < from.drawOrderThreshold;
                timelineCount = from.animation.timelines.size;
                timelines = from.animation.timelines.items;
                alphaHold = from.alpha * to.interruptAlpha;
                alphaMix = alphaHold * (1.0f - mix);
                animationLast = from.animationLast;
                applyTime = animationTime = from.getAnimationTime();
                events = null;
                if (from.reverse) {
                    applyTime = from.animation.duration - applyTime;
                } else if (mix < from.eventThreshold) {
                    events = this.events;
                }
                if (blend != Animation.MixBlend.add) break block25;
                int i = 0;
                while (i < timelineCount) {
                    ((Animation.Timeline)timelines[i]).apply(skeleton, animationLast, applyTime, events, alphaMix, blend, Animation.MixDirection.out);
                    ++i;
                }
                break block26;
            }
            int[] timelineMode = from.timelineMode.items;
            T[] timelineHoldMix = from.timelineHoldMix.items;
            boolean bl = firstFrame = from.timelinesRotation.size != timelineCount << 1;
            if (firstFrame) {
                from.timelinesRotation.setSize(timelineCount << 1);
            }
            float[] timelinesRotation = from.timelinesRotation.items;
            from.totalAlpha = 0.0f;
            int i = 0;
            while (i < timelineCount) {
                block27: {
                    float alpha;
                    Animation.MixBlend timelineBlend;
                    Animation.Timeline timeline = (Animation.Timeline)timelines[i];
                    Animation.MixDirection direction = Animation.MixDirection.out;
                    switch (timelineMode[i]) {
                        case 0: {
                            if (drawOrder || !(timeline instanceof Animation.DrawOrderTimeline)) {
                                timelineBlend = blend;
                                alpha = alphaMix;
                                break;
                            }
                            break block27;
                        }
                        case 1: {
                            timelineBlend = Animation.MixBlend.setup;
                            alpha = alphaMix;
                            break;
                        }
                        case 2: {
                            timelineBlend = blend;
                            alpha = alphaHold;
                            break;
                        }
                        case 3: {
                            timelineBlend = Animation.MixBlend.setup;
                            alpha = alphaHold;
                            break;
                        }
                        default: {
                            timelineBlend = Animation.MixBlend.setup;
                            TrackEntry holdMix = (TrackEntry)timelineHoldMix[i];
                            alpha = alphaHold * Math.max(0.0f, 1.0f - holdMix.mixTime / holdMix.mixDuration);
                        }
                    }
                    from.totalAlpha += alpha;
                    if (timeline instanceof Animation.RotateTimeline) {
                        this.applyRotateTimeline((Animation.RotateTimeline)timeline, skeleton, applyTime, alpha, timelineBlend, timelinesRotation, i << 1, firstFrame);
                    } else if (timeline instanceof Animation.AttachmentTimeline) {
                        this.applyAttachmentTimeline((Animation.AttachmentTimeline)timeline, skeleton, applyTime, timelineBlend, attachments);
                    } else {
                        if (drawOrder && timeline instanceof Animation.DrawOrderTimeline && timelineBlend == Animation.MixBlend.setup) {
                            direction = Animation.MixDirection.in;
                        }
                        timeline.apply(skeleton, animationLast, applyTime, events, alpha, timelineBlend, direction);
                    }
                }
                ++i;
            }
        }
        if (to.mixDuration > 0.0f) {
            this.queueEvents(from, animationTime);
        }
        this.events.clear();
        from.nextAnimationLast = animationTime;
        from.nextTrackLast = from.trackTime;
        return mix;
    }

    private void applyAttachmentTimeline(Animation.AttachmentTimeline timeline, Skeleton skeleton, float time, Animation.MixBlend blend, boolean attachments) {
        Slot slot = skeleton.slots.get(timeline.slotIndex);
        if (!slot.bone.active) {
            return;
        }
        float[] frames = timeline.frames;
        if (time < frames[0]) {
            if (blend == Animation.MixBlend.setup || blend == Animation.MixBlend.first) {
                this.setAttachment(skeleton, slot, slot.data.attachmentName, attachments);
            }
        } else {
            this.setAttachment(skeleton, slot, timeline.attachmentNames[Animation.search(frames, time)], attachments);
        }
        if (slot.attachmentState <= this.unkeyedState) {
            slot.attachmentState = this.unkeyedState + 1;
        }
    }

    private void setAttachment(Skeleton skeleton, Slot slot, String attachmentName, boolean attachments) {
        slot.setAttachment(attachmentName == null ? null : skeleton.getAttachment(slot.data.index, attachmentName));
        if (attachments) {
            slot.attachmentState = this.unkeyedState + 2;
        }
    }

    private void applyRotateTimeline(Animation.RotateTimeline timeline, Skeleton skeleton, float time, float alpha, Animation.MixBlend blend, float[] timelinesRotation, int i, boolean firstFrame) {
        float total;
        float r2;
        float r1;
        if (firstFrame) {
            timelinesRotation[i] = 0.0f;
        }
        if (alpha == 1.0f) {
            timeline.apply(skeleton, 0.0f, time, null, 1.0f, blend, Animation.MixDirection.in);
            return;
        }
        Bone bone = skeleton.bones.get(timeline.boneIndex);
        if (!bone.active) {
            return;
        }
        float[] frames = timeline.frames;
        if (time < frames[0]) {
            switch (blend) {
                case setup: {
                    bone.rotation = bone.data.rotation;
                }
                default: {
                    return;
                }
                case first: 
            }
            r1 = bone.rotation;
            r2 = bone.data.rotation;
        } else {
            r1 = blend == Animation.MixBlend.setup ? bone.data.rotation : bone.rotation;
            r2 = bone.data.rotation + timeline.getCurveValue(time);
        }
        float diff = r2 - r1;
        diff -= (float)((16384 - (int)(16384.499999999996 - (double)(diff / 360.0f))) * 360);
        if (diff == 0.0f) {
            total = timelinesRotation[i];
        } else {
            boolean dir;
            float lastDiff;
            float lastTotal;
            if (firstFrame) {
                lastTotal = 0.0f;
                lastDiff = diff;
            } else {
                lastTotal = timelinesRotation[i];
                lastDiff = timelinesRotation[i + 1];
            }
            boolean current = diff > 0.0f;
            boolean bl = dir = lastTotal >= 0.0f;
            if (Math.signum(lastDiff) != Math.signum(diff) && Math.abs(lastDiff) <= 90.0f) {
                if (Math.abs(lastTotal) > 180.0f) {
                    lastTotal += 360.0f * Math.signum(lastTotal);
                }
                dir = current;
            }
            total = diff + lastTotal - lastTotal % 360.0f;
            if (dir != current) {
                total += 360.0f * Math.signum(lastTotal);
            }
            timelinesRotation[i] = total;
        }
        timelinesRotation[i + 1] = diff;
        bone.rotation = r1 + total * alpha;
    }

    private void queueEvents(TrackEntry entry, float animationTime) {
        boolean complete;
        float animationStart = entry.animationStart;
        float animationEnd = entry.animationEnd;
        float duration = animationEnd - animationStart;
        float trackLastWrapped = entry.trackLast % duration;
        T[] events = this.events.items;
        int i = 0;
        int n = this.events.size;
        while (i < n) {
            Event event = (Event)events[i];
            if (event.time < trackLastWrapped) break;
            if (!(event.time > animationEnd)) {
                this.queue.event(entry, event);
            }
            ++i;
        }
        if (entry.loop) {
            complete = duration == 0.0f || trackLastWrapped > entry.trackTime % duration;
        } else {
            boolean bl = complete = animationTime >= animationEnd && entry.animationLast < animationEnd;
        }
        if (complete) {
            this.queue.complete(entry);
        }
        while (i < n) {
            Event event = (Event)events[i];
            if (!(event.time < animationStart)) {
                this.queue.event(entry, event);
            }
            ++i;
        }
    }

    public void clearTracks() {
        boolean oldDrainDisabled = this.queue.drainDisabled;
        this.queue.drainDisabled = true;
        int i = 0;
        int n = this.tracks.size;
        while (i < n) {
            this.clearTrack(i);
            ++i;
        }
        this.tracks.clear();
        this.queue.drainDisabled = oldDrainDisabled;
        this.queue.drain();
    }

    public void clearTrack(int trackIndex) {
        TrackEntry from;
        if (trackIndex < 0) {
            throw new IllegalArgumentException("trackIndex must be >= 0.");
        }
        if (trackIndex >= this.tracks.size) {
            return;
        }
        TrackEntry current = this.tracks.get(trackIndex);
        if (current == null) {
            return;
        }
        this.queue.end(current);
        this.disposeNext(current);
        TrackEntry entry = current;
        while ((from = entry.mixingFrom) != null) {
            this.queue.end(from);
            entry.mixingFrom = null;
            entry.mixingTo = null;
            entry = from;
        }
        this.tracks.set(current.trackIndex, null);
        this.queue.drain();
    }

    public void clearNext(TrackEntry entry) {
        this.disposeNext(entry.next);
    }

    private void setCurrent(int index, TrackEntry current, boolean interrupt) {
        TrackEntry from = this.expandToIndex(index);
        this.tracks.set(index, current);
        current.previous = null;
        if (from != null) {
            if (interrupt) {
                this.queue.interrupt(from);
            }
            current.mixingFrom = from;
            from.mixingTo = current;
            current.mixTime = 0.0f;
            if (from.mixingFrom != null && from.mixDuration > 0.0f) {
                current.interruptAlpha *= Math.min(1.0f, from.mixTime / from.mixDuration);
            }
            from.timelinesRotation.clear();
        }
        this.queue.start(current);
    }

    public TrackEntry setAnimation(int trackIndex, String animationName, boolean loop) {
        Animation animation = this.data.skeletonData.findAnimation(animationName);
        if (animation == null) {
            throw new IllegalArgumentException("Animation not found: " + animationName);
        }
        return this.setAnimation(trackIndex, animation, loop);
    }

    public TrackEntry setAnimation(int trackIndex, Animation animation, boolean loop) {
        if (trackIndex < 0) {
            throw new IllegalArgumentException("trackIndex must be >= 0.");
        }
        if (animation == null) {
            throw new IllegalArgumentException("animation cannot be null.");
        }
        boolean interrupt = true;
        TrackEntry current = this.expandToIndex(trackIndex);
        if (current != null) {
            if (current.nextTrackLast == -1.0f) {
                this.tracks.set(trackIndex, current.mixingFrom);
                this.queue.interrupt(current);
                this.queue.end(current);
                this.disposeNext(current);
                current = current.mixingFrom;
                interrupt = false;
            } else {
                this.disposeNext(current);
            }
        }
        TrackEntry entry = this.trackEntry(trackIndex, animation, loop, current);
        this.setCurrent(trackIndex, entry, interrupt);
        this.queue.drain();
        return entry;
    }

    public TrackEntry addAnimation(int trackIndex, String animationName, boolean loop, float delay) {
        Animation animation = this.data.skeletonData.findAnimation(animationName);
        if (animation == null) {
            throw new IllegalArgumentException("Animation not found: " + animationName);
        }
        return this.addAnimation(trackIndex, animation, loop, delay);
    }

    public TrackEntry addAnimation(int trackIndex, Animation animation, boolean loop, float delay) {
        if (trackIndex < 0) {
            throw new IllegalArgumentException("trackIndex must be >= 0.");
        }
        if (animation == null) {
            throw new IllegalArgumentException("animation cannot be null.");
        }
        TrackEntry last = this.expandToIndex(trackIndex);
        if (last != null) {
            while (last.next != null) {
                last = last.next;
            }
        }
        TrackEntry entry = this.trackEntry(trackIndex, animation, loop, last);
        if (last == null) {
            this.setCurrent(trackIndex, entry, true);
            this.queue.drain();
        } else {
            last.next = entry;
            entry.previous = last;
            if (delay <= 0.0f) {
                delay += last.getTrackComplete() - entry.mixDuration;
            }
        }
        entry.delay = delay;
        return entry;
    }

    public TrackEntry setEmptyAnimation(int trackIndex, float mixDuration) {
        TrackEntry entry = this.setAnimation(trackIndex, emptyAnimation, false);
        entry.mixDuration = mixDuration;
        entry.trackEnd = mixDuration;
        return entry;
    }

    public TrackEntry addEmptyAnimation(int trackIndex, float mixDuration, float delay) {
        TrackEntry entry = this.addAnimation(trackIndex, emptyAnimation, false, delay <= 0.0f ? 1.0f : delay);
        entry.mixDuration = mixDuration;
        entry.trackEnd = mixDuration;
        if (delay <= 0.0f && entry.previous != null) {
            entry.delay = entry.previous.getTrackComplete() - entry.mixDuration;
        }
        return entry;
    }

    public void setEmptyAnimations(float mixDuration) {
        boolean oldDrainDisabled = this.queue.drainDisabled;
        this.queue.drainDisabled = true;
        T[] tracks = this.tracks.items;
        int i = 0;
        int n = this.tracks.size;
        while (i < n) {
            TrackEntry current = (TrackEntry)tracks[i];
            if (current != null) {
                this.setEmptyAnimation(current.trackIndex, mixDuration);
            }
            ++i;
        }
        this.queue.drainDisabled = oldDrainDisabled;
        this.queue.drain();
    }

    private TrackEntry expandToIndex(int index) {
        if (index < this.tracks.size) {
            return this.tracks.get(index);
        }
        this.tracks.ensureCapacity(index - this.tracks.size + 1);
        this.tracks.size = index + 1;
        return null;
    }

    private TrackEntry trackEntry(int trackIndex, Animation animation, boolean loop, @Null TrackEntry last) {
        TrackEntry entry = this.trackEntryPool.obtain();
        entry.trackIndex = trackIndex;
        entry.animation = animation;
        entry.loop = loop;
        entry.holdPrevious = false;
        entry.eventThreshold = 0.0f;
        entry.attachmentThreshold = 0.0f;
        entry.drawOrderThreshold = 0.0f;
        entry.animationStart = 0.0f;
        entry.animationEnd = animation.getDuration();
        entry.animationLast = -1.0f;
        entry.nextAnimationLast = -1.0f;
        entry.delay = 0.0f;
        entry.trackTime = 0.0f;
        entry.trackLast = -1.0f;
        entry.nextTrackLast = -1.0f;
        entry.trackEnd = Float.MAX_VALUE;
        entry.timeScale = 1.0f;
        entry.alpha = 1.0f;
        entry.interruptAlpha = 1.0f;
        entry.mixTime = 0.0f;
        entry.mixDuration = last == null ? 0.0f : this.data.getMix(last.animation, animation);
        return entry;
    }

    private void disposeNext(TrackEntry entry) {
        TrackEntry next = entry.next;
        while (next != null) {
            this.queue.dispose(next);
            next = next.next;
        }
        entry.next = null;
    }

    /*
     * Unable to fully structure code
     */
    void animationsChanged() {
        this.animationsChanged = false;
        this.propertyIds.clear(2048);
        n = this.tracks.size;
        tracks = this.tracks.items;
        i = 0;
        while (i < n) {
            block3: {
                entry = (TrackEntry)tracks[i];
                if (entry != null) ** GOTO lbl11
                break block3;
lbl-1000:
                // 1 sources

                {
                    entry = entry.mixingFrom;
lbl11:
                    // 2 sources

                    ** while (entry.mixingFrom != null)
                }
lbl12:
                // 1 sources

                do {
                    if (entry.mixingTo != null && entry.mixBlend == Animation.MixBlend.add) continue;
                    this.computeHold(entry);
                } while ((entry = entry.mixingTo) != null);
            }
            ++i;
        }
    }

    private void computeHold(TrackEntry entry) {
        TrackEntry to = entry.mixingTo;
        T[] timelines = entry.animation.timelines.items;
        int timelinesCount = entry.animation.timelines.size;
        int[] timelineMode = entry.timelineMode.setSize(timelinesCount);
        entry.timelineHoldMix.clear();
        TrackEntry[] timelineHoldMix = entry.timelineHoldMix.setSize(timelinesCount);
        ObjectSet<String> propertyIds = this.propertyIds;
        if (to != null && to.holdPrevious) {
            int i = 0;
            while (i < timelinesCount) {
                timelineMode[i] = propertyIds.addAll((String[])((Animation.Timeline)timelines[i]).getPropertyIds()) ? 3 : 2;
                ++i;
            }
            return;
        }
        int i = 0;
        while (i < timelinesCount) {
            block9: {
                Animation.Timeline timeline = (Animation.Timeline)timelines[i];
                String[] ids = timeline.getPropertyIds();
                if (!propertyIds.addAll((String[])ids)) {
                    timelineMode[i] = 0;
                } else if (to == null || timeline instanceof Animation.AttachmentTimeline || timeline instanceof Animation.DrawOrderTimeline || timeline instanceof Animation.EventTimeline || !to.animation.hasTimeline(ids)) {
                    timelineMode[i] = 1;
                } else {
                    TrackEntry next = to.mixingTo;
                    while (next != null) {
                        if (!next.animation.hasTimeline(ids)) {
                            if (!(next.mixDuration > 0.0f)) break;
                            timelineMode[i] = 4;
                            timelineHoldMix[i] = next;
                            break block9;
                        }
                        next = next.mixingTo;
                    }
                    timelineMode[i] = 3;
                }
            }
            ++i;
        }
    }

    @Null
    public TrackEntry getCurrent(int trackIndex) {
        if (trackIndex < 0) {
            throw new IllegalArgumentException("trackIndex must be >= 0.");
        }
        if (trackIndex >= this.tracks.size) {
            return null;
        }
        return this.tracks.get(trackIndex);
    }

    public void addListener(AnimationStateListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null.");
        }
        this.listeners.add(listener);
    }

    public void removeListener(AnimationStateListener listener) {
        this.listeners.removeValue(listener, true);
    }

    public void clearListeners() {
        this.listeners.clear();
    }

    public void clearListenerNotifications() {
        this.queue.clear();
    }

    public float getTimeScale() {
        return this.timeScale;
    }

    public void setTimeScale(float timeScale) {
        this.timeScale = timeScale;
    }

    public AnimationStateData getData() {
        return this.data;
    }

    public void setData(AnimationStateData data) {
        if (data == null) {
            throw new IllegalArgumentException("data cannot be null.");
        }
        this.data = data;
    }

    public Array<TrackEntry> getTracks() {
        return this.tracks;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(64);
        T[] tracks = this.tracks.items;
        int i = 0;
        int n = this.tracks.size;
        while (i < n) {
            TrackEntry entry = (TrackEntry)tracks[i];
            if (entry != null) {
                if (buffer.length() > 0) {
                    buffer.append(", ");
                }
                buffer.append(entry.toString());
            }
            ++i;
        }
        if (buffer.length() == 0) {
            return "<none>";
        }
        return buffer.toString();
    }

    public static abstract class AnimationStateAdapter
    implements AnimationStateListener {
        @Override
        public void start(TrackEntry entry) {
        }

        @Override
        public void interrupt(TrackEntry entry) {
        }

        @Override
        public void end(TrackEntry entry) {
        }

        @Override
        public void dispose(TrackEntry entry) {
        }

        @Override
        public void complete(TrackEntry entry) {
        }

        @Override
        public void event(TrackEntry entry, Event event) {
        }
    }

    public static interface AnimationStateListener {
        public void start(TrackEntry var1);

        public void interrupt(TrackEntry var1);

        public void end(TrackEntry var1);

        public void dispose(TrackEntry var1);

        public void complete(TrackEntry var1);

        public void event(TrackEntry var1, Event var2);
    }

    class EventQueue {
        private final Array objects = new Array();
        boolean drainDisabled;

        EventQueue() {
        }

        void start(TrackEntry entry) {
            this.objects.add(EventType.start);
            this.objects.add(entry);
            AnimationState.this.animationsChanged = true;
        }

        void interrupt(TrackEntry entry) {
            this.objects.add(EventType.interrupt);
            this.objects.add(entry);
        }

        void end(TrackEntry entry) {
            this.objects.add(EventType.end);
            this.objects.add(entry);
            AnimationState.this.animationsChanged = true;
        }

        void dispose(TrackEntry entry) {
            this.objects.add(EventType.dispose);
            this.objects.add(entry);
        }

        void complete(TrackEntry entry) {
            this.objects.add(EventType.complete);
            this.objects.add(entry);
        }

        void event(TrackEntry entry, Event event) {
            this.objects.add(EventType.event);
            this.objects.add(entry);
            this.objects.add(event);
        }

        void drain() {
            if (this.drainDisabled) {
                return;
            }
            this.drainDisabled = true;
            SnapshotArray<AnimationStateListener> listenersArray = AnimationState.this.listeners;
            int i = 0;
            while (i < this.objects.size) {
                EventType type = (EventType)((Object)this.objects.get(i));
                TrackEntry entry = (TrackEntry)this.objects.get(i + 1);
                int listenersCount = listenersArray.size;
                AnimationStateListener[] listeners = listenersArray.begin();
                switch (type) {
                    case start: {
                        if (entry.listener != null) {
                            entry.listener.start(entry);
                        }
                        int ii = 0;
                        while (ii < listenersCount) {
                            listeners[ii].start(entry);
                            ++ii;
                        }
                        break;
                    }
                    case interrupt: {
                        if (entry.listener != null) {
                            entry.listener.interrupt(entry);
                        }
                        int ii = 0;
                        while (ii < listenersCount) {
                            listeners[ii].interrupt(entry);
                            ++ii;
                        }
                        break;
                    }
                    case end: {
                        if (entry.listener != null) {
                            entry.listener.end(entry);
                        }
                        int ii = 0;
                        while (ii < listenersCount) {
                            listeners[ii].end(entry);
                            ++ii;
                        }
                    }
                    case dispose: {
                        if (entry.listener != null) {
                            entry.listener.dispose(entry);
                        }
                        int ii = 0;
                        while (ii < listenersCount) {
                            listeners[ii].dispose(entry);
                            ++ii;
                        }
                        AnimationState.this.trackEntryPool.free(entry);
                        break;
                    }
                    case complete: {
                        if (entry.listener != null) {
                            entry.listener.complete(entry);
                        }
                        int ii = 0;
                        while (ii < listenersCount) {
                            listeners[ii].complete(entry);
                            ++ii;
                        }
                        break;
                    }
                    case event: {
                        Event event = (Event)this.objects.get(i++ + 2);
                        if (entry.listener != null) {
                            entry.listener.event(entry, event);
                        }
                        int ii = 0;
                        while (ii < listenersCount) {
                            listeners[ii].event(entry, event);
                            ++ii;
                        }
                        break;
                    }
                }
                listenersArray.end();
                i += 2;
            }
            this.clear();
            this.drainDisabled = false;
        }

        void clear() {
            this.objects.clear();
        }
    }

    private static enum EventType {
        start,
        interrupt,
        end,
        dispose,
        complete,
        event;

    }

    public static class TrackEntry
    implements Pool.Poolable {
        Animation animation;
        @Null
        TrackEntry previous;
        @Null
        TrackEntry next;
        @Null
        TrackEntry mixingFrom;
        @Null
        TrackEntry mixingTo;
        @Null
        AnimationStateListener listener;
        int trackIndex;
        boolean loop;
        boolean holdPrevious;
        boolean reverse;
        float eventThreshold;
        float attachmentThreshold;
        float drawOrderThreshold;
        float animationStart;
        float animationEnd;
        float animationLast;
        float nextAnimationLast;
        float delay;
        float trackTime;
        float trackLast;
        float nextTrackLast;
        float trackEnd;
        float timeScale;
        float alpha;
        float mixTime;
        float mixDuration;
        float interruptAlpha;
        float totalAlpha;
        Animation.MixBlend mixBlend = Animation.MixBlend.replace;
        final IntArray timelineMode = new IntArray();
        final Array<TrackEntry> timelineHoldMix = new Array();
        final FloatArray timelinesRotation = new FloatArray();

        @Override
        public void reset() {
            this.previous = null;
            this.next = null;
            this.mixingFrom = null;
            this.mixingTo = null;
            this.animation = null;
            this.listener = null;
            this.timelineMode.clear();
            this.timelineHoldMix.clear();
            this.timelinesRotation.clear();
        }

        public int getTrackIndex() {
            return this.trackIndex;
        }

        public Animation getAnimation() {
            return this.animation;
        }

        public void setAnimation(Animation animation) {
            if (animation == null) {
                throw new IllegalArgumentException("animation cannot be null.");
            }
            this.animation = animation;
        }

        public boolean getLoop() {
            return this.loop;
        }

        public void setLoop(boolean loop) {
            this.loop = loop;
        }

        public float getDelay() {
            return this.delay;
        }

        public void setDelay(float delay) {
            this.delay = delay;
        }

        public float getTrackTime() {
            return this.trackTime;
        }

        public void setTrackTime(float trackTime) {
            this.trackTime = trackTime;
        }

        public float getTrackEnd() {
            return this.trackEnd;
        }

        public void setTrackEnd(float trackEnd) {
            this.trackEnd = trackEnd;
        }

        public float getTrackComplete() {
            float duration = this.animationEnd - this.animationStart;
            if (duration != 0.0f) {
                if (this.loop) {
                    return duration * (float)(1 + (int)(this.trackTime / duration));
                }
                if (this.trackTime < duration) {
                    return duration;
                }
            }
            return this.trackTime;
        }

        public float getAnimationStart() {
            return this.animationStart;
        }

        public void setAnimationStart(float animationStart) {
            this.animationStart = animationStart;
        }

        public float getAnimationEnd() {
            return this.animationEnd;
        }

        public void setAnimationEnd(float animationEnd) {
            this.animationEnd = animationEnd;
        }

        public float getAnimationLast() {
            return this.animationLast;
        }

        public void setAnimationLast(float animationLast) {
            this.animationLast = animationLast;
            this.nextAnimationLast = animationLast;
        }

        public float getAnimationTime() {
            if (this.loop) {
                float duration = this.animationEnd - this.animationStart;
                if (duration == 0.0f) {
                    return this.animationStart;
                }
                return this.trackTime % duration + this.animationStart;
            }
            return Math.min(this.trackTime + this.animationStart, this.animationEnd);
        }

        public float getTimeScale() {
            return this.timeScale;
        }

        public void setTimeScale(float timeScale) {
            this.timeScale = timeScale;
        }

        @Null
        public AnimationStateListener getListener() {
            return this.listener;
        }

        public void setListener(@Null AnimationStateListener listener) {
            this.listener = listener;
        }

        public float getAlpha() {
            return this.alpha;
        }

        public void setAlpha(float alpha) {
            this.alpha = alpha;
        }

        public float getEventThreshold() {
            return this.eventThreshold;
        }

        public void setEventThreshold(float eventThreshold) {
            this.eventThreshold = eventThreshold;
        }

        public float getAttachmentThreshold() {
            return this.attachmentThreshold;
        }

        public void setAttachmentThreshold(float attachmentThreshold) {
            this.attachmentThreshold = attachmentThreshold;
        }

        public float getDrawOrderThreshold() {
            return this.drawOrderThreshold;
        }

        public void setDrawOrderThreshold(float drawOrderThreshold) {
            this.drawOrderThreshold = drawOrderThreshold;
        }

        @Null
        public TrackEntry getNext() {
            return this.next;
        }

        @Null
        public TrackEntry getPrevious() {
            return this.previous;
        }

        public boolean isComplete() {
            return this.trackTime >= this.animationEnd - this.animationStart;
        }

        public float getMixTime() {
            return this.mixTime;
        }

        public void setMixTime(float mixTime) {
            this.mixTime = mixTime;
        }

        public float getMixDuration() {
            return this.mixDuration;
        }

        public void setMixDuration(float mixDuration) {
            this.mixDuration = mixDuration;
        }

        public Animation.MixBlend getMixBlend() {
            return this.mixBlend;
        }

        public void setMixBlend(Animation.MixBlend mixBlend) {
            if (mixBlend == null) {
                throw new IllegalArgumentException("mixBlend cannot be null.");
            }
            this.mixBlend = mixBlend;
        }

        @Null
        public TrackEntry getMixingFrom() {
            return this.mixingFrom;
        }

        @Null
        public TrackEntry getMixingTo() {
            return this.mixingTo;
        }

        public void setHoldPrevious(boolean holdPrevious) {
            this.holdPrevious = holdPrevious;
        }

        public boolean getHoldPrevious() {
            return this.holdPrevious;
        }

        public void resetRotationDirections() {
            this.timelinesRotation.clear();
        }

        public void setReverse(boolean reverse) {
            this.reverse = reverse;
        }

        public boolean getReverse() {
            return this.reverse;
        }

        public String toString() {
            return this.animation == null ? "<none>" : this.animation.name;
        }
    }
}

