/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.gloomhavenhelper;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.PerspectiveCamera;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.Array;
import com.esotericsoftware.gloomhavenhelper.App;
import com.esotericsoftware.gloomhavenhelper.DeckDialog;
import com.esotericsoftware.gloomhavenhelper.MonsterRow;
import com.esotericsoftware.gloomhavenhelper.model.Condition;
import com.esotericsoftware.gloomhavenhelper.model.Line;
import com.esotericsoftware.gloomhavenhelper.model.MonsterAbility;
import com.esotericsoftware.gloomhavenhelper.model.MonsterAbilityDeck;
import com.esotericsoftware.gloomhavenhelper.model.MonsterStats;
import com.esotericsoftware.gloomhavenhelper.model.MonsterType;
import com.esotericsoftware.gloomhavenhelper.util.Actor3D;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MonsterAbilityCard
extends Actor {
    public static final Pattern statsPattern = Pattern.compile("!?\\^?%(move|attack|range|shield|retaliate)% ([+-]) ([0-9]+).*");
    private static final GlyphLayout layout = new GlyphLayout();
    final MonsterRow row;
    private final Drawable frontDrawable = App.skin.getDrawable("psd/monsterAbility-front");
    private final Drawable backDrawable = App.skin.getDrawable("psd/monsterAbility-back");
    private final Drawable shuffleDrawable = App.skin.getDrawable("abilities/shuffle");
    private final Drawable curseDrawable = App.skin.getDrawable("abilities/curse-medium");
    private final Array<Condition> attackConditions = new Array();
    public MonsterAbility forceAbility;

    public MonsterAbilityCard(final MonsterRow row, boolean deckDialog) {
        this.row = row;
        this.setSize(441.0f, 209.0f);
        if (deckDialog) {
            this.addListener(new ClickListener(){

                @Override
                public void clicked(InputEvent event, float x, float y) {
                    new DeckDialog.MonsterAbilityDeckDialog(row).show();
                }
            });
        }
    }

    @Override
    public void draw(Batch batch, float a) {
        MonsterAbilityDeck deck = App.state.getAbilityDeck(this.row.data.deckID);
        batch.setColor(1.0f, 1.0f, 1.0f, a);
        if (deck.shownAbility == null && this.forceAbility == null || !App.state.abilityCards) {
            this.backDrawable.draw(batch, this.x(0.0f), this.y(209.0f), 441.0f, 209.0f);
            if (App.state.abilityCards) {
                App.plainMediumOutline.setColor(App.c(App.lightGray, a));
                App.plainMediumOutline.draw(batch, Integer.toString(deck.abilities.size), this.getX() + 434.0f, this.getY() + 27.0f, 0.0f, 16, false);
            }
        } else {
            MonsterAbility ability;
            this.frontDrawable.draw(batch, this.x(0.0f), this.y(209.0f), 441.0f, 209.0f);
            MonsterAbility monsterAbility = ability = this.forceAbility != null ? this.forceAbility : this.row.ability;
            if (ability == null) {
                return;
            }
            if (App.config.abilityNumbers) {
                App.plainSmallOutline.setColor(App.c(App.lightGray, a));
                App.plainSmallOutline.draw(batch, ability.number, this.x(8.0f), this.y(184.0f));
            }
            App.fancyExtraLargeOutlineNumbers.setColor(1.0f, 1.0f, 1.0f, a);
            App.fancyExtraLargeOutlineNumbers.draw(batch, ability.initiativeString, this.x(33.0f), this.y(18.0f), 0.0f, 1, false);
            boolean hasElite = this.row.hasElite();
            boolean hasNormal = this.row.hasNormal();
            if (this.forceAbility != null && App.state.trackStandees) {
                hasElite = true;
                hasNormal = true;
            }
            float x = this.getX();
            float y = this.getY();
            Line.loadAbilityLines(ability);
            boolean normalOnly = false;
            boolean eliteOnly = false;
            for (Line line : ability.lines) {
                if (App.state.calculateStats && (hasElite || hasNormal)) {
                    if (line.line.equals("NORMAL:")) {
                        normalOnly = true;
                        eliteOnly = false;
                    } else if (line.line.equals("ELITE:")) {
                        eliteOnly = true;
                        normalOnly = false;
                    } else {
                        Matcher matcher = null;
                        try {
                            matcher = statsPattern.matcher(line.line);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        if (matcher != null && matcher.matches()) {
                            String name = matcher.group(1);
                            if (ability.id != 171 || !name.equals("shield")) {
                                try {
                                    int amount = App.parseInt(matcher.group(3));
                                }
                                catch (NumberFormatException ignored) {
                                    continue;
                                }
                                if (this.drawCalculatedStat(batch, a, x, y, name, amount *= matcher.group(2).charAt(0) == '-' ? -1 : 1, line, hasNormal && !eliteOnly, hasElite && !normalOnly)) continue;
                            }
                        } else if (line.line.endsWith(" ")) {
                            eliteOnly = false;
                            normalOnly = false;
                        }
                    }
                }
                line.draw(batch, x, y, this.row.data, a);
            }
            if (ability.shuffle) {
                this.shuffleDrawable.draw(batch, this.x(400.0f), this.y(196.0f), this.shuffleDrawable.getMinWidth(), this.shuffleDrawable.getMinHeight());
            }
        }
    }

    private boolean drawCalculatedStat(Batch batch, float a, float x, float y, String name, int amount, Line line, boolean hasNormal, boolean hasElite) {
        float textX;
        line.parts.get(0).draw(batch, line, x, y, this.row.data, a);
        line.parts.get(1).draw(batch, line, x, y, this.row.data, a);
        Line.LinePart numberPart = line.parts.get(2);
        float startX = textX = x + line.x + numberPart.x + 3.0f;
        float textY = y + line.y;
        try {
            if (this.row.data.isBoss()) {
                if (hasNormal) {
                    int value = this.statValue(name, MonsterType.boss, amount);
                    textX = this.drawStat(name, MonsterType.boss, value, batch, line.font, Color.WHITE, textX, textY, "", a);
                }
            } else {
                int elite;
                int normal = hasNormal ? this.statValue(name, MonsterType.normal, amount) : 0;
                int n = elite = hasElite ? this.statValue(name, MonsterType.elite, amount) : 0;
                if (hasNormal) {
                    textX = this.drawStat(name, MonsterType.normal, normal, batch, line.font, Color.WHITE, textX, textY, hasElite ? " /" : "", a);
                    if (hasElite) {
                        textX += 5.0f;
                    }
                }
                if (hasElite) {
                    textX = this.drawStat(name, MonsterType.elite, elite, batch, line.font, App.eliteGold, textX, textY, "", a);
                }
            }
            if (line.parts.size > 3) {
                float width = textX - startX;
                textX = x + numberPart.x + width + 5.0f;
                if (line.parts.get(3) instanceof Line.RegionPart) {
                    textX += 11.0f;
                }
                int i = 3;
                int n = line.parts.size;
                while (i < n) {
                    Line.LinePart part = line.parts.get(i);
                    float partX = textX - part.x;
                    partX = Math.min(partX, x - line.x + 435.0f - part.x - part.width + part.space);
                    part.draw(batch, line, partX, y, this.row.data, a);
                    textX += part.width;
                    ++i;
                }
            }
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public int statValue(String name, MonsterType type, int amount) {
        MonsterStats stats = this.row.data.stats[type.ordinal()][this.row.level];
        if (name.equals("attack")) {
            return amount + stats.attack();
        }
        String valueString = null;
        if (name.equals("move")) {
            valueString = stats.move;
        } else if (name.equals("range")) {
            valueString = stats.range;
        } else if (name.equals("shield")) {
            Line.loadAttributeLines(this.row.data, stats, type == MonsterType.elite);
            for (Line attribute : stats.attributeLines) {
                if (!attribute.line.startsWith("^%shield% ")) continue;
                valueString = attribute.line.substring(10);
                break;
            }
        } else if (name.equals("retaliate")) {
            Line.loadAttributeLines(this.row.data, stats, type == MonsterType.elite);
            for (Line attribute : stats.attributeLines) {
                if (!attribute.line.startsWith("^%retaliate% ")) continue;
                valueString = attribute.line.substring(13);
                break;
            }
        } else {
            throw new RuntimeException();
        }
        return amount + (valueString == null ? 0 : App.parseInt(valueString));
    }

    private float drawStat(String name, MonsterType type, int value, Batch batch, BitmapFont font, Color color, float textX, float textY, String extra, float a) {
        MonsterStats stats = this.row.data.stats[type.ordinal()][this.row.level];
        boolean curse = false;
        if (name.equals("attack")) {
            Line.loadAttributeLines(this.row.data, stats, type == MonsterType.elite);
            for (Line attribute : stats.attributeLines) {
                if (attribute.line.equals("^%wound%")) {
                    this.attackConditions.add(Condition.wound);
                    continue;
                }
                if (attribute.line.equals("^%disarm%")) {
                    this.attackConditions.add(Condition.disarm);
                    continue;
                }
                if (attribute.line.equals("^%immobilize%")) {
                    this.attackConditions.add(Condition.immobilize);
                    continue;
                }
                if (attribute.line.equals("^%poison%")) {
                    this.attackConditions.add(Condition.poison);
                    continue;
                }
                if (attribute.line.equals("^%muddle%")) {
                    this.attackConditions.add(Condition.muddle);
                    continue;
                }
                if (!attribute.line.equals("^%curse%")) continue;
                curse = true;
            }
        }
        font.setColor(App.c(color, a));
        textX += font.draw((Batch)batch, (CharSequence)Integer.toString((int)value), (float)textX, (float)(textY + font.getCapHeight())).width;
        if (this.attackConditions.size > 0 || curse) {
            textX += 2.0f;
        }
        for (Condition condition : this.attackConditions) {
            condition.drawableMedium.draw(batch, textX += 2.0f, textY - 6.0f, condition.drawableMedium.getMinWidth(), condition.drawableMedium.getMinHeight());
            textX += 31.0f;
        }
        if (curse) {
            this.curseDrawable.draw(batch, textX += 2.0f, textY - 6.0f, this.curseDrawable.getMinWidth(), this.curseDrawable.getMinHeight());
            textX += 31.0f;
        }
        if (this.attackConditions.size > 0 || curse) {
            textX -= 4.0f;
        }
        if (extra != null) {
            textX -= 1.0f;
            textX += font.draw((Batch)batch, (CharSequence)extra, (float)textX, (float)(textY + font.getCapHeight())).width - 2.0f;
        }
        this.attackConditions.clear();
        return textX;
    }

    private float x(float value) {
        return this.getX() + value;
    }

    private float y(float value) {
        return this.getY() + 209.0f - value;
    }

    public static class Ability3D
    extends Actor3D {
        private static final float flipDuration = 0.45f;
        private final int deckID;
        private final Actor actor;
        private float flipTime;
        private boolean front;

        public Ability3D(int deckID, Actor actor) {
            super(441, 209, 70.0f);
            this.deckID = deckID;
            this.actor = actor;
        }

        public void start(boolean front) {
            this.front = front;
            this.flipTime = 0.45f;
        }

        @Override
        public void act(float delta) {
            this.flipTime -= delta;
            if (this.flipTime < 0.0f) {
                this.remove();
                this.actor.setVisible(true);
            } else {
                Gdx.graphics.requestRendering();
            }
        }

        @Override
        public void draw(Batch batch, float parentAlpha) {
            this.setPosition(this.actor.getX(), this.actor.getY());
            Gdx.gl.glCullFace(1028);
            Gdx.gl.glEnable(2884);
            super.draw(batch, parentAlpha);
            Gdx.gl.glDisable(2884);
        }

        @Override
        protected void updateCamera(PerspectiveCamera camera, float x, float y, float w, float h) {
            float a;
            float percent = Interpolation.slowFast.apply(1.0f - this.flipTime / 0.45f);
            camera.update(true);
            camera.combined.translate(x + w / 2.0f, y + h / 2.0f, -camera.position.z);
            if (percent < 0.5f) {
                a = percent / 0.5f;
                float s = 1.0f + 0.3f * a;
                camera.combined.scale(s, s, s);
            } else {
                a = (percent - 0.5f) / 0.5f;
                float s = 1.3f - 0.3f * a;
                camera.combined.scale(s, s, s);
            }
            boolean shown = App.state.getAbilityDeck((int)this.deckID).shownAbility != null;
            camera.combined.rotate(App.v3.set(1.0f, 0.0f, 0.0f), 180.0f * percent * (float)(shown ? -1 : 1));
            if (this.front) {
                camera.combined.scale(1.0f, -1.0f, 1.0f);
            }
            camera.combined.translate(-(x + w / 2.0f), -(y + h / 2.0f), camera.position.z);
        }
    }
}

