/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.gloomhavenhelper;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.VerticalGroup;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.DragScrollListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.BooleanArray;
import com.badlogic.gdx.utils.IntArray;
import com.esotericsoftware.gloomhavenhelper.App;
import com.esotericsoftware.gloomhavenhelper.MonsterAbilityCard;
import com.esotericsoftware.gloomhavenhelper.MonsterRow;
import com.esotericsoftware.gloomhavenhelper.model.AttackModifier;
import com.esotericsoftware.gloomhavenhelper.model.CharacterClass;
import com.esotericsoftware.gloomhavenhelper.model.MonsterAbility;
import com.esotericsoftware.gloomhavenhelper.model.MonsterAbilityDeck;
import com.esotericsoftware.gloomhavenhelper.util.Card;
import com.esotericsoftware.gloomhavenhelper.util.GloomScrollPane;
import com.esotericsoftware.gloomhavenhelper.util.Menu;
import com.esotericsoftware.gloomhavenhelper.util.builders.TextButtonBuilder;

public abstract class DeckDialog<T extends Card>
extends Table {
    Array<T> remaining;
    Array<T> discard;
    float cardWidth;
    float cardHeight;
    final VerticalGroup right = new VerticalGroup();
    Menu actions;
    final BooleanArray shown = new BooleanArray();
    float selectedX;
    float selectedY;
    float selectedW;
    float selectedH;
    Actor selected;
    DragScrollListener dragListener;
    float dragOffsetY;
    final VerticalGroup left = new VerticalGroup(){

        @Override
        public void layout() {
            float y = DeckDialog.this.selected != null ? DeckDialog.this.selected.getY() : 0.0f;
            super.layout();
            if (DeckDialog.this.selected != null && DeckDialog.this.dragListener.isDragging()) {
                DeckDialog.this.selected.setY(y);
            }
        }

        @Override
        protected void drawChildren(Batch batch, float parentAlpha) {
            super.drawChildren(batch, parentAlpha);
            if (DeckDialog.this.selected != null) {
                DeckDialog.this.getSelectedDrawable().draw(batch, DeckDialog.this.selected.getX() - DeckDialog.this.selectedX, DeckDialog.this.selected.getY() - DeckDialog.this.selectedY, DeckDialog.this.cardWidth + DeckDialog.this.selectedW, DeckDialog.this.cardHeight + DeckDialog.this.selectedH);
            }
        }
    };

    protected void show(float cardWidth, final float cardHeight, float selectedX, float selectedY, float selectedW, float selectedH, final Array<T> remaining, Array<T> discard, IntArray reveal, boolean canRemove) {
        this.cardWidth = cardWidth;
        this.cardHeight = cardHeight;
        this.selectedX = selectedX;
        this.selectedY = selectedY;
        this.selectedW = selectedW;
        this.selectedH = selectedH;
        this.remaining = remaining;
        this.discard = discard;
        this.resetRemaining();
        if (discard.isEmpty()) {
            this.right.addActor(new FixedSizeImage(this.getEmptyDrawable(), cardWidth, cardHeight));
        }
        for (Card card : discard) {
            this.right.addActor(this.newFrontActor(card));
        }
        this.left.reverse().top().space(10.0f);
        this.right.reverse().top().space(10.0f);
        GloomScrollPane leftScroll = new GloomScrollPane(new Container<VerticalGroup>(this.left).pad(17.0f, 18.0f, 15.0f, 18.0f).top()){

            @Override
            public void act(float delta) {
                float y = this.getVisualScrollY();
                super.act(delta);
                if ((y -= this.getVisualScrollY()) != 0.0f && DeckDialog.this.dragListener.isDragging()) {
                    DeckDialog.this.updateSelectedPosition(DeckDialog.this.selected.getY() - DeckDialog.this.dragOffsetY + y);
                }
            }
        };
        leftScroll.setScrollingDisabled(true, false);
        leftScroll.setForceScroll(false, true);
        leftScroll.setFlickScrollTapSquareSize(35.0f);
        GloomScrollPane rightScroll = new GloomScrollPane((Actor)new Container<VerticalGroup>(this.right).pad(17.0f, 0.0f, 15.0f, 18.0f).top());
        rightScroll.setScrollingDisabled(true, false);
        rightScroll.setForceScroll(false, true);
        rightScroll.setFlickScrollTapSquareSize(35.0f);
        Table revealButtons = new Table();
        revealButtons.defaults().space(10.0f);
        int i = 0;
        int n = reveal.size;
        while (i < n) {
            String text = reveal.get(i) == -1 ? "All" : Integer.toString(reveal.get(i));
            Button button = ((TextButtonBuilder)App.textButton(text).align(8)).create();
            button.pad(0.0f, 20.0f, 0.0f, 20.0f);
            ((TextButton)button).getLabelCell().height(80.0f);
            button.invalidate();
            revealButtons.add(button);
            ++i;
        }
        Button sendToBottomButton = ((TextButtonBuilder)App.textButton("Send to Bottom").align(8)).create();
        sendToBottomButton.pad(0.0f, 20.0f, 0.0f, 20.0f);
        ((TextButton)sendToBottomButton).getLabelCell().height(80.0f);
        sendToBottomButton.invalidate();
        sendToBottomButton.setDisabled(true);
        Button removeButton = ((TextButtonBuilder)App.textButton("Remove").align(8)).create();
        removeButton.pad(0.0f, 20.0f, 0.0f, 20.0f);
        ((TextButton)removeButton).getLabelCell().height(80.0f);
        removeButton.invalidate();
        removeButton.setDisabled(true);
        Table selectedButtons = new Table();
        selectedButtons.defaults().space(10.0f);
        selectedButtons.add(sendToBottomButton);
        if (canRemove) {
            selectedButtons.add(removeButton);
        }
        this.actions = new Menu();
        this.actions.showArrow = false;
        this.actions.padLeft(30.0f).defaults().spaceRight(15.0f);
        if (revealButtons.hasChildren()) {
            this.actions.add(new Label((CharSequence)"Reveal:", App.skin, "fancyLargeOutline", Color.WHITE)).right();
            this.actions.add(revealButtons).left().padRight(10.0f).row();
        }
        this.actions.add(new Label((CharSequence)"Selected:", App.skin, "fancyLargeOutline", Color.WHITE)).right();
        this.actions.add(selectedButtons).left().row();
        if (!(!App.gloom.hasCharacterClass(CharacterClass.Diviner) && App.gloom.hasCharacters() || App.state.canDraw)) {
            this.add(this.actions).colspan(2).padTop(12.0f).padBottom(12.0f).row();
        } else {
            this.padTop(80.0f);
        }
        Table table = new Table().background(App.skin.newDrawable("rounded-top", new Color(0.0f, 0.0f, 0.0f, 0.55f)));
        table.pad(0.0f);
        table.add(leftScroll).fill().minWidth(cardWidth);
        table.add(rightScroll).fill().minWidth(cardHeight);
        this.add(table);
        this.setBackground(App.skin.newDrawable("white", new Color(0.0f, 0.0f, 0.0f, 0.5f)));
        this.setTouchable(Touchable.enabled);
        this.setFillParent(true);
        this.getColor().a = 0.0f;
        this.addAction(Actions.fadeIn(0.3f));
        App.stage.addActor(this);
        InputListener eatTouch = new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                event.stop();
                return true;
            }
        };
        leftScroll.addListener(eatTouch);
        rightScroll.addListener(eatTouch);
        this.actions.setTouchable(Touchable.enabled);
        this.actions.addListener(eatTouch);
        this.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                DeckDialog.this.hide();
            }

            @Override
            public boolean isOver(Actor actor, float x, float y) {
                return this.inTapSquare(x, y);
            }
        });
        revealButtons.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (DeckDialog.this.shown.isEmpty()) {
                    return;
                }
                String text = ((TextButton)actor).getText().toString();
                int count = text.equals("All") ? remaining.size : Integer.valueOf(text);
                int i = 0;
                while (i < count) {
                    int index = remaining.size - 1 - i;
                    if (index < 0) break;
                    if (!DeckDialog.this.shown.get(index)) {
                        DeckDialog.this.shown.set(index, true);
                        Actor back = DeckDialog.this.left.getChild(index);
                        DeckDialog.this.left.addActorAt(back.getZIndex(), DeckDialog.this.newFrontActor((Card)remaining.get(index)));
                        back.remove();
                    }
                    ++i;
                }
            }
        });
        sendToBottomButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (DeckDialog.this.selected == null) {
                    return;
                }
                int index = DeckDialog.this.selected.getZIndex();
                if (index == -1) {
                    return;
                }
                DeckDialog.this.selected.remove();
                DeckDialog.this.left.addActorAt(0, DeckDialog.this.selected);
                remaining.insert(0, (Card)remaining.removeIndex(index));
                DeckDialog.this.shown.insert(0, DeckDialog.this.shown.removeIndex(index));
                App.state.changed();
            }
        });
        removeButton.addListener(new ChangeListener((TextButton)removeButton, remaining){
            private final /* synthetic */ TextButton val$removeButton;
            private final /* synthetic */ Array val$remaining;
            {
                this.val$removeButton = textButton;
                this.val$remaining = array;
            }

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (DeckDialog.this.selected == null) {
                    return;
                }
                int index = DeckDialog.this.selected.getZIndex();
                DeckDialog.this.selected.remove();
                DeckDialog.this.selected = null;
                this.val$removeButton.setDisabled(true);
                DeckDialog.this.shown.removeIndex(index);
                MonsterAbility card = (MonsterAbility)this.val$remaining.removeIndex(index);
                this.val$remaining.shuffle();
                App.state.removedAbilities.add(card.id);
                App.state.changed();
                DeckDialog.this.resetRemaining();
                App.toast("Hand of Destiny has shuffled");
                App.toast("the monster abilities.");
            }
        });
        this.left.addListener(new ClickListener((TextButton)sendToBottomButton, (TextButton)removeButton, leftScroll){
            private final /* synthetic */ TextButton val$sendToBottomButton;
            private final /* synthetic */ TextButton val$removeButton;
            private final /* synthetic */ ScrollPane val$leftScroll;
            {
                this.val$sendToBottomButton = textButton;
                this.val$removeButton = textButton2;
                this.val$leftScroll = scrollPane;
            }

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                if (event.getTarget() == DeckDialog.this.selected) {
                    Gdx.app.postRunnable(new Runnable(){

                        @Override
                        public void run() {
                            val$leftScroll.cancel();
                        }
                    });
                }
                return super.touchDown(event, x, y, pointer, button);
            }

            @Override
            public boolean isOver(Actor actor, float x, float y) {
                return this.inTapSquare(x, y);
            }

            @Override
            public void clicked(InputEvent event, float x, float y) {
                int index = event.getTarget().getZIndex();
                if (DeckDialog.this.shown.isEmpty()) {
                    return;
                }
                if (!DeckDialog.this.shown.get(index)) {
                    return;
                }
                DeckDialog.this.selected = DeckDialog.this.selected == event.getTarget() ? null : event.getTarget();
                this.val$sendToBottomButton.setDisabled(DeckDialog.this.selected == null);
                this.val$removeButton.setDisabled(DeckDialog.this.selected == null);
            }
        });
        this.dragListener = new DragScrollListener(leftScroll){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                if (event.getTarget() != DeckDialog.this.selected) {
                    return false;
                }
                DeckDialog.this.dragOffsetY = DeckDialog.this.selected.getY() - y;
                return super.touchDown(event, x, y, pointer, button);
            }

            @Override
            public void drag(InputEvent event, float x, float y, int pointer) {
                super.drag(event, x, y, pointer);
                DeckDialog.this.updateSelectedPosition(y);
            }

            @Override
            public void dragStop(InputEvent event, float x, float y, int pointer) {
                super.dragStop(event, x, y, pointer);
                DeckDialog.this.left.invalidate();
            }

            @Override
            protected boolean isAbove(float y) {
                return super.isAbove(y + DeckDialog.this.dragOffsetY + cardHeight);
            }

            @Override
            protected boolean isBelow(float y) {
                return super.isBelow(y + DeckDialog.this.dragOffsetY);
            }
        };
        this.left.addListener(this.dragListener);
        this.dragListener.setPadding(20.0f, 20.0f);
    }

    void hide() {
        this.addAction(Actions.sequence((Action)Actions.fadeOut(0.3f), (Action)Actions.removeActor()));
    }

    void resetRemaining() {
        this.left.clearChildren();
        this.shown.clear();
        if (this.remaining.isEmpty()) {
            this.left.addActor(new FixedSizeImage(this.getEmptyDrawable(), this.cardWidth, this.cardHeight));
        }
        for (Card card : this.remaining) {
            this.left.addActor(new FixedSizeImage(this.getBackDrawable(), this.cardWidth, this.cardHeight));
            this.shown.add(false);
        }
    }

    void updateSelectedPosition(float y) {
        this.selected.setY(y + this.dragOffsetY);
        int index = this.selected.getZIndex();
        if (index > 0) {
            Actor before = this.left.getChild(index - 1);
            if (this.selected.getY() <= before.getY()) {
                this.selected.remove();
                this.left.addActorAt(index - 1, this.selected);
                this.shown.insert(index - 1, this.shown.removeIndex(index));
                this.remaining.insert(index - 1, (Card)this.remaining.removeIndex(index));
                App.state.changed();
            }
        }
        if (index < this.remaining.size - 1) {
            Actor after = this.left.getChild(index + 1);
            if (this.selected.getTop() >= after.getY()) {
                this.selected.remove();
                this.left.addActorAt(index + 1, this.selected);
                this.shown.insert(index + 1, this.shown.removeIndex(index));
                this.remaining.insert(index + 1, (Card)this.remaining.removeIndex(index));
                App.state.changed();
            }
        }
    }

    protected abstract Drawable getEmptyDrawable();

    protected abstract Drawable getBackDrawable();

    protected abstract Actor newFrontActor(T var1);

    protected abstract Drawable getSelectedDrawable();

    public static class AttackModifierDeckDialog
    extends DeckDialog<AttackModifier> {
        Drawable back = App.drawable("attack/back", "attack/border");
        Drawable empty = App.drawable("attack/back-empty");
        Drawable selected = App.drawable("attack/selected");

        @Override
        protected Drawable getEmptyDrawable() {
            return this.empty;
        }

        @Override
        protected Drawable getBackDrawable() {
            return this.back;
        }

        @Override
        protected Actor newFrontActor(AttackModifier card) {
            return new FixedSizeImage(App.drawable("attack/" + card, "attack/border"), this.cardWidth, this.cardHeight);
        }

        @Override
        protected Drawable getSelectedDrawable() {
            return this.selected;
        }

        protected void show() {
            this.show(158.0f, 107.0f, 9.0f, 9.0f, 18.0f, 18.0f, App.state.attackModifiers, App.state.attackModifiersDiscard, IntArray.with(2, 3, 4, 5, 6, 8, 9), false);
            Button badOmenButton = ((TextButtonBuilder)App.textButton("Bad Omen" + (App.state.badOmen > 0 ? ": " + App.state.badOmen : "")).align(8)).create();
            badOmenButton.pad(0.0f, 20.0f, 0.0f, 20.0f);
            ((TextButton)badOmenButton).getLabelCell().height(80.0f);
            badOmenButton.invalidate();
            int minusOnes = App.state.count(AttackModifier.minus1, true) - 5;
            Button enfeeblingHexButton = ((TextButtonBuilder)App.textButton("Enfeebling Hex" + (minusOnes > 0 ? ": " + minusOnes : "")).align(8)).create();
            enfeeblingHexButton.pad(0.0f, 20.0f, 0.0f, 20.0f);
            ((TextButton)enfeeblingHexButton).getLabelCell().height(80.0f);
            enfeeblingHexButton.invalidate();
            Table table = new Table();
            table.add(badOmenButton).space(20.0f);
            table.add(enfeeblingHexButton);
            this.actions.add(table).colspan(2).padRight(20.0f);
            badOmenButton.addListener(new ChangeListener((TextButton)badOmenButton){
                private final /* synthetic */ TextButton val$badOmenButton;
                {
                    this.val$badOmenButton = textButton;
                }

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    App.state.badOmen = 6;
                    App.state.changed();
                    this.val$badOmenButton.setText("Bad Omen: " + App.state.badOmen);
                    App.toast("Bad Omen will be applied the");
                    App.toast("next 6 times a null is shuffled.");
                }
            });
            enfeeblingHexButton.addListener(new ChangeListener((TextButton)enfeeblingHexButton){
                private final /* synthetic */ TextButton val$enfeeblingHexButton;
                {
                    this.val$enfeeblingHexButton = textButton;
                }

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    App.state.add(AttackModifier.minus1);
                    App.state.attackModifiers.shuffle();
                    App.state.changed();
                    int minusOnes = App.state.count(AttackModifier.minus1, true) - 5;
                    this.val$enfeeblingHexButton.setText("Enfeebling Hex: " + minusOnes);
                    AttackModifierDeckDialog.this.resetRemaining();
                    App.toast("Enfeebling Hex has shuffled the");
                    App.toast("monster attack modifiers.");
                }
            });
        }
    }

    static class FixedSizeImage
    extends Image {
        private final float width;
        private final float height;

        public FixedSizeImage(Drawable drawable, float width, float height) {
            super(drawable);
            this.width = width;
            this.height = height;
        }

        @Override
        public float getPrefWidth() {
            return this.width;
        }

        @Override
        public float getPrefHeight() {
            return this.height;
        }
    }

    public static class MonsterAbilityDeckDialog
    extends DeckDialog<MonsterAbility> {
        final MonsterRow row;
        final Drawable back = App.drawable("psd/monsterAbility-back");
        final Drawable empty = App.drawable("monsterAbility-back-empty");
        final Drawable selected = App.drawable("monsterAbility-selected");

        public MonsterAbilityDeckDialog(MonsterRow row) {
            this.row = row;
        }

        @Override
        protected Drawable getEmptyDrawable() {
            return this.empty;
        }

        @Override
        protected Drawable getBackDrawable() {
            return this.back;
        }

        @Override
        protected Actor newFrontActor(MonsterAbility ability) {
            MonsterAbilityCard card = new MonsterAbilityCard(this.row, false);
            card.forceAbility = ability;
            return card;
        }

        @Override
        protected Drawable getSelectedDrawable() {
            return this.selected;
        }

        public void show() {
            MonsterAbilityDeck deck = this.row.getAbilityDeck();
            Array<MonsterAbility> discard = new Array<MonsterAbility>(deck.abilitiesDiscard);
            IntArray reveal = new IntArray();
            if (this.row.data.isBoss()) {
                reveal.add(2, 3);
            } else {
                reveal.add(1, 2, 3, 4);
                reveal.add(5);
            }
            reveal.add(-1);
            this.show(441.0f, 209.0f, 18.0f, 15.0f, 36.0f, 34.0f, deck.abilities, discard, reveal, true);
        }
    }
}

