/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.spi.orbutil.codegen;

import com.sun.corba.ee.spi.orbutil.codegen.ClassInfo;
import com.sun.corba.ee.spi.orbutil.codegen.InterceptorContext;
import com.sun.corba.ee.spi.orbutil.codegen.MethodInfo;
import com.sun.corba.ee.spi.orbutil.codegen.Signature;
import com.sun.corba.ee.spi.orbutil.codegen.Type;
import java.lang.reflect.Constructor;
import java.util.ArrayList;

public class GenericClass<T> {
    private Type implType;
    private ClassInfo implClassInfo;
    private Class<T> typeClass;
    private Constructor constructor;

    public GenericClass(Class<T> type, InterceptorContext ic, byte[] classData) {
        throw new IllegalArgumentException("Not supported yet");
    }

    public GenericClass(Class<T> type, Class<?> cls) {
        if (!type.isAssignableFrom(cls)) {
            throw new IllegalArgumentException("Class " + cls.getName() + " is not a subclass of " + type.getName());
        }
        this.implType = Type.type(cls);
        this.implClassInfo = this.implType.classInfo();
        this.typeClass = type;
    }

    private synchronized Constructor getConstructor(Object ... args) {
        if (this.constructor == null) {
            ArrayList<Type> atypes = new ArrayList<Type>();
            for (Object arg : args) {
                Type type = Type._null();
                if (arg != null) {
                    Class<?> cls = arg.getClass();
                    type = Type.type(cls);
                }
                atypes.add(type);
            }
            Signature sig = Signature.fromConstructorUsingTypes(this.implType, atypes);
            MethodInfo minfo = this.implClassInfo.findConstructorInfo(sig);
            this.constructor = minfo.getConstructor();
        }
        return this.constructor;
    }

    private synchronized Constructor clearAndGetConstructor(Object ... args) {
        this.constructor = null;
        return this.getConstructor(args);
    }

    public T create(Object ... args) {
        try {
            try {
                return this.typeClass.cast(this.getConstructor(new Object[0]).newInstance(args));
            }
            catch (IllegalArgumentException argexc) {
                return this.typeClass.cast(this.clearAndGetConstructor(args).newInstance(args));
            }
        }
        catch (Exception exc) {
            throw new IllegalArgumentException("Could not construct instance of class " + this.implType.name(), exc);
        }
    }
}

