/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.orbutil.copyobject;

import java.util.AbstractMap;
import java.util.Map;
import java.util.Set;

public class FastCache<K, V>
extends AbstractMap<K, V> {
    public static final int TABLE_SIZE = 256;
    private Map<K, V> map;
    private Object[] keys = new Object[256];
    private Object[] values = new Object[256];
    private long cacheCount = 0L;
    private long totalCount = 0L;

    public long getCacheCount() {
        return this.cacheCount;
    }

    public long getTotalCount() {
        return this.totalCount;
    }

    public FastCache(Map<K, V> map) {
        this.map = map;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }

    private int hash(Object key) {
        int hv = System.identityHashCode(key);
        return hv & 0xFF;
    }

    @Override
    public V get(Object key) {
        ++this.totalCount;
        int slot = this.hash(key);
        Object ckey = this.keys[slot];
        if (ckey == key) {
            ++this.cacheCount;
            return (V)this.values[slot];
        }
        V result = this.map.get(key);
        this.keys[slot] = key;
        this.values[slot] = result;
        return result;
    }

    @Override
    public V put(K key, V value) {
        int slot = this.hash(key);
        this.keys[slot] = key;
        this.values[slot] = value;
        return this.map.put(key, value);
    }
}

