/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.jms.tx.log;

import com.sun.messaging.bridge.service.jms.tx.BranchXid;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class BranchXidDecision
implements Externalizable {
    public static final int COMMIT = 0;
    public static final int ROLLBACK = 1;
    public static final int HEUR_COMMIT = 50;
    public static final int HEUR_ROLLBACK = 51;
    public static final int HEUR_MIXED = 52;
    private BranchXid _xid = null;
    private int _decision = 0;

    public BranchXidDecision() {
    }

    public BranchXidDecision(BranchXid branchXid, int n) throws Exception {
        if (n != 0 && n != 1 && n != 50 && n != 51 && n != 52) {
            throw new IllegalArgumentException("Invalid decision value: " + n);
        }
        this._xid = branchXid;
        this._decision = n;
    }

    public BranchXid getBranchXid() {
        return this._xid;
    }

    public int getBranchDecision() {
        return this._decision;
    }

    public boolean isHeuristic() {
        return this._decision == 50 || this._decision == 51 || this._decision == 52;
    }

    public void setBranchDecision(int n) {
        if (n != 0 && n != 1 && n != 50 && n != 51 && n != 52) {
            throw new IllegalArgumentException("Invalid decision value: " + n);
        }
        this._decision = n;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        this._xid.write(objectOutput);
        objectOutput.writeInt(this._decision);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this._xid = BranchXid.read(objectInput);
        this._decision = objectInput.readInt();
    }

    private static String decisionString(int n) {
        switch (n) {
            case 0: {
                return "COMMIT";
            }
            case 1: {
                return "ROLLBACK";
            }
            case 50: {
                return "HEUR_COMMIT";
            }
            case 51: {
                return "HEUR_ROLLBACK";
            }
            case 52: {
                return "HEUR_MIXED";
            }
        }
        return "UNKNOWN";
    }

    public String toString() {
        return this._xid.toString() + "(" + BranchXidDecision.decisionString(this._decision) + ")";
    }
}

