/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node;

import com.sun.enterprise.deployment.node.SaxParserHandler;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.io.InputStream;
import java.util.logging.Level;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SaxParserHandlerBundled
extends SaxParserHandler {
    private static final String BUNDLED_SCHEMA_ROOT = "/schemas";
    private static final String BUNDLED_DTD_ROOT = "/dtds";

    public InputSource resolveEntity(String publicID, String systemID) throws SAXException {
        InputSource result = null;
        try {
            if (DOLUtils.getDefaultLogger().isLoggable(Level.FINE)) {
                DOLUtils.getDefaultLogger().fine("Asked to resolve  " + publicID + " system id = " + systemID);
            }
            if (publicID == null) {
                if (systemID == null || systemID.lastIndexOf(47) == systemID.length()) {
                    return null;
                }
                InputStream is = this.openSchemaStream(systemID);
                result = is != null ? new InputSource(is) : new InputSource(systemID);
            } else if (SaxParserHandlerBundled.getMapping().containsKey(publicID)) {
                this.publicID = publicID;
                InputStream is = this.openDTDStream(publicID);
                if (is != null) {
                    result = new InputSource(is);
                }
            } else if (systemID != null) {
                InputStream is = this.openSchemaStream(systemID);
                if (is != null) {
                    result = new InputSource(is);
                }
                if ((is = this.openStream(BUNDLED_DTD_ROOT, systemID)) != null) {
                    result = new InputSource(is);
                }
            }
        }
        catch (Exception exc) {
            DOLUtils.getDefaultLogger().log(Level.SEVERE, "Error occurred", exc);
            throw new SAXException(exc);
        }
        return result;
    }

    private InputStream openSchemaStream(String systemID) {
        return this.openStream(BUNDLED_SCHEMA_ROOT, systemID);
    }

    private InputStream openDTDStream(String publicID) {
        return this.openStream(BUNDLED_DTD_ROOT, SaxParserHandlerBundled.getMapping().get(publicID));
    }

    private InputStream openStream(String localRoot, String systemID) {
        String targetID = localRoot + "/" + systemID.substring(systemID.lastIndexOf("/") + 1);
        InputStream result = this.getClass().getResourceAsStream(targetID);
        return result;
    }
}

