/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.transform;

import com.sun.xml.wss.impl.transform.NameSpaceSymbEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class NameSpaceSymbTable {
    HashMap symb = new HashMap();
    int nameSpaces = 0;
    List level = new ArrayList();
    boolean cloned = true;
    static final String XMLNS = "xmlns";

    public NameSpaceSymbTable() {
        NameSpaceSymbEntry ne = new NameSpaceSymbEntry("", null, true);
        ne.lastrendered = "";
        this.symb.put(XMLNS, ne);
    }

    public void getUnrenderedNodes(Collection result) {
        Iterator it = this.symb.entrySet().iterator();
        while (it.hasNext()) {
            NameSpaceSymbEntry n = (NameSpaceSymbEntry)it.next().getValue();
            if (n.rendered || n.n == null) continue;
            result.add(n.n);
            n.rendered = true;
        }
    }

    public void outputNodePush() {
        ++this.nameSpaces;
        this.push();
    }

    public void outputNodePop() {
        --this.nameSpaces;
        this.pop();
    }

    public void push() {
        this.level.add(null);
        this.cloned = false;
    }

    public void pop() {
        int size = this.level.size() - 1;
        Object ob = this.level.remove(size);
        if (ob != null) {
            this.symb = (HashMap)ob;
            this.cloned = size == 0 ? false : this.level.get(size - 1) != this.symb;
        } else {
            this.cloned = false;
        }
    }

    final void needsClone() {
        if (!this.cloned) {
            this.level.remove(this.level.size() - 1);
            this.level.add(this.symb);
            this.symb = (HashMap)this.symb.clone();
            this.cloned = true;
        }
    }

    public Attr getMapping(String prefix) {
        NameSpaceSymbEntry entry = (NameSpaceSymbEntry)this.symb.get(prefix);
        if (entry == null) {
            return null;
        }
        if (entry.rendered) {
            return null;
        }
        entry = (NameSpaceSymbEntry)entry.clone();
        this.needsClone();
        this.symb.put(prefix, entry);
        entry.rendered = true;
        entry.level = this.nameSpaces;
        entry.lastrendered = entry.uri;
        return entry.n;
    }

    public Attr getMappingWithoutRendered(String prefix) {
        NameSpaceSymbEntry entry = (NameSpaceSymbEntry)this.symb.get(prefix);
        if (entry == null) {
            return null;
        }
        if (entry.rendered) {
            return null;
        }
        return entry.n;
    }

    public boolean addMapping(String prefix, String uri, Attr n) {
        NameSpaceSymbEntry ob = (NameSpaceSymbEntry)this.symb.get(prefix);
        if (ob != null && uri.equals(ob.uri)) {
            return false;
        }
        NameSpaceSymbEntry ne = new NameSpaceSymbEntry(uri, n, false);
        this.needsClone();
        this.symb.put(prefix, ne);
        if (ob != null) {
            ne.lastrendered = ob.lastrendered;
            if (ob.lastrendered != null && ob.lastrendered.equals(uri)) {
                ne.rendered = true;
            }
        }
        return true;
    }

    public Node addMappingAndRender(String prefix, String uri, Attr n) {
        NameSpaceSymbEntry ob = (NameSpaceSymbEntry)this.symb.get(prefix);
        if (ob != null && uri.equals(ob.uri)) {
            if (!ob.rendered) {
                ob = (NameSpaceSymbEntry)ob.clone();
                this.needsClone();
                this.symb.put(prefix, ob);
                ob.lastrendered = uri;
                ob.rendered = true;
                return ob.n;
            }
            return null;
        }
        NameSpaceSymbEntry ne = new NameSpaceSymbEntry(uri, n, true);
        ne.lastrendered = uri;
        this.needsClone();
        this.symb.put(prefix, ne);
        if (ob != null && ob.lastrendered != null && ob.lastrendered.equals(uri)) {
            ne.rendered = true;
            return null;
        }
        return ne.n;
    }

    public Node addMappingAndRenderXNodeSet(String prefix, String uri, Attr n, boolean outputNode) {
        NameSpaceSymbEntry ob = (NameSpaceSymbEntry)this.symb.get(prefix);
        int visibleNameSpaces = this.nameSpaces;
        if (ob != null && uri.equals(ob.uri)) {
            if (!ob.rendered) {
                ob = (NameSpaceSymbEntry)ob.clone();
                this.needsClone();
                this.symb.put(prefix, ob);
                ob.rendered = true;
                ob.level = visibleNameSpaces;
                return ob.n;
            }
            ob = (NameSpaceSymbEntry)ob.clone();
            this.needsClone();
            this.symb.put(prefix, ob);
            if (outputNode && (visibleNameSpaces - ob.level < 2 || XMLNS.equals(prefix))) {
                ob.level = visibleNameSpaces;
                return null;
            }
            ob.level = visibleNameSpaces;
            return ob.n;
        }
        NameSpaceSymbEntry ne = new NameSpaceSymbEntry(uri, n, true);
        ne.level = this.nameSpaces;
        ne.rendered = true;
        this.needsClone();
        this.symb.put(prefix, ne);
        if (ob != null) {
            ne.lastrendered = ob.lastrendered;
            if (ob.lastrendered != null && ob.lastrendered.equals(uri)) {
                ne.rendered = true;
            }
        }
        return ne.n;
    }
}

