/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.inmemory;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.inmemory.MessageInfo;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;

class DstMsgStore {
    Logger logger = Globals.getLogger();
    BrokerResources br = Globals.getBrokerResources();
    DestinationUID myDestination = null;
    private ConcurrentHashMap messageMap = new ConcurrentHashMap(4096);
    private int msgCount = 0;
    private long byteCount = 0L;
    private Object countLock = new Object();

    DstMsgStore(DestinationUID destinationUID) {
        this.myDestination = destinationUID;
    }

    MessageInfo storeMessage(Packet packet, ConsumerUID[] consumerUIDArray, int[] nArray) throws IOException, BrokerException {
        SysMessageID sysMessageID = packet.getSysMessageID();
        MessageInfo messageInfo = new MessageInfo(this, packet, consumerUIDArray, nArray);
        MessageInfo messageInfo2 = this.messageMap.putIfAbsent(messageInfo.getID(), messageInfo);
        if (messageInfo2 != null) {
            this.logger.log(32, "B3008", (Object)sysMessageID, (Object)this.myDestination);
            throw new BrokerException(this.br.getString("B3008", sysMessageID, this.myDestination));
        }
        int n = packet.getPacketSize();
        this.incrMsgCount(n);
        return messageInfo;
    }

    void removeMessage(SysMessageID sysMessageID) throws IOException, BrokerException {
        MessageInfo messageInfo = (MessageInfo)this.messageMap.remove(sysMessageID);
        if (messageInfo == null) {
            this.logger.log(32, "B3007", (Object)sysMessageID, (Object)this.myDestination);
            throw new BrokerException(this.br.getString("B3007", sysMessageID, this.myDestination));
        }
        this.decrMsgCount(messageInfo.getSize());
    }

    void removeAllMessages(boolean bl) throws IOException, BrokerException {
        this.messageMap.clear();
        this.clearCounts();
    }

    Enumeration messageEnumeration() {
        return new MsgEnumeration(this, this.getMessageIterator());
    }

    int getMessageCount() throws BrokerException {
        if (Store.getDEBUG()) {
            this.logger.log(4, "DstMsgStore:getMessageCount()");
        }
        return this.msgCount;
    }

    long getByteCount() throws BrokerException {
        if (Store.getDEBUG()) {
            this.logger.log(4, "DstMsgStore:getByteCount()");
        }
        return this.byteCount;
    }

    protected void close() {
        this.messageMap.clear();
    }

    MessageInfo getMessageInfo(SysMessageID sysMessageID) throws BrokerException {
        MessageInfo messageInfo = (MessageInfo)this.messageMap.get(sysMessageID);
        if (messageInfo == null) {
            this.logger.log(32, "B3007", (Object)sysMessageID, (Object)this.myDestination);
            throw new BrokerException(this.br.getString("B3007", sysMessageID, this.myDestination));
        }
        return messageInfo;
    }

    private Iterator getMessageIterator() {
        return this.messageMap.keySet().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrMsgCount(int n) {
        Object object = this.countLock;
        synchronized (object) {
            ++this.msgCount;
            this.byteCount += (long)n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrMsgCount(int n) {
        Object object = this.countLock;
        synchronized (object) {
            --this.msgCount;
            this.byteCount -= (long)n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCounts() {
        if (Store.getDEBUG()) {
            this.logger.log(4, "DstMsgStore:clearCounts for " + this.myDestination);
        }
        Object object = this.countLock;
        synchronized (object) {
            this.msgCount = 0;
            this.byteCount = 0L;
        }
    }

    Hashtable getDebugState() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put(this.myDestination + ":messages in-memory", String.valueOf(this.msgCount));
        return hashtable;
    }

    void storeInterestStates(SysMessageID sysMessageID, ConsumerUID[] consumerUIDArray, int[] nArray) throws IOException, BrokerException {
        this.getMessageInfo(sysMessageID).storeStates(consumerUIDArray, nArray);
    }

    void updateInterestState(SysMessageID sysMessageID, ConsumerUID consumerUID, int n) throws IOException, BrokerException {
        this.getMessageInfo(sysMessageID).updateState(consumerUID, n);
    }

    boolean containsMsg(SysMessageID sysMessageID) {
        return this.messageMap.containsKey(sysMessageID);
    }

    Packet getMessage(SysMessageID sysMessageID) throws IOException, BrokerException {
        MessageInfo messageInfo = (MessageInfo)this.messageMap.get(sysMessageID);
        if (messageInfo == null) {
            this.logger.log(32, "B3007", (Object)sysMessageID, (Object)this.myDestination);
            throw new BrokerException(this.br.getString("B3007", sysMessageID, this.myDestination));
        }
        return messageInfo.getMessage();
    }

    private static class MsgEnumeration
    implements Enumeration {
        DstMsgStore parent = null;
        Iterator itr = null;
        Object objToReturn = null;

        MsgEnumeration(DstMsgStore dstMsgStore, Iterator iterator) {
            this.parent = dstMsgStore;
            this.itr = iterator;
        }

        public boolean hasMoreElements() {
            if (this.itr.hasNext()) {
                this.objToReturn = this.itr.next();
                return true;
            }
            return false;
        }

        public Object nextElement() {
            if (this.objToReturn != null) {
                Object object = null;
                if (this.objToReturn instanceof SysMessageID) {
                    try {
                        object = this.parent.getMessage((SysMessageID)this.objToReturn);
                    }
                    catch (IOException iOException) {
                        this.parent.logger.log(32, "B4005", this.objToReturn, (Object)this.parent.myDestination, (Throwable)iOException);
                        throw new NoSuchElementException();
                    }
                    catch (BrokerException brokerException) {
                        this.parent.logger.log(32, "B4005", this.objToReturn, (Object)this.parent.myDestination, (Throwable)brokerException);
                        throw new NoSuchElementException();
                    }
                } else {
                    object = this.objToReturn;
                }
                this.objToReturn = null;
                return object;
            }
            throw new NoSuchElementException();
        }
    }
}

