/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.multibroker.Cluster;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.util.HashMap;

class Resource {
    private final Logger logger = Globals.getLogger();
    private String resId = null;
    private ConnectionUID owner = null;
    private long timestamp;
    private long xid;
    private int lockState;
    private boolean shared;
    private int status;
    private HashMap recipients;
    private Cluster c = null;

    public Resource(String string, Cluster cluster) {
        this.resId = string;
        this.c = cluster;
        this.timestamp = 0L;
        this.xid = 0L;
        this.recipients = new HashMap();
    }

    public String getResId() {
        return this.resId;
    }

    public ConnectionUID getOwner() {
        return this.owner;
    }

    public void setOwner(ConnectionUID connectionUID) {
        this.owner = connectionUID;
    }

    public void setTimestamp(long l) {
        this.timestamp = l;
    }

    public long getXid() {
        return this.xid;
    }

    public int getLockState() {
        return this.lockState;
    }

    public void setLockState(int n) {
        this.lockState = n;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean getShared() {
        return this.shared;
    }

    public void setShared(boolean bl) {
        this.shared = bl;
    }

    public String showRecipients() {
        String string = "";
        for (BrokerAddress brokerAddress : this.recipients.keySet()) {
            string = string + "\n\t" + brokerAddress.toString();
        }
        return string;
    }

    public synchronized void prepareLockRequest(BrokerAddress[] brokerAddressArray, long l) {
        this.recipients.clear();
        for (int i = 0; i < brokerAddressArray.length; ++i) {
            this.recipients.put(brokerAddressArray[i], null);
        }
        this.xid = l;
        this.status = 0;
    }

    private boolean hasUnreachable(int n) {
        boolean bl = false;
        for (BrokerAddress brokerAddress : this.recipients.keySet()) {
            try {
                if (this.c.isReachable(brokerAddress, n)) continue;
                this.logger.log(8, Globals.getBrokerResources().getKString("B1242", brokerAddress));
                this.c.closeLink(brokerAddress, true);
                bl = true;
            }
            catch (IOException iOException) {
                this.logger.log(16, Globals.getBrokerResources().getKString("B2171", brokerAddress, iOException.getMessage()));
            }
        }
        return bl;
    }

    public synchronized int waitForStatusChange(int n, boolean bl) {
        long l = (long)n * 1000L;
        long l2 = System.currentTimeMillis() + l;
        boolean bl2 = true;
        while (this.status == 0 && this.recipients.size() > 0) {
            try {
                this.wait(l);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.status != 0 || this.recipients.size() == 0) break;
            long l3 = System.currentTimeMillis();
            if (l3 >= l2) {
                if (!bl && bl2 && this.hasUnreachable(n)) {
                    l = (long)n * 1000L;
                    l2 = System.currentTimeMillis() + l;
                    bl2 = false;
                    continue;
                }
                return -1;
            }
            l = l2 - l3;
        }
        return this.status;
    }

    public synchronized void consumeResponse(long l, BrokerAddress brokerAddress, int n) {
        if (l != this.xid) {
            return;
        }
        if (this.status != 0) {
            return;
        }
        switch (n) {
            case 0: {
                this.recipients.remove(brokerAddress);
                break;
            }
            case 1: 
            case 2: {
                this.status = n;
            }
        }
        if (this.status != 0 || this.recipients.size() == 0) {
            this.notify();
        }
    }

    public synchronized void impliedFailure() {
        this.status = 1;
        this.notify();
    }

    public synchronized void brokerAdded(BrokerAddress brokerAddress) {
        this.status = 3;
        this.notify();
    }

    public synchronized void brokerRemoved(BrokerAddress brokerAddress) {
        if (this.status != 0) {
            return;
        }
        this.recipients.remove(brokerAddress);
        if (this.recipients.size() == 0) {
            this.notify();
        }
    }
}

