/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQBasicConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.PacketUtil;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.DataInput;
import java.io.DataInputStream;
import java.util.Hashtable;

public class DeliverHandler
extends PacketHandler {
    static final int DELIVER_BLOCK_SIZE = 32;
    private Logger logger = Globals.getLogger();
    private static boolean DEBUG = false;

    public boolean handle(IMQConnection iMQConnection, Packet packet) throws BrokerException {
        Object object;
        PacketReference packetReference;
        int n;
        Packet[] packetArray;
        block25: {
            block24: {
                int n2;
                String string;
                block23: {
                    block22: {
                        long l;
                        string = null;
                        Hashtable hashtable = null;
                        try {
                            hashtable = packet.getProperties();
                        }
                        catch (Exception exception) {
                            this.logger.log(8, "Internal Error: unable to retrieve  properties from deliver message " + packet, (Throwable)exception);
                            hashtable = new Hashtable();
                        }
                        int n3 = packet.getMessageBodySize();
                        int n4 = n3 / 32;
                        int n5 = n3 % 32;
                        if (n4 == 0) {
                            throw new BrokerException(Globals.getBrokerResources().getString("B4117", "Empty Deliver Message"));
                        }
                        if (n5 != 0) {
                            throw new BrokerException(Globals.getBrokerResources().getString("B4117", "Invalid Deliver Message Size: " + n3 + ". Not multiple of " + 32));
                        }
                        if (DEBUG) {
                            this.logger.log(4, "Deliver Message: processing message {0} {1}", (Object)packet.toString(), (Object)iMQConnection.getConnectionUID().toString());
                        }
                        Long l2 = (Long)hashtable.get("JMQConsumerID");
                        assert (l2 != null);
                        long l3 = l = l2 == null ? 0L : l2;
                        assert (l != 0L);
                        DataInputStream dataInputStream = new DataInputStream(packet.getMessageBodyStream());
                        packetArray = new Packet[n4];
                        n = 0;
                        try {
                            for (n = 0; n < n4; ++n) {
                                SysMessageID sysMessageID = new SysMessageID();
                                sysMessageID.readID((DataInput)dataInputStream);
                                packetReference = Destination.get(sysMessageID);
                                Object object2 = object = packetReference == null ? null : packetReference.getPacket();
                                if (packetReference == null || packetReference.isInvalid() || object == null) continue;
                                Packet packet2 = new Packet(iMQConnection.useDirectBuffers());
                                packet2.fill((Packet)object);
                                packet2.setConsumerID(l);
                                packetArray[n] = packet2;
                            }
                        }
                        catch (Exception exception) {
                            this.logger.logStack(32, Globals.getBrokerResources().getString("B4117", "\tackcnt = " + n4 + "\n" + PacketUtil.dumpPacket(packet) + "\n" + "\t" + PacketUtil.dumpThrowable(exception)), (Throwable)exception);
                            if ($assertionsDisabled) break block22;
                            throw new AssertionError();
                        }
                    }
                    n2 = 200;
                    try {
                        if (n > 0) {
                            assert (packetArray[n - 1] != null);
                            packetArray[n - 1].setIsLast(true);
                        } else {
                            string = "NOT FOUND";
                            n2 = 404;
                        }
                    }
                    catch (Exception exception) {
                        assert (false);
                        string = exception.getMessage();
                        n2 = 500;
                        if (!(exception instanceof BrokerException)) break block23;
                        n2 = ((BrokerException)exception).getStatusCode();
                    }
                }
                packetReference = new Packet(iMQConnection.useDirectBuffers());
                packetReference.setConsumerID(packet.getConsumerID());
                packetReference.setPacketType(43);
                object = new Hashtable();
                ((Hashtable)object).put("JMQStatus", new Integer(n2));
                if (string != null) {
                    ((Hashtable)object).put("JMQReason", string);
                }
                IMQBasicConnection cfr_ignored_0 = (IMQBasicConnection)iMQConnection;
                if (IMQBasicConnection.getDumpPacket()) break block24;
                IMQBasicConnection cfr_ignored_1 = (IMQBasicConnection)iMQConnection;
                if (!IMQBasicConnection.getDumpOutPacket()) break block25;
            }
            ((Hashtable)object).put("JMQReqID", packet.getSysMessageID().toString());
        }
        packetReference.setProperties((Hashtable)object);
        iMQConnection.sendControlMessage((Packet)packetReference);
        for (int i = 0; i < n; ++i) {
            assert (packetArray[i] != null);
            if (packetArray[i] == null) continue;
            iMQConnection.sendControlMessage(packetArray[i]);
        }
        return true;
    }
}

