/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data;

import com.sun.messaging.jmq.io.MQAddress;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.BrokerState;
import com.sun.messaging.jmq.jmsserver.cluster.BrokerStatus;
import com.sun.messaging.jmq.jmsserver.cluster.ClusterListener;
import com.sun.messaging.jmq.jmsserver.cluster.ClusterManager;
import com.sun.messaging.jmq.jmsserver.cluster.ClusteredBroker;
import com.sun.messaging.jmq.jmsserver.cluster.ha.HAClusteredBroker;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.BrokerMQAddress;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.core.cluster.RemoteTransactionAckEntry;
import com.sun.messaging.jmq.jmsserver.data.AutoRollbackType;
import com.sun.messaging.jmq.jmsserver.data.ClusterTransaction;
import com.sun.messaging.jmq.jmsserver.data.DetachedTransactionReaper;
import com.sun.messaging.jmq.jmsserver.data.RemoteTransaction;
import com.sun.messaging.jmq.jmsserver.data.RemoteTransactionInformation;
import com.sun.messaging.jmq.jmsserver.data.TransactionAcknowledgement;
import com.sun.messaging.jmq.jmsserver.data.TransactionBroker;
import com.sun.messaging.jmq.jmsserver.data.TransactionInformation;
import com.sun.messaging.jmq.jmsserver.data.TransactionListLoader;
import com.sun.messaging.jmq.jmsserver.data.TransactionReaper;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.persist.LoadException;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.TransactionInfo;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.UnknownTransactionException;
import com.sun.messaging.jmq.util.JMQXid;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class TransactionList
implements ClusterListener {
    private static boolean DEBUG = false;
    public static final boolean DEBUG_CLUSTER_TXN;
    public static final boolean AUTO_ROLLBACK;
    public static final long TXN_REAPINTERVAL;
    public static int TXN_REAPLIMIT;
    public static final String XA_TXN_DETACHED_TIMEOUT_PROP = "imq.transaction.detachedTimeout";
    public static final String XA_TXN_DETACHED_RETAINALL_PROP = "imq.transaction.detachedRetainAll";
    public static final String TXN_PRODUCER_MAX_NUM_MSGS_PROP = "imq.transaction.producer.maxNumMsgs";
    public static final String TXN_CONSUMER_MAX_NUM_MSGS_PROP = "imq.transaction.consumer.maxNumMsgs";
    protected static int defaultProducerMaxMsgCnt;
    protected static int defaultConsumerMaxMsgCnt;
    TransactionReaper txnReaper = null;
    DetachedTransactionReaper detachedTxnReaper = null;
    HashSet inuse_translist = null;
    HashMap translist = null;
    HashMap remoteTranslist = null;
    HashMap xidTable = null;
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private Lock shareLock = this.lock.readLock();
    private Lock exclusiveLock = this.lock.writeLock();
    Store store = null;
    TransactionListLoader transactionListLoader;
    protected Vector newlyActivatedBrokers = new Vector();
    protected final CountDownLatch loadCompleteLatch = new CountDownLatch(1);
    protected boolean loadComplete = false;
    Logger logger = Globals.getLogger();

    public TransactionList(Store store) {
        this.store = store;
        this.translist = new HashMap(1000);
        this.remoteTranslist = new HashMap(1000);
        this.xidTable = new HashMap(1000);
        this.inuse_translist = new HashSet(1000);
        this.txnReaper = new TransactionReaper(this);
        this.detachedTxnReaper = new DetachedTransactionReaper(this);
        Globals.getClusterManager().addEventListener(this);
        try {
            if (Globals.isNewTxnLogEnabled() || store.isTxnConversionRequired()) {
                store.init();
            }
            if (store.isTxnConversionRequired()) {
                store.convertTxnFormats(this);
            } else if (!Globals.isNewTxnLogEnabled()) {
                this.loadTransactions();
            } else if (!AUTO_ROLLBACK) {
                TransactionListLoader.loadTransactions(store, this);
            } else {
                TransactionListLoader.rollbackAllTransactions(store);
            }
            this.newlyActivatedBrokers.add(Globals.getMyAddress().getMQAddress());
            this.loadComplete = true;
            this.loadCompleteLatch.countDown();
            this.txnReaper.wakeupReaperTimer();
        }
        catch (Exception exception) {
            this.logger.logStack(8, "B2096", (Throwable)exception);
        }
    }

    public Map getTransactionListMap() {
        return this.translist;
    }

    public Map getRemoteTransactionListMap() {
        return this.remoteTranslist;
    }

    protected boolean isLoadComplete() {
        return this.loadComplete;
    }

    public void destroy() {
        if (this.txnReaper != null) {
            this.txnReaper.destroy();
        }
        if (this.detachedTxnReaper != null) {
            this.detachedTxnReaper.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getDebugState(TransactionUID transactionUID) {
        TransactionInformation transactionInformation = null;
        RemoteTransactionInformation remoteTransactionInformation = null;
        this.shareLock.lock();
        try {
            transactionInformation = (TransactionInformation)this.translist.get(transactionUID);
            remoteTransactionInformation = (RemoteTransactionInformation)this.remoteTranslist.get(transactionUID);
            Object var5_4 = null;
            this.shareLock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.shareLock.unlock();
            throw throwable;
        }
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        if (transactionInformation == null && remoteTransactionInformation == null) {
            hashtable.put(transactionUID.toString(), "UNKNOWN TID");
            return hashtable;
        }
        if (transactionInformation != null) {
            hashtable.put(transactionUID.toString(), transactionInformation.getDebugState());
        }
        if (remoteTransactionInformation != null) {
            hashtable.put(transactionUID.toString() + "(remote)", remoteTransactionInformation.getDebugState());
        }
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockTakeoverTxns(List list) {
        TransactionInformation transactionInformation = null;
        for (TransactionUID transactionUID : list) {
            Object var6_5;
            if (transactionUID == null) continue;
            this.shareLock.lock();
            try {
                transactionInformation = (TransactionInformation)this.translist.get(transactionUID);
                var6_5 = null;
                this.shareLock.unlock();
            }
            catch (Throwable throwable) {
                var6_5 = null;
                this.shareLock.unlock();
                throw throwable;
            }
            if (transactionInformation == null) continue;
            transactionInformation.releaseTakeoverLock();
        }
    }

    public Map loadTakeoverTxns(List list, List list2, Map map) throws BrokerException, IOException {
        List<TransactionAcknowledgement> list3;
        TransactionState transactionState;
        TransactionAcknowledgement[] transactionAcknowledgementArray;
        TransactionInfo transactionInfo;
        this.logger.log(8, Globals.getBrokerResources().getKString("B1283", list.size()));
        Iterator iterator = list.iterator();
        HashMap<TransactionUID, List<TransactionAcknowledgement>> hashMap = new HashMap<TransactionUID, List<TransactionAcknowledgement>>();
        while (iterator.hasNext()) {
            TransactionUID transactionUID = (TransactionUID)iterator.next();
            transactionInfo = null;
            try {
                transactionInfo = this.store.getTransactionInfo(transactionUID);
            }
            catch (Exception exception) {
                transactionAcknowledgementArray = "Failed to get transaction " + transactionUID + " information from store after takeover";
                this.logger.logStack(32, "B3100", (Object)transactionAcknowledgementArray, (Throwable)exception);
                throw new BrokerException((String)transactionAcknowledgementArray);
            }
            transactionState = transactionInfo.getTransactionState();
            this.logger.log(4, "Processing transaction " + transactionUID + transactionInfo.toString());
            try {
                if (transactionState.getState() != 6 && transactionState.getState() != 5) {
                    this.store.removeTransactionAck(transactionUID, false);
                }
                transactionAcknowledgementArray = this.store.getTransactionAcks(transactionUID);
                this.logger.log(4, "Processing transaction acks " + transactionUID + " number=" + transactionAcknowledgementArray.length);
                list3 = Arrays.asList(transactionAcknowledgementArray);
                hashMap.put(transactionUID, list3);
                this.addTransactionID(transactionUID, transactionState, true, transactionInfo.getType(), false);
                if (transactionInfo.getType() != 2) continue;
                this.logClusterTransaction(transactionUID, transactionState, transactionInfo.getTransactionBrokers(), true, false);
            }
            catch (Exception exception) {
                this.logger.logStack(32, "B3100", (Object)("error taking over " + transactionUID), (Throwable)exception);
                hashMap.remove(transactionUID);
            }
        }
        for (TransactionUID transactionUID : list2) {
            if (list.contains(transactionUID)) continue;
            transactionInfo = null;
            try {
                transactionInfo = this.store.getTransactionInfo(transactionUID);
            }
            catch (Exception exception) {
                transactionAcknowledgementArray = "Failed to get remote transaction " + transactionUID + " information from store after takeover";
                this.logger.logStack(32, "B3100", (Object)transactionAcknowledgementArray, (Throwable)exception);
                throw new BrokerException((String)transactionAcknowledgementArray);
            }
            transactionState = transactionInfo.getTransactionState();
            if (DEBUG || DEBUG_CLUSTER_TXN) {
                this.logger.log(8, Globals.getBrokerResources().getString("B1329", transactionUID + "[" + TransactionState.toString(transactionState.getState()) + "]" + transactionInfo.toString()));
            } else {
                this.logger.log(8, Globals.getBrokerResources().getString("B1329", transactionUID + "[" + TransactionState.toString(transactionState.getState()) + "]"));
            }
            try {
                transactionAcknowledgementArray = this.store.getTransactionAcks(transactionUID);
                list3 = new ArrayList<TransactionAcknowledgement>();
                Iterator iterator2 = null;
                for (int i = 0; i < transactionAcknowledgementArray.length; ++i) {
                    for (String string : map.keySet()) {
                        if (!string.equals(transactionAcknowledgementArray[i].getSysMessageID().toString())) continue;
                        ((ArrayList)list3).add(transactionAcknowledgementArray[i]);
                        if (!DEBUG && !DEBUG_CLUSTER_TXN) continue;
                        this.logger.log(8, "Processing remote transaction ack for TUID=" + transactionUID + " " + transactionAcknowledgementArray[i].toString());
                    }
                }
                if (((ArrayList)list3).size() > 0) {
                    hashMap.put(transactionUID, list3);
                    this.logger.log(8, "Processing remote transaction " + transactionUID + "[" + TransactionState.toString(transactionState.getState()) + "] with acks " + ((ArrayList)list3).size());
                    if (transactionState.getState() != 5 && transactionState.getState() != 6) {
                        transactionState.setState(5);
                    }
                }
                this.logRemoteTransaction(transactionUID, transactionState, ((ArrayList)list3).toArray((TransactionAcknowledgement[])new TransactionAcknowledgement[0]), transactionInfo.getTransactionHomeBroker(), true, false, false);
                if (transactionState.getState() != 6) continue;
                this.txnReaper.addRemoteTransaction(transactionUID, true);
            }
            catch (Exception exception) {
                this.logger.logStack(32, "B3100", (Object)("error taking over " + transactionUID), (Throwable)exception);
                hashMap.remove(transactionUID);
            }
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getDebugState() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        this.shareLock.lock();
        try {
            Serializable serializable22;
            hashtable.put("TransactionCount", new Integer(this.translist.size()));
            for (Serializable serializable22 : this.translist.keySet()) {
                hashtable.put(((TransactionUID)serializable22).toString(), this.getDebugState((TransactionUID)serializable22));
            }
            hashtable.put("TransactionCount(remote)", new Integer(this.remoteTranslist.size()));
            for (Serializable serializable22 : this.remoteTranslist.keySet()) {
                if (this.translist.containsKey(serializable22) || this.remoteTranslist.containsKey(serializable22)) continue;
                hashtable.put(((TransactionUID)serializable22).toString(), this.getDebugState((TransactionUID)serializable22));
            }
            if (this.inuse_translist.size() > 0) {
                hashtable.put("inUse", this.inuse_translist.toArray());
            } else {
                hashtable.put("inUse", "none");
            }
            serializable22 = new Hashtable();
            for (Map.Entry entry : this.xidTable.entrySet()) {
                ((Hashtable)serializable22).put(entry.getKey().toString(), entry.getValue().toString());
            }
            if (((Hashtable)serializable22).size() > 0) {
                hashtable.put("XIDs", serializable22);
            } else {
                hashtable.put("XIDs", "none");
            }
            Object var6_5 = null;
            this.shareLock.unlock();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.shareLock.unlock();
            throw throwable;
        }
        hashtable.put("txnReaper", this.txnReaper.getDebugState());
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TransactionUID getTransaction(String string) {
        this.shareLock.lock();
        try {
            TransactionInformation transactionInformation;
            TransactionState transactionState;
            String string2;
            Iterator iterator = this.translist.values().iterator();
            do {
                if (iterator.hasNext()) continue;
                Object var8_8 = null;
                this.shareLock.unlock();
                return null;
            } while ((string2 = (transactionState = (transactionInformation = (TransactionInformation)iterator.next()).getState()).getCreator()) == null || !string2.equals(string));
            TransactionUID transactionUID = transactionInformation.getTID();
            Object var8_7 = null;
            this.shareLock.unlock();
            return transactionUID;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.shareLock.unlock();
            throw throwable;
        }
    }

    public void addTransactionID(TransactionUID transactionUID, TransactionState transactionState) throws BrokerException {
        this.addTransactionID(transactionUID, transactionState, false, 1, true);
    }

    public TransactionInformation addTransactionID(TransactionUID transactionUID, TransactionState transactionState, boolean bl) throws BrokerException {
        return this.addTransactionID(transactionUID, transactionState, false, 1, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TransactionInformation addTransactionID(TransactionUID transactionUID, TransactionState transactionState, boolean bl, int n, boolean bl2) throws BrokerException {
        JMQXid jMQXid = transactionState.getXid();
        this.shareLock.lock();
        try {
            if (this.inuse_translist.contains(transactionUID) && (!bl || n != 2 || this.translist.containsKey(transactionUID) || !this.remoteTranslist.containsKey(transactionUID))) {
                throw new BrokerException(Globals.getBrokerResources().getKString("B4061", transactionUID.toString()), "B4061", null, 409);
            }
            if (jMQXid != null && this.xidTable.containsKey(jMQXid)) {
                throw new BrokerException(Globals.getBrokerResources().getKString("B4061", transactionUID.toString() + "[Xid=" + jMQXid.toString() + "]"), "B4061", null, 409);
            }
            Object var8_7 = null;
            this.shareLock.unlock();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.shareLock.unlock();
            throw throwable;
        }
        try {
            if (bl2) {
                this.store.storeTransaction(transactionUID, transactionState, Destination.PERSIST_SYNC);
            }
        }
        catch (Exception exception) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4062", transactionUID.toString()), "B4062", exception, 500);
        }
        TransactionInformation transactionInformation = new TransactionInformation(transactionUID, transactionState, bl2);
        if (bl) {
            transactionInformation.getTakeoverLock();
        }
        this.exclusiveLock.lock();
        try {
            this.inuse_translist.add(transactionUID);
            this.translist.put(transactionUID, transactionInformation);
            if (jMQXid != null) {
                this.xidTable.put(jMQXid, transactionUID);
            }
            Object var10_12 = null;
            this.exclusiveLock.unlock();
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            this.exclusiveLock.unlock();
            throw throwable;
        }
        return transactionInformation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isXATransaction(TransactionUID transactionUID) throws BrokerException {
        TransactionState transactionState = null;
        TransactionInformation transactionInformation = null;
        this.shareLock.lock();
        try {
            transactionInformation = (TransactionInformation)this.translist.get(transactionUID);
            Object var5_4 = null;
            this.shareLock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.shareLock.unlock();
            throw throwable;
        }
        if (transactionInformation != null && (transactionState = transactionInformation.getState()) != null) {
            return transactionState.isXA();
        }
        throw new BrokerException("Transaction " + transactionUID + "not found", 404);
    }

    public void removeTransaction(TransactionUID transactionUID, boolean bl) throws BrokerException {
        this.removeTransactionID(transactionUID, bl, false, true);
    }

    public void removeTransactionID(TransactionUID transactionUID) throws BrokerException {
        this.removeTransactionID(transactionUID, false, false, true);
    }

    protected void reapTransactionID(TransactionUID transactionUID, boolean bl) throws BrokerException {
        this.removeTransactionID(transactionUID, bl, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTransactionID(TransactionUID transactionUID, boolean bl, boolean bl2, boolean bl3) throws BrokerException {
        TransactionState transactionState = null;
        TransactionInformation transactionInformation = null;
        this.shareLock.lock();
        try {
            transactionInformation = (TransactionInformation)this.translist.get(transactionUID);
            Object var8_7 = null;
            this.shareLock.unlock();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.shareLock.unlock();
            throw throwable;
        }
        if (transactionInformation != null) {
            transactionState = transactionInformation.getState();
            if (!bl2 && transactionState != null && transactionState.getState() == 6) {
                if (transactionInformation.getType() == 2) {
                    transactionInformation.processed();
                    this.txnReaper.addClusterTransaction(transactionUID, bl);
                    return;
                }
                if (transactionInformation.getType() == 1) {
                    transactionInformation.processed();
                    if (bl || TXN_REAPLIMIT > 0) {
                        this.txnReaper.addLocalTransaction(transactionUID, bl);
                        return;
                    }
                }
            }
        }
        if (!bl && bl3) {
            try {
                this.store.removeTransaction(transactionUID, true, false);
            }
            catch (IOException iOException) {
                throw new BrokerException(Globals.getBrokerResources().getString("B4117", "Unable to remove the transaction id " + transactionUID), iOException);
            }
        }
        this.exclusiveLock.lock();
        try {
            this.translist.remove(transactionUID);
            if (!this.remoteTranslist.containsKey(transactionUID)) {
                this.inuse_translist.remove(transactionUID);
            }
            if (transactionState != null && transactionState.getXid() != null) {
                this.xidTable.remove(transactionState.getXid());
            }
            Object var10_11 = null;
            this.exclusiveLock.unlock();
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            this.exclusiveLock.unlock();
            throw throwable;
        }
    }

    public void removeRemoteTransactionAck(TransactionUID transactionUID) throws BrokerException {
        if (Globals.getHAEnabled()) {
            return;
        }
        this.removeTransactionAck(transactionUID, true);
    }

    public void removeTransactionAck(TransactionUID transactionUID) throws BrokerException {
    }

    public void removeTransactionAck(TransactionUID transactionUID, boolean bl) throws BrokerException {
        try {
            this.store.removeTransactionAck(transactionUID, false);
        }
        catch (Exception exception) {
            throw new BrokerException(Globals.getBrokerResources().getString("B4117", ": unable to remove the transaction acks for " + transactionUID), exception);
        }
    }

    public void addDetachedTransactionID(TransactionUID transactionUID) {
        this.detachedTxnReaper.addDetachedTID(transactionUID);
    }

    public void addMessage(TransactionUID transactionUID, SysMessageID sysMessageID) throws BrokerException {
        this.addMessage(transactionUID, sysMessageID, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessage(TransactionUID transactionUID, SysMessageID sysMessageID, boolean bl) throws BrokerException {
        TransactionInformation transactionInformation = null;
        this.shareLock.lock();
        try {
            transactionInformation = (TransactionInformation)this.translist.get(transactionUID);
            Object var6_5 = null;
            this.shareLock.unlock();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.shareLock.unlock();
            throw throwable;
        }
        if (transactionInformation == null) {
            throw new BrokerException(Globals.getBrokerResources().getString("B4117", "received message with Unknown Transaction ID " + transactionUID + ": ignoring message"), 410);
        }
        TransactionInformation transactionInformation2 = transactionInformation;
        synchronized (transactionInformation2) {
            int n = transactionInformation.getState().getState();
            if (n == 8) {
                throw new BrokerException(Globals.getBrokerResources().getString("B4117", "Transaction " + transactionUID + ": is has timed out "), 408);
            }
            if (!bl && n != 1) {
                throw new BrokerException(Globals.getBrokerResources().getString("B4117", "Transaction " + transactionUID + "[" + TransactionState.toString(n) + "]: is not in " + TransactionState.toString(1) + " state"), 412);
            }
            transactionInformation.addPublishedMessage(sysMessageID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getTransactionMap(TransactionUID transactionUID, boolean bl) throws BrokerException {
        Hashtable<String, Object> hashtable;
        TransactionInformation transactionInformation = null;
        this.shareLock.lock();
        try {
            transactionInformation = (TransactionInformation)this.translist.get(transactionUID);
            hashtable = null;
            this.shareLock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.shareLock.unlock();
            throw throwable;
        }
        if (transactionInformation == null) {
            throw new BrokerException(Globals.getBrokerResources().getString("B4117", "received acknowledgement with Unknown Transaction ID " + transactionUID), 410);
        }
        TransactionState transactionState = transactionInformation.getState();
        if (transactionState == null) {
            throw new BrokerException(Globals.getBrokerResources().getString("B4117", "received acknowledgement with Unknown Transaction state " + transactionUID), 500);
        }
        hashtable = new Hashtable<String, Object>();
        hashtable.put("JMQAutoRollback", new Integer(transactionState.getType().intValue()));
        if (transactionState.getXid() != null) {
            hashtable.put("JMQXid", transactionState.getXid().toString());
        }
        hashtable.put("JMQSessionLess", transactionState.isSessionLess());
        hashtable.put("JMQCreateTime", new Long(transactionState.getCreationTime()));
        hashtable.put("JMQLifetime", new Long(transactionState.getLifetime()));
        if (bl) {
            hashtable.put("State", new Integer(transactionState.getState() + 1));
        } else {
            hashtable.put("State", new Integer(transactionState.getState()));
        }
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkAcknowledgement(TransactionUID transactionUID, SysMessageID sysMessageID, ConsumerUID consumerUID) throws BrokerException {
        TransactionInformation transactionInformation = null;
        this.shareLock.lock();
        try {
            transactionInformation = (TransactionInformation)this.translist.get(transactionUID);
            Object var6_5 = null;
            this.shareLock.unlock();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.shareLock.unlock();
            throw throwable;
        }
        if (transactionInformation == null) {
            throw new BrokerException(Globals.getBrokerResources().getString("B4117", "received acknowledgement with Unknown Transaction ID " + transactionUID + ": ignoring message"), 410);
        }
        if (transactionInformation.getState().getState() == 8) {
            throw new BrokerException(Globals.getBrokerResources().getString("B4117", "Transaction " + consumerUID + ": is has timed out "), 408);
        }
        return transactionInformation.checkConsumedMessage(sysMessageID, consumerUID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConsumedInTransaction(SysMessageID sysMessageID, ConsumerUID consumerUID) {
        TransactionInformation transactionInformation2 = null;
        this.shareLock.lock();
        try {
            for (TransactionInformation transactionInformation2 : this.translist.values()) {
                if (transactionInformation2 == null || !transactionInformation2.isConsumedMessage(sysMessageID, consumerUID)) continue;
                boolean bl = true;
                Object var7_6 = null;
                this.shareLock.unlock();
                return bl;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.shareLock.unlock();
            throw throwable;
        }
        Object var7_7 = null;
        this.shareLock.unlock();
        return false;
    }

    public boolean addAcknowledgement(TransactionUID transactionUID, SysMessageID sysMessageID, ConsumerUID consumerUID, ConsumerUID consumerUID2) throws BrokerException {
        PacketReference packetReference = Destination.get(sysMessageID);
        if (packetReference == null) {
            if (!Destination.isLocked(sysMessageID)) {
                throw new BrokerException(Globals.getBrokerResources().getKString("B1261", "" + sysMessageID + "[" + consumerUID + ":" + consumerUID2 + "]TUID=" + transactionUID), 409);
            }
            throw new BrokerException(Globals.getBrokerResources().getKString("B1289", "" + sysMessageID + "[" + consumerUID + ":" + consumerUID2 + "]TUID=" + transactionUID), 409);
        }
        boolean bl = consumerUID2.shouldStore() && packetReference != null && packetReference.isPersistent() && packetReference.isLocal();
        return this.addAcknowledgement(transactionUID, sysMessageID, consumerUID, consumerUID2, false, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAcknowledgement(TransactionUID transactionUID, SysMessageID sysMessageID, ConsumerUID consumerUID, ConsumerUID consumerUID2, boolean bl, boolean bl2) throws BrokerException {
        boolean bl3 = false;
        TransactionInformation transactionInformation = null;
        this.shareLock.lock();
        try {
            transactionInformation = (TransactionInformation)this.translist.get(transactionUID);
            Object var10_9 = null;
            this.shareLock.unlock();
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.shareLock.unlock();
            throw throwable;
        }
        if (transactionInformation == null) {
            throw new BrokerException(Globals.getBrokerResources().getString("B4117", "Received acknowledgement with Unknown Transaction ID " + transactionUID), 410);
        }
        TransactionInformation transactionInformation2 = transactionInformation;
        synchronized (transactionInformation2) {
            int n = transactionInformation.getState().getState();
            if (n == 8) {
                throw new BrokerException(Globals.getBrokerResources().getString("B4117", "Transaction " + transactionUID + " has timed out "), 408);
            }
            if (!bl && n != 1) {
                throw new BrokerException(Globals.getBrokerResources().getString("B4117", "Transaction " + transactionUID + " has state [" + TransactionState.toString(n) + "],  not in [" + TransactionState.toString(1) + "] state"), 412);
            }
            transactionInformation.addConsumedMessage(sysMessageID, consumerUID, consumerUID2);
            bl3 = transactionInformation.getState().isXA();
        }
        if (bl2) {
            this.store.storeTransactionAck(transactionUID, new TransactionAcknowledgement(sysMessageID, consumerUID, consumerUID2), false);
        }
        return bl3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAckBrokerAddress(TransactionUID transactionUID, SysMessageID sysMessageID, ConsumerUID consumerUID, BrokerAddress brokerAddress) throws BrokerException {
        TransactionInformation transactionInformation = null;
        this.shareLock.lock();
        try {
            transactionInformation = (TransactionInformation)this.translist.get(transactionUID);
            Object var7_6 = null;
            this.shareLock.unlock();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.shareLock.unlock();
            throw throwable;
        }
        if (transactionInformation == null) {
            throw new BrokerException(Globals.getBrokerResources().getString("B4117", "Unknown Transaction ID " + transactionUID + " for transaction ack [" + sysMessageID + ":" + consumerUID + "]" + brokerAddress), 410);
        }
        TransactionInformation transactionInformation2 = transactionInformation;
        synchronized (transactionInformation2) {
            int n = transactionInformation.getState().getState();
            if (n == 8) {
                throw new BrokerException(Globals.getBrokerResources().getString("B4117", "Transaction " + transactionUID + ": has timed out "), 408);
            }
            if (n != 1) {
                throw new BrokerException(Globals.getBrokerResources().getString("B4117", "Transaction " + transactionUID + "[" + TransactionState.toString(n) + "]: is not in " + TransactionState.toString(1) + " state"), 412);
            }
            transactionInformation.setAckBrokerAddress(sysMessageID, consumerUID, brokerAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BrokerAddress getAckBrokerAddress(TransactionUID transactionUID, SysMessageID sysMessageID, ConsumerUID consumerUID) throws BrokerException {
        TransactionInformation transactionInformation = null;
        this.shareLock.lock();
        try {
            transactionInformation = (TransactionInformation)this.translist.get(transactionUID);
            Object var6_5 = null;
            this.shareLock.unlock();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.shareLock.unlock();
            throw throwable;
        }
        if (transactionInformation == null) {
            throw new BrokerException(Globals.getBrokerResources().getString("B4117", "Unknown Transaction ID " + transactionUID + " for transaction ack [" + sysMessageID + ":" + consumerUID + "]"), 410);
        }
        TransactionInformation transactionInformation2 = transactionInformation;
        synchronized (transactionInformation2) {
            return transactionInformation.getAckBrokerAddress(sysMessageID, consumerUID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List retrieveSentMessages(TransactionUID transactionUID) {
        TransactionInformation transactionInformation = null;
        this.shareLock.lock();
        try {
            transactionInformation = (TransactionInformation)this.translist.get(transactionUID);
            Object var4_3 = null;
            this.shareLock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.shareLock.unlock();
            throw throwable;
        }
        if (transactionInformation == null) {
            return null;
        }
        return transactionInformation.getPublishedMessages();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int retrieveNSentMessages(TransactionUID transactionUID) {
        TransactionInformation transactionInformation = null;
        this.shareLock.lock();
        try {
            transactionInformation = (TransactionInformation)this.translist.get(transactionUID);
            Object var4_3 = null;
            this.shareLock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.shareLock.unlock();
            throw throwable;
        }
        if (transactionInformation == null) {
            return 0;
        }
        return transactionInformation.getNPublishedMessages();
    }

    public HashMap retrieveConsumedMessages(TransactionUID transactionUID) {
        return this.retrieveConsumedMessages(transactionUID, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap retrieveConsumedMessages(TransactionUID transactionUID, boolean bl) {
        TransactionInformation transactionInformation = null;
        this.shareLock.lock();
        try {
            transactionInformation = (TransactionInformation)this.translist.get(transactionUID);
            Object var5_4 = null;
            this.shareLock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.shareLock.unlock();
            throw throwable;
        }
        if (transactionInformation == null) {
            return null;
        }
        return transactionInformation.getConsumedMessages(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap retrieveStoredConsumerUIDs(TransactionUID transactionUID) {
        TransactionInformation transactionInformation = null;
        this.shareLock.lock();
        try {
            transactionInformation = (TransactionInformation)this.translist.get(transactionUID);
            Object var4_3 = null;
            this.shareLock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.shareLock.unlock();
            throw throwable;
        }
        if (transactionInformation == null) {
            return null;
        }
        return transactionInformation.getStoredConsumerUIDs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap retrieveAckBrokerAddresses(TransactionUID transactionUID) {
        TransactionInformation transactionInformation = null;
        this.shareLock.lock();
        try {
            transactionInformation = (TransactionInformation)this.translist.get(transactionUID);
            Object var4_3 = null;
            this.shareLock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.shareLock.unlock();
            throw throwable;
        }
        if (transactionInformation == null) {
            return null;
        }
        return transactionInformation.getAckBrokerAddresses();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int retrieveNConsumedMessages(TransactionUID transactionUID) {
        TransactionInformation transactionInformation = null;
        this.shareLock.lock();
        try {
            transactionInformation = (TransactionInformation)this.translist.get(transactionUID);
            Object var4_3 = null;
            this.shareLock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.shareLock.unlock();
            throw throwable;
        }
        if (transactionInformation == null) {
            return 0;
        }
        return transactionInformation.getNConsumedMessages();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int retrieveNRemoteConsumedMessages(TransactionUID transactionUID) {
        RemoteTransactionInformation remoteTransactionInformation = null;
        this.shareLock.lock();
        try {
            remoteTransactionInformation = (RemoteTransactionInformation)this.remoteTranslist.get(transactionUID);
            Object var4_3 = null;
            this.shareLock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.shareLock.unlock();
            throw throwable;
        }
        if (remoteTransactionInformation == null) {
            return 0;
        }
        return remoteTransactionInformation.getNRemoteConsumedMessages();
    }

    public TransactionState retrieveState(TransactionUID transactionUID) {
        return this.retrieveState(transactionUID, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionState retrieveState(TransactionUID transactionUID, boolean bl) {
        if (transactionUID == null) {
            return null;
        }
        TransactionInformation transactionInformation = null;
        this.shareLock.lock();
        try {
            transactionInformation = (TransactionInformation)this.translist.get(transactionUID);
            Object var5_4 = null;
            this.shareLock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.shareLock.unlock();
            throw throwable;
        }
        if (transactionInformation == null) {
            return null;
        }
        if (bl) {
            return transactionInformation.getState();
        }
        if (transactionInformation.isTakeoverLocked()) {
            Globals.getLogger().log(16, Globals.getBrokerResources().getKString("B4290", transactionUID));
            return null;
        }
        if (transactionInformation.isProcessed()) {
            return null;
        }
        return transactionInformation.getState();
    }

    public TransactionState updateState(TransactionUID transactionUID, int n, boolean bl) throws BrokerException {
        return this.updateState(transactionUID, n, -1, false, -1, bl);
    }

    public TransactionState updateState(TransactionUID transactionUID, int n, boolean bl, boolean bl2) throws BrokerException {
        return this.updateState(transactionUID, n, -1, bl, -1, bl2);
    }

    public TransactionState updateState(TransactionUID transactionUID, int n, int n2, boolean bl) throws BrokerException {
        return this.updateState(transactionUID, n, n2, false, -1, bl);
    }

    public TransactionState updateState(TransactionUID transactionUID, int n, boolean bl, int n2, boolean bl2) throws BrokerException {
        return this.updateState(transactionUID, n, -1, bl, n2, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionState updateState(TransactionUID transactionUID, int n, int n2, boolean bl, int n3, boolean bl2) throws BrokerException {
        TransactionInformation transactionInformation;
        TransactionInformation transactionInformation2 = null;
        this.shareLock.lock();
        try {
            transactionInformation2 = (TransactionInformation)this.translist.get(transactionUID);
            transactionInformation = null;
            this.shareLock.unlock();
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.shareLock.unlock();
            throw throwable;
        }
        if (transactionInformation2 == null) {
            throw new UnknownTransactionException("Update state " + TransactionState.toString(n) + " for unknown transaction: " + transactionUID);
        }
        if (transactionInformation2.isTakeoverLocked()) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4290", transactionUID), 404);
        }
        TransactionState transactionState = null;
        transactionInformation = transactionInformation2;
        synchronized (transactionInformation) {
            transactionState = transactionInformation2.getState();
            if (transactionState == null) {
                throw new BrokerException(Globals.getBrokerResources().getString("B4117", "updateState(): No state for transaction: " + transactionUID), 410);
            }
            if (transactionState.getState() == 8) {
                throw new BrokerException(Globals.getBrokerResources().getString("B4117", "Transaction " + transactionUID + ": is has timed out"), 408);
            }
            int n4 = transactionState.getState();
            if (n2 != -1 && n4 != n2) {
                Object[] objectArray = new String[]{transactionUID.toString(), TransactionState.toString(n), TransactionState.toString(transactionState.getState()), TransactionState.toString(n2)};
                throw new BrokerException(Globals.getBrokerResources().getKString("B4272", objectArray), 409);
            }
            transactionState.setState(n);
            if (n == 5) {
                transactionState.setOnephasePrepare(bl);
            }
            if (n == 2 && n4 != 2) {
                transactionState.setFailFromState(n4);
                if (n3 != -1) {
                    transactionState.setFailToState(n3);
                }
            }
        }
        if (bl2) {
            try {
                this.store.updateTransactionState(transactionUID, transactionState, Destination.PERSIST_SYNC);
            }
            catch (IOException iOException) {
                throw new BrokerException(null, iOException);
            }
        }
        return transactionState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionUID xidToUID(JMQXid jMQXid) {
        this.shareLock.lock();
        try {
            TransactionUID transactionUID = (TransactionUID)this.xidTable.get(jMQXid);
            Object var4_3 = null;
            this.shareLock.unlock();
            return transactionUID;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.shareLock.unlock();
            throw throwable;
        }
    }

    public JMQXid UIDToXid(TransactionUID transactionUID) {
        TransactionState transactionState = this.retrieveState(transactionUID);
        if (transactionState != null) {
            return transactionState.getXid();
        }
        return null;
    }

    public Vector getTransactions(int n) {
        return this.getTransactions(this.translist, n);
    }

    public Vector getClusterTransactions(int n) {
        return this.getTransactions(this.translist, n, 2);
    }

    public Vector getRemoteTransactions(int n) {
        return this.getTransactions(this.remoteTranslist, n);
    }

    private Vector getTransactions(Map map, int n) {
        return this.getTransactions(map, n, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector getTransactions(Map map, int n, int n2) {
        TransactionUID transactionUID2 = null;
        TransactionState transactionState = null;
        Vector<TransactionUID> vector = new Vector<TransactionUID>();
        this.shareLock.lock();
        try {
            Set set = map.keySet();
            for (TransactionUID transactionUID2 : set) {
                TransactionInformation transactionInformation = (TransactionInformation)map.get(transactionUID2);
                if (n < 0 && (n2 == 0 || transactionInformation.getType() == n2)) {
                    if (transactionInformation.isProcessed() && (n2 == 1 || n2 == 0 || n2 == 2 && transactionInformation.isClusterTransactionBrokersCompleted())) continue;
                    vector.add(transactionUID2);
                    continue;
                }
                transactionState = this.retrieveState(transactionUID2);
                if (transactionState == null || transactionState.getState() != n || n2 != 0 && transactionInformation.getType() != n2) continue;
                vector.add(transactionUID2);
            }
            Object var11_10 = null;
            this.shareLock.unlock();
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            this.shareLock.unlock();
            throw throwable;
        }
        return vector;
    }

    public void addOrphanAck(TransactionUID transactionUID, SysMessageID sysMessageID, ConsumerUID consumerUID) {
        this.addOrphanAck(transactionUID, sysMessageID, consumerUID, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOrphanAck(TransactionUID transactionUID, SysMessageID sysMessageID, ConsumerUID consumerUID, ConsumerUID consumerUID2) {
        TransactionInformation transactionInformation = null;
        this.shareLock.lock();
        try {
            transactionInformation = (TransactionInformation)this.translist.get(transactionUID);
            Object var7_6 = null;
            this.shareLock.unlock();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.shareLock.unlock();
            throw throwable;
        }
        if (transactionInformation != null) {
            transactionInformation.addOrphanAck(sysMessageID, consumerUID, consumerUID2);
        }
    }

    public void removeOrphanAck(TransactionUID transactionUID, SysMessageID sysMessageID, ConsumerUID consumerUID) {
        this.removeOrphanAck(transactionUID, sysMessageID, consumerUID, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOrphanAck(TransactionUID transactionUID, SysMessageID sysMessageID, ConsumerUID consumerUID, ConsumerUID consumerUID2) {
        TransactionInformation transactionInformation = null;
        this.shareLock.lock();
        try {
            transactionInformation = (TransactionInformation)this.translist.get(transactionUID);
            Object var7_6 = null;
            this.shareLock.unlock();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.shareLock.unlock();
            throw throwable;
        }
        if (transactionInformation != null) {
            transactionInformation.removeOrphanAck(sysMessageID, consumerUID, consumerUID2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getOrphanAck(TransactionUID transactionUID) {
        TransactionInformation transactionInformation = null;
        this.shareLock.lock();
        try {
            transactionInformation = (TransactionInformation)this.translist.get(transactionUID);
            Object var4_3 = null;
            this.shareLock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.shareLock.unlock();
            throw throwable;
        }
        if (transactionInformation != null) {
            return transactionInformation.getOrphanAck();
        }
        return null;
    }

    public void loadTransactions() throws BrokerException, IOException {
        Object object;
        Object object3;
        int n;
        int n2;
        Serializable serializable;
        Object object4;
        Serializable serializable2;
        Object object5;
        Serializable serializable3;
        Serializable serializable4;
        LoadException loadException = Globals.getStore().getLoadTransactionException();
        if (loadException != null) {
            serializable4 = loadException;
            while (serializable4 != null) {
                serializable3 = (TransactionUID)((LoadException)serializable4).getKey();
                object5 = (TransactionAcknowledgement[])((LoadException)serializable4).getValue();
                if (serializable3 == null && object5 == null) {
                    this.logger.log(16, "B3044", (Object)("Both key and value for a transactions entry are corrupted with key exception " + ((LoadException)serializable4).getKeyCause().getMessage() + " and value exception " + ((LoadException)serializable4).getValueCause()));
                    serializable4 = ((LoadException)serializable4).getNextException();
                    continue;
                }
                if (serializable3 == null) {
                    this.logger.logStack(16, "B2098", (Object)((TransactionInfo)object5).toString(), ((LoadException)serializable4).getKeyCause());
                    serializable4 = ((LoadException)serializable4).getNextException();
                    continue;
                }
                if (object5 == null) {
                    this.logger.log(16, Globals.getBrokerResources().getKString("B2187", ((TransactionUID)serializable3).toString()));
                    serializable2 = new TransactionState(AutoRollbackType.NOT_PREPARED, 0L, true);
                    ((TransactionState)serializable2).setState(5);
                    try {
                        this.store.storeTransaction((TransactionUID)serializable3, (TransactionState)serializable2, false);
                    }
                    catch (Exception exception) {
                        this.logger.logStack(16, "B3044", (Object)("Error updating transaction " + serializable3), (Throwable)exception);
                    }
                    serializable4 = ((LoadException)serializable4).getNextException();
                    continue;
                }
                if (((TransactionInfo)object5).getType() == 0) {
                    this.logger.logStack(16, Globals.getBrokerResources().getKString("B2202", serializable3 + "[" + ((TransactionInfo)object5).toString() + "]", TransactionInfo.toString(1)), ((LoadException)serializable4).getValueCause());
                    serializable2 = new TransactionState(AutoRollbackType.NOT_PREPARED, 0L, true);
                    ((TransactionState)serializable2).setState(5);
                    try {
                        this.store.storeTransaction((TransactionUID)serializable3, (TransactionState)serializable2, false);
                    }
                    catch (Exception exception) {
                        this.logger.logStack(16, "B3044", (Object)("Error updating transaction " + serializable3), (Throwable)exception);
                    }
                    serializable4 = ((LoadException)serializable4).getNextException();
                    continue;
                }
                if (((TransactionInfo)object5).getTransactionState() == null) {
                    this.logger.log(16, "B2097", (Object)serializable3, ((LoadException)serializable4).getValueCause());
                    serializable2 = new TransactionState(AutoRollbackType.NOT_PREPARED, 0L, true);
                    ((TransactionState)serializable2).setState(5);
                    try {
                        this.store.storeTransaction((TransactionUID)serializable3, (TransactionState)serializable2, false);
                    }
                    catch (Exception exception) {
                        this.logger.logStack(16, "B3044", (Object)("Error updating transaction " + serializable3), (Throwable)exception);
                    }
                    serializable4 = ((LoadException)serializable4).getNextException();
                    continue;
                }
                if (((TransactionInfo)object5).getType() == 2 && ((TransactionInfo)object5).getTransactionBrokers() == null) {
                    this.logger.log(16, "B2203", (Object)serializable3, ((LoadException)serializable4).getValueCause());
                    this.store.storeClusterTransaction((TransactionUID)serializable3, ((TransactionInfo)object5).getTransactionState(), null, false);
                    serializable4 = ((LoadException)serializable4).getNextException();
                    continue;
                }
                if (((TransactionInfo)object5).getType() == 3 && ((TransactionInfo)object5).getTransactionHomeBroker() == null) {
                    this.logger.log(16, "B2204", (Object)serializable3, ((LoadException)serializable4).getValueCause());
                    this.store.storeRemoteTransaction((TransactionUID)serializable3, ((TransactionInfo)object5).getTransactionState(), null, null, false);
                    serializable4 = ((LoadException)serializable4).getNextException();
                    continue;
                }
                this.logger.log(32, "XXXI18N Internal Error: unknown load error for TUID=" + serializable3 + "[" + ((TransactionInfo)object5).toString() + "]");
            }
        }
        if ((loadException = Globals.getStore().getLoadTransactionAckException()) != null) {
            serializable4 = loadException;
            while (serializable4 != null) {
                serializable3 = (TransactionUID)((LoadException)serializable4).getKey();
                object5 = (TransactionAcknowledgement[])((LoadException)serializable4).getValue();
                if (serializable3 == null && object5 == null) {
                    this.logger.log(16, "B3044", (Object)"both key and value for a Transaction Ack entry are corrupted");
                    serializable4 = ((LoadException)serializable4).getNextException();
                    continue;
                }
                if (serializable3 == null) {
                    this.logger.log(16, "B2098", (Object)object5.toString());
                    serializable4 = ((LoadException)serializable4).getNextException();
                    continue;
                }
                this.logger.log(16, "B2099", (Object)((TransactionUID)serializable3).toString());
                try {
                    this.store.removeTransactionAck((TransactionUID)serializable3, false);
                }
                catch (Exception exception) {
                    this.logger.logStack(16, "B3044", (Object)("Error updating transaction acks " + serializable3), (Throwable)exception);
                }
            }
        }
        this.logger.log(8, "B1136");
        serializable4 = this.store.getAllTransactionStates();
        TransactionList.logTransactionInfo((HashMap)serializable4, AUTO_ROLLBACK);
        serializable3 = new HashSet(((HashMap)serializable4).size());
        object5 = new HashSet(((HashMap)serializable4).size());
        serializable2 = new HashMap();
        HashMap<SysMessageID, Object> hashMap = new HashMap<SysMessageID, Object>();
        HashMap<TransactionUID, String> hashMap2 = new HashMap<TransactionUID, String>();
        int n3 = 0;
        boolean bl = false;
        boolean bl2 = false;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        Iterator iterator = ((HashMap)serializable4).entrySet().iterator();
        while (iterator.hasNext()) {
            ++n3;
            try {
                object4 = iterator.next();
                serializable = (TransactionUID)object4.getKey();
                TransactionState transactionState = (TransactionState)object4.getValue();
                TransactionAcknowledgement[] transactionAcknowledgementArray = this.store.getTransactionAcks((TransactionUID)serializable);
                n2 = transactionState.getState();
                if (DEBUG) {
                    this.logger.log(8, "Load transaction: TUID=" + serializable + "[" + TransactionState.toString(n2) + (transactionState.getCreationTime() == 0L ? "" : " createTime=" + transactionState.getCreationTime()) + "]");
                }
                switch (n2) {
                    case 0: {
                        ((HashSet)serializable3).add(serializable);
                        break;
                    }
                    case 5: {
                        ++n4;
                        if (!AUTO_ROLLBACK) {
                            this.addTransactionID((TransactionUID)serializable, transactionState, false);
                            if (this.store.getTransactionInfo((TransactionUID)serializable).getType() == 2) {
                                this.logClusterTransaction((TransactionUID)serializable, transactionState, this.store.getClusterTransactionBrokers((TransactionUID)serializable), true, false);
                                ++n7;
                            }
                            ((HashMap)serializable2).put(serializable, Boolean.TRUE);
                            break;
                        }
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 7: {
                        this.addTransactionID((TransactionUID)serializable, transactionState, false);
                        if (this.store.getTransactionInfo((TransactionUID)serializable).getType() == 2) {
                            this.logClusterTransaction((TransactionUID)serializable, transactionState, this.store.getClusterTransactionBrokers((TransactionUID)serializable), true, false);
                        }
                        ((HashMap)serializable2).put(serializable, Boolean.FALSE);
                        ((HashSet)serializable3).add(serializable);
                        transactionState.setState(7);
                        ++n6;
                        if (n2 != 5) break;
                        ((HashSet)object5).add(serializable);
                        try {
                            this.updateState((TransactionUID)serializable, 7, true);
                        }
                        catch (Exception exception) {
                            this.logger.logStack(16, "Unable to update auto-rollback PREPARED transaction " + serializable + " state to ROLLEDBACK", (Throwable)exception);
                        }
                        break;
                    }
                    case 6: {
                        ++n5;
                        hashMap2.put((TransactionUID)serializable, "");
                        if (this.store.getTransactionInfo((TransactionUID)serializable).getType() == 2) {
                            ++n8;
                            n = 1;
                            object3 = this.store.getClusterTransactionBrokers((TransactionUID)serializable);
                            this.logClusterTransaction((TransactionUID)serializable, transactionState, (TransactionBroker[])object3, false, false);
                            for (int i = 0; object3 != null && i < ((Object)object3).length; ++i) {
                                n = ((TransactionBroker)object3[i]).isCompleted() ? 1 : 0;
                                if (n != 0) continue;
                                if (!DEBUG_CLUSTER_TXN) break;
                                this.logger.log(8, "COMMITTED cluster transaction " + serializable + ", incomplete broker:" + object3[i]);
                                break;
                            }
                            if (n == 0) {
                                ++n9;
                            }
                        } else {
                            this.addTransactionID((TransactionUID)serializable, transactionState, false);
                        }
                        ((HashSet)serializable3).add(serializable);
                        break;
                    }
                    default: {
                        this.logger.log(32, "Internal Error unexpected transaction state:" + TransactionState.toString(n2) + " TUID=" + serializable + ", set to PREPARE");
                        this.addTransactionID((TransactionUID)serializable, transactionState, false);
                        if (this.store.getTransactionInfo((TransactionUID)serializable).getType() == 2) {
                            this.logClusterTransaction((TransactionUID)serializable, transactionState, this.store.getClusterTransactionBrokers((TransactionUID)serializable), true, false);
                        }
                        this.updateState((TransactionUID)serializable, 5, true);
                        ((HashMap)serializable2).put(serializable, Boolean.TRUE);
                    }
                }
                for (n = 0; n < transactionAcknowledgementArray.length; ++n) {
                    if (DEBUG) {
                        this.logger.log(8, "Load transaction ack " + transactionAcknowledgementArray[n] + " [TUID=" + serializable + "]");
                    }
                    object3 = transactionAcknowledgementArray[n].getConsumerUID();
                    Object object6 = transactionAcknowledgementArray[n].getStoredConsumerUID();
                    SysMessageID object22 = transactionAcknowledgementArray[n].getSysMessageID();
                    object = (TransactionAcknowledgement[])hashMap.get(object22);
                    if (object6 == null) {
                        this.logger.log(16, "Internal Error:  Unable to locate stored ConsumerUID :" + transactionAcknowledgementArray);
                        object6 = object3;
                        if (transactionAcknowledgementArray == null) {
                            this.logger.log(16, "Internal Error:  no consumerUID stored w/ the transaction:" + transactionAcknowledgementArray);
                            continue;
                        }
                    }
                    if (object == null) {
                        object = new HashMap();
                        hashMap.put(object22, object);
                    }
                    object.put(object6, serializable);
                    if (((HashMap)serializable2).get(serializable) == null) continue;
                    TransactionInformation transactionInformation = (TransactionInformation)this.translist.get(serializable);
                    if (transactionInformation == null) {
                        this.logger.log(8, "Unable to retrieve  transaction information " + transactionInformation + " for " + serializable + " we may be clearing the transaction");
                        continue;
                    }
                    if (((HashMap)serializable2).get(serializable) == Boolean.TRUE) {
                        transactionInformation.addConsumedMessage(object22, (ConsumerUID)object3, (ConsumerUID)object6);
                    }
                    transactionInformation.addOrphanAck(object22, (ConsumerUID)object6);
                }
            }
            catch (Exception exception) {
                this.logger.logStack(16, "B3100", (Object)"Error parsing transaction ", (Throwable)exception);
            }
        }
        object4 = new Object[]{n7, n9};
        this.logger.log(8, Globals.getBrokerResources().getKString("B1284", (Object[])object4));
        object4 = this.store.getAllRemoteTransactionStates();
        serializable = new HashSet(((HashMap)object4).size());
        int n10 = 0;
        int n11 = 0;
        n2 = 0;
        n = 0;
        iterator = ((HashMap)object4).entrySet().iterator();
        while (iterator.hasNext()) {
            try {
                object3 = iterator.next();
                TransactionUID transactionUID = (TransactionUID)object3.getKey();
                TransactionState transactionState = (TransactionState)object3.getValue();
                object = this.store.getTransactionAcks(transactionUID);
                int n12 = transactionState.getState();
                if (DEBUG) {
                    this.logger.log(8, "Load remote transaction: TUID=" + transactionUID + "[" + TransactionState.toString(n12) + (transactionState.getCreationTime() == 0L ? "" : " createTime=" + transactionState.getCreationTime()) + "]");
                }
                switch (n12) {
                    case 0: {
                        ((HashSet)serializable).add(transactionUID);
                        ++n11;
                        break;
                    }
                    case 5: {
                        ++n10;
                        this.logRemoteTransaction(transactionUID, transactionState, (TransactionAcknowledgement[])object, this.store.getRemoteTransactionHomeBroker(transactionUID), true, true, false);
                        ((HashMap)serializable2).put(transactionUID, Boolean.TRUE);
                        break;
                    }
                    case 4: {
                        if (Globals.getHAEnabled() && object != null && ((TransactionAcknowledgement[])object).length > 0) {
                            ++n;
                            transactionState.setState(5);
                            this.logRemoteTransaction(transactionUID, transactionState, (TransactionAcknowledgement[])object, this.store.getRemoteTransactionHomeBroker(transactionUID), true, true, false);
                            ((HashMap)serializable2).put(transactionUID, Boolean.TRUE);
                            break;
                        }
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 7: {
                        ((HashMap)serializable2).put(transactionUID, Boolean.FALSE);
                        ((HashSet)serializable).add(transactionUID);
                        ++n11;
                        break;
                    }
                    case 6: {
                        ++n2;
                        this.logRemoteTransaction(transactionUID, transactionState, (TransactionAcknowledgement[])object, this.store.getRemoteTransactionHomeBroker(transactionUID), true, true, false);
                        hashMap2.put(transactionUID, "");
                        break;
                    }
                    default: {
                        this.logger.log(32, "Internal Error unexpected transaction state:" + TransactionState.toString(n12) + " TUID=" + transactionUID + ", set to PREPARED");
                        this.logRemoteTransaction(transactionUID, transactionState, (TransactionAcknowledgement[])object, this.store.getRemoteTransactionHomeBroker(transactionUID), true, true, false);
                        this.updateRemoteTransactionState(transactionUID, 5, true, true, true);
                        ((HashMap)serializable2).put(transactionUID, Boolean.TRUE);
                    }
                }
                for (int i = 0; i < ((TransactionAcknowledgement[])object).length; ++i) {
                    if (DEBUG) {
                        this.logger.log(8, "Load remote transaction ack " + object[i] + " [TUID=" + transactionUID + "]");
                    }
                    ConsumerUID consumerUID = object[i].getConsumerUID();
                    ConsumerUID consumerUID2 = object[i].getStoredConsumerUID();
                    SysMessageID sysMessageID = object[i].getSysMessageID();
                    HashMap<ConsumerUID, TransactionUID> hashMap3 = (HashMap<ConsumerUID, TransactionUID>)hashMap.get(sysMessageID);
                    if (consumerUID2 == null) {
                        this.logger.log(16, "Internal Error:  Unable to locate stored ConsumerUID :" + object);
                        consumerUID2 = consumerUID;
                    }
                    if (hashMap3 == null) {
                        hashMap3 = new HashMap<ConsumerUID, TransactionUID>();
                        hashMap.put(sysMessageID, hashMap3);
                    }
                    hashMap3.put(consumerUID2, transactionUID);
                }
            }
            catch (Exception exception) {
                this.logger.logStack(16, "B3100", (Object)"Error parsing remote transaction ", (Throwable)exception);
            }
        }
        if (Globals.getHAEnabled()) {
            object3 = new Object[]{String.valueOf(((HashMap)object4).size()), String.valueOf(n10), String.valueOf(n), String.valueOf(n2)};
            this.logger.log(8, Globals.getBrokerResources().getString("B1268", (Object[])object3));
        } else {
            object3 = new Object[]{String.valueOf(((HashMap)object4).size()), String.valueOf(n10), String.valueOf(n2)};
            this.logger.log(8, Globals.getBrokerResources().getString("B1267", (Object[])object3));
        }
        if (!(((HashMap)serializable2).size() <= 0 && hashMap.size() <= 0 || (object3 = Destination.processTransactions(hashMap, (Map)((Object)serializable2), hashMap2)) == null || ((HashMap)object3).isEmpty())) {
            for (Map.Entry entry : ((LinkedHashMap)object3).entrySet()) {
                object = (TransactionInformation)this.translist.get(entry.getValue());
                ((TransactionInformation)object).addPublishedMessage((SysMessageID)entry.getKey());
            }
        }
        object3 = null;
        Object var25_38 = null;
        iterator = ((HashSet)serializable3).iterator();
        while (iterator.hasNext()) {
            TransactionUID transactionUID = (TransactionUID)((Object)iterator.next());
            this.logger.log(4, "Clearing transaction " + transactionUID);
            if (!((HashSet)object5).contains(transactionUID)) {
                this.removeTransactionAck(transactionUID);
                this.removeTransactionID(transactionUID);
                continue;
            }
            this.removeTransactionAck(transactionUID, true);
        }
        iterator = ((HashSet)serializable).iterator();
        while (iterator.hasNext()) {
            TransactionUID transactionUID = (TransactionUID)((Object)iterator.next());
            try {
                this.logger.log(4, "Clearing remote transaction " + transactionUID);
                this.removeRemoteTransactionAck(transactionUID);
                this.removeRemoteTransactionID(transactionUID, true);
            }
            catch (Exception exception) {
                this.logger.log(16, "Failed to remove remote transaction TUID=" + transactionUID + ": " + exception.getMessage());
            }
        }
    }

    public static void logTransactionInfo(HashMap hashMap, boolean bl) {
        Logger logger = Globals.getLogger();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (hashMap != null && hashMap.size() > 0) {
            Object[] objectArray2;
            for (Object[] objectArray2 : hashMap.values()) {
                if (objectArray2.getState() == 5) {
                    ++n2;
                    if (!bl) continue;
                    ++n;
                    continue;
                }
                if (objectArray2.getState() != 6) {
                    ++n;
                    continue;
                }
                ++n3;
            }
            logger.log(8, "B1079", (Object)new Integer(hashMap.size()), (Object)new Integer(n));
            objectArray2 = new Object[]{new Integer(hashMap.size()), new Integer(n2), new Integer(n3)};
            logger.log(8, "B1080", objectArray2);
            if (n2 > 0) {
                if (bl) {
                    logger.log(8, "B1081");
                } else {
                    logger.log(8, "B1082");
                }
            }
        }
    }

    public void logClusterTransaction(TransactionUID transactionUID, TransactionState transactionState, TransactionBroker[] transactionBrokerArray, boolean bl, boolean bl2) throws BrokerException {
        this.logClusterTransaction(transactionUID, transactionState, transactionBrokerArray, bl, bl2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logClusterTransaction(TransactionUID transactionUID, TransactionState transactionState, TransactionBroker[] transactionBrokerArray, boolean bl, boolean bl2, ClusterTransaction clusterTransaction) throws BrokerException {
        boolean bl3 = false;
        TransactionInformation transactionInformation = null;
        this.shareLock.lock();
        try {
            transactionInformation = (TransactionInformation)this.translist.get(transactionUID);
            Object var10_9 = null;
            this.shareLock.unlock();
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.shareLock.unlock();
            throw throwable;
        }
        if (transactionInformation == null) {
            if (bl) {
                throw new BrokerException(Globals.getBrokerResources().getString("B4117", "logClusterTransaction(): Unknown transaction: " + transactionUID));
            }
            transactionInformation = this.addTransactionID(transactionUID, transactionState, false);
            bl3 = true;
        }
        if (transactionInformation != null && transactionInformation.isTakeoverLocked()) {
            throw new BrokerException(Globals.getBrokerResources().getString("B4290", transactionUID), 404);
        }
        if (transactionInformation != null) {
            transactionInformation.setClusterTransactionBrokers(transactionBrokerArray);
        }
        if (bl2) {
            try {
                if (bl3) {
                    this.store.storeClusterTransaction(transactionUID, transactionState, transactionBrokerArray, Destination.PERSIST_SYNC);
                } else if (Globals.isNewTxnLogEnabled()) {
                    this.store.logTxn(clusterTransaction);
                } else {
                    this.store.updateClusterTransaction(transactionUID, transactionBrokerArray, Destination.PERSIST_SYNC);
                }
            }
            catch (BrokerException brokerException) {
                if (bl3) {
                    this.removeTransactionID(transactionUID, false, true, false);
                }
                throw brokerException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completeClusterTransactionBrokerState(TransactionUID transactionUID, int n, BrokerAddress brokerAddress, boolean bl) throws BrokerException {
        boolean bl2 = false;
        TransactionBroker transactionBroker = null;
        TransactionInformation transactionInformation = null;
        this.shareLock.lock();
        try {
            transactionInformation = (TransactionInformation)this.translist.get(transactionUID);
            Object var9_8 = null;
            this.shareLock.unlock();
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.shareLock.unlock();
            throw throwable;
        }
        if (transactionInformation == null) {
            throw new BrokerException(Globals.getBrokerResources().getString("B4117", "updateClusterTransationBrokerState(): Unknown transaction: " + transactionUID));
        }
        TransactionInformation transactionInformation2 = transactionInformation;
        synchronized (transactionInformation2) {
            if (transactionInformation.getState().getState() != n) {
                throw new BrokerException(Globals.getBrokerResources().getString("B4117", "updateClusterTransactionBrokerState(): Unexpected cluster transaction state: " + transactionInformation.getState()) + ", expect:" + n);
            }
            transactionBroker = transactionInformation.getClusterTransactionBroker(brokerAddress);
            if (transactionBroker == null) {
                throw new BrokerException("Can't update transaction broker state " + brokerAddress.toString() + ": not found", 404);
            }
            bl2 = transactionBroker.copyState(new TransactionBroker(brokerAddress, true));
        }
        if (bl && bl2) {
            this.store.updateClusterTransactionBrokerState(transactionUID, n, transactionBroker, Destination.PERSIST_SYNC);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateRemoteTransactionState(TransactionUID transactionUID, int n, boolean bl, boolean bl2, boolean bl3) throws BrokerException {
        Object[] objectArray;
        boolean bl4 = false;
        TransactionState transactionState = null;
        RemoteTransactionInformation remoteTransactionInformation = null;
        this.shareLock.lock();
        try {
            remoteTransactionInformation = (RemoteTransactionInformation)this.remoteTranslist.get(transactionUID);
            objectArray = null;
            this.shareLock.unlock();
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.shareLock.unlock();
            throw throwable;
        }
        if (remoteTransactionInformation == null) {
            if (n == 6 && this.txnReaper.hasRemoteTransaction(transactionUID)) {
                if (DEBUG_CLUSTER_TXN) {
                    this.logger.log(8, "Remote transaction " + transactionUID + " has already been committed");
                }
                return false;
            }
            throw new BrokerException("Update remote transaction state to " + TransactionState.toString(n) + ": transaction " + transactionUID + " not found, the transaction may have already been committed.", 404);
        }
        RemoteTransactionInformation remoteTransactionInformation2 = remoteTransactionInformation;
        synchronized (remoteTransactionInformation2) {
            transactionState = remoteTransactionInformation.getState();
            if (TransactionState.remoteTransactionNextState(transactionState, n) != n) {
                throw new BrokerException("Update remote transaction " + transactionUID + " to state " + TransactionState.toString(n) + " not allowed", 405);
            }
            if (transactionState.getState() != n) {
                remoteTransactionInformation.getState().setState(n);
                bl4 = true;
            }
        }
        if (bl3 && !Globals.getHAEnabled()) {
            try {
                this.store.updateTransactionState(transactionUID, transactionState, bl2 ? Destination.PERSIST_SYNC : false);
                if (Globals.isNewTxnLogEnabled()) {
                    this.store.logTxnCompletion(transactionUID, n, 2);
                }
            }
            catch (IOException iOException) {
                objectArray = new String[]{transactionUID.toString(), TransactionState.toString(n), iOException.getMessage()};
                throw new BrokerException(Globals.getBrokerResources().getKString("B4300", objectArray), iOException);
            }
        }
        if (bl4 && n == 6) {
            this.txnReaper.addRemoteTransaction(transactionUID, bl);
        }
        return bl4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteTransactionAckEntry[] getRecoveryRemoteTransactionAcks(TransactionUID transactionUID) throws BrokerException {
        RemoteTransactionInformation remoteTransactionInformation = null;
        this.shareLock.lock();
        try {
            remoteTransactionInformation = (RemoteTransactionInformation)this.remoteTranslist.get(transactionUID);
            Object var4_3 = null;
            this.shareLock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.shareLock.unlock();
            throw throwable;
        }
        if (remoteTransactionInformation == null) {
            return null;
        }
        return remoteTransactionInformation.getRecoveryTransactionAcks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void logRemoteTransaction(TransactionUID transactionUID, TransactionState transactionState, TransactionAcknowledgement[] transactionAcknowledgementArray, BrokerAddress brokerAddress, boolean bl, boolean bl2, boolean bl3) throws BrokerException {
        DestinationUID[] destinationUIDArray;
        DestinationUID[] destinationUIDArray2 = null;
        boolean bl4 = false;
        this.exclusiveLock.lock();
        try {
            destinationUIDArray2 = (DestinationUID[])this.remoteTranslist.get(transactionUID);
            if (bl2) {
                if (destinationUIDArray2 != null) throw new BrokerException(Globals.getBrokerResources().getKString("B4061", transactionUID.toString()), "B4061", null, 409);
                if (this.inuse_translist.contains(transactionUID)) throw new BrokerException(Globals.getBrokerResources().getKString("B4061", transactionUID.toString()), "B4061", null, 409);
                if (this.translist.containsKey(transactionUID)) {
                    throw new BrokerException(Globals.getBrokerResources().getKString("B4061", transactionUID.toString()), "B4061", null, 409);
                }
            }
            if (destinationUIDArray2 == null) {
                destinationUIDArray2 = new RemoteTransactionInformation(transactionUID, transactionState, transactionAcknowledgementArray, brokerAddress, bl, bl3);
                this.inuse_translist.add(transactionUID);
                this.remoteTranslist.put(transactionUID, destinationUIDArray2);
                bl4 = true;
            }
            Object var11_10 = null;
            this.exclusiveLock.unlock();
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            this.exclusiveLock.unlock();
            throw throwable;
        }
        if (!bl4) {
            if (!Globals.getHAEnabled()) {
                throw new BrokerException(Globals.getBrokerResources().getKString("B4061", transactionUID.toString()), "B4061", null, 409);
            }
            destinationUIDArray = destinationUIDArray2;
            // MONITORENTER : destinationUIDArray2
            if (!destinationUIDArray2.getTransactionHomeBroker().equals(new TransactionBroker(brokerAddress))) {
                throw new BrokerException("Transaction home broker mismatch:" + brokerAddress.toString() + " but existed " + destinationUIDArray2.getTransactionHomeBroker());
            }
            if (!bl) {
                throw new BrokerException("XXXI18N-Internal Error: unexpected non-recovery, TUID=" + transactionUID);
            }
            if (destinationUIDArray2.getState().getState() != transactionState.getState()) {
                throw new BrokerException("XXXI18N-Internal Error: state mismatch:" + TransactionState.toString(transactionState.getState()) + ", but exist" + TransactionState.toString(destinationUIDArray2.getState().getState()) + "TUID=" + transactionUID);
            }
            destinationUIDArray2.addRecoveryTransactionAcks(transactionAcknowledgementArray);
            // MONITOREXIT : destinationUIDArray
        }
        if (!bl3) return;
        if (!bl4) return;
        try {
            if (Globals.getHAEnabled()) {
                this.store.updateRemoteTransaction(transactionUID, transactionAcknowledgementArray, brokerAddress, Destination.PERSIST_SYNC);
                return;
            }
            if (!Globals.isNewTxnLogEnabled()) {
                this.store.storeRemoteTransaction(transactionUID, transactionState, transactionAcknowledgementArray, brokerAddress, Destination.PERSIST_SYNC);
                return;
            }
            destinationUIDArray = new DestinationUID[transactionAcknowledgementArray.length];
            int n = 0;
            while (true) {
                if (n >= transactionAcknowledgementArray.length) {
                    RemoteTransaction remoteTransaction = new RemoteTransaction(transactionUID, transactionState, transactionAcknowledgementArray, destinationUIDArray, brokerAddress);
                    this.store.logTxn(remoteTransaction);
                    return;
                }
                SysMessageID sysMessageID = transactionAcknowledgementArray[n].getSysMessageID();
                PacketReference packetReference = Destination.get(sysMessageID);
                DestinationUID destinationUID = null;
                if (packetReference != null) {
                    destinationUID = packetReference.getDestinationUID();
                } else {
                    this.logger.log(16, "Could not find packet for " + sysMessageID);
                }
                destinationUIDArray[n] = destinationUID;
                ++n;
            }
        }
        catch (Exception exception) {
            if (bl4) {
                this.exclusiveLock.lock();
                try {
                    this.inuse_translist.remove(transactionUID);
                    this.remoteTranslist.remove(transactionUID);
                    Object var16_20 = null;
                    this.exclusiveLock.unlock();
                }
                catch (Throwable throwable) {
                    Object var16_21 = null;
                    this.exclusiveLock.unlock();
                    throw throwable;
                }
            }
            this.logger.logStack(32, exception.getMessage() + (exception.getCause() == null ? "" : ": " + exception.getCause().getMessage()), (Throwable)exception);
            throw new BrokerException(Globals.getBrokerResources().getKString("B4062", transactionUID.toString()), "B4062", exception, 500);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteTransactionAckEntry getRemoteTransactionAcks(TransactionUID transactionUID) throws BrokerException {
        RemoteTransactionInformation remoteTransactionInformation = null;
        this.shareLock.lock();
        try {
            remoteTransactionInformation = (RemoteTransactionInformation)this.remoteTranslist.get(transactionUID);
            Object var4_3 = null;
            this.shareLock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.shareLock.unlock();
            throw throwable;
        }
        if (remoteTransactionInformation == null) {
            return null;
        }
        return remoteTransactionInformation.getTransactionAcks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRemoteTransactionID(TransactionUID transactionUID, boolean bl) throws BrokerException {
        RemoteTransactionInformation remoteTransactionInformation = null;
        this.shareLock.lock();
        try {
            remoteTransactionInformation = (RemoteTransactionInformation)this.remoteTranslist.get(transactionUID);
            Object var5_4 = null;
            this.shareLock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.shareLock.unlock();
            throw throwable;
        }
        if (remoteTransactionInformation == null) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4301", transactionUID.toString()), 404);
        }
        if (!remoteTransactionInformation.isProcessed()) {
            return;
        }
        try {
            if (bl && !Globals.getHAEnabled()) {
                this.store.removeTransaction(transactionUID, false);
            }
        }
        catch (Exception exception) {
            throw new BrokerException(Globals.getBrokerResources().getString("B4117", "Unable to remove cluster the transaction id " + transactionUID), exception);
        }
        this.exclusiveLock.lock();
        try {
            this.remoteTranslist.remove(transactionUID);
            if (!this.translist.containsKey(transactionUID)) {
                this.inuse_translist.remove(transactionUID);
            }
            Object var7_8 = null;
            this.exclusiveLock.unlock();
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.exclusiveLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionBroker[] getClusterTransactionBrokers(TransactionUID transactionUID) throws BrokerException {
        TransactionInformation transactionInformation = null;
        this.shareLock.lock();
        try {
            transactionInformation = (TransactionInformation)this.translist.get(transactionUID);
            Object var4_3 = null;
            this.shareLock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.shareLock.unlock();
            throw throwable;
        }
        if (transactionInformation == null) {
            throw new BrokerException(Globals.getBrokerResources().getString("B4117", "getClusterTransactionBrokers(): Unknown transaction: " + transactionUID));
        }
        return transactionInformation.getClusterTransactionBrokers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionBroker getClusterTransactionBroker(TransactionUID transactionUID, BrokerAddress brokerAddress) {
        TransactionInformation transactionInformation = null;
        this.shareLock.lock();
        try {
            transactionInformation = (TransactionInformation)this.translist.get(transactionUID);
            Object var5_4 = null;
            this.shareLock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.shareLock.unlock();
            throw throwable;
        }
        if (transactionInformation == null) {
            return null;
        }
        return transactionInformation.getClusterTransactionBroker(brokerAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClusterTransactionBroker(TransactionUID transactionUID, HAClusteredBroker hAClusteredBroker) {
        TransactionInformation transactionInformation = null;
        this.shareLock.lock();
        try {
            transactionInformation = (TransactionInformation)this.translist.get(transactionUID);
            Object var5_4 = null;
            this.shareLock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.shareLock.unlock();
            throw throwable;
        }
        if (transactionInformation == null) {
            return false;
        }
        return transactionInformation.isClusterTransactionBroker(hAClusteredBroker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasRemoteBroker(TransactionUID transactionUID) throws BrokerException {
        TransactionInformation transactionInformation = null;
        this.shareLock.lock();
        try {
            transactionInformation = (TransactionInformation)this.translist.get(transactionUID);
            Object var4_3 = null;
            this.shareLock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.shareLock.unlock();
            throw throwable;
        }
        if (transactionInformation == null) {
            return false;
        }
        TransactionBroker[] transactionBrokerArray = transactionInformation.getClusterTransactionBrokers();
        return transactionBrokerArray != null && transactionBrokerArray.length != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionState getRemoteTransactionState(TransactionUID transactionUID) {
        RemoteTransactionInformation remoteTransactionInformation = null;
        this.shareLock.lock();
        try {
            remoteTransactionInformation = (RemoteTransactionInformation)this.remoteTranslist.get(transactionUID);
            Object var4_3 = null;
            this.shareLock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.shareLock.unlock();
            throw throwable;
        }
        if (remoteTransactionInformation != null) {
            return remoteTransactionInformation.getState();
        }
        if (this.txnReaper.hasRemoteTransaction(transactionUID)) {
            TransactionState transactionState = new TransactionState();
            try {
                transactionState.setState(6);
                return transactionState;
            }
            catch (Exception exception) {
                this.logger.logStack(32, exception.getMessage(), (Throwable)exception);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionBroker getRemoteTransactionHomeBroker(TransactionUID transactionUID) {
        RemoteTransactionInformation remoteTransactionInformation = null;
        this.shareLock.lock();
        try {
            remoteTransactionInformation = (RemoteTransactionInformation)this.remoteTranslist.get(transactionUID);
            Object var4_3 = null;
            this.shareLock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.shareLock.unlock();
            throw throwable;
        }
        if (remoteTransactionInformation == null) {
            return null;
        }
        return remoteTransactionInformation.getTransactionHomeBroker();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getPreparedRemoteTransactions() {
        ArrayList<TransactionUID> arrayList = new ArrayList<TransactionUID>();
        TransactionUID transactionUID = null;
        TransactionState transactionState = null;
        RemoteTransactionInformation remoteTransactionInformation = null;
        this.shareLock.lock();
        try {
            for (Map.Entry entry : this.remoteTranslist.entrySet()) {
                transactionUID = (TransactionUID)entry.getKey();
                remoteTransactionInformation = (RemoteTransactionInformation)entry.getValue();
                if (remoteTransactionInformation == null || (transactionState = remoteTransactionInformation.getState()) == null || transactionState.getState() != 5) continue;
                arrayList.add(transactionUID);
            }
            Object var8_7 = null;
            this.shareLock.unlock();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.shareLock.unlock();
            throw throwable;
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAcknowledgement(TransactionUID transactionUID, SysMessageID sysMessageID, ConsumerUID consumerUID) throws BrokerException {
        TransactionInformation transactionInformation = null;
        this.shareLock.lock();
        try {
            transactionInformation = (TransactionInformation)this.translist.get(transactionUID);
            Object var6_5 = null;
            this.shareLock.unlock();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.shareLock.unlock();
            throw throwable;
        }
        if (transactionInformation == null) {
            throw new BrokerException(Globals.getBrokerResources().getString("B4117", "Removing acknowledgement with Unknown Transaction ID " + transactionUID));
        }
        transactionInformation.removeConsumedMessage(sysMessageID, consumerUID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap retrieveRemovedConsumedMessages(TransactionUID transactionUID) {
        TransactionInformation transactionInformation = null;
        this.shareLock.lock();
        try {
            transactionInformation = (TransactionInformation)this.translist.get(transactionUID);
            Object var4_3 = null;
            this.shareLock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.shareLock.unlock();
            throw throwable;
        }
        if (transactionInformation == null) {
            return null;
        }
        return transactionInformation.getRemovedConsumedMessages();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reapTakeoverCommittedTransaction(TransactionUID transactionUID) {
        TransactionInformation transactionInformation = null;
        this.shareLock.lock();
        try {
            transactionInformation = (TransactionInformation)this.translist.get(transactionUID);
            Object var4_3 = null;
            this.shareLock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.shareLock.unlock();
            throw throwable;
        }
        if (transactionInformation != null) {
            if (transactionInformation.getType() == 2) {
                this.txnReaper.addClusterTransaction(transactionUID, false, true);
            } else if (transactionInformation.getType() == 1) {
                this.txnReaper.addLocalTransaction(transactionUID, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLocalTransaction(TransactionUID transactionUID) {
        TransactionInformation transactionInformation = null;
        this.shareLock.lock();
        try {
            transactionInformation = (TransactionInformation)this.translist.get(transactionUID);
            Object var4_3 = null;
            this.shareLock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.shareLock.unlock();
            throw throwable;
        }
        if (transactionInformation == null) {
            return false;
        }
        return transactionInformation.getType() == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTransactionAsString(TransactionUID transactionUID) {
        this.shareLock.lock();
        try {
            TransactionInformation transactionInformation = (TransactionInformation)this.translist.get(transactionUID);
            String string = transactionInformation == null ? "null" : transactionInformation.toString();
            Object var5_4 = null;
            this.shareLock.unlock();
            return string;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.shareLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClusterTransaction(TransactionUID transactionUID) {
        TransactionInformation transactionInformation = null;
        this.shareLock.lock();
        try {
            transactionInformation = (TransactionInformation)this.translist.get(transactionUID);
            Object var4_3 = null;
            this.shareLock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.shareLock.unlock();
            throw throwable;
        }
        if (transactionInformation == null) {
            return false;
        }
        return transactionInformation.getType() == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRemoteTransaction(TransactionUID transactionUID) {
        RemoteTransactionInformation remoteTransactionInformation = null;
        this.shareLock.lock();
        try {
            remoteTransactionInformation = (RemoteTransactionInformation)this.remoteTranslist.get(transactionUID);
            Object var4_3 = null;
            this.shareLock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.shareLock.unlock();
            throw throwable;
        }
        return remoteTransactionInformation != null;
    }

    public void clusterPropertyChanged(String string, String string2) {
    }

    public void brokerAdded(ClusteredBroker clusteredBroker, UID uID) {
    }

    public void brokerRemoved(ClusteredBroker clusteredBroker, UID uID) {
    }

    public void masterBrokerChanged(ClusteredBroker clusteredBroker, ClusteredBroker clusteredBroker2) {
    }

    public void brokerStatusChanged(String string, int n, int n2, UID uID, Object object) {
        ClusterManager clusterManager = Globals.getClusterManager();
        ClusteredBroker clusteredBroker = clusterManager.getBroker(string);
        if (DEBUG_CLUSTER_TXN) {
            this.logger.log(8, "TransactionList:brokerStatusChanged:broker=" + clusteredBroker + ", oldStatus=" + BrokerStatus.toString(n) + ", newStatus=" + BrokerStatus.toString(n2) + ", brokerSession=" + uID + ", userData=" + object);
        }
        if (BrokerStatus.getBrokerLinkIsUp(n2) && !BrokerStatus.getBrokerLinkIsUp(n)) {
            this.newlyActivatedBrokers.add((BrokerMQAddress)clusteredBroker.getBrokerURL());
            if (this.txnReaper != null) {
                this.txnReaper.wakeupReaperTimer();
            }
        }
    }

    public void brokerStateChanged(String string, BrokerState brokerState, BrokerState brokerState2) {
    }

    public void brokerVersionChanged(String string, int n, int n2) {
    }

    public void brokerURLChanged(String string, MQAddress mQAddress, MQAddress mQAddress2) {
    }

    static {
        if (Globals.getLogger().getLevel() <= 4) {
            DEBUG = true;
        }
        DEBUG_CLUSTER_TXN = Globals.getConfig().getBooleanProperty("imq.cluster.debug.txn") || DEBUG;
        AUTO_ROLLBACK = Globals.getConfig().getBooleanProperty("imq.transaction.autorollback", false);
        TXN_REAPINTERVAL = Globals.getConfig().getLongProperty("imq.txn.reapInterval", 900L) * 1000L;
        TXN_REAPLIMIT = Globals.getConfig().getIntProperty("imq.txn.reapLimit", 500);
        defaultProducerMaxMsgCnt = Globals.getConfig().getIntProperty(TXN_PRODUCER_MAX_NUM_MSGS_PROP, 10000);
        defaultConsumerMaxMsgCnt = Globals.getConfig().getIntProperty(TXN_CONSUMER_MAX_NUM_MSGS_PROP, 1000);
        if (Broker.isInProcess()) {
            TXN_REAPLIMIT = Globals.getConfig().getIntProperty("imq.txn.reapLimit", 0);
        }
    }
}

