/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.audit;

import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.audit.MQAuditSession;
import com.sun.messaging.jmq.jmsserver.license.LicenseBase;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsservice.BrokerEvent;
import com.sun.messaging.jmq.util.log.Logger;

public class MQAuditService {
    static Logger logger = null;
    static BrokerResources br = null;
    public static boolean AUDIT_LOGGING_LICENSED = false;
    public static final String AUDIT_PROP_PREFIX = "imq.audit.";
    public static final String AUDIT_ENABLED_PROP = "imq.audit.enabled";
    private static final String CLASS_PROP_SUBFIX = ".class";
    public static final String BSM_TYPE = "bsm";
    public static final String LOG_TYPE = "log";
    private static final String DEFAULT_LOG_CLASS = "com.sun.messaging.jmq.jmsserver.audit.LogAuditSession";
    private static final String DEFAULT_BSM_CLASS = "com.sun.messaging.jmq.jmsserver.audit.BSMAuditSession";
    private static final String MQ_AUDIT_CLASS = "com.sun.messaging.jmq.jmsserver.audit.MQAuditManager";
    private static final String BSM_CLASS = "com.sun.audit.AuditSession";
    static boolean DEFAULT_BSM_DISABLED;
    static boolean bsmDisabled;
    static boolean bsmAudit;
    static boolean logAuditEnabled;
    private static MQAuditSession auditSession;

    public static void clear() {
        logger = null;
        br = null;
        auditSession = null;
    }

    public static void init() {
        logger = Globals.getLogger();
        br = Globals.getBrokerResources();
        try {
            LicenseBase licenseBase = Globals.getCurrentLicense(null);
            AUDIT_LOGGING_LICENSED = licenseBase.getBooleanProperty("imq.enable_audit_ccc", false);
        }
        catch (BrokerException brokerException) {
            AUDIT_LOGGING_LICENSED = false;
        }
        bsmDisabled = Globals.getConfig().getBooleanProperty("imq.audit.bsm.disabled", DEFAULT_BSM_DISABLED);
        if (AUDIT_LOGGING_LICENSED && !bsmDisabled) {
            try {
                Class.forName(BSM_CLASS);
                bsmAudit = true;
            }
            catch (Throwable throwable) {
                logger.log(1, "com.sun.audit.AuditSession not found:BSM audit not available:" + throwable);
            }
        }
    }

    public static synchronized MQAuditSession getAuditSession() throws BrokerException {
        if (auditSession == null) {
            logAuditEnabled = Globals.getConfig().getBooleanProperty(AUDIT_ENABLED_PROP, false);
            if (!AUDIT_LOGGING_LICENSED && logAuditEnabled) {
                Globals.getLogger().log(32, "B3123", (Object)Globals.getBrokerResources().getString("B0057"));
                Broker.getBroker().exit(1, Globals.getBrokerResources().getString("B0057"), BrokerEvent.Type.FATAL_ERROR);
            }
            auditSession = MQAuditService.createAuditSession();
        }
        return auditSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static MQAuditSession getAuditSession(String string) throws BrokerException {
        String string2 = null;
        if (LOG_TYPE.equals(string)) {
            string2 = DEFAULT_LOG_CLASS;
        } else {
            if (!BSM_TYPE.equals(string)) {
                throw new BrokerException("UNEXPECTED AUDIT TYPE SPECIFIED: " + string);
            }
            string2 = DEFAULT_BSM_CLASS;
        }
        String string3 = AUDIT_PROP_PREFIX + string + CLASS_PROP_SUBFIX;
        string2 = Globals.getConfig().getProperty(string3, string2);
        MQAuditSession mQAuditSession = null;
        Throwable throwable = null;
        try {
            try {
                mQAuditSession = (MQAuditSession)Class.forName(string2).newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                ClassNotFoundException classNotFoundException2 = classNotFoundException;
                Object var7_9 = null;
                if (classNotFoundException2 == null) return mQAuditSession;
                if (classNotFoundException2 instanceof BrokerException) {
                    throw (BrokerException)((Object)classNotFoundException2);
                }
                throw new BrokerException(br.getString("B4204", string2), classNotFoundException2);
            }
            catch (InstantiationException instantiationException) {
                InstantiationException instantiationException2 = instantiationException;
                Object var7_10 = null;
                if (instantiationException2 == null) return mQAuditSession;
                if (instantiationException2 instanceof BrokerException) {
                    throw (BrokerException)((Object)instantiationException2);
                }
                throw new BrokerException(br.getString("B4204", string2), instantiationException2);
            }
            catch (IllegalAccessException illegalAccessException) {
                IllegalAccessException illegalAccessException2 = illegalAccessException;
                Object var7_11 = null;
                if (illegalAccessException2 == null) return mQAuditSession;
                if (illegalAccessException2 instanceof BrokerException) {
                    throw (BrokerException)((Object)illegalAccessException2);
                }
                throw new BrokerException(br.getString("B4204", string2), illegalAccessException2);
            }
            Object var7_8 = null;
            if (throwable == null) return mQAuditSession;
        }
        catch (Throwable throwable2) {
            Object var7_12 = null;
            if (throwable == null) {
                throw throwable2;
            }
            if (throwable instanceof BrokerException) {
                throw (BrokerException)throwable;
            }
            throw new BrokerException(br.getString("B4204", string2), throwable);
        }
        if (throwable instanceof BrokerException) {
            throw (BrokerException)throwable;
        }
        throw new BrokerException(br.getString("B4204", string2), throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static MQAuditSession createAuditSession() throws BrokerException {
        MQAuditSession mQAuditSession = null;
        Throwable throwable = null;
        try {
            try {
                mQAuditSession = (MQAuditSession)Class.forName(MQ_AUDIT_CLASS).newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                ClassNotFoundException classNotFoundException2 = classNotFoundException;
                Object var4_6 = null;
                if (classNotFoundException2 == null) return mQAuditSession;
                if (classNotFoundException2 instanceof BrokerException) {
                    throw (BrokerException)((Object)classNotFoundException2);
                }
                throw new BrokerException(br.getString("B4204", MQ_AUDIT_CLASS), classNotFoundException2);
            }
            catch (InstantiationException instantiationException) {
                InstantiationException instantiationException2 = instantiationException;
                Object var4_7 = null;
                if (instantiationException2 == null) return mQAuditSession;
                if (instantiationException2 instanceof BrokerException) {
                    throw (BrokerException)((Object)instantiationException2);
                }
                throw new BrokerException(br.getString("B4204", MQ_AUDIT_CLASS), instantiationException2);
            }
            catch (IllegalAccessException illegalAccessException) {
                IllegalAccessException illegalAccessException2 = illegalAccessException;
                Object var4_8 = null;
                if (illegalAccessException2 == null) return mQAuditSession;
                if (illegalAccessException2 instanceof BrokerException) {
                    throw (BrokerException)((Object)illegalAccessException2);
                }
                throw new BrokerException(br.getString("B4204", MQ_AUDIT_CLASS), illegalAccessException2);
            }
            Object var4_5 = null;
            if (throwable == null) return mQAuditSession;
        }
        catch (Throwable throwable2) {
            Object var4_9 = null;
            if (throwable == null) {
                throw throwable2;
            }
            if (throwable instanceof BrokerException) {
                throw (BrokerException)throwable;
            }
            throw new BrokerException(br.getString("B4204", MQ_AUDIT_CLASS), throwable);
        }
        if (throwable instanceof BrokerException) {
            throw (BrokerException)throwable;
        }
        throw new BrokerException(br.getString("B4204", MQ_AUDIT_CLASS), throwable);
    }

    static {
        bsmDisabled = DEFAULT_BSM_DISABLED = true;
        bsmAudit = false;
        logAuditEnabled = false;
        auditSession = null;
    }
}

