/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.searchpolicy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.felix.framework.Logger;
import org.apache.felix.framework.searchpolicy.CandidateSet;
import org.apache.felix.framework.searchpolicy.R4Wire;
import org.apache.felix.framework.searchpolicy.R4WireModule;
import org.apache.felix.framework.searchpolicy.ResolveException;
import org.apache.felix.framework.searchpolicy.ResolvedPackage;
import org.apache.felix.framework.util.Util;
import org.apache.felix.framework.util.manifestparser.Capability;
import org.apache.felix.framework.util.manifestparser.R4Attribute;
import org.apache.felix.framework.util.manifestparser.R4Directive;
import org.apache.felix.framework.util.manifestparser.R4Library;
import org.apache.felix.framework.util.manifestparser.Requirement;
import org.apache.felix.moduleloader.ICapability;
import org.apache.felix.moduleloader.IModule;
import org.apache.felix.moduleloader.IRequirement;
import org.apache.felix.moduleloader.IWire;

public class Resolver {
    private final Logger m_logger;
    private final String m_fwkExecEnvStr;
    private final Set m_fwkExecEnvSet;
    private static final IWire[] m_emptyWires = new IWire[0];
    private static final IModule[] m_emptyModules = new IModule[0];
    private boolean m_candidatesRotated = false;

    public Resolver(Logger logger, String fwkExecEnvStr) {
        this.m_logger = logger;
        this.m_fwkExecEnvStr = fwkExecEnvStr != null ? fwkExecEnvStr.trim() : null;
        this.m_fwkExecEnvSet = Resolver.parseExecutionEnvironments(fwkExecEnvStr);
    }

    public Map resolve(ResolverState state, IModule rootModule) throws ResolveException {
        if (rootModule.isResolved()) {
            return null;
        }
        HashMap candidatesMap = new HashMap();
        this.populateCandidatesMap(state, candidatesMap, rootModule);
        this.findConsistentClassSpace(state, candidatesMap, rootModule);
        return Resolver.populateWireMap(state, candidatesMap, rootModule, new HashMap());
    }

    public Object[] resolveDynamicImport(ResolverState state, IModule importer, String pkgName) throws ResolveException {
        ICapability candidate = null;
        Map resolvedModuleWireMap = null;
        IRequirement dynReq = Resolver.findAllowedDynamicImport(importer, pkgName);
        if (dynReq != null) {
            R4Directive[] dirs = ((Requirement)dynReq).getDirectives();
            R4Attribute[] attrs = ((Requirement)dynReq).getAttributes();
            R4Attribute[] newAttrs = new R4Attribute[attrs.length];
            System.arraycopy(attrs, 0, newAttrs, 0, attrs.length);
            for (int attrIdx = 0; attrIdx < newAttrs.length; ++attrIdx) {
                if (!newAttrs[attrIdx].getName().equals("package")) continue;
                newAttrs[attrIdx] = new R4Attribute("package", pkgName, false);
                break;
            }
            Requirement target = new Requirement("package", dirs, newAttrs);
            try {
                List candidates = state.getResolvedCandidates(target);
                candidates.addAll(state.getUnresolvedCandidates(target));
                for (int candIdx = 0; candidate == null && candIdx < candidates.size(); ++candIdx) {
                    try {
                        resolvedModuleWireMap = this.resolveDynamicImportCandidate(state, ((ICapability)candidates.get(candIdx)).getModule(), importer);
                        if (resolvedModuleWireMap == null) continue;
                        candidate = (ICapability)candidates.get(candIdx);
                        continue;
                    }
                    catch (ResolveException ex) {
                        // empty catch block
                    }
                }
                if (candidate != null) {
                    Object[] result = new Object[]{new R4Wire(importer, dynReq, candidate.getModule(), candidate), resolvedModuleWireMap};
                    return result;
                }
            }
            catch (Exception ex) {
                this.m_logger.log(1, "Unable to dynamically import package.", ex);
            }
        }
        return null;
    }

    public static IRequirement findAllowedDynamicImport(IModule importer, String pkgName) {
        ICapability[] caps = importer.getCapabilities();
        for (int i = 0; caps != null && i < caps.length; ++i) {
            if (!caps[i].getNamespace().equals("package") || !caps[i].getProperties().get("package").equals(pkgName)) continue;
            return null;
        }
        IWire[] wires = importer.getWires();
        for (int i = 0; wires != null && i < wires.length; ++i) {
            if (!wires[i].hasPackage(pkgName)) continue;
            return null;
        }
        IRequirement[] dynamics = importer.getDynamicRequirements();
        for (int dynIdx = 0; dynamics != null && dynIdx < dynamics.length; ++dynIdx) {
            String dynPkgName = ((Requirement)dynamics[dynIdx]).getTargetName();
            boolean wildcard = dynPkgName.lastIndexOf(".*") >= 0;
            String string = dynPkgName = wildcard ? dynPkgName.substring(0, dynPkgName.length() - 1) : dynPkgName;
            if (!dynPkgName.equals("*") && !pkgName.equals(dynPkgName) && (!wildcard || !pkgName.startsWith(dynPkgName))) continue;
            return dynamics[dynIdx];
        }
        return null;
    }

    private Map resolveDynamicImportCandidate(ResolverState state, IModule provider, IModule importer) throws ResolveException {
        HashMap candidatesMap = new HashMap();
        if (!provider.isResolved()) {
            this.populateCandidatesMap(state, candidatesMap, provider);
            this.findConsistentClassSpace(state, candidatesMap, provider);
        }
        HashMap moduleMap = new HashMap();
        Map importerPkgMap = Resolver.getModulePackages(moduleMap, importer, candidatesMap);
        Map usesMap = Resolver.calculateUsesConstraints(provider, moduleMap, candidatesMap);
        Iterator iter = usesMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            ResolvedPackage rp = (ResolvedPackage)importerPkgMap.get(entry.getKey());
            if (rp == null) continue;
            rp = (ResolvedPackage)rp.clone();
            List constraintList = (List)entry.getValue();
            for (int constIdx = 0; constIdx < constraintList.size(); ++constIdx) {
                ResolvedPackage rpUses = (ResolvedPackage)constraintList.get(constIdx);
                if (rpUses.isSubset(rp)) continue;
                if (rp.isSubset(rpUses)) {
                    rp.m_capList.clear();
                    rp.m_capList.addAll(rpUses.m_capList);
                    continue;
                }
                this.m_logger.log(4, "Constraint violation for " + importer + " detected; module can see " + rp + " and " + rpUses);
                return null;
            }
        }
        return Resolver.populateWireMap(state, candidatesMap, provider, new HashMap());
    }

    private void populateCandidatesMap(ResolverState state, Map candidatesMap, IModule targetModule) throws ResolveException {
        if (candidatesMap.containsKey(targetModule)) {
            return;
        }
        Resolver.verifyExecutionEnvironment(this.m_fwkExecEnvStr, this.m_fwkExecEnvSet, targetModule);
        Resolver.verifyNativeLibraries(targetModule);
        candidatesMap.put(targetModule, null);
        ArrayList<CandidateSet> candSetList = new ArrayList<CandidateSet>();
        IRequirement[] reqs = targetModule.getRequirements();
        for (int reqIdx = 0; reqs != null && reqIdx < reqs.length; ++reqIdx) {
            List candidates = state.getResolvedCandidates(reqs[reqIdx]);
            candidates.addAll(state.getUnresolvedCandidates(reqs[reqIdx]));
            ResolveException rethrow = null;
            if (candidates.size() > 0) {
                Iterator it = candidates.iterator();
                while (it.hasNext()) {
                    ICapability candidate = (ICapability)it.next();
                    try {
                        if (candidate.getModule().isResolved()) continue;
                        this.populateCandidatesMap(state, candidatesMap, candidate.getModule());
                    }
                    catch (ResolveException ex) {
                        it.remove();
                        rethrow = ex;
                    }
                }
            }
            if (candidates.size() == 0 && !reqs[reqIdx].isOptional()) {
                Resolver.removeInvalidCandidate(targetModule, candidatesMap, new ArrayList());
                if (rethrow != null) {
                    throw rethrow;
                }
                throw new ResolveException("Unable to resolve.", targetModule, reqs[reqIdx]);
            }
            if (candidates.size() <= 0) continue;
            candSetList.add(new CandidateSet(targetModule, reqs[reqIdx], candidates));
        }
        candidatesMap.put(targetModule, candSetList);
    }

    private static void removeInvalidCandidate(IModule invalidModule, Map candidatesMap, List invalidList) {
        candidatesMap.remove(invalidModule);
        Iterator itCandidatesMap = candidatesMap.entrySet().iterator();
        while (itCandidatesMap.hasNext()) {
            Map.Entry entry = itCandidatesMap.next();
            IModule module = (IModule)entry.getKey();
            List candSetList = (List)entry.getValue();
            if (candSetList == null) continue;
            Iterator itCandSetList = candSetList.iterator();
            block1: while (itCandSetList.hasNext()) {
                CandidateSet cs = (CandidateSet)itCandSetList.next();
                Iterator itCandidates = cs.m_candidates.iterator();
                while (itCandidates.hasNext()) {
                    ICapability candCap = (ICapability)itCandidates.next();
                    if (!candCap.getModule().equals(invalidModule)) continue;
                    itCandidates.remove();
                    if (cs.m_candidates.size() != 0) continue block1;
                    itCandSetList.remove();
                    if (cs.m_requirement.isOptional() || module == invalidModule || invalidList.contains(module)) continue block1;
                    invalidList.add(module);
                    continue block1;
                }
            }
        }
        if (!invalidList.isEmpty()) {
            while (!invalidList.isEmpty()) {
                IModule m = (IModule)invalidList.remove(0);
                Resolver.removeInvalidCandidate(m, candidatesMap, invalidList);
            }
        }
    }

    private void findConsistentClassSpace(ResolverState state, Map candidatesMap, IModule rootModule) throws ResolveException {
        ArrayList candidatesList = null;
        HashMap moduleMap = new HashMap();
        HashMap cycleMap = new HashMap();
        while (!this.isSingletonConsistent(state, rootModule, moduleMap, candidatesMap) || !this.isClassSpaceConsistent(rootModule, moduleMap, cycleMap, candidatesMap)) {
            if (candidatesList == null) {
                candidatesList = new ArrayList();
                Iterator iter = candidatesMap.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    candidatesList.add(entry.getValue());
                }
                Collections.sort(candidatesList, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        int w2;
                        int w1 = this.calculateWeight((List)o1);
                        if (w1 < (w2 = this.calculateWeight((List)o2))) {
                            return -1;
                        }
                        if (w1 > w2) {
                            return 1;
                        }
                        return 0;
                    }

                    private int calculateWeight(List candSetList) {
                        int weight = 0;
                        for (int csIdx = 0; csIdx < candSetList.size(); ++csIdx) {
                            CandidateSet cs = (CandidateSet)candSetList.get(csIdx);
                            if (cs.m_candidates == null || cs.m_candidates.size() <= 1) continue;
                            weight += cs.m_candidates.size();
                        }
                        return -weight;
                    }
                });
            }
            if (!this.m_candidatesRotated) {
                Resolver.incrementCandidateConfiguration(candidatesList);
            } else {
                this.m_candidatesRotated = false;
            }
            moduleMap.clear();
            cycleMap.clear();
        }
    }

    private boolean isSingletonConsistent(ResolverState state, IModule targetModule, Map moduleMap, Map candidatesMap) {
        HashMap<String, String> singletonMap = new HashMap<String, String>();
        IModule[] modules = state.getModules();
        for (int i = 0; modules != null && i < modules.length; ++i) {
            if (!modules[i].isResolved() || !Resolver.isSingleton(modules[i])) continue;
            String symName = modules[i].getSymbolicName();
            singletonMap.put(symName, symName);
        }
        return this.areCandidatesSingletonConsistent(state, targetModule, singletonMap, moduleMap, new HashMap(), candidatesMap);
    }

    private boolean areCandidatesSingletonConsistent(ResolverState state, IModule targetModule, Map singletonMap, Map moduleMap, Map cycleMap, Map candidatesMap) {
        if (cycleMap.get(targetModule) != null) {
            return true;
        }
        cycleMap.put(targetModule, targetModule);
        String symName = targetModule.getSymbolicName();
        boolean isSingleton = Resolver.isSingleton(targetModule);
        if (isSingleton && singletonMap.containsKey(symName)) {
            return false;
        }
        if (isSingleton) {
            singletonMap.put(symName, symName);
        }
        Map pkgMap = null;
        try {
            pkgMap = Resolver.getModulePackages(moduleMap, targetModule, candidatesMap);
        }
        catch (ResolveException ex) {
            this.m_logger.log(4, "Constraint violation for " + targetModule + " detected.", ex);
            return false;
        }
        Iterator iter = pkgMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            ResolvedPackage rp = (ResolvedPackage)entry.getValue();
            for (int capIdx = 0; capIdx < rp.m_capList.size(); ++capIdx) {
                ICapability cap = (ICapability)rp.m_capList.get(capIdx);
                if (cap.getModule().isResolved()) continue;
                return this.areCandidatesSingletonConsistent(state, cap.getModule(), singletonMap, moduleMap, cycleMap, candidatesMap);
            }
        }
        return true;
    }

    private static boolean isSingleton(IModule module) {
        ICapability[] modCaps = Util.getCapabilityByNamespace(module, "module");
        if (modCaps == null || modCaps.length == 0) {
            return false;
        }
        R4Directive[] dirs = ((Capability)modCaps[0]).getDirectives();
        for (int dirIdx = 0; dirs != null && dirIdx < dirs.length; ++dirIdx) {
            if (!dirs[dirIdx].getName().equalsIgnoreCase("singleton") || !Boolean.valueOf(dirs[dirIdx].getValue()).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private boolean isClassSpaceConsistent(IModule targetModule, Map moduleMap, Map cycleMap, Map candidatesMap) {
        if (cycleMap.get(targetModule) != null) {
            return true;
        }
        cycleMap.put(targetModule, targetModule);
        Map pkgMap = null;
        try {
            pkgMap = Resolver.getModulePackages(moduleMap, targetModule, candidatesMap);
        }
        catch (ResolveException ex) {
            this.m_logger.log(4, "Constraint violation for " + targetModule + " detected.", ex);
            return false;
        }
        Iterator iter = pkgMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            ResolvedPackage rp = (ResolvedPackage)entry.getValue();
            for (int capIdx = 0; capIdx < rp.m_capList.size(); ++capIdx) {
                ICapability cap = (ICapability)rp.m_capList.get(capIdx);
                if (this.isClassSpaceConsistent(cap.getModule(), moduleMap, cycleMap, candidatesMap)) continue;
                return false;
            }
        }
        Map usesMap = null;
        try {
            usesMap = Resolver.calculateUsesConstraints(targetModule, moduleMap, candidatesMap);
        }
        catch (ResolveException ex) {
            this.m_logger.log(4, "Constraint violation for " + targetModule + " detected.", ex);
            return false;
        }
        Iterator iter2 = usesMap.entrySet().iterator();
        while (iter2.hasNext()) {
            Map.Entry entry = iter2.next();
            ResolvedPackage rp = (ResolvedPackage)pkgMap.get(entry.getKey());
            if (rp == null) continue;
            rp = (ResolvedPackage)rp.clone();
            List constraintList = (List)entry.getValue();
            for (int constIdx = 0; constIdx < constraintList.size(); ++constIdx) {
                ResolvedPackage rpUses = (ResolvedPackage)constraintList.get(constIdx);
                if (rpUses.isSubset(rp)) continue;
                if (rp.isSubset(rpUses)) {
                    rp.m_capList.clear();
                    rp.m_capList.addAll(rpUses.m_capList);
                    continue;
                }
                this.m_logger.log(4, "Constraint violation for " + targetModule + " detected; module can see " + rp + " and " + rpUses);
                if (rp.m_cs != null && rp.m_cs.m_candidates.size() > 1 && rp.m_cs.m_rotated < rp.m_cs.m_candidates.size()) {
                    ICapability first = (ICapability)rp.m_cs.m_candidates.get(0);
                    for (int i = 1; i < rp.m_cs.m_candidates.size(); ++i) {
                        rp.m_cs.m_candidates.set(i - 1, rp.m_cs.m_candidates.get(i));
                    }
                    rp.m_cs.m_candidates.set(rp.m_cs.m_candidates.size() - 1, first);
                    ++rp.m_cs.m_rotated;
                    this.m_candidatesRotated = true;
                }
                return false;
            }
        }
        return true;
    }

    private static Map calculateUsesConstraints(IModule targetModule, Map moduleMap, Map candidatesMap) throws ResolveException {
        Map usesMap = new HashMap();
        HashMap cycleMap = new HashMap();
        Map pkgMap = Resolver.getModulePackages(moduleMap, targetModule, candidatesMap);
        Iterator iter = pkgMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            ResolvedPackage rp = (ResolvedPackage)entry.getValue();
            for (int capIdx = 0; capIdx < rp.m_capList.size(); ++capIdx) {
                usesMap = Resolver.calculateUsesConstraints((ICapability)rp.m_capList.get(capIdx), moduleMap, usesMap, cycleMap, candidatesMap);
            }
        }
        return usesMap;
    }

    private static Map calculateUsesConstraints(ICapability capTarget, Map moduleMap, Map usesMap, Map cycleMap, Map candidatesMap) throws ResolveException {
        if (cycleMap.get(capTarget) != null) {
            return usesMap;
        }
        cycleMap.put(capTarget, capTarget);
        Map pkgMap = Resolver.getModulePackages(moduleMap, capTarget.getModule(), candidatesMap);
        Capability cap = (Capability)capTarget;
        for (int i = 0; i < cap.getUses().length; ++i) {
            ResolvedPackage rp = (ResolvedPackage)pkgMap.get(cap.getUses()[i]);
            if (rp == null) continue;
            for (int srcIdx = 0; srcIdx < rp.m_capList.size(); ++srcIdx) {
                usesMap = Resolver.calculateUsesConstraints((ICapability)rp.m_capList.get(srcIdx), moduleMap, usesMap, cycleMap, candidatesMap);
            }
            ArrayList<ResolvedPackage> constraintList = (ArrayList<ResolvedPackage>)usesMap.get(cap.getUses()[i]);
            if (constraintList == null) {
                constraintList = new ArrayList<ResolvedPackage>();
            }
            constraintList.add(rp);
            usesMap.put(cap.getUses()[i], constraintList);
        }
        return usesMap;
    }

    private static Map getModulePackages(Map moduleMap, IModule module, Map candidatesMap) throws ResolveException {
        Map map = (Map)moduleMap.get(module);
        if (map == null) {
            map = Resolver.calculateModulePackages(module, candidatesMap);
            moduleMap.put(module, map);
        }
        return map;
    }

    private static Map calculateModulePackages(IModule module, Map candidatesMap) throws ResolveException {
        Map.Entry entry;
        Map importedPackages = Resolver.calculateImportedPackages(module, candidatesMap);
        Map exportedPackages = Resolver.calculateExportedPackages(module);
        Map requiredPackages = Resolver.calculateRequiredPackages(module, candidatesMap);
        Iterator i = exportedPackages.entrySet().iterator();
        while (i.hasNext()) {
            entry = i.next();
            ResolvedPackage rpReq = (ResolvedPackage)requiredPackages.get(entry.getKey());
            if (rpReq != null) {
                ResolvedPackage rpExport = (ResolvedPackage)entry.getValue();
                rpReq.merge(rpExport);
                continue;
            }
            requiredPackages.put(entry.getKey(), entry.getValue());
        }
        i = importedPackages.entrySet().iterator();
        while (i.hasNext()) {
            entry = i.next();
            requiredPackages.put(entry.getKey(), entry.getValue());
        }
        return requiredPackages;
    }

    private static Map calculateImportedPackages(IModule targetModule, Map candidatesMap) throws ResolveException {
        return candidatesMap.get(targetModule) == null ? Resolver.calculateImportedPackagesResolved(targetModule) : Resolver.calculateImportedPackagesUnresolved(targetModule, candidatesMap);
    }

    private static Map calculateImportedPackagesUnresolved(IModule targetModule, Map candidatesMap) throws ResolveException {
        HashMap<String, ResolvedPackage> pkgMap = new HashMap<String, ResolvedPackage>();
        List candSetList = (List)candidatesMap.get(targetModule);
        for (int candSetIdx = 0; candSetList != null && candSetIdx < candSetList.size(); ++candSetIdx) {
            CandidateSet cs = (CandidateSet)candSetList.get(candSetIdx);
            ICapability candCap = (ICapability)cs.m_candidates.get(cs.m_idx);
            if (!candCap.getNamespace().equals("package")) continue;
            String pkgName = (String)candCap.getProperties().get("package");
            ResolvedPackage rp = new ResolvedPackage(pkgName, cs);
            rp.m_capList.add(candCap);
            pkgMap.put(rp.m_name, rp);
        }
        return pkgMap;
    }

    private static Map calculateImportedPackagesResolved(IModule targetModule) throws ResolveException {
        HashMap<String, ResolvedPackage> pkgMap = new HashMap<String, ResolvedPackage>();
        IWire[] wires = targetModule.getWires();
        for (int wireIdx = 0; wires != null && wireIdx < wires.length; ++wireIdx) {
            if (!wires[wireIdx].getCapability().getNamespace().equals("package")) continue;
            String pkgName = (String)wires[wireIdx].getCapability().getProperties().get("package");
            ResolvedPackage rp = (ResolvedPackage)pkgMap.get(pkgName);
            rp = rp == null ? new ResolvedPackage(pkgName, null) : rp;
            rp.m_capList.add(wires[wireIdx].getCapability());
            pkgMap.put(rp.m_name, rp);
        }
        return pkgMap;
    }

    private static Map calculateExportedPackages(IModule targetModule) {
        HashMap<String, ResolvedPackage> pkgMap = new HashMap<String, ResolvedPackage>();
        ICapability[] caps = targetModule.getCapabilities();
        for (int capIdx = 0; caps != null && capIdx < caps.length; ++capIdx) {
            if (!caps[capIdx].getNamespace().equals("package")) continue;
            String pkgName = (String)caps[capIdx].getProperties().get("package");
            ResolvedPackage rp = (ResolvedPackage)pkgMap.get(pkgName);
            rp = rp == null ? new ResolvedPackage(pkgName, null) : rp;
            rp.m_capList.add(caps[capIdx]);
            pkgMap.put(rp.m_name, rp);
        }
        return pkgMap;
    }

    private static Map calculateRequiredPackages(IModule targetModule, Map candidatesMap) {
        return candidatesMap.get(targetModule) == null ? Resolver.calculateRequiredPackagesResolved(targetModule) : Resolver.calculateRequiredPackagesUnresolved(targetModule, candidatesMap);
    }

    private static Map calculateRequiredPackagesUnresolved(IModule targetModule, Map candidatesMap) {
        HashMap pkgMap = new HashMap();
        List candSetList = (List)candidatesMap.get(targetModule);
        for (int candSetIdx = 0; candSetList != null && candSetIdx < candSetList.size(); ++candSetIdx) {
            CandidateSet cs = (CandidateSet)candSetList.get(candSetIdx);
            ICapability candCap = (ICapability)cs.m_candidates.get(cs.m_idx);
            if (!candCap.getNamespace().equals("module")) continue;
            HashMap<IModule, IModule> cycleMap = new HashMap<IModule, IModule>();
            cycleMap.put(targetModule, targetModule);
            Map requireMap = Resolver.calculateExportedAndReexportedPackages(candCap, candidatesMap, cycleMap);
            Iterator reqIter = requireMap.entrySet().iterator();
            while (reqIter.hasNext()) {
                Map.Entry entry = reqIter.next();
                ResolvedPackage rp = (ResolvedPackage)pkgMap.get(entry.getKey());
                if (rp != null) {
                    ResolvedPackage rpReq = (ResolvedPackage)entry.getValue();
                    rp.merge(rpReq);
                    continue;
                }
                pkgMap.put(entry.getKey(), entry.getValue());
            }
        }
        return pkgMap;
    }

    private static Map calculateRequiredPackagesResolved(IModule targetModule) {
        HashMap pkgMap = new HashMap();
        IWire[] wires = targetModule.getWires();
        for (int i = 0; wires != null && i < wires.length; ++i) {
            if (!wires[i].getCapability().getNamespace().equals("module")) continue;
            HashMap<IModule, IModule> cycleMap = new HashMap<IModule, IModule>();
            cycleMap.put(targetModule, targetModule);
            Map requireMap = Resolver.calculateExportedAndReexportedPackagesResolved(wires[i].getExporter(), cycleMap);
            Iterator reqIter = requireMap.entrySet().iterator();
            while (reqIter.hasNext()) {
                Map.Entry entry = reqIter.next();
                ResolvedPackage rp = (ResolvedPackage)pkgMap.get(entry.getKey());
                if (rp != null) {
                    ResolvedPackage rpReq = (ResolvedPackage)entry.getValue();
                    rp.merge(rpReq);
                    continue;
                }
                pkgMap.put(entry.getKey(), entry.getValue());
            }
        }
        return pkgMap;
    }

    private static Map calculateExportedAndReexportedPackages(ICapability capTarget, Map candidatesMap, Map cycleMap) {
        return candidatesMap.get(capTarget.getModule()) == null ? Resolver.calculateExportedAndReexportedPackagesResolved(capTarget.getModule(), cycleMap) : Resolver.calculateExportedAndReexportedPackagesUnresolved(capTarget, candidatesMap, cycleMap);
    }

    private static Map calculateExportedAndReexportedPackagesUnresolved(ICapability capTarget, Map candidatesMap, Map cycleMap) {
        HashMap pkgMap = new HashMap();
        if (cycleMap.get(capTarget.getModule()) != null) {
            return pkgMap;
        }
        cycleMap.put(capTarget.getModule(), capTarget.getModule());
        HashMap allRequiredMap = new HashMap();
        HashMap<String, String> reexportedPkgMap = new HashMap<String, String>();
        List candSetList = (List)candidatesMap.get(capTarget.getModule());
        for (int candSetIdx = 0; candSetIdx < candSetList.size(); ++candSetIdx) {
            CandidateSet cs = (CandidateSet)candSetList.get(candSetIdx);
            ICapability candCap = (ICapability)cs.m_candidates.get(cs.m_idx);
            if (!candCap.getNamespace().equals("module")) continue;
            boolean reexport = false;
            R4Directive[] dirs = ((Requirement)cs.m_requirement).getDirectives();
            for (int dirIdx = 0; !reexport && dirs != null && dirIdx < dirs.length; ++dirIdx) {
                if (!dirs[dirIdx].getName().equals("visibility") || !dirs[dirIdx].getValue().equals("reexport")) continue;
                reexport = true;
            }
            Map requiredMap = Resolver.calculateExportedAndReexportedPackages(candCap, candidatesMap, cycleMap);
            Iterator reqIter = requiredMap.entrySet().iterator();
            while (reqIter.hasNext()) {
                Map.Entry entry = reqIter.next();
                String pkgName = (String)entry.getKey();
                ResolvedPackage rp = (ResolvedPackage)allRequiredMap.get(pkgName);
                if (rp != null) {
                    ResolvedPackage rpReq = (ResolvedPackage)entry.getValue();
                    rp.merge(rpReq);
                } else {
                    allRequiredMap.put(pkgName, entry.getValue());
                }
                if (!reexport) continue;
                reexportedPkgMap.put(pkgName, pkgName);
            }
        }
        Iterator iter = reexportedPkgMap.entrySet().iterator();
        while (iter.hasNext()) {
            String pkgName = (String)iter.next().getKey();
            pkgMap.put(pkgName, allRequiredMap.get(pkgName));
        }
        ICapability[] candCaps = capTarget.getModule().getCapabilities();
        for (int capIdx = 0; candCaps != null && capIdx < candCaps.length; ++capIdx) {
            if (!candCaps[capIdx].getNamespace().equals("package")) continue;
            String pkgName = (String)candCaps[capIdx].getProperties().get("package");
            ResolvedPackage rp = (ResolvedPackage)pkgMap.get(pkgName);
            rp = rp == null ? new ResolvedPackage(pkgName, null) : rp;
            rp.m_capList.add(candCaps[capIdx]);
            pkgMap.put(rp.m_name, rp);
        }
        return pkgMap;
    }

    private static Map calculateExportedAndReexportedPackagesResolved(IModule targetModule, Map cycleMap) {
        HashMap pkgMap = new HashMap();
        if (cycleMap.get(targetModule) != null) {
            return pkgMap;
        }
        cycleMap.put(targetModule, targetModule);
        HashMap allRequiredMap = new HashMap();
        HashMap<String, String> reexportedPkgMap = new HashMap<String, String>();
        IWire[] wires = targetModule.getWires();
        for (int i = 0; wires != null && i < wires.length; ++i) {
            if (!wires[i].getCapability().getNamespace().equals("module")) continue;
            boolean reexport = false;
            R4Directive[] dirs = ((Requirement)wires[i].getRequirement()).getDirectives();
            for (int dirIdx = 0; !reexport && dirs != null && dirIdx < dirs.length; ++dirIdx) {
                if (!dirs[dirIdx].getName().equals("visibility") || !dirs[dirIdx].getValue().equals("reexport")) continue;
                reexport = true;
            }
            Map requiredMap = Resolver.calculateExportedAndReexportedPackagesResolved(wires[i].getExporter(), cycleMap);
            Iterator reqIter = requiredMap.entrySet().iterator();
            while (reqIter.hasNext()) {
                Map.Entry entry = reqIter.next();
                String pkgName = (String)entry.getKey();
                ResolvedPackage rp = (ResolvedPackage)allRequiredMap.get(pkgName);
                if (rp != null) {
                    ResolvedPackage rpReq = (ResolvedPackage)entry.getValue();
                    rp.merge(rpReq);
                } else {
                    allRequiredMap.put(pkgName, entry.getValue());
                }
                if (!reexport) continue;
                reexportedPkgMap.put(pkgName, pkgName);
            }
        }
        Iterator iter = reexportedPkgMap.entrySet().iterator();
        while (iter.hasNext()) {
            String pkgName = (String)iter.next().getKey();
            pkgMap.put(pkgName, allRequiredMap.get(pkgName));
        }
        ICapability[] caps = targetModule.getCapabilities();
        for (int i = 0; caps != null && i < caps.length; ++i) {
            if (!caps[i].getNamespace().equals("package")) continue;
            String pkgName = (String)caps[i].getProperties().get("package");
            ResolvedPackage rp = (ResolvedPackage)pkgMap.get(pkgName);
            rp = rp == null ? new ResolvedPackage(pkgName, null) : rp;
            rp.m_capList.add(caps[i]);
            pkgMap.put(rp.m_name, rp);
        }
        return pkgMap;
    }

    private static Map calculateCandidateRequiredPackages(IModule module, ICapability capTarget, Map candidatesMap) {
        HashMap<IModule, IModule> cycleMap = new HashMap<IModule, IModule>();
        cycleMap.put(module, module);
        return Resolver.calculateExportedAndReexportedPackages(capTarget, candidatesMap, cycleMap);
    }

    private static void incrementCandidateConfiguration(List resolverList) throws ResolveException {
        for (int i = 0; i < resolverList.size(); ++i) {
            List candSetList = (List)resolverList.get(i);
            for (int j = 0; j < candSetList.size(); ++j) {
                CandidateSet cs = (CandidateSet)candSetList.get(j);
                if (cs.m_idx + 1 < cs.m_candidates.size()) {
                    ++cs.m_idx;
                    return;
                }
                cs.m_idx = 0;
            }
        }
        throw new ResolveException("Unable to resolve due to constraint violation.", null, null);
    }

    private static Map populateWireMap(ResolverState state, Map candidatesMap, IModule importer, Map wireMap) {
        if (importer.isResolved() || wireMap.get(importer) != null) {
            return wireMap;
        }
        List candSetList = (List)candidatesMap.get(importer);
        ArrayList<R4WireModule> moduleWires = new ArrayList<R4WireModule>();
        ArrayList<IWire> packageWires = new ArrayList<IWire>();
        wireMap.put(importer, m_emptyWires);
        for (int candSetIdx = 0; candSetIdx < candSetList.size(); ++candSetIdx) {
            CandidateSet cs = (CandidateSet)candSetList.get(candSetIdx);
            if (cs.m_requirement.getNamespace().equals("module")) {
                moduleWires.add(new R4WireModule(importer, cs.m_requirement, ((ICapability)cs.m_candidates.get(cs.m_idx)).getModule(), (ICapability)cs.m_candidates.get(cs.m_idx), Resolver.calculateCandidateRequiredPackages(importer, (ICapability)cs.m_candidates.get(cs.m_idx), candidatesMap)));
            } else if (importer != ((ICapability)cs.m_candidates.get(cs.m_idx)).getModule()) {
                packageWires.add(new R4Wire(importer, cs.m_requirement, ((ICapability)cs.m_candidates.get(cs.m_idx)).getModule(), (ICapability)cs.m_candidates.get(cs.m_idx)));
            }
            wireMap = Resolver.populateWireMap(state, candidatesMap, ((ICapability)cs.m_candidates.get(cs.m_idx)).getModule(), wireMap);
        }
        packageWires.addAll(moduleWires);
        wireMap.put(importer, packageWires.toArray(new IWire[packageWires.size()]));
        return wireMap;
    }

    private static void verifyNativeLibraries(IModule module) throws ResolveException {
        R4Library[] libs = module.getNativeLibraries();
        if (libs != null) {
            String msg = null;
            for (int libIdx = 0; msg == null && libIdx < libs.length; ++libIdx) {
                String entryName = libs[libIdx].getEntryName();
                if (entryName == null || module.getContent().hasEntry(entryName)) continue;
                msg = "Native library does not exist: " + entryName;
            }
            if (libs.length == 0) {
                msg = "No matching native libraries found.";
            }
            if (msg != null) {
                throw new ResolveException(msg, module, null);
            }
        }
    }

    private static void verifyExecutionEnvironment(String fwkExecEnvStr, Set fwkExecEnvSet, IModule module) throws ResolveException {
        String bundleExecEnvStr = (String)module.getHeaders().get("Bundle-RequiredExecutionEnvironment");
        if (bundleExecEnvStr != null && !(bundleExecEnvStr = bundleExecEnvStr.trim()).equals("") && fwkExecEnvStr != null && fwkExecEnvStr.length() > 0) {
            StringTokenizer tokens = new StringTokenizer(bundleExecEnvStr, ",");
            boolean found = false;
            while (tokens.hasMoreTokens() && !found) {
                if (!fwkExecEnvSet.contains(tokens.nextToken().trim())) continue;
                found = true;
            }
            if (!found) {
                throw new ResolveException("Execution environment not supported: " + bundleExecEnvStr, module, null);
            }
        }
    }

    private static Set parseExecutionEnvironments(String fwkExecEnvStr) {
        HashSet<String> newSet = new HashSet<String>();
        if (fwkExecEnvStr != null) {
            StringTokenizer tokens = new StringTokenizer(fwkExecEnvStr, ",");
            while (tokens.hasMoreTokens()) {
                newSet.add(tokens.nextToken().trim());
            }
        }
        return newSet;
    }

    private static IModule[] shrinkModuleArray(IModule[] modules) {
        if (modules == null) {
            return m_emptyModules;
        }
        int lower = 0;
        for (int i = 0; i < modules.length; ++i) {
            if (modules[i] == null) continue;
            modules[lower++] = modules[i];
        }
        if (lower == 0) {
            return m_emptyModules;
        }
        IModule[] newModules = new IModule[lower];
        System.arraycopy(modules, 0, newModules, 0, lower);
        return newModules;
    }

    public static interface ResolverState {
        public IModule[] getModules();

        public List getResolvedCandidates(IRequirement var1);

        public List getUnresolvedCandidates(IRequirement var1);
    }
}

