/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra;

import com.sun.messaging.jms.ra.ManagedConnection;
import java.io.Serializable;
import java.util.Vector;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;

public class ConnectionManager
implements Serializable,
javax.resource.spi.ConnectionManager,
ConnectionEventListener {
    private transient Vector connections = null;
    private static final transient String _className = "com.sun.messaging.jms.ra.ConnectionManager";
    protected static final transient String _lgrNameOutboundConnection = "javax.resourceadapter.mqjmsra.outbound.connection";
    protected static final transient Logger _loggerOC = Logger.getLogger("javax.resourceadapter.mqjmsra.outbound.connection");
    protected static final transient String _lgrMIDPrefix = "MQJMSRA_CM";
    protected static final transient String _lgrMID_EET = "MQJMSRA_CM1001: ";
    protected static final transient String _lgrMID_INF = "MQJMSRA_CM1101: ";
    protected static final transient String _lgrMID_WRN = "MQJMSRA_CM2001: ";
    protected static final transient String _lgrMID_ERR = "MQJMSRA_CM3001: ";
    protected static final transient String _lgrMID_EXC = "MQJMSRA_CM4001: ";

    public ConnectionManager() {
        _loggerOC.entering(_className, "constructor()");
    }

    public Object allocateConnection(ManagedConnectionFactory managedConnectionFactory, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        Object[] objectArray = new Object[]{managedConnectionFactory, connectionRequestInfo};
        _loggerOC.entering(_className, "allocateConnection()", objectArray);
        javax.resource.spi.ManagedConnection managedConnection = null;
        managedConnection = managedConnectionFactory.createManagedConnection(null, connectionRequestInfo);
        managedConnection.addConnectionEventListener((ConnectionEventListener)this);
        return managedConnection.getConnection(null, connectionRequestInfo);
    }

    public void connectionClosed(ConnectionEvent connectionEvent) {
        _loggerOC.entering(_className, "connectionClosed()", connectionEvent);
        if (connectionEvent != null) {
            ManagedConnection managedConnection = (ManagedConnection)connectionEvent.getSource();
            try {
                _loggerOC.fine("MQJMSRA_CM1101: connectionClosed:event=" + connectionEvent + ":cleanup&destroy mc=" + managedConnection.toString());
                managedConnection.cleanup();
                managedConnection.destroy();
            }
            catch (Exception exception) {
                _loggerOC.warning("MQJMSRA_CM2001: connectionErrorOccurred:Exception on cleanup&destroy:" + exception.getMessage() + ":event=" + connectionEvent + ":mc=" + managedConnection.toString());
                exception.printStackTrace();
            }
        }
    }

    public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
        _loggerOC.entering(_className, "connectionErrorOccurred()", connectionEvent);
        if (connectionEvent != null) {
            ManagedConnection managedConnection = (ManagedConnection)connectionEvent.getSource();
            try {
                _loggerOC.warning("MQJMSRA_CM2001: connectionErrorOccurred:event=" + connectionEvent + ":Destroying mc=" + managedConnection.toString());
                managedConnection.destroy();
            }
            catch (Exception exception) {
                _loggerOC.warning("MQJMSRA_CM2001: connectionErrorOccurred:Exception on destroy():" + exception.getMessage() + ":event=" + connectionEvent + ":mc=" + managedConnection.toString());
                exception.printStackTrace();
            }
        }
    }

    public void localTransactionCommitted(ConnectionEvent connectionEvent) {
        _loggerOC.entering(_className, "localTransactionCommitted()", connectionEvent);
    }

    public void localTransactionRolledback(ConnectionEvent connectionEvent) {
        _loggerOC.entering(_className, "localTransactionRolledback()", connectionEvent);
    }

    public void localTransactionStarted(ConnectionEvent connectionEvent) {
        _loggerOC.entering(_className, "localTransactionStarted()", connectionEvent);
    }

    public void destroyConnections() {
    }
}

