/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.apps.objmgr;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.InvalidPropertyException;
import com.sun.messaging.InvalidPropertyValueException;
import com.sun.messaging.ReadOnlyPropertyException;
import com.sun.messaging.jmq.admin.apps.objmgr.ObjMgrOptions;
import com.sun.messaging.jmq.admin.apps.objmgr.ObjMgrPrinter;
import com.sun.messaging.jmq.admin.apps.objmgr.ObjMgrProperties;
import com.sun.messaging.jmq.admin.apps.objmgr.Utils;
import com.sun.messaging.jmq.admin.objstore.ObjStoreAttrs;
import com.sun.messaging.jmq.admin.resources.AdminResources;
import com.sun.messaging.jmq.admin.util.Globals;
import com.sun.messaging.jmq.admin.util.JMSObjFactory;
import com.sun.messaging.jmq.util.MultiColumnPrinter;
import java.util.Properties;

public class CmdPreviewer
implements ObjMgrOptions {
    private AdminResources ar = Globals.getAdminResources();
    private ObjMgrProperties objMgrProps;

    public CmdPreviewer(ObjMgrProperties objMgrProperties) {
        this.objMgrProps = objMgrProperties;
    }

    public void previewCommands() {
        Globals.stdOutPrintln(this.ar.getString("A1067"));
        String string = this.objMgrProps.getCommand();
        if (string.equals("add")) {
            this.previewAddCommand(this.objMgrProps);
        } else if (string.equals("delete")) {
            this.previewDeleteCommand(this.objMgrProps);
        } else if (string.equals("query")) {
            this.previewQueryCommand(this.objMgrProps);
        } else if (string.equals("list")) {
            this.previewListCommand(this.objMgrProps);
        } else if (string.equals("update")) {
            this.previewUpdateCommand(this.objMgrProps);
        }
    }

    private void previewAddCommand(ObjMgrProperties objMgrProperties) {
        String string = objMgrProperties.getObjType();
        Properties properties = objMgrProperties.getObjProperties();
        ObjStoreAttrs objStoreAttrs = objMgrProperties.getObjStoreAttrs();
        String string2 = objMgrProperties.getLookupName();
        boolean bl = objMgrProperties.forceModeSet();
        Object object = null;
        try {
            if (string.equals("q")) {
                object = JMSObjFactory.createQueue(properties);
            } else if (string.equals("t")) {
                object = JMSObjFactory.createTopic(properties);
            } else if (string.equals("xqf")) {
                object = JMSObjFactory.createXAQueueConnectionFactory(properties);
            } else if (string.equals("xtf")) {
                object = JMSObjFactory.createXATopicConnectionFactory(properties);
            } else if (string.equals("xcf")) {
                object = JMSObjFactory.createXAConnectionFactory(properties);
            } else if (string.equals("qf")) {
                object = JMSObjFactory.createQueueConnectionFactory(properties);
            } else if (string.equals("tf")) {
                object = JMSObjFactory.createTopicConnectionFactory(properties);
            } else if (string.equals("cf")) {
                object = JMSObjFactory.createConnectionFactory(properties);
            }
        }
        catch (Exception exception) {
            this.handleRunCommandExceptions(exception, string2);
            Globals.stdOutPrintln("");
            Globals.stdOutPrintln(this.ar.getString("A1037"));
            return;
        }
        if (bl) {
            Globals.stdOutPrintln(this.ar.getString("A1069"));
        } else {
            Globals.stdOutPrintln(this.ar.getString("A1068"));
        }
        Globals.stdOutPrintln("");
        Globals.stdOutPrintln(this.ar.getString("A1070", Utils.getObjTypeString(string)));
        Globals.stdOutPrintln("");
        ObjMgrPrinter objMgrPrinter = new ObjMgrPrinter(2, 4);
        objMgrPrinter.printObjPropertiesFromObj((AdministeredObject)object);
        Globals.stdOutPrintln("");
        ObjMgrPrinter.printReadOnly(objMgrProperties.readOnlyValue());
        Globals.stdOutPrintln("");
        Globals.stdOutPrintln(this.ar.getString("A1101"));
        Globals.stdOutPrintln("");
        Globals.stdOutPrintln(string2);
        Globals.stdOutPrintln("");
        Globals.stdOutPrintln(this.ar.getString("A1102"));
        Globals.stdOutPrintln("");
        ObjMgrPrinter objMgrPrinter2 = new ObjMgrPrinter(objStoreAttrs, 2, 4);
        objMgrPrinter2.print();
        Globals.stdOutPrintln("");
        Globals.stdOutPrintln(this.ar.getString("A1023"));
    }

    private void previewDeleteCommand(ObjMgrProperties objMgrProperties) {
        String string = objMgrProperties.getObjType();
        Properties properties = objMgrProperties.getObjProperties();
        ObjStoreAttrs objStoreAttrs = objMgrProperties.getObjStoreAttrs();
        String string2 = objMgrProperties.getLookupName();
        boolean bl = objMgrProperties.forceModeSet();
        if (bl) {
            Globals.stdOutPrintln(this.ar.getString("A1069"));
        } else {
            Globals.stdOutPrintln(this.ar.getString("A1068"));
        }
        Globals.stdOutPrintln("");
        Globals.stdOutPrintln(this.ar.getString("A1071"));
        Globals.stdOutPrintln("");
        Globals.stdOutPrintln(string2);
        Globals.stdOutPrintln("");
        Globals.stdOutPrintln(this.ar.getString("A1104"));
        Globals.stdOutPrintln("");
        ObjMgrPrinter objMgrPrinter = new ObjMgrPrinter(objStoreAttrs, 2, 4);
        objMgrPrinter.print();
        Globals.stdOutPrintln("");
        Globals.stdOutPrintln(this.ar.getString("A1024"));
    }

    private void previewQueryCommand(ObjMgrProperties objMgrProperties) {
        String string = objMgrProperties.getObjType();
        ObjStoreAttrs objStoreAttrs = objMgrProperties.getObjStoreAttrs();
        String string2 = objMgrProperties.getLookupName();
        Globals.stdOutPrintln(this.ar.getString("A1072"));
        Globals.stdOutPrintln("");
        Globals.stdOutPrintln(string2);
        Globals.stdOutPrintln("");
        Globals.stdOutPrintln(this.ar.getString("A1106"));
        Globals.stdOutPrintln("");
        ObjMgrPrinter objMgrPrinter = new ObjMgrPrinter(objStoreAttrs, 2, 4);
        objMgrPrinter.print();
        Globals.stdOutPrintln("");
        Globals.stdOutPrintln(this.ar.getString("A1034"));
    }

    private void previewListCommand(ObjMgrProperties objMgrProperties) {
        String string = objMgrProperties.getObjType();
        ObjStoreAttrs objStoreAttrs = objMgrProperties.getObjStoreAttrs();
        String string2 = objMgrProperties.getLookupName();
        String string3 = Utils.getObjTypeString(string);
        if (string3 != null) {
            Globals.stdOutPrintln(this.ar.getString("A1073", string3));
        } else {
            Globals.stdOutPrintln(this.ar.getString("A1074"));
        }
        Globals.stdOutPrintln("");
        ObjMgrPrinter objMgrPrinter = new ObjMgrPrinter(objStoreAttrs, 2, 4);
        objMgrPrinter.print();
        Globals.stdOutPrintln("");
        Globals.stdOutPrintln(this.ar.getString("A1035"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void previewUpdateCommand(ObjMgrProperties objMgrProperties) {
        Object object;
        String string = objMgrProperties.getObjType();
        Properties properties = objMgrProperties.getObjProperties();
        ObjStoreAttrs objStoreAttrs = objMgrProperties.getObjStoreAttrs();
        String string2 = objMgrProperties.getLookupName();
        boolean bl = objMgrProperties.forceModeSet();
        String string3 = Utils.getObjTypeString(string);
        if (bl) {
            Globals.stdOutPrintln(this.ar.getString("A1069"));
        } else {
            Globals.stdOutPrintln(this.ar.getString("A1068"));
        }
        Globals.stdOutPrintln("");
        if (string3 != null) {
            block14: {
                object = null;
                try {
                    if (string.equals("q")) {
                        object = JMSObjFactory.createQueue(properties);
                        break block14;
                    }
                    if (string.equals("t")) {
                        object = JMSObjFactory.createTopic(properties);
                        break block14;
                    }
                    if (string.equals("xqf")) {
                        object = JMSObjFactory.createXAQueueConnectionFactory(properties);
                        break block14;
                    }
                    if (string.equals("xtf")) {
                        object = JMSObjFactory.createXATopicConnectionFactory(properties);
                        break block14;
                    }
                    if (string.equals("xcf")) {
                        object = JMSObjFactory.createXAConnectionFactory(properties);
                        break block14;
                    }
                    if (string.equals("qf")) {
                        object = JMSObjFactory.createQueueConnectionFactory(properties);
                        break block14;
                    }
                    if (string.equals("tf")) {
                        object = JMSObjFactory.createTopicConnectionFactory(properties);
                        break block14;
                    }
                    if (string.equals("cf")) {
                        object = JMSObjFactory.createConnectionFactory(properties);
                    }
                }
                catch (Exception exception) {
                    this.handleRunCommandExceptions(exception, string2);
                    Globals.stdOutPrintln("");
                    Globals.stdOutPrintln(this.ar.getString("A1036"));
                    return;
                }
            }
            Globals.stdOutPrintln(this.ar.getString("A1075", string3));
            Globals.stdOutPrintln("");
            ObjMgrPrinter objMgrPrinter = new ObjMgrPrinter(properties, 2, 4);
            objMgrPrinter.print();
        } else {
            Globals.stdOutPrintln(this.ar.getString("A1076"));
            Globals.stdOutPrintln("");
            object = new ObjMgrPrinter(properties, 2, 4);
            ((MultiColumnPrinter)object).print();
        }
        Globals.stdOutPrintln("");
        ObjMgrPrinter.printReadOnly(objMgrProperties.readOnlyValue());
        Globals.stdOutPrintln("");
        Globals.stdOutPrintln(this.ar.getString("A1077"));
        Globals.stdOutPrintln("");
        Globals.stdOutPrintln(string2);
        Globals.stdOutPrintln("");
        Globals.stdOutPrintln(this.ar.getString("A1112"));
        Globals.stdOutPrintln("");
        object = new ObjMgrPrinter(objStoreAttrs, 2, 4);
        ((MultiColumnPrinter)object).print();
        Globals.stdOutPrintln("");
        Globals.stdOutPrintln(this.ar.getString("A1025"));
    }

    private void handleRunCommandExceptions(Exception exception, String string) {
        if (exception instanceof InvalidPropertyException) {
            Globals.stdErrPrintln(this.ar.getString("A1001"), this.ar.getKString("A3070", exception.getMessage()));
            Globals.stdErrPrintln("");
            Globals.stdErrPrintln(this.ar.getString("A1623"));
        } else if (exception instanceof InvalidPropertyValueException) {
            Globals.stdErrPrintln(this.ar.getString("A1001"), this.ar.getKString("A3072", exception.getMessage()));
        } else if (exception instanceof ReadOnlyPropertyException) {
            Globals.stdErrPrintln(this.ar.getString("A1001"), this.ar.getKString("A3071"));
        }
    }
}

