/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.stomp;

import com.sun.messaging.bridge.service.Bridge;
import com.sun.messaging.bridge.service.BridgeCmdSharedReplyData;
import com.sun.messaging.bridge.service.BridgeContext;
import com.sun.messaging.bridge.service.BridgeException;
import com.sun.messaging.bridge.service.stomp.StompServer;
import java.util.ArrayList;
import java.util.Properties;
import java.util.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StompBridge
implements Bridge {
    private final String _type = "STOMP";
    private String _name = null;
    private Bridge.State _state = Bridge.State.STOPPED;
    private StompServer _stompServer = null;

    @Override
    public synchronized boolean start(BridgeContext bridgeContext, String[] stringArray) throws Exception {
        if (stringArray != null) {
            Object[] objectArray = new String[2];
            objectArray[0] = BridgeContext.toString(stringArray);
            objectArray[1] = this.getType();
            Object[] objectArray2 = objectArray;
            bridgeContext.logInfo(StompServer.getStompBridgeResources().getString("BSS2001", objectArray2), null);
        }
        if (this._state == Bridge.State.STARTED) {
            return true;
        }
        this._state = Bridge.State.STARTING;
        boolean bl = false;
        try {
            this._stompServer = new StompServer();
            this._stompServer.init(bridgeContext);
            bl = true;
            this._stompServer.start();
            this._state = Bridge.State.STARTED;
            return true;
        }
        catch (Exception exception) {
            bridgeContext.logError(exception.getMessage(), exception);
            try {
                if (bl) {
                    this.stop(bridgeContext, null);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (!bl) {
                this._stompServer = null;
                throw exception;
            }
            throw new BridgeException(exception.getMessage(), exception, 201);
        }
    }

    @Override
    public void pause(BridgeContext bridgeContext, String[] stringArray) throws Exception {
        throw new UnsupportedOperationException(StompServer.getStompBridgeResources().getKString("BSS4000", String.valueOf("pause"), this.getType()));
    }

    @Override
    public void resume(BridgeContext bridgeContext, String[] stringArray) throws Exception {
        throw new UnsupportedOperationException(StompServer.getStompBridgeResources().getKString("BSS4000", String.valueOf("resume"), this.getType()));
    }

    @Override
    public synchronized void stop(BridgeContext bridgeContext, String[] stringArray) throws Exception {
        if (stringArray != null) {
            throw new UnsupportedOperationException(StompServer.getStompBridgeResources().getKString("BSS4000", String.valueOf("stop(.., " + BridgeContext.toString(stringArray) + ")"), this.getType()));
        }
        if (this._stompServer == null) {
            this._state = Bridge.State.STOPPED;
            throw new IllegalStateException(StompServer.getStompBridgeResources().getKString("BSS4001", this.getType(), this.getName()));
        }
        this._state = Bridge.State.STOPPING;
        this._stompServer.stop();
        this._state = Bridge.State.STOPPED;
    }

    @Override
    public ArrayList<BridgeCmdSharedReplyData> list(BridgeContext bridgeContext, String[] stringArray, ResourceBundle resourceBundle) throws Exception {
        throw new UnsupportedOperationException(StompServer.getStompBridgeResources().getKString("BSS4000", String.valueOf("list"), this.getType()));
    }

    @Override
    public String getType() {
        return "STOMP";
    }

    @Override
    public boolean isMultipliable() {
        return false;
    }

    @Override
    public void setName(String string) {
        this._name = string;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public Bridge.State getState() {
        return this._state;
    }

    @Override
    public Object getExportedService(String string, Properties properties) throws Exception {
        throw new UnsupportedOperationException(StompServer.getStompBridgeResources().getKString("BSS4000", String.valueOf("getExportedService"), this.getType()));
    }
}

